/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableExtendedRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.gaf.ReportAction;
import de.cismet.watergis.utils.AbstractCidsLayerListCellRenderer;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class QpGafPpRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(QpGafPpRuleSet.class);

    public QpGafPpRuleSet() {
        WatergisDefaultRuleSet.Numeric rw = new WatergisDefaultRuleSet.Numeric(11, 2, false, false);
        WatergisDefaultRuleSet.Numeric hw = new WatergisDefaultRuleSet.Numeric(10, 2, false, false);
        WatergisDefaultRuleSet.Numeric y = new WatergisDefaultRuleSet.Numeric(6, 2, false);
        WatergisDefaultRuleSet.Numeric z = new WatergisDefaultRuleSet.Numeric(6, 2, false);
        hw.setRange(5600000.0, 6399999.99);
        rw.setRange(3.3E7, 3.399999999E7);
        y.setRange(-999.99, 999.99);
        z.setRange(-19.99, 199.99);
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("p_nr", new WatergisDefaultRuleSet.Numeric(20, 0, true, false));
        this.typeMap.put("qp_nr", new WatergisDefaultRuleSet.Numeric(20, 0, true, false));
        this.typeMap.put("id_gaf", new WatergisDefaultRuleSet.Varchar(50, true));
        this.typeMap.put("y", y);
        this.typeMap.put("z", z);
        this.typeMap.put("kz", new WatergisDefaultRuleSet.Catalogue("k_qp_gaf_kz", true, true, new WatergisDefaultRuleSet.Varchar(10, false, false)));
        this.typeMap.put("rk", new WatergisDefaultRuleSet.Catalogue("k_qp_gaf_rk", false, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("rk_name", new WatergisDefaultRuleSet.Varchar(75, false));
        this.typeMap.put("rk_k", new WatergisDefaultRuleSet.Numeric(6, 2, false));
        this.typeMap.put("rk_kst", new WatergisDefaultRuleSet.Numeric(6, 2, false));
        this.typeMap.put("bk", new WatergisDefaultRuleSet.Catalogue("k_qp_gaf_bk", false, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("bk_name", new WatergisDefaultRuleSet.Varchar(75, false));
        this.typeMap.put("bk_ax", new WatergisDefaultRuleSet.Numeric(6, 2, false));
        this.typeMap.put("bk_ay", new WatergisDefaultRuleSet.Numeric(6, 2, false));
        this.typeMap.put("bk_dp", new WatergisDefaultRuleSet.Numeric(6, 3, false));
        this.typeMap.put("hw", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("rw", new WatergisDefaultRuleSet.Numeric(11, 2, false, false));
        this.typeMap.put("hw", hw);
        this.typeMap.put("rw", rw);
        this.typeMap.put("hyk", new WatergisDefaultRuleSet.Varchar(10, false, false));
        this.typeMap.put("bemerkung", new WatergisDefaultRuleSet.Varchar(250, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("p_nr") && !columnName.equals("qp_nr") && !columnName.equals("hyk") && !columnName.equals("geom") && !columnName.equals("id");
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        Object result = super.afterEdit(feature, column, row, oldValue, newValue);
        if (column.equals("kz")) {
            Object catObject = newValue;
            if (catObject instanceof String) {
                catObject = QpGafPpRuleSet.getCatalogueElement("dlm25w.k_qp_gaf_kz", "kz", (String)catObject);
            }
            if (catObject instanceof CidsLayerFeature) {
                Object hyk = ((CidsLayerFeature)catObject).getProperty("hyk");
                feature.setProperty("hyk", hyk == null ? "x" : hyk);
            } else if (catObject instanceof CidsBean) {
                Object hyk = ((CidsBean)catObject).getProperty("hyk");
                feature.setProperty("hyk", hyk == null ? "x" : hyk);
            }
        }
        return result;
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("qp_nr")) {
            return new LinkTableCellRenderer(4);
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("kz")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("kz") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("rk")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("rk") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        if (columnName.equals("bk")) {
            CidsLayerReferencedComboEditor editor = new CidsLayerReferencedComboEditor(new FeatureServiceAttribute(columnName, String.valueOf(12), true));
            editor.setNullable(true);
            editor.setListRenderer((ListCellRenderer)new AbstractCidsLayerListCellRenderer(){

                @Override
                protected String toString(CidsLayerFeature bean) {
                    return bean.getProperty("bk") + " - " + bean.getProperty("name");
                }
            });
            return editor;
        }
        return null;
    }

    @Override
    public boolean prepareForSave(List<FeatureServiceFeature> features) {
        return this.prepareForSaveWithDetails(features) == null;
    }

    @Override
    public AttributeTableExtendedRuleSet.ErrorDetails prepareForSaveWithDetails(List<FeatureServiceFeature> features) {
        for (FeatureServiceFeature feature : features) {
            this.idOfCurrentlyCheckedFeature = feature.getId();
            Object kz = feature.getProperty("kz");
            if (kz instanceof FeatureServiceFeature) {
                Object hyk = ((FeatureServiceFeature)kz).getProperty("hyk");
                if (hyk == null) {
                    hyk = "x";
                }
                feature.setProperty("hyk", hyk);
            }
            Object rk = feature.getProperty("rk");
            Object bk = feature.getProperty("bk");
            if (QpGafPpRuleSet.isValueEmpty(rk) && (QpGafPpRuleSet.isValueEmpty(feature.getProperty("rk_name")) || QpGafPpRuleSet.isValueEmpty(feature.getProperty("rk_k")) || QpGafPpRuleSet.isValueEmpty(feature.getProperty("rk_kst")))) {
                JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), "Wenn das Attribut rk leer ist, dann m\u00fcssen rk_name, rk_k und rk_kst gesetzt sein.", "Fehlerhaft Attributbelegung", 0);
                if (QpGafPpRuleSet.isValueEmpty(feature.getProperty("rk_name"))) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "rk_name");
                }
                if (QpGafPpRuleSet.isValueEmpty(feature.getProperty("rk_k"))) {
                    return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "rk_k");
                }
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "rk_kst");
            }
            if (!QpGafPpRuleSet.isValueEmpty(bk) || !QpGafPpRuleSet.isValueEmpty(feature.getProperty("bk_name")) && !QpGafPpRuleSet.isValueEmpty(feature.getProperty("bk_ax")) && !QpGafPpRuleSet.isValueEmpty(feature.getProperty("bk_ay")) && !QpGafPpRuleSet.isValueEmpty(feature.getProperty("bk_dp"))) continue;
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), "Wenn das Attribut rk leer ist, dann m\u00fcssen bk_name, bk_ax, bk_ay und bk_dp gesetzt sein.", "Fehlerhaft Attributbelegung", 0);
            if (QpGafPpRuleSet.isValueEmpty(feature.getProperty("bk_name"))) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bk_name");
            }
            if (QpGafPpRuleSet.isValueEmpty(feature.getProperty("bk_ax"))) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bk_ax");
            }
            if (QpGafPpRuleSet.isValueEmpty(feature.getProperty("bk_ay"))) {
                return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bk_ay");
            }
            return new AttributeTableExtendedRuleSet.ErrorDetails(feature, "bk_dp");
        }
        return super.prepareForSaveWithDetails(features);
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public FeatureCreator getFeatureCreator() {
        return null;
    }

    public boolean isCatThree() {
        return false;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("qp_nr") && value instanceof Integer && clickCount == 1 && feature instanceof CidsLayerFeature) {
            ReportAction action = new ReportAction();
            action.actionPerformed(null);
        }
    }
}

