/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.navigator.exception.ConnectionException;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerFeatureFilter;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.LinkTableCellRenderer;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class SgDetailRuleSet
extends WatergisDefaultRuleSet {
    private final Logger LOG = Logger.getLogger(SgDetailRuleSet.class);

    public SgDetailRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ww_gr", new WatergisDefaultRuleSet.Catalogue("k_ww_gr", true, true, new WatergisDefaultRuleSet.Numeric(4, 0, false, false)));
        this.typeMap.put("vl", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("kg", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("see_gn", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("see_gn_t", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("see_lawa", new WatergisDefaultRuleSet.Varchar(20, false, true));
        this.typeMap.put("gbk_lawa", new WatergisDefaultRuleSet.Numeric(15, 0, false, true));
        this.typeMap.put("gwk_lawa", new WatergisDefaultRuleSet.Numeric(15, 0, false, true));
        this.typeMap.put("see_sp", new WatergisDefaultRuleSet.Varchar(8, false, true));
        this.typeMap.put("see_typ", new WatergisDefaultRuleSet.Varchar(3, false, true));
        this.typeMap.put("see_art", new WatergisDefaultRuleSet.Varchar(3, false, true));
        this.typeMap.put("see_wrrl", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("see_nhn", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("see_verm", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("verm_datum", new WatergisDefaultRuleSet.Varchar(10, false, true));
        this.typeMap.put("verm_nhn", new WatergisDefaultRuleSet.Numeric(6, 2, false, true));
        this.typeMap.put("bz", new WatergisDefaultRuleSet.Numeric(2, 0, false, true));
        this.typeMap.put("tmax", new WatergisDefaultRuleSet.Numeric(5, 2, false, true));
        this.typeMap.put("td", new WatergisDefaultRuleSet.Numeric(5, 2, false, true));
        this.typeMap.put("vol", new WatergisDefaultRuleSet.Numeric(10, 0, false, true));
        this.typeMap.put("tg", new WatergisDefaultRuleSet.Numeric(6, 3, false, true));
        this.typeMap.put("ue", new WatergisDefaultRuleSet.Numeric(6, 3, false, true));
        this.typeMap.put("ul", new WatergisDefaultRuleSet.Numeric(7, 3, false, true));
        this.typeMap.put("leff", new WatergisDefaultRuleSet.Numeric(6, 3, false, true));
        this.typeMap.put("beff", new WatergisDefaultRuleSet.Numeric(6, 3, false, true));
        this.typeMap.put("tabelle", new WatergisDefaultRuleSet.Varchar(50, false, true));
        this.typeMap.put("ezg", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("ezg_fl", new WatergisDefaultRuleSet.Numeric(12, 0, false, true));
        this.typeMap.put("flaeche", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("flaeche") && !columnName.equals("geom") && !columnName.equals("id");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        if (columnName.equals("tabelle")) {
            return new LinkTableCellRenderer();
        }
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ww_gr")) {
            WatergisDefaultRuleSet.WwGrAdminFilter filter = null;
            if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("Administratoren")) {
                final String userName = AppBroker.getInstance().getOwner();
                filter = new CidsLayerFeatureFilter(){

                    public boolean accept(CidsLayerFeature bean) {
                        if (bean == null) {
                            return false;
                        }
                        return bean.getProperty("owner").equals(userName) || bean.getProperty("ww_gr").equals(4000);
                    }
                };
            } else {
                filter = new WatergisDefaultRuleSet.WwGrAdminFilter();
            }
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true), (CidsLayerFeatureFilter)filter);
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
        try {
            this.refreshTemplate("RefreshEzgKrl");
        }
        catch (ConnectionException ex) {
            this.LOG.error((Object)"Cannot refresh templates", (Throwable)ex);
        }
        super.afterSave(model);
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"flaeche"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("flaeche")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Long value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = Math.round(geom.getArea());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("flaeche")) {
            return "round(st_area(geom))";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Long.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", this.getDefaultValues(), true);
        c.setMinArea(1.0E-4);
        return c;
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("tabelle") && value instanceof String && clickCount == 1) {
            SgDetailRuleSet.downloadDocumentFromWebDav(this.getSgLinkTablePath(), SgDetailRuleSet.addExtension(value.toString(), "xlsx"));
        }
    }

    @Override
    public Map<String, Object> getDefaultValues() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (AppBroker.getInstance().getOwnWwGr() != null) {
            properties.put("ww_gr", AppBroker.getInstance().getOwnWwGr());
        } else {
            properties.put("ww_gr", AppBroker.getInstance().getNiemandWwGr());
        }
        return properties;
    }
}

