/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.navigator.connection.SessionManager;
import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cids.custom.watergis.server.search.RemoveUnnusedRoute;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.CidsLayerReferencedComboEditor;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.SimpleAttributeTableModel;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class SgSuRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(SgSuRuleSet.class);

    public SgSuRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("su_cd", new WatergisDefaultRuleSet.Varchar(50, true, true));
        this.typeMap.put("su_st_von", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("su_st_bis", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("see_gn", new WatergisDefaultRuleSet.Varchar(50, true, true));
        this.typeMap.put("see_lawa", new WatergisDefaultRuleSet.Varchar(20, true, true));
        this.typeMap.put("see_sp", new WatergisDefaultRuleSet.Varchar(8, true, true));
        this.typeMap.put("see_wrrl", new WatergisDefaultRuleSet.Numeric(1, 0, false, true));
        this.typeMap.put("laenge", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("laenge") && !columnName.equals("su_st_von") && !columnName.equals("su_st_bis") && !columnName.equals("geom") && !columnName.equals("id");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ww_gr")) {
            return new CidsLayerReferencedComboEditor(new FeatureServiceAttribute("ww_gr", String.valueOf(4), true));
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
        List removedFeatures;
        if (model instanceof SimpleAttributeTableModel && (removedFeatures = ((SimpleAttributeTableModel)model).getRemovedFeature()) != null && !removedFeatures.isEmpty()) {
            ArrayList<Feature> selectedFeaturesToRemove = new ArrayList<Feature>();
            for (FeatureServiceFeature feature : removedFeatures) {
                try {
                    RemoveUnnusedRoute nodesSearch = new RemoveUnnusedRoute(feature.getId(), 5);
                    SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)nodesSearch);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while removing unused stations", (Throwable)e);
                }
                List selectedFeatures = SelectionManager.getInstance().getSelectedFeatures();
                for (Feature f : selectedFeatures) {
                    String deletedFeatureBaCd;
                    String selectedFeatureBaCd;
                    CidsLayerFeature clf;
                    if (!(f instanceof CidsLayerFeature) || (clf = (CidsLayerFeature)f).getProperty("su_cd") == null || feature.getProperty("su_cd") == null || !(selectedFeatureBaCd = String.valueOf(clf.getProperty("su_cd"))).equals(deletedFeatureBaCd = String.valueOf(feature.getProperty("su_cd")))) continue;
                    selectedFeaturesToRemove.add(f);
                }
            }
            if (!selectedFeaturesToRemove.isEmpty()) {
                SelectionManager.getInstance().removeSelectedFeatures(selectedFeaturesToRemove);
            }
        }
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"su_st_von", "su_st_bis", "laenge"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("laenge")) {
            return -3;
        }
        if (name.equals("su_st_von")) {
            return 3;
        }
        if (name.equals("su_st_bis")) {
            return 4;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Double value = null;
        if (propertyName.equals("su_st_von")) {
            return 0;
        }
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = this.round(geom.getLength());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("laenge")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        if (propertyName.equals("su_st_von")) {
            return "0";
        }
        if (propertyName.equals("su_st_bis")) {
            return "round(st_length(geom)::numeric, 2)";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Double.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator creator = new PrimitiveGeometryCreator("LINESTRING");
        creator.setMinLength(0.01);
        return creator;
    }
}

