/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class VwAlkFlstFnRuleSet
extends WatergisDefaultRuleSet {
    public VwAlkFlstFnRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("flst", new WatergisDefaultRuleSet.Varchar(10, true));
        this.typeMap.put("fl_nr", new WatergisDefaultRuleSet.Numeric(3, 0, true));
        this.typeMap.put("gmk_nr", new WatergisDefaultRuleSet.Numeric(6, 0, true));
        this.typeMap.put("gmk_name", new WatergisDefaultRuleSet.Varchar(50, true));
        this.typeMap.put("gmd_nr", new WatergisDefaultRuleSet.Numeric(8, 0, true));
        this.typeMap.put("gmd_name", new WatergisDefaultRuleSet.Varchar(50, true));
        this.typeMap.put("wbv", new WatergisDefaultRuleSet.Numeric(2, 0, true));
        this.typeMap.put("flst_fl", new WatergisDefaultRuleSet.Numeric(15, 4, true));
        this.typeMap.put("fn_gr", new WatergisDefaultRuleSet.Numeric(1, 0, true));
        this.typeMap.put("fn", new WatergisDefaultRuleSet.Numeric(4, 0, true));
        this.typeMap.put("fn_fl", new WatergisDefaultRuleSet.Numeric(16, 4, false, false));
        this.typeMap.put("fn_flst_an", new WatergisDefaultRuleSet.Numeric(5, 2, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        Double flst_fl;
        Double value;
        Double fn_fl;
        Geometry geom;
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if ((column.equals("fl_nr") || column.equals("gmk_nr") || column.equals("gmd_nr") || column.equals("flst") || column.equals("fn")) && newValue instanceof String) {
            try {
                newValue = Integer.parseInt((String)newValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (newValue instanceof Geometry) {
            geom = (Geometry)newValue;
            fn_fl = null;
            if (geom != null) {
                fn_fl = geom.getArea();
                feature.setProperty("fn_fl", (Object)((double)Math.round(fn_fl * 10000.0) / 10000.0));
                value = null;
                flst_fl = (Double)feature.getProperty("flst_fl");
                if (flst_fl != null) {
                    value = fn_fl * 100.0 / flst_fl;
                }
                feature.setProperty("fn_flst_an", (Object)this.round(value));
            }
        }
        if (column.equals("flst_fl") && newValue != null) {
            geom = (Geometry)feature.getProperty("geom");
            fn_fl = null;
            if (geom != null) {
                fn_fl = geom.getArea();
                feature.setProperty("fn_fl", (Object)((double)Math.round(fn_fl * 10000.0) / 10000.0));
                value = null;
                flst_fl = (Double)newValue;
                if (flst_fl != null) {
                    value = fn_fl * 100.0 / flst_fl;
                }
                feature.setProperty("fn_flst_an", (Object)this.round(value));
            }
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("fn_fl") && !columnName.equals("fn_flst_an") && !columnName.equals("geom");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("fl_nr")) {
            return new DefaultCellEditor(new JTextField());
        }
        if (columnName.equals("gmk_nr")) {
            return new DefaultCellEditor(new JTextField());
        }
        if (columnName.equals("gmd_nr")) {
            return new DefaultCellEditor(new JTextField());
        }
        if (columnName.equals("flst")) {
            return new DefaultCellEditor(new JTextField());
        }
        if (columnName.equals("fn")) {
            return new DefaultCellEditor(new JTextField());
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
        Geometry geom = (Geometry)feature.getProperty("geom");
        Double fn_fl = null;
        if (geom != null) {
            fn_fl = geom.getArea();
            feature.getProperties().put("fn_fl", VwAlkFlstFnRuleSet.round(fn_fl, 4));
            Double value = null;
            Double flst_fl = (Double)feature.getProperty("flst_fl");
            if (flst_fl != null) {
                value = fn_fl * 100.0 / flst_fl;
            }
            feature.getProperties().put("fn_flst_an", this.round(value));
        }
    }

    public void afterSave(TableModel model) {
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", true);
        c.setMinArea(1.0E-4);
        return c;
    }
}

