/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class VwAlkFlstWbvGRuleSet
extends WatergisDefaultRuleSet {
    public VwAlkFlstWbvGRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("fsk", new WatergisDefaultRuleSet.Varchar(20, true));
        this.typeMap.put("flst", new WatergisDefaultRuleSet.Varchar(10, false));
        this.typeMap.put("fl_nr", new WatergisDefaultRuleSet.Numeric(3, 0, false));
        this.typeMap.put("gmk_nr", new WatergisDefaultRuleSet.Numeric(6, 0, false));
        this.typeMap.put("gmk_name", new WatergisDefaultRuleSet.Varchar(50, false));
        this.typeMap.put("gmd_nr", new WatergisDefaultRuleSet.Numeric(8, 0, false));
        this.typeMap.put("gmd_name", new WatergisDefaultRuleSet.Varchar(50, false));
        this.typeMap.put("wbv", new WatergisDefaultRuleSet.Numeric(2, 0, false));
        this.typeMap.put("flst_fl", new WatergisDefaultRuleSet.Numeric(16, 0, false));
        this.typeMap.put("flst_g_an", new WatergisDefaultRuleSet.Numeric(5, 1, false, false));
        this.typeMap.put("flst_g_fl", new WatergisDefaultRuleSet.Numeric(16, 1, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        Double flst_fl;
        Double value;
        Geometry geom;
        Double flst_g_fl;
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if ((column.equals("fl_nr") || column.equals("gmk_nr") || column.equals("gmd_nr") || column.equals("flst")) && newValue instanceof String) {
            try {
                newValue = Integer.parseInt((String)newValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (newValue instanceof Geometry) {
            flst_g_fl = null;
            geom = (Geometry)newValue;
            if (geom != null) {
                flst_g_fl = geom.getArea();
                feature.getProperties().put("flst_g_fl", VwAlkFlstWbvGRuleSet.round(flst_g_fl, 4));
                value = null;
                flst_fl = (Double)feature.getProperty("flst_fl");
                if (flst_fl != null) {
                    value = flst_g_fl * 100.0 / flst_fl;
                    feature.getProperties().put("flst_g_an", this.round(value));
                } else {
                    feature.getProperties().put("flst_g_an", null);
                }
            } else {
                feature.getProperties().put("flst_g_fl", null);
                feature.getProperties().put("flst_g_an", null);
            }
        }
        if (column.equals("flst_fl")) {
            flst_g_fl = null;
            geom = (Geometry)feature.getProperty("geom");
            if (geom != null) {
                flst_g_fl = geom.getArea();
                feature.getProperties().put("flst_g_fl", VwAlkFlstWbvGRuleSet.round(flst_g_fl, 4));
                value = null;
                flst_fl = (Double)newValue;
                if (flst_fl != null) {
                    value = flst_g_fl * 100.0 / flst_fl;
                    feature.getProperties().put("flst_g_an", this.round(value));
                } else {
                    feature.getProperties().put("flst_g_an", null);
                }
            } else {
                feature.getProperties().put("flst_g_fl", null);
                feature.getProperties().put("flst_g_an", null);
            }
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("flst_g_an") && !columnName.equals("flst_g_fl") && !columnName.equals("geom");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("fl_nr")) {
            return new DefaultCellEditor(new JTextField());
        }
        if (columnName.equals("gmk_nr")) {
            return new DefaultCellEditor(new JTextField());
        }
        if (columnName.equals("gmd_nr")) {
            return new DefaultCellEditor(new JTextField());
        }
        if (columnName.equals("flst")) {
            return new DefaultCellEditor(new JTextField());
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
        Double flst_g_fl = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            flst_g_fl = geom.getArea();
            feature.getProperties().put("flst_g_fl", VwAlkFlstWbvGRuleSet.round(flst_g_fl, 4));
            Double value = null;
            Double flst_fl = (Double)feature.getProperty("flst_fl");
            if (flst_fl != null) {
                value = flst_g_fl * 100.0 / flst_fl;
                feature.getProperties().put("flst_g_an", this.round(value));
            } else {
                feature.getProperties().put("flst_g_an", null);
            }
        } else {
            feature.getProperties().put("flst_g_fl", null);
            feature.getProperties().put("flst_g_an", null);
        }
    }

    public void afterSave(TableModel model) {
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", true);
        c.setMinArea(1.0E-4);
        return c;
    }
}

