/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import com.vividsolutions.jts.geom.Geometry;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.PrimitiveGeometryCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import javax.swing.DefaultCellEditor;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class VwDvgGmdRuleSet
extends WatergisDefaultRuleSet {
    public VwDvgGmdRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("gmd_nr", new WatergisDefaultRuleSet.Numeric(8, 0, true));
        this.typeMap.put("gmd_name", new WatergisDefaultRuleSet.Varchar(50, true));
        this.typeMap.put("amt_nr", new WatergisDefaultRuleSet.Numeric(4, 0, true));
        this.typeMap.put("amt_name", new WatergisDefaultRuleSet.Varchar(50, true));
        this.typeMap.put("kreis_nr", new WatergisDefaultRuleSet.Numeric(5, 0, true));
        this.typeMap.put("kreis_name", new WatergisDefaultRuleSet.Varchar(50, true));
        this.typeMap.put("ort_fl", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("gmd_fl", new WatergisDefaultRuleSet.Numeric(12, 0, false, false));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (column.equals("gmd_nr") && newValue instanceof String) {
            try {
                newValue = Integer.parseInt((String)newValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("gmd_fl") && !columnName.equals("geom") && !columnName.equals("id");
    }

    @Override
    public TableCellRenderer getCellRenderer(String columnName) {
        return super.getCellRenderer(columnName);
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("gmd_nr")) {
            return new DefaultCellEditor(new JTextField());
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public String[] getAdditionalFieldNames() {
        return new String[]{"gmd_fl"};
    }

    public int getIndexOfAdditionalFieldName(String name) {
        if (name.equals("gmd_fl")) {
            return -3;
        }
        return super.getIndexOfAdditionalFieldName(name);
    }

    public Object getAdditionalFieldValue(String propertyName, FeatureServiceFeature feature) {
        Long value = null;
        Geometry geom = (Geometry)feature.getProperty("geom");
        if (geom != null) {
            value = Math.round(geom.getArea());
        }
        return value;
    }

    public String getAdditionalFieldFormula(String propertyName) {
        if (propertyName.equals("gmd_fl")) {
            return "round(st_area(geom))";
        }
        return null;
    }

    public Class getAdditionalFieldClass(int index) {
        return Integer.class;
    }

    public FeatureCreator getFeatureCreator() {
        PrimitiveGeometryCreator c = new PrimitiveGeometryCreator("POLYGON", true);
        c.setMinArea(1.0E-4);
        return c;
    }
}

