/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.attributerule;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.PointAndStationCreator;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.custom.attributerule.WatergisDefaultRuleSet;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.cismap.linearreferencing.RouteTableCellEditor;
import de.cismet.cismap.linearreferencing.StationTableCellEditor;
import de.cismet.tools.BrowserLauncher;
import de.cismet.watergis.utils.LinearReferencingWatergisHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class WrWbuAusRuleSet
extends WatergisDefaultRuleSet {
    private static final Logger LOG = Logger.getLogger(WrWbuAusRuleSet.class);
    private static final String URL_TEMPLATE_PUBLIC = "https://fis-wasser-mv.de/kvwmap/index.php?gast=37&go=Layer-Suche_Suchen&selected_layer_id=1118&value_wbbl_id=%1s&operator_wbbl_id==";
    private static final String URL_TEMPLATE_INTERN = "https://fis-wasser-mv.de/kvwmap/index.php?Stelle_ID=1066&go=Layer-Suche_Suchen&selected_layer_id=232&value_wbbl_id=%1s&operator_wbbl_id==";

    public WrWbuAusRuleSet() {
        this.typeMap.put("geom", new WatergisDefaultRuleSet.Geom(true, false));
        this.typeMap.put("ba_cd", new WatergisDefaultRuleSet.Varchar(50, false, false));
        this.typeMap.put("ba_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, true));
        this.typeMap.put("la_cd", new WatergisDefaultRuleSet.Numeric(15, 0, false, false));
        this.typeMap.put("la_st", new WatergisDefaultRuleSet.Numeric(10, 2, false, false));
        this.typeMap.put("wbbl", new WatergisDefaultRuleSet.WbblLink(WrWbuAusRuleSet.getWbblPath(), 10, true, true));
        this.typeMap.put("wbaktzei", new WatergisDefaultRuleSet.Varchar(75, false, true));
        this.typeMap.put("wbbehakt", new WatergisDefaultRuleSet.Varchar(65, false, true));
        this.typeMap.put("wbbescheid", new WatergisDefaultRuleSet.Varchar(75, false, true));
        this.typeMap.put("wbausbau1", new WatergisDefaultRuleSet.Varchar(75, false, true));
        this.typeMap.put("wbausbau2", new WatergisDefaultRuleSet.Varchar(75, false, true));
        this.typeMap.put("fis_g_date", new WatergisDefaultRuleSet.DateTime(false, false));
        this.typeMap.put("fis_g_user", new WatergisDefaultRuleSet.Varchar(50, false, false));
    }

    @Override
    public Object afterEdit(FeatureServiceFeature feature, String column, int row, Object oldValue, Object newValue) {
        this.idOfCurrentlyCheckedFeature = feature.getId();
        if (column.equals("ba_cd")) {
            Number o = (Number)feature.getProperty("ba_st");
            Double baSt = o instanceof CidsBean ? (Double)((CidsBean)o).getProperty("wert") : (o == null ? null : Double.valueOf(((Number)feature.getProperty("ba_st")).doubleValue()));
            this.refreshLaStation(feature, (String)newValue, baSt, "la_cd", "la_st");
        }
        if (column.equals("ba_st")) {
            this.refreshLaStation(feature, (String)feature.getProperty("ba_cd"), ((Number)newValue).doubleValue(), "la_cd", "la_st");
        }
        return super.afterEdit(feature, column, row, oldValue, newValue);
    }

    public boolean isColumnEditable(String columnName) {
        return !columnName.equals("fis_g_user") && !columnName.equals("fis_g_date") && !columnName.equals("id") && !columnName.equals("geom") && !columnName.equals("la_cd") && !columnName.equals("la_st");
    }

    @Override
    public TableCellEditor getCellEditor(String columnName) {
        if (columnName.equals("ba_cd")) {
            RouteTableCellEditor editor = new RouteTableCellEditor("dlm25w.fg_ba", "ba_st", false);
            String filterString = this.getRouteFilter();
            if (filterString != null) {
                editor.setRouteQuery(filterString);
            }
            return editor;
        }
        if (columnName.equals("ba_st")) {
            return new StationTableCellEditor(columnName);
        }
        return null;
    }

    @Override
    public void beforeSave(FeatureServiceFeature feature) {
        this.adjustFisGDateAndFisGUser(feature);
    }

    public void afterSave(TableModel model) {
    }

    public FeatureCreator getFeatureCreator() {
        MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        return new PointAndStationCreator("ba_st", null, routeMc, (LinearReferencingHelper)new LinearReferencingWatergisHelper());
    }

    @Override
    public void mouseClicked(FeatureServiceFeature feature, String columnName, Object value, int clickCount) {
        if (columnName.equals("wbbl") && value != null && clickCount == 1) {
            String urlTemplate = WrWbuAusRuleSet.hasAccessToProtectedWbbl() ? URL_TEMPLATE_INTERN : URL_TEMPLATE_PUBLIC;
            String wbbl = String.valueOf(value);
            try {
                URL u = new URL(String.format(urlTemplate, wbbl.toString()));
                try {
                    BrowserLauncher.openURL((String)u.toString());
                }
                catch (Exception ex) {
                    LOG.error((Object)("Cannot open the url:" + u), (Throwable)ex);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public boolean isCatThree() {
        return true;
    }

    public FeatureServiceFeature[] prepareFeaturesForExport(FeatureServiceFeature[] features) {
        ArrayList<FeatureServiceFeature> featureList = new ArrayList<FeatureServiceFeature>();
        for (FeatureServiceFeature f : features) {
            FeatureServiceFeature newFeature = (FeatureServiceFeature)f.clone();
            newFeature.removeProperty("ba_cd");
            newFeature.removeProperty("ba_st");
            newFeature.removeProperty("la_cd");
            newFeature.removeProperty("la_st");
            newFeature.removeProperty("wbausbau2");
            featureList.add(newFeature);
        }
        return featureList.toArray(new FeatureServiceFeature[featureList.size()]);
    }
}

