/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.cismap.custom.simplifier;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import de.cismet.cismap.commons.features.DefaultFeatureSimplifier;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import org.apache.log4j.Logger;

public class AslFeatureSimplifier
extends DefaultFeatureSimplifier {
    private static final Logger LOG = Logger.getLogger(AslFeatureSimplifier.class);

    public Geometry simplify(Feature feature) {
        Geometry geom = feature.getGeometry();
        int s = geom.getCoordinates().length;
        long start = System.currentTimeMillis();
        if (geom.getCoordinates().length > 1000) {
            geom = CismapBroker.getInstance().getMappingComponent().getScaleDenominator() > 50000.0 ? this.simplifyGeometry(geom, 30.0) : (CismapBroker.getInstance().getMappingComponent().getScaleDenominator() > 25000.0 ? this.simplifyGeometry(geom, 15.0) : this.simplifyGeometry(geom, 5.0));
        }
        return geom;
    }

    private Geometry simplifyGeometry(Geometry geom, double precision) {
        Geometry simplifiedGeometry = DouglasPeuckerSimplifier.simplify((Geometry)geom, (double)precision);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("length of the geometry: " + geom.getCoordinates().length + "  Geometry will be simplified to a length of: " + simplifiedGeometry.getCoordinates().length));
        }
        return simplifiedGeometry;
    }
}

