/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.broker;

import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.event.CatalogueActivationListener;
import Sirius.navigator.event.CatalogueSelectionListener;
import Sirius.navigator.resource.PropertyManager;
import Sirius.navigator.types.treenode.RootTreeNode;
import Sirius.navigator.ui.ComponentRegistry;
import Sirius.navigator.ui.DescriptionPane;
import Sirius.navigator.ui.DescriptionPaneFS;
import Sirius.navigator.ui.GUIContainer;
import Sirius.navigator.ui.LayoutedContainer;
import Sirius.navigator.ui.MutableMenuBar;
import Sirius.navigator.ui.MutablePopupMenu;
import Sirius.navigator.ui.MutableToolBar;
import Sirius.navigator.ui.attributes.AttributeViewer;
import Sirius.navigator.ui.attributes.editor.AttributeEditor;
import Sirius.navigator.ui.tree.MetaCatalogueTree;
import Sirius.navigator.ui.tree.SearchResultsTree;
import Sirius.server.middleware.types.Node;
import Sirius.server.newuser.User;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.java2xml.Java2XML;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.piccolo.CustomFixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.FixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.MessenGeometryListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.RubberBandZoomListener;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.tools.gui.DefaultPopupMenuListener;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.broker.listener.SelectionModeChangedEvent;
import de.cismet.watergis.broker.listener.SelectionModeListener;
import de.cismet.watergis.gui.WatergisApp;
import de.cismet.watergis.gui.actions.CleanUpAction;
import de.cismet.watergis.gui.actions.InfoWindowAction;
import de.cismet.watergis.gui.actions.foto.ExportAction;
import de.cismet.watergis.gui.actions.foto.ReportAction;
import de.cismet.watergis.gui.components.RefreshMenuItem;
import de.cismet.watergis.gui.recently_opened_files.RecentlyOpenedFilesList;
import de.cismet.watergis.utils.BookmarkManager;
import de.latlon.deejump.plugin.style.LayerStyle2SLDPlugIn;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseListener;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionListener;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import net.infonode.docking.RootWindow;
import net.infonode.docking.View;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import org.apache.log4j.Logger;
import org.deegree.style.persistence.sld.SLDParser;
import org.deegree.style.se.unevaluated.Style;
import org.jdom.Element;

public class AppBroker
implements Configurable {
    private static final Logger LOG = Logger.getLogger(AppBroker.class);
    private static final Color blue;
    public static final Color DEFAULT_MODE_COLOR;
    public static final String MEASURE_MODE = "MEASURE_MODE";
    public static final String FOTO_MC_NAME = "foto";
    public static final String GAF_PROF_MC_NAME = "qp";
    public static final String QP_UPL_MC_NAME = "qp_upl";
    public static final String QP_NPL_MC_NAME = "qp_npl";
    private static ConfigurationManager configManager;
    public static final String DOMAIN_NAME = "DLM25W";
    public static final String DOMAIN_NAME_WRRL = "WRRL_DB_MV";
    public static final String PRJ_CONTENT = "PROJCS[\"ETRS_1989_UTM_Zone_33N_zE-N\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",33500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",5650]]";
    private RecentlyOpenedFilesList recentlyOpenedFilesList;
    private transient ConnectionSession session;
    private MappingComponent mappingComponent;
    private boolean loggedIn;
    private String domain;
    private String callserverUrl;
    private String connectionClass;
    private RootWindow rootWindow;
    private BookmarkManager bookmarkManager;
    private final EnumMap<ComponentName, Component> components = new EnumMap(ComponentName.class);
    private final HashMap<String, Action> mapModeSelectionActions = new HashMap();
    private MessenGeometryListener measureListener;
    private final List<SelectionModeListener> selecionModeListener = new ArrayList<SelectionModeListener>();
    private ComponentRegistry componentRegistry;
    private ConnectionInfo connectionInfo;
    private InfoWindowAction infoWindowAction;
    private Action lastActionMode;
    private Layer drawingStyleLayer;
    private List<CidsBean> ownWwGr = new ArrayList<CidsBean>();
    private List<CidsBean> wwGr = new ArrayList<CidsBean>();
    private String[] validLawaCodes;
    private CidsBean niemandWwGr = null;
    private View photoView;
    private View gafView;
    private ExportAction photoExport;
    private de.cismet.watergis.gui.actions.gaf.ExportAction gafExport;
    private ReportAction photoPrint;
    private de.cismet.watergis.gui.actions.gaf.ReportAction gafPrint;
    private FeatureCreator activeFeatureCreator = null;
    private int problemFeatureGeometryIncrease = 0;

    private AppBroker() {
        LayerManager layerManager = new LayerManager();
        FeatureSchema featureSchema = new FeatureSchema();
        FeatureDataset features = new FeatureDataset(featureSchema);
        layerManager.setFiringEvents(false);
        this.drawingStyleLayer = new Layer("default", Color.RED, (FeatureCollection)features, layerManager);
    }

    public int getProblemFeatureGeometryIncrease() {
        return this.problemFeatureGeometryIncrease;
    }

    public void setProblemFeatureGeometryIncrease(int problemFeatureGeometryIncrease) {
        this.problemFeatureGeometryIncrease = problemFeatureGeometryIncrease;
    }

    public FeatureCreator getActiveFeatureCreator() {
        return this.activeFeatureCreator;
    }

    public void setActiveFeatureCreator(FeatureCreator activeFeatureCreator) {
        this.activeFeatureCreator = activeFeatureCreator;
    }

    public ConnectionSession getSession() {
        return this.session;
    }

    public void setSession(ConnectionSession session) {
        this.session = session;
    }

    public static AppBroker getInstance() {
        return LazyInitialiser.INSTANCE;
    }

    public MappingComponent getMappingComponent() {
        return this.mappingComponent;
    }

    public void setMappingComponent(MappingComponent aMappingComponent) {
        this.mappingComponent = aMappingComponent;
        this.mappingComponent.setReadOnly(false);
        this.setMeasureListener(new MessenGeometryListener(this.mappingComponent){

            protected PPath initTempFeature(boolean filled) {
                PPath newTempFeaturePath = new PPath();
                newTempFeaturePath.setStroke((Stroke)new FixedWidthStroke());
                if (filled) {
                    Color fillingColor = new Color(1.0f, 0.0f, 0.0f, 0.5f);
                    newTempFeaturePath.setStrokePaint((Paint)fillingColor.darker());
                    newTempFeaturePath.setPaint((Paint)fillingColor);
                } else {
                    Color fillingColor = new Color(1.0f, 0.0f, 0.0f, 0.5f);
                    newTempFeaturePath.setStroke((Stroke)new CustomFixedWidthStroke(3.0f));
                    newTempFeaturePath.setStrokePaint((Paint)fillingColor);
                }
                return newTempFeaturePath;
            }
        });
        this.mappingComponent.addInputListener(MEASURE_MODE, (PBasicInputEventHandler)this.getMeasureListener());
    }

    public Element getConfiguration() {
        return null;
    }

    public void masterConfigure(Element parent) {
    }

    public void configure(Element parent) {
    }

    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void setLoggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
    }

    public String getConnectionClass() {
        return this.connectionClass;
    }

    public void setConnectionClass(String connectionClass) {
        this.connectionClass = connectionClass;
        this.connectionClass = this.connectionClass.replace('\"', ' ');
        this.connectionClass = this.connectionClass.trim();
    }

    public String getCallserverUrl() {
        return this.callserverUrl;
    }

    public void setCallserverUrl(String callserverUrl) {
        this.callserverUrl = callserverUrl;
        this.callserverUrl = this.callserverUrl.replace('\"', ' ');
        this.callserverUrl = this.callserverUrl.trim();
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
        this.domain = this.domain.replace('\"', ' ');
        this.domain = this.domain.trim();
    }

    public void setRootWindow(RootWindow rootWindow) {
        this.rootWindow = rootWindow;
    }

    public RootWindow getRootWindow() {
        return this.rootWindow;
    }

    public void setTitleBarComponentpainter(Color color) {
        this.getRootWindow().getRootWindowProperties().getViewProperties().getViewTitleBarProperties().getNormalProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)new GradientComponentPainter(color, new Color(236, 233, 216), color, new Color(236, 233, 216)));
    }

    public Component getComponent(ComponentName name) {
        return this.components.get((Object)name);
    }

    public WatergisApp getWatergisApp() {
        return (WatergisApp)this.components.get((Object)ComponentName.MAIN);
    }

    public void addComponent(ComponentName name, Component component) {
        this.components.put(name, component);
    }

    public RecentlyOpenedFilesList getRecentlyOpenedFilesList() {
        return this.recentlyOpenedFilesList;
    }

    public void setRecentlyOpenedFilesList(RecentlyOpenedFilesList recentlyOpenedFilesList) {
        this.recentlyOpenedFilesList = recentlyOpenedFilesList;
    }

    public boolean isActionsAlwaysEnabled() {
        return false;
    }

    public void addMapMode(String name, Action action) {
        this.mapModeSelectionActions.put(name, action);
    }

    public void switchMapMode(String mode) {
        Action action = this.mapModeSelectionActions.get(mode);
        if (action != null) {
            if (this.lastActionMode instanceof CleanUpAction) {
                ((CleanUpAction)((Object)this.lastActionMode)).cleanUp();
            }
            action.actionPerformed(new ActionEvent(this, 1001, mode));
            this.lastActionMode = action;
            if (this.activeFeatureCreator != null) {
                this.activeFeatureCreator.cancel();
            }
        } else {
            LOG.warn((Object)("Can not switch to mode " + mode + ". It does not exist."));
        }
    }

    public Action getSelectionMode() {
        return this.mapModeSelectionActions.get("SELECT");
    }

    public void simpleZoom(float factor) {
        RubberBandZoomListener r = (RubberBandZoomListener)AppBroker.getInstance().getMappingComponent().getInputListener("ZOOM");
        r.zoom(factor, this.mappingComponent.getCamera(), this.mappingComponent.getAnimationDuration(), 500);
    }

    public static ConfigurationManager getConfigManager() {
        return configManager;
    }

    public static void setConfigManager(ConfigurationManager configManager) {
        AppBroker.configManager = configManager;
    }

    public BookmarkManager getBookmarkManager() {
        return this.bookmarkManager;
    }

    public void setBookmarkManager(BookmarkManager bookmarkManager) {
        this.bookmarkManager = bookmarkManager;
    }

    public MessenGeometryListener getMeasureListener() {
        return this.measureListener;
    }

    public void setMeasureListener(MessenGeometryListener measureListener) {
        this.measureListener = measureListener;
    }

    public void addSelecionModeListener(SelectionModeListener listener) {
        this.selecionModeListener.add(listener);
    }

    public void removeSelecionModeListener(SelectionModeListener listener) {
        this.selecionModeListener.remove(listener);
    }

    public void fireSelectionModeChanged(Object source, String oldMode, String newMode) {
        SelectionModeChangedEvent e = new SelectionModeChangedEvent(source, oldMode, newMode);
        for (SelectionModeListener tmp : this.selecionModeListener) {
            tmp.selectionModeChanged(e);
        }
    }

    public void initComponentRegistry(JFrame frame) throws Exception {
        PropertyManager.getManager().setEditable(true);
        SearchResultsTree searchResultsTree = new SearchResultsTree();
        MutableToolBar toolBar = new MutableToolBar();
        MutableMenuBar menuBar = new MutableMenuBar();
        LayoutedContainer container = new LayoutedContainer(toolBar, menuBar, true);
        AttributeViewer attributeViewer = new AttributeViewer();
        AttributeEditor attributeEditor = new AttributeEditor();
        DescriptionPaneFS descriptionPane = new DescriptionPaneFS();
        MutablePopupMenu popupMenu = new MutablePopupMenu();
        for (PopupMenuListener l : popupMenu.getPopupMenuListeners()) {
            popupMenu.removePopupMenuListener(l);
        }
        popupMenu.removeAll();
        popupMenu.add((JMenuItem)((Object)new RefreshMenuItem()));
        DefaultPopupMenuListener cataloguePopupMenuListener = new DefaultPopupMenuListener((JPopupMenu)popupMenu);
        Node[] roots = SessionManager.getProxy().getRoots();
        RootTreeNode rootTreeNode = new RootTreeNode(roots);
        while (roots.length != rootTreeNode.getChildCount()) {
            Thread.sleep(100L);
        }
        MetaCatalogueTree metaCatalogueTree = new MetaCatalogueTree(rootTreeNode, PropertyManager.getManager().isEditable(), true, PropertyManager.getManager().getMaxConnections());
        CatalogueSelectionListener catalogueSelectionListener = new CatalogueSelectionListener(attributeViewer, (DescriptionPane)descriptionPane);
        CatalogueActivationListener catalogueActivationListener = new CatalogueActivationListener(metaCatalogueTree, attributeViewer, (DescriptionPane)descriptionPane);
        metaCatalogueTree.addMouseListener((MouseListener)cataloguePopupMenuListener);
        metaCatalogueTree.addTreeSelectionListener((TreeSelectionListener)catalogueSelectionListener);
        metaCatalogueTree.addComponentListener((ComponentListener)catalogueActivationListener);
        ComponentRegistry.registerComponents((JFrame)frame, (GUIContainer)container, (MutableMenuBar)menuBar, (MutableToolBar)toolBar, (MutablePopupMenu)popupMenu, (MetaCatalogueTree)metaCatalogueTree, (SearchResultsTree)searchResultsTree, null, (AttributeViewer)attributeViewer, (AttributeEditor)attributeEditor, (DescriptionPane)descriptionPane);
        this.setComponentRegistry(ComponentRegistry.getRegistry());
    }

    public ComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public void setComponentRegistry(ComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public void setConnectionInfo(ConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
    }

    public InfoWindowAction getInfoWindowAction() {
        return this.infoWindowAction;
    }

    public void setInfoWindowAction(InfoWindowAction infoWindowAction) {
        this.infoWindowAction = infoWindowAction;
    }

    public Layer getDrawingStyleLayer() {
        return this.drawingStyleLayer;
    }

    public boolean isWawiOrAdminUser() {
        User user = SessionManager.getSession().getUser();
        return user.getUserGroup().getName().startsWith("lung_edit") || user.getUserGroup().getName().equalsIgnoreCase("administratoren") || user.getUserGroup().getName().contains("lu") || user.getUserGroup().getName().contains("wbv") || user.getUserGroup().getName().contains("uwb") || user.getUserGroup().getName().contains("wsa") || user.getUserGroup().getName().contains("stalu");
    }

    public boolean isAdminUser() {
        User user = SessionManager.getSession().getUser();
        return user.getUserGroup().getName().equalsIgnoreCase("administratoren");
    }

    public boolean isGu() {
        User user = SessionManager.getSession().getUser();
        for (CidsBean bean : this.getWwGrList()) {
            String prefix;
            String owner = (String)bean.getProperty("owner");
            if (owner == null || !owner.equals(user.getUserGroup().getName()) || (prefix = (String)bean.getProperty("praefix")) == null && (owner == null || !owner.startsWith("wbv"))) continue;
            return true;
        }
        return false;
    }

    public void setDrawingStyleLayer(Layer drawingStyleLayer) {
        this.drawingStyleLayer = drawingStyleLayer;
    }

    private String exportSLD(Layer layer, String geometryType) {
        String sld = null;
        try {
            Java2XML java2Xml = new Java2XML();
            StringWriter xmlWriter = new StringWriter();
            String name = "default";
            java2Xml.write((Object)layer, "layer", (Writer)xmlWriter);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("wmsLayerName", "default");
            params.put("featureTypeStyle", "default");
            params.put("styleName", "default");
            params.put("styleTitle", "default");
            params.put("Namespace", "http://cismet.de");
            params.put("NamespacePrefix", "");
            params.put("geoType", geometryType);
            params.put("geomProperty", "geom");
            if (layer.getMinScale() != null) {
                params.put("maxScale", "" + layer.getMinScale());
            }
            if (layer.getMaxScale() != null) {
                params.put("minScale", "" + layer.getMaxScale());
            }
            sld = LayerStyle2SLDPlugIn.transformContext((Reader)new StringReader(xmlWriter.toString()), params);
        }
        catch (Exception e) {
            LOG.info((Object)"could not save sld definition", (Throwable)e);
        }
        return sld;
    }

    public Map<String, LinkedList<Style>> getDrawingStyles(String geometryType) {
        StringReader input = new StringReader(this.exportSLD(this.drawingStyleLayer, geometryType));
        Map styles = null;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            styles = SLDParser.getStyles((XMLStreamReader)factory.createXMLStreamReader(input));
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler in der SLD", (Throwable)ex);
        }
        if (styles == null) {
            LOG.info((Object)"SLD Parser funtkioniert nicht");
        }
        return styles;
    }

    public Map<String, LinkedList<Style>> getDrawingStylesBySld(String sld) {
        StringReader input = new StringReader(sld);
        Map styles = null;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            styles = SLDParser.getStyles((XMLStreamReader)factory.createXMLStreamReader(input));
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler in der SLD", (Throwable)ex);
        }
        if (styles == null) {
            LOG.info((Object)"SLD Parser funtkioniert nicht");
        }
        return styles;
    }

    public List<CidsBean> getOwnWwGrList() {
        return this.ownWwGr;
    }

    public void setOwnWwGr(List<CidsBean> ownWwGr) {
        this.ownWwGr = ownWwGr;
    }

    public List<CidsBean> getWwGrList() {
        return this.wwGr;
    }

    public void setWwGr(List<CidsBean> wwGr) {
        this.wwGr = wwGr;
    }

    public String[] getValidLawaCodes() {
        return this.validLawaCodes;
    }

    public void setValidLawaCodes(String[] validLawaCodes) {
        this.validLawaCodes = validLawaCodes;
    }

    public CidsBean getNiemandWwGr() {
        return this.niemandWwGr;
    }

    public void setNiemandWwGr(CidsBean niemandWwGr) {
        this.niemandWwGr = niemandWwGr;
    }

    public String getOwner() {
        return SessionManager.getSession().getUser().getUserGroup().getName();
    }

    public CidsBean getOwnWwGr() {
        if (this.getOwnWwGrList() != null && !this.getOwnWwGrList().isEmpty()) {
            CidsBean min = null;
            for (int i = 0; i < this.getOwnWwGrList().size(); ++i) {
                if (min != null && (Integer)min.getProperty("ww_gr") <= (Integer)this.getOwnWwGrList().get(i).getProperty("ww_gr")) continue;
                min = this.getOwnWwGrList().get(i);
            }
            return min;
        }
        return this.getNiemandWwGr();
    }

    public boolean isOwnerWwGr(Integer wwGr) {
        if (wwGr == null) {
            return false;
        }
        if (this.getOwnWwGrList() != null && !this.getOwnWwGrList().isEmpty()) {
            for (int i = 0; i < this.getOwnWwGrList().size(); ++i) {
                if (!wwGr.equals(this.getOwnWwGrList().get(i).getProperty("ww_gr"))) continue;
                return true;
            }
        }
        return false;
    }

    public View getPhotoView() {
        return this.photoView;
    }

    public View getGafView() {
        return this.gafView;
    }

    public void setPhotoView(View photoView) {
        this.photoView = photoView;
    }

    public void setGafView(View gafView) {
        this.gafView = gafView;
    }

    public ExportAction getPhotoExport() {
        return this.photoExport;
    }

    public void setPhotoExport(ExportAction photoExport) {
        this.photoExport = photoExport;
    }

    public de.cismet.watergis.gui.actions.gaf.ExportAction getGafExport() {
        return this.gafExport;
    }

    public void setGafExport(de.cismet.watergis.gui.actions.gaf.ExportAction gafExport) {
        this.gafExport = gafExport;
    }

    public ReportAction getPhotoPrint() {
        return this.photoPrint;
    }

    public void setPhotoPrint(ReportAction photoPrint) {
        this.photoPrint = photoPrint;
    }

    public de.cismet.watergis.gui.actions.gaf.ReportAction getGafPrint() {
        return this.gafPrint;
    }

    public void setGafPrint(de.cismet.watergis.gui.actions.gaf.ReportAction gafPrint) {
        this.gafPrint = gafPrint;
    }

    public Action getLastActionMode() {
        return this.lastActionMode;
    }

    static {
        DEFAULT_MODE_COLOR = blue = new Color(124, 160, 221);
    }

    private static final class LazyInitialiser {
        static final AppBroker INSTANCE = new AppBroker();

        private LazyInitialiser() {
        }
    }
}

