/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.download;

import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.tools.gui.downloadmanager.AbstractDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.watergis.gui.actions.gaf.ReportAction;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class QpDownload
extends AbstractDownload {
    private static final Logger LOG = Logger.getLogger(QpDownload.class);
    private final String extension;
    private final CidsLayerFeature qpFeature;
    private final Integer qpNr;

    public QpDownload(String filename, String extension, String directory, Integer qpNr, CidsLayerFeature qpFeature) {
        this.extension = extension;
        this.qpFeature = qpFeature;
        this.directory = directory;
        this.qpNr = qpNr;
        this.title = NbBundle.getMessage(QpDownload.class, (String)"QpDownload.title");
        this.status = Download.State.WAITING;
        this.determineDestinationFile(filename, extension);
    }

    public void run() {
        if (this.status != Download.State.WAITING) {
            return;
        }
        this.status = Download.State.RUNNING;
        this.stateChanged();
        this.deleteFile();
        if (this.qpFeature != null || this.qpNr != null) {
            try {
                if (this.qpFeature == null) {
                    ReportAction.createReport(this.qpNr, this.fileToSaveTo);
                }
                ReportAction.createReport(this.qpFeature, this.fileToSaveTo);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while creating qp report.", (Throwable)ex);
                this.status = Download.State.COMPLETED_WITH_ERROR;
                this.stateChanged();
                this.deleteFile();
                return;
            }
        } else {
            LOG.error((Object)"Error while creating qp report: No CidsLayerFeature");
            this.status = Download.State.COMPLETED_WITH_ERROR;
            this.stateChanged();
        }
        if (this.status == Download.State.RUNNING) {
            this.status = Download.State.COMPLETED;
            this.stateChanged();
        }
    }

    public boolean cancel() {
        boolean cancelled = true;
        if (this.downloadFuture != null) {
            cancelled = this.downloadFuture.cancel(true);
        }
        if (cancelled) {
            this.status = Download.State.ABORTED;
            this.stateChanged();
        }
        return cancelled;
    }

    private void deleteFile() {
        if (this.fileToSaveTo.exists() && this.fileToSaveTo.isFile()) {
            this.fileToSaveTo.delete();
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 37 * hash + (this.extension != null ? this.extension.hashCode() : 0);
        hash = 37 * hash + (this.qpFeature != null ? this.qpFeature.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        QpDownload other = (QpDownload)((Object)obj);
        if (this.extension == null ? other.extension != null : !this.extension.equals(other.extension)) {
            return false;
        }
        return this.qpFeature == other.qpFeature || this.qpFeature != null && this.qpFeature.equals((Object)other.qpFeature);
    }
}

