/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui;

import Sirius.navigator.DefaultNavigatorExceptionHandler;
import Sirius.navigator.connection.Connection;
import Sirius.navigator.connection.ConnectionFactory;
import Sirius.navigator.connection.ConnectionInfo;
import Sirius.navigator.connection.ConnectionSession;
import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.connection.proxy.ConnectionProxy;
import Sirius.navigator.exception.ConnectionException;
import Sirius.navigator.exception.ExceptionManager;
import Sirius.navigator.resource.PropertyManager;
import Sirius.navigator.types.treenode.PureTreeNode;
import Sirius.navigator.types.treenode.RootTreeNode;
import Sirius.navigator.ui.dialog.LoginDialog;
import Sirius.navigator.ui.tree.MetaCatalogueTree;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import Sirius.server.newuser.UserException;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import de.cismet.cids.custom.watergis.server.search.CheckForCreatedObjectTable;
import de.cismet.cids.custom.watergis.server.search.CleanupCreatedObjectTable;
import de.cismet.cids.custom.watergis.server.search.RemoveOldLocks;
import de.cismet.cids.custom.watergis.server.search.RemoveUnnusedRoute;
import de.cismet.cids.custom.watergis.server.search.ValidLawaCodes;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.navigator.utils.SimpleMemoryMonitoringToolbarWidget;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.DrawingManager;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.MappingModel;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.DrawingSLDStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.WFSCapabilitiesTreeCellRenderer;
import de.cismet.cismap.commons.featureservice.factory.H2FeatureServiceFactory;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableFactory;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableListener;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.capabilitywidget.CapabilityWidget;
import de.cismet.cismap.commons.gui.infowidgets.Legend;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.gui.layerwidget.LayerDropUtils;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerEvent;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerListener;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerMenuItem;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerWidget;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToFeaturesWorker;
import de.cismet.cismap.commons.gui.options.CapabilityWidgetOptionsPanel;
import de.cismet.cismap.commons.gui.overviewwidget.OverviewComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SimpleMoveListener;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.actions.CustomAction;
import de.cismet.cismap.commons.interaction.ActiveLayerListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.CrsChangeListener;
import de.cismet.cismap.commons.interaction.MapBoundsListener;
import de.cismet.cismap.commons.interaction.MapDnDListener;
import de.cismet.cismap.commons.interaction.StatusListener;
import de.cismet.cismap.commons.interaction.events.MapDnDEvent;
import de.cismet.cismap.commons.rasterservice.ImageFileMetaData;
import de.cismet.cismap.commons.rasterservice.ImageFileUtils;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.tools.ExportCsvDownload;
import de.cismet.cismap.commons.tools.ExportDbfDownload;
import de.cismet.cismap.commons.tools.ExportShapeDownload;
import de.cismet.cismap.commons.tools.ExportTxtDownload;
import de.cismet.cismap.commons.tools.PointReferencingDialog;
import de.cismet.cismap.commons.util.DnDUtils;
import de.cismet.cismap.commons.util.SelectionChangedEvent;
import de.cismet.cismap.commons.util.SelectionChangedListener;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.commons.concurrency.CismetConcurrency;
import de.cismet.commons.concurrency.CismetExecutors;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.lookupoptions.gui.OptionsClient;
import de.cismet.netutil.Proxy;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.BrowserLauncher;
import de.cismet.tools.StaticDebuggingTools;
import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.ConfigurationManager;
import de.cismet.tools.gui.HighlightingRadioButtonMenuItem;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.AbstractCancellableDownload;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.historybutton.HistoryModel;
import de.cismet.tools.gui.historybutton.JHistoryButton;
import de.cismet.tools.gui.log4jquickconfig.Log4JQuickConfig;
import de.cismet.tools.gui.startup.StaticStartupTools;
import de.cismet.veto.VetoException;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.broker.listener.DeleteFeatureListener;
import de.cismet.watergis.broker.listener.DrawingCountChangedEvent;
import de.cismet.watergis.broker.listener.DrawingsListener;
import de.cismet.watergis.broker.listener.PolygonChangeListener;
import de.cismet.watergis.check.BackgroundCheckEvent;
import de.cismet.watergis.check.BackgroundCheckListener;
import de.cismet.watergis.check.CheckBackgroundWorker;
import de.cismet.watergis.gui.GafInfoListener;
import de.cismet.watergis.gui.PhotoAngleListener;
import de.cismet.watergis.gui.PhotoInfoListener;
import de.cismet.watergis.gui.actions.AddThemeAction;
import de.cismet.watergis.gui.actions.AnnexAction;
import de.cismet.watergis.gui.actions.CentralConfigAction;
import de.cismet.watergis.gui.actions.CloseAction;
import de.cismet.watergis.gui.actions.CreateViewsForUser;
import de.cismet.watergis.gui.actions.DefaultConfig2Action;
import de.cismet.watergis.gui.actions.DefaultConfigAction;
import de.cismet.watergis.gui.actions.DownloadManagerAction;
import de.cismet.watergis.gui.actions.ExportIgmAction;
import de.cismet.watergis.gui.actions.ExportOptionAction;
import de.cismet.watergis.gui.actions.InfoAction;
import de.cismet.watergis.gui.actions.InfoWindowAction;
import de.cismet.watergis.gui.actions.IntermediateSaveAction;
import de.cismet.watergis.gui.actions.LocalConfigAction;
import de.cismet.watergis.gui.actions.MergeAction;
import de.cismet.watergis.gui.actions.NewObjectAction;
import de.cismet.watergis.gui.actions.OnlineHelpAction;
import de.cismet.watergis.gui.actions.OpenProjectAction;
import de.cismet.watergis.gui.actions.OptionsAction;
import de.cismet.watergis.gui.actions.PresentationAction;
import de.cismet.watergis.gui.actions.PrintAction;
import de.cismet.watergis.gui.actions.RefreshViewsForUser;
import de.cismet.watergis.gui.actions.ReleaseAction;
import de.cismet.watergis.gui.actions.SaveProjectAction;
import de.cismet.watergis.gui.actions.SaveToSameFileProjectAction;
import de.cismet.watergis.gui.actions.ShowWindowAction;
import de.cismet.watergis.gui.actions.SplitAction;
import de.cismet.watergis.gui.actions.WindowAction;
import de.cismet.watergis.gui.actions.bookmarks.ShowCreateBookmarkDialogAction;
import de.cismet.watergis.gui.actions.bookmarks.ShowManageBookmarksDialogAction;
import de.cismet.watergis.gui.actions.checks.AbstractCheckResult;
import de.cismet.watergis.gui.actions.checks.AusbauCheckAction;
import de.cismet.watergis.gui.actions.checks.BasicRoutesCheckAction;
import de.cismet.watergis.gui.actions.checks.BauwerkeCheckAction;
import de.cismet.watergis.gui.actions.checks.GWKConnectionCheckAction;
import de.cismet.watergis.gui.actions.checks.LawaCheckAction;
import de.cismet.watergis.gui.actions.checks.SonstigeCheckAction;
import de.cismet.watergis.gui.actions.checks.VerwaltungCheckAction;
import de.cismet.watergis.gui.actions.foto.ExportAction;
import de.cismet.watergis.gui.actions.foto.FotoInfoAction;
import de.cismet.watergis.gui.actions.foto.OptionAction;
import de.cismet.watergis.gui.actions.foto.UploadAction;
import de.cismet.watergis.gui.actions.gaf.CheckAction;
import de.cismet.watergis.gui.actions.gaf.DeleteAction;
import de.cismet.watergis.gui.actions.gaf.GafInfoAction;
import de.cismet.watergis.gui.actions.gaf.ReportAction;
import de.cismet.watergis.gui.actions.geoprocessing.BufferGeoprocessingAction;
import de.cismet.watergis.gui.actions.geoprocessing.ClipGeoprocessingAction;
import de.cismet.watergis.gui.actions.geoprocessing.DissolveGeoprocessingAction;
import de.cismet.watergis.gui.actions.geoprocessing.MergeGeoprocessingAction;
import de.cismet.watergis.gui.actions.geoprocessing.PointInLineGeoprocessingAction;
import de.cismet.watergis.gui.actions.geoprocessing.PointInPolygonGeoprocessingAction;
import de.cismet.watergis.gui.actions.geoprocessing.StationAction;
import de.cismet.watergis.gui.actions.geoprocessing.TechProfAction;
import de.cismet.watergis.gui.actions.geoprocessing.UnionGeoprocessingAction;
import de.cismet.watergis.gui.actions.map.ChangePolygonModeAction;
import de.cismet.watergis.gui.actions.map.CopyObjectAction;
import de.cismet.watergis.gui.actions.map.CreateGeoLinkAction;
import de.cismet.watergis.gui.actions.map.DeleteObjectAction;
import de.cismet.watergis.gui.actions.map.ExportMapAction;
import de.cismet.watergis.gui.actions.map.ExportMapToFileAction;
import de.cismet.watergis.gui.actions.map.FlipAction;
import de.cismet.watergis.gui.actions.map.FullExtendAction;
import de.cismet.watergis.gui.actions.map.GoToAction;
import de.cismet.watergis.gui.actions.map.LoadDrawingsAction;
import de.cismet.watergis.gui.actions.map.MeasureAction;
import de.cismet.watergis.gui.actions.map.MeasureLineAction;
import de.cismet.watergis.gui.actions.map.MoveModeAction;
import de.cismet.watergis.gui.actions.map.NewLinestringModeAction;
import de.cismet.watergis.gui.actions.map.NewMarkerModeAction;
import de.cismet.watergis.gui.actions.map.NewRectangleModeAction;
import de.cismet.watergis.gui.actions.map.NewTextModeAction;
import de.cismet.watergis.gui.actions.map.NextExtendAction;
import de.cismet.watergis.gui.actions.map.OptionModeAction;
import de.cismet.watergis.gui.actions.map.PanModeAction;
import de.cismet.watergis.gui.actions.map.PasteObjectAction;
import de.cismet.watergis.gui.actions.map.PreviousExtendAction;
import de.cismet.watergis.gui.actions.map.ReloadAction;
import de.cismet.watergis.gui.actions.map.RemoveDrawingModeAction;
import de.cismet.watergis.gui.actions.map.RemoveModeAction;
import de.cismet.watergis.gui.actions.map.SaveDrawingsAction;
import de.cismet.watergis.gui.actions.map.SelectionModeAction;
import de.cismet.watergis.gui.actions.map.ZoomInAction;
import de.cismet.watergis.gui.actions.map.ZoomModeAction;
import de.cismet.watergis.gui.actions.map.ZoomOutAction;
import de.cismet.watergis.gui.actions.reports.GerinneGFlReportAction;
import de.cismet.watergis.gui.actions.reports.GerinneGGemeindeReportAction;
import de.cismet.watergis.gui.actions.reports.GerinneGGewaesserReportAction;
import de.cismet.watergis.gui.actions.reports.GerinneGSbReportAction;
import de.cismet.watergis.gui.actions.reports.GerinneOFlReportAction;
import de.cismet.watergis.gui.actions.reports.GerinneOGemeindeReportAction;
import de.cismet.watergis.gui.actions.reports.GerinneOGewReportAction;
import de.cismet.watergis.gui.actions.reports.GerinneOSbReportAction;
import de.cismet.watergis.gui.actions.reports.GerogaRsAction;
import de.cismet.watergis.gui.actions.reports.GewaesserReportAction;
import de.cismet.watergis.gui.actions.reports.KatasterFlaechenReportAction;
import de.cismet.watergis.gui.actions.reports.KatasterGemeindenReportAction;
import de.cismet.watergis.gui.actions.reports.KatasterGewaesserReportAction;
import de.cismet.watergis.gui.actions.reports.KatasterSbReportAction;
import de.cismet.watergis.gui.actions.reports.RechtsgrundlageAction;
import de.cismet.watergis.gui.actions.reports.WkFgReportAction;
import de.cismet.watergis.gui.actions.reports.WsgAction;
import de.cismet.watergis.gui.actions.reports.WsgWaldAction;
import de.cismet.watergis.gui.actions.reports.template.TemplateExportAction;
import de.cismet.watergis.gui.actions.selection.InvertSelectionAction;
import de.cismet.watergis.gui.actions.selection.RemoveSelectionAllTopicsAction;
import de.cismet.watergis.gui.actions.selection.SelectAllAction;
import de.cismet.watergis.gui.actions.selection.SelectAllDrawingsAction;
import de.cismet.watergis.gui.actions.selection.SelectionAttributeAction;
import de.cismet.watergis.gui.actions.selection.SelectionEllipseAction;
import de.cismet.watergis.gui.actions.selection.SelectionLocationAction;
import de.cismet.watergis.gui.actions.selection.SelectionPolygonAction;
import de.cismet.watergis.gui.actions.selection.SelectionRectangleAction;
import de.cismet.watergis.gui.actions.selection.UnselectAllDrawingsAction;
import de.cismet.watergis.gui.actions.selection.ZoomAllDrawingsAction;
import de.cismet.watergis.gui.actions.selection.ZoomSelectedDrawingsAction;
import de.cismet.watergis.gui.actions.selection.ZoomSelectedObjectsAction;
import de.cismet.watergis.gui.actions.selection.ZoomSelectedThemesAction;
import de.cismet.watergis.gui.actions.window.ShowHideOverviewWindowAction;
import de.cismet.watergis.gui.components.GeometryOpButton;
import de.cismet.watergis.gui.components.MeasureButton;
import de.cismet.watergis.gui.components.NewDrawingButton;
import de.cismet.watergis.gui.components.ScaleJComboBox;
import de.cismet.watergis.gui.components.SelectionButton;
import de.cismet.watergis.gui.components.SnappingButton;
import de.cismet.watergis.gui.dialog.ThemeExportDialog;
import de.cismet.watergis.gui.panels.GafProf;
import de.cismet.watergis.gui.panels.InfoPanel;
import de.cismet.watergis.gui.panels.MapPanel;
import de.cismet.watergis.gui.panels.Photo;
import de.cismet.watergis.gui.panels.RouteZoomPanel;
import de.cismet.watergis.gui.panels.SelectionPanel;
import de.cismet.watergis.gui.panels.StatusBar;
import de.cismet.watergis.gui.panels.StatusPanel;
import de.cismet.watergis.gui.panels.ZoomPanel;
import de.cismet.watergis.gui.recently_opened_files.FileMenu;
import de.cismet.watergis.gui.recently_opened_files.RecentlyOpenedFilesList;
import de.cismet.watergis.server.GeoLinkServer;
import de.cismet.watergis.utils.BookmarkManager;
import de.cismet.watergis.utils.FeatureServiceHelper;
import de.cismet.watergis.utils.WatergisTreeNodeVisualizationService;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.DockingWindowAdapter;
import net.infonode.docking.DockingWindowListener;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.mouse.DockingWindowActionMouseButtonListener;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.theme.ShapedGradientDockingTheme;
import net.infonode.docking.util.AbstractViewMap;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.PropertiesUtil;
import net.infonode.docking.util.StringViewMap;
import net.infonode.gui.componentpainter.AlphaGradientComponentPainter;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.tabbedpanel.TabAreaVisiblePolicy;
import net.infonode.util.Direction;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.jdesktop.swingx.autocomplete.AutoCompleteDecorator;
import org.jdom.Content;
import org.jdom.Element;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WatergisApp
extends JFrame
implements Configurable,
WindowListener,
Observer,
FeatureCollectionListener,
ThemeLayerListener,
MapDnDListener,
SelectionChangedListener {
    private static final Logger LOG = Logger.getLogger(WatergisApp.class);
    private static JFrame SPLASH;
    private static final ConfigurationManager configManager;
    private static final String FILENAME_WATERGIS_CONFIGURATION = "defaultWatergisProperties.xml";
    private static final String FILENAME_LOCAL_WATERGIS_CONFIGURATION = "watergisProperties.xml";
    private static final String CLASSPATH_WATERGIS_CONFIGURATION = "/de/cismet/watergis/configuration/";
    private static final String DIRECTORYPATH_HOME;
    private static final String DIRECTORYEXTENSION;
    private static final String FILESEPARATOR;
    private static final String DIRECTORYNAME_WATERGISHOME;
    private static final String DIRECTORYPATH_WATERGIS;
    private static final String FILEPATH_DEFAULT_LAYOUT;
    private static final String FILEPATH_PLUGIN_LAYOUT;
    private static final String FILEPATH_DEFAULT_APP_DATA;
    private static final String FILEPATH_SCREEN;
    private static final String CONNECTION_PROPERTIES_FILE = "/serverConnection.properties";
    private static final ConnectionContext connectionContext;
    DataFlavor CAPABILITY_WIDGET_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "SelectionAndCapabilities");
    private Integer httpInterfacePort = 9098;
    private RootWindow rootWindow;
    private TabWindow tabWindow;
    private StringViewMap viewMap = new StringViewMap();
    private HashMap<String, View> attributeTableMap = new HashMap();
    private Dimension windowSize = null;
    private Point windowLocation = null;
    private MapPanel pMap;
    private Photo pPhoto;
    private GafProf pGaf;
    private ThemeLayerWidget pTopicTree;
    private InfoPanel pInfo;
    private SelectionPanel pSelection;
    private MetaCatalogueTree pTable;
    private JScrollPane pTablePane = new JScrollPane();
    private OverviewComponent pOverview;
    private CapabilityWidget pCapabilities;
    private Legend pLegend;
    private View vMap;
    private View vPhoto;
    private View vGaf;
    private View vTopicTree;
    private View vTable;
    private View vOverview;
    private View vCapability;
    private View vLegend;
    private MappingComponent mappingComponent;
    private ActiveLayerModel mappingModel = new ActiveLayerModel();
    private MetaClass routeMc;
    private MetaClass wwGrMc;
    private List<TemplateExportAction> allTemplates = new ArrayList<TemplateExportAction>();
    private AddThemeAction addThemeTreeAction;
    private String helpURL;
    private String infoURL;
    private boolean isInit = true;
    private Executor watergisSingleThreadExecutor = CismetExecutors.newSingleThreadExecutor();
    private String lastExportPath = null;
    private String currentLayoutFile = null;
    private AddThemeAction addThemeAction1;
    private AnnexAction annexAction;
    private AusbauCheckAction ausbauCheckAction;
    private BasicRoutesCheckAction basicRoutesCheckAction1;
    private BauwerkeCheckAction bauwerkeCheckAction;
    private ButtonGroup btnGroupMapMode;
    private BufferGeoprocessingAction bufferGeoprocessingAction;
    private JButton butIntermediateSave;
    private JComboBox cboScale;
    private JComboBox cboTheme;
    private CentralConfigAction centralConfigAction;
    private ChangePolygonModeAction changePolygonModeAction1;
    private CheckAction checkAction1;
    private ClipGeoprocessingAction clipGeoprocessingAction;
    private CloseAction closeAction;
    private JButton cmdAddBookmark;
    private JButton cmdAnnex;
    private JButton cmdCopy;
    private JButton cmdDelete;
    private JButton cmdDownloadManager;
    private JButton cmdDownloadManager1;
    private JButton cmdDrawingMode;
    private JButton cmdDrawingOptions;
    private JButton cmdExportMap1;
    private JButton cmdExportMap2;
    private JButton cmdFreeStat;
    private JButton cmdFullExtend;
    private JButton cmdGeoLink;
    private JButton cmdGeometryOpMode;
    private JButton cmdGoTo;
    private JButton cmdInvertSelection;
    private JButton cmdLoadDrawings;
    private JButton cmdManageBookmarks;
    private JButton cmdMerge;
    private JToggleButton cmdMoveGeometry;
    private JToggleButton cmdNewLinestring;
    private JToggleButton cmdNewPoint;
    private JToggleButton cmdNewPolygon;
    private JToggleButton cmdNewText;
    private JButton cmdNextExtend;
    private JToggleButton cmdNodeAdd;
    private JToggleButton cmdNodeMove;
    private JToggleButton cmdNodeRemove;
    private JButton cmdOnlineHelp;
    private JButton cmdOpenProject;
    private JButton cmdPaste;
    private JButton cmdPresentation;
    private JButton cmdPreviousExtend;
    private JButton cmdPrint;
    private JButton cmdRefresh;
    private JButton cmdRelease;
    private JButton cmdRemoveGeometry;
    private JButton cmdRemoveSelectionAllThemes;
    private JButton cmdSaveDrawings;
    private JButton cmdSaveProject;
    private JButton cmdSaveSameFileProject;
    private JButton cmdSelectAll;
    private JButton cmdSelectAllDrawings;
    private JButton cmdSelectionAttribute;
    private JButton cmdSelectionLocation;
    private JButton cmdSelectionMode;
    private JButton cmdSnappingMode;
    private JButton cmdSplit;
    private JButton cmdUndo;
    private JButton cmdUnselectDrawings;
    private JButton cmdZoomIn;
    private JButton cmdZoomOut;
    private JButton cmdZoomSelectedObjects;
    private JButton cmdZoomSelectedThemes;
    private JButton cmdZoomToAllDrawings;
    private JButton cmdZoomToSelectedDrawings;
    private CopyObjectAction copyObjectAction1;
    private CreateGeoLinkAction createGeoLinkAction;
    private CreateViewsForUser createViewsForUser1;
    private DefaultConfig2Action defaultConfig2Action1;
    private DefaultConfigAction defaultConfigAction1;
    private de.cismet.watergis.gui.actions.foto.DeleteAction deleteAction1;
    private DeleteAction deleteActionGaf;
    private DeleteObjectAction deleteObjectAction1;
    private DissolveGeoprocessingAction dissolveGeoprocessingAction;
    private DownloadManagerAction downloadManagerAction;
    private ButtonGroup drawingGroup;
    private ButtonGroup editGroup;
    private de.cismet.watergis.gui.actions.ExportAction exportAction1;
    private de.cismet.watergis.gui.actions.gaf.ExportAction exportActionGaf;
    private ExportAction exportActionPhoto;
    private ExportIgmAction exportIgmAction;
    private ExportMapAction exportMapAction;
    private ExportMapToFileAction exportMapToFileAction;
    private ExportOptionAction exportOptionAction;
    private KatasterFlaechenReportAction flaechenReportAction1;
    private FlipAction flipAction;
    private FotoInfoAction fotoInfoAction1;
    private FullExtendAction fullExtendAction;
    private GWKConnectionCheckAction gWKConnectionCheckAction;
    private GafInfoAction gafInfoAction;
    private KatasterGemeindenReportAction gemeindenReportAction;
    private GerinneGFlReportAction gerinneGFlReportAction1;
    private GerinneGGewaesserReportAction gerinneGGewaesserReportAction1;
    private GerinneGSbReportAction gerinneGSbReportAction1;
    private GerinneOFlReportAction gerinneOFlReportAction1;
    private GerinneOGemeindeReportAction gerinneOGemeindeReportAction;
    private GerinneOGewReportAction gerinneOGewReportAction;
    private GerinneOSbReportAction gerinneOSbReportAction;
    private GerogaRsAction gerogaRsAction1;
    private KatasterGewaesserReportAction gewaesserGewReportAction;
    private GewaesserReportAction gewaesserReportAction;
    private GoToAction goToAction;
    private InfoAction infoAction;
    private InfoWindowAction infoWindowAction;
    private IntermediateSaveAction intermediateSaveAction;
    private InvertSelectionAction invertSelectionAction;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JPopupMenu.Separator jSeparator1;
    private JToolBar.Separator jSeparator11;
    private JToolBar.Separator jSeparator14;
    private JToolBar.Separator jSeparator15;
    private JPopupMenu.Separator jSeparator2;
    private JToolBar jToolBar1;
    private LawaCheckAction lawaCheckAction;
    private JLabel lblPlaceholder;
    private LoadDrawingsAction loadDrawingsAction;
    private LocalConfigAction localConfigAction;
    private MeasureAction measureAction;
    private MeasureLineAction measureLineAction;
    private JMenu menBasicChecks;
    private JMenu menBookmark;
    private JMenu menChecks;
    private JMenu menChecks1;
    private JMenu menDrawings;
    private JMenu menExtendedChecks;
    private JMenu menFile;
    private JMenu menGeoProcessing;
    private JMenu menGewaesser;
    private JMenu menGewaesser1;
    private JMenu menGewaesser2;
    private JMenu menGewaesser3;
    private JMenu menHelp;
    private JMenu menPhoto;
    private JMenu menProfiles;
    private JMenu menReport;
    private JMenu menSchablonen;
    private JMenu menSelection;
    private JMenu menStatistik;
    private JMenu menSteckbrief;
    private JMenu menSteckbriefGewaesser;
    private JMenu menSteckbriefPhotos;
    private JMenu menSteckbriefQp;
    private JMenu menSteckbriefWasserkoerper;
    private JMenu menTools;
    private JMenu menWindow;
    private JMenu menWsg;
    private MergeAction mergeAction;
    private MergeGeoprocessingAction mergeGeoprocessingAction;
    private JMenuItem mniBuffer;
    private JMenuItem mniCheckAusbau;
    private JMenuItem mniCheckBasisRoutes;
    private JMenuItem mniCheckBauwerke;
    private JMenuItem mniCheckLawa;
    private JMenuItem mniCheckLawaConnection;
    private JMenuItem mniCheckSonstige;
    private JMenuItem mniCheckVerwaltung;
    private JMenuItem mniClip;
    private JMenuItem mniClose;
    private JMenuItem mniCreateBookmark;
    private JMenuItem mniCreateDbUser;
    private JMenuItem mniCreateGeoLink;
    private JMenuItem mniDefaultConfig;
    private JMenuItem mniDeleteGaf;
    private JMenuItem mniDeletePhoto;
    private JMenuItem mniDissolve;
    private JMenuItem mniDownloadManager;
    private JMenuItem mniDrawingOptions;
    private JMenuItem mniExport;
    private JMenuItem mniExportGaf;
    private JMenuItem mniExportMap;
    private JMenuItem mniExportOption;
    private JMenuItem mniExportPhoto;
    private JMenuItem mniFG;
    private JMenuItem mniFileOptions;
    private JMenuItem mniFl;
    private JMenuItem mniFl1;
    private JMenuItem mniFl2;
    private JMenuItem mniFlNu;
    private JMenuItem mniGafInfo;
    private JMenuItem mniGafOptions;
    private JMenuItem mniGafUpload;
    private JMenuItem mniGemeinde;
    private JMenuItem mniGemeinde1;
    private JMenuItem mniGemeinde2;
    private JMenuItem mniGewaesser;
    private JMenuItem mniGewaesserRep;
    private JMenuItem mniGewaesserRep1;
    private JMenuItem mniGewaesserRep2;
    private JMenuItem mniGewaesserRep3;
    private JMenuItem mniHelp;
    private JMenuItem mniIgmExport;
    private JMenuItem mniInfo;
    private JMenuItem mniLoadDrawings;
    private JMenuItem mniManageBookmarks;
    private JMenuItem mniMerge;
    private JMenuItem mniNewLineStringDrawing;
    private JMenuItem mniNewMarkerDrawing;
    private JMenuItem mniNewRectangleDrawing;
    private JMenuItem mniNewTextDrawing;
    private JMenuItem mniOpenProject;
    private JMenuItem mniOverview;
    private JMenuItem mniPhotoInfo;
    private JMenuItem mniPhotoOptions;
    private JMenuItem mniPointInLine;
    private JMenuItem mniPointInPolygon;
    private JMenuItem mniPrint;
    private JMenuItem mniPrintPhoto;
    private JMenuItem mniPrintQp;
    private JMenuItem mniRechtsgrundlage;
    private JMenuItem mniRechtsgrundlage1;
    private JMenuItem mniRefreshDbUser;
    private JMenuItem mniRemoveDrawing;
    private JMenuItem mniRemoveSelection;
    private JMenuItem mniReportGaf;
    private JMenuItem mniReportPhoto;
    private JMenuItem mniSaveDrawings;
    private JMenuItem mniSaveMapToFile;
    private JMenuItem mniSaveProject;
    private JMenuItem mniSaveProject1;
    private JMenuItem mniSb;
    private JMenuItem mniSb1;
    private JMenuItem mniSb2;
    private JMenuItem mniSelectAllDrawing;
    private JMenuItem mniSelectAttribute;
    private JMenuItem mniSelectEllipse;
    private JMenuItem mniSelectLocation;
    private JMenuItem mniSelectPolygon;
    private JMenuItem mniSelectRectangle;
    private JMenuItem mniShowDatasource;
    private JMenuItem mniShowDefaultConfig2;
    private JMenuItem mniShowInfo;
    private JMenuItem mniShowLegend;
    private JMenuItem mniShowMap;
    private JMenuItem mniShowOverview;
    private JMenuItem mniShowPhotos;
    private JMenuItem mniShowProblems;
    private JMenuItem mniShowProfiles;
    private JMenuItem mniShowTree;
    private JMenuItem mniStation;
    private JMenuItem mniTechProf;
    private JMenuItem mniUnion;
    private JMenuItem mniUnselectAllDrawing;
    private JMenuItem mniUpload;
    private JMenuItem mniZoomAllDrawings;
    private JMenuItem mniZoomSelectedDrawings;
    private JMenuItem mniZoomSelectedObjects;
    private JMenuItem mniZoomSelectedThemes;
    private MoveModeAction moveModeAction;
    private NewLinestringModeAction newLinestringModeAction;
    private NewMarkerModeAction newMarkerModeAction;
    private NewObjectAction newObjectAction;
    private NewRectangleModeAction newRectangleModeAction;
    private NewTextModeAction newTextModeAction;
    private NextExtendAction nextExtendAction;
    private OnlineHelpAction onlineHelpAction;
    private OpenProjectAction openProjectAction;
    private OptionAction optionAction1;
    private de.cismet.watergis.gui.actions.gaf.OptionAction optionActionGaf;
    private OptionModeAction optionModeAction1;
    private OptionsAction optionsAction;
    private PanModeAction panAction;
    private JPanel panMain;
    private JPanel panSearch;
    private PasteObjectAction pasteObjectAction1;
    private PointInLineGeoprocessingAction pointInLineGeoprocessingAction;
    private PointInPolygonGeoprocessingAction pointInPolygonGeoprocessingAction;
    private PresentationAction presentationAction;
    private PreviousExtendAction previousExtendAction;
    private PrintAction printAction;
    private RechtsgrundlageAction rechtsgrundlageAction1;
    private RefreshViewsForUser refreshViewsForUser1;
    private ReleaseAction releaseAction;
    private ReloadAction reloadAction1;
    private RemoveDrawingModeAction removeDrawingModeAction;
    private RemoveModeAction removeModeAction1;
    private RemoveSelectionAllTopicsAction removeSelectionAllTopicsAction;
    private de.cismet.watergis.gui.actions.foto.ReportAction reportAction1;
    private ReportAction reportActionGaf;
    private GerinneGGemeindeReportAction rlDDueReportAction;
    private RouteZoomPanel routeZoomPanel;
    private SaveDrawingsAction saveDrawingsAction;
    private SaveProjectAction saveProjectAction;
    private SaveToSameFileProjectAction saveToSameFileProjectAction1;
    private KatasterSbReportAction sbReportAction;
    private SelectAllAction selectAllAction;
    private SelectAllDrawingsAction selectAllDrawingsAction;
    private SelectionAttributeAction selectionAttributeAction;
    private SelectionEllipseAction selectionEllipseAction;
    private SelectionLocationAction selectionLocationAction;
    private SelectionModeAction selectionModeAction;
    private SelectionPolygonAction selectionPolygonAction;
    private SelectionRectangleAction selectionRectangleAction;
    private JPopupMenu.Separator sepCentralFilesEnd;
    private JPopupMenu.Separator sepCentralFilesStart;
    private JPopupMenu.Separator sepDrawingOperation;
    private JPopupMenu.Separator sepDrawingOperation1;
    private JPopupMenu.Separator sepLocalFilesEnd;
    private JPopupMenu.Separator sepWindowSeparator;
    private ShowCreateBookmarkDialogAction showCreateBookmarkDialogAction;
    private ShowWindowAction showDatasource;
    private ShowHideOverviewWindowAction showHideOverviewWindowAction;
    private ShowWindowAction showInfo;
    private InfoWindowAction showInfoWindowAction;
    private ShowWindowAction showLegend;
    private ShowManageBookmarksDialogAction showManageBookmarksDialogAction;
    private ShowWindowAction showMap;
    private ShowWindowAction showOverview;
    private ShowWindowAction showPhoto;
    private ShowWindowAction showProblems;
    private ShowWindowAction showProfiles;
    private ShowWindowAction showTree;
    private SimpleMemoryMonitoringToolbarWidget simpleMemoryMonitoringToolbarWidget1;
    private SonstigeCheckAction sonstigeCheckAction;
    private SplitAction splitAction;
    private StationAction stationAction1;
    private StatusBar statusBar1;
    private StatusPanel statusPanel1;
    private JToggleButton tbtNewObject;
    private JToggleButton tbtnAddMode;
    private JToggleButton tbtnInfo;
    private JButton tbtnMeasure;
    private JToggleButton tbtnMeasureLineMode;
    private JToggleButton tbtnPanMode;
    private JToggleButton tbtnPhotoInfoMode;
    private JToggleButton tbtnProfileInfoMode;
    private JToggleButton tbtnRemoveMode;
    private JToggleButton tbtnZoomMode;
    private TechProfAction techProfAction1;
    private JToolBar tobDLM25W;
    private UnionGeoprocessingAction unionGeoprocessingAction;
    private UnselectAllDrawingsAction unselectAllDrawingsAction;
    private UploadAction uploadAction1;
    private de.cismet.watergis.gui.actions.gaf.UploadAction uploadActionGaf;
    private VerwaltungCheckAction verwaltungCheckAction;
    private WindowAction windowAction;
    private WkFgReportAction wkFgReportAction;
    private WsgAction wsgAction1;
    private WsgWaldAction wsgWaldAction1;
    private ZoomAllDrawingsAction zoomAllDrawingsAction;
    private ZoomInAction zoomInAction;
    private ZoomModeAction zoomModeAction;
    private ZoomOutAction zoomOutAction;
    private ZoomSelectedDrawingsAction zoomSelectedDrawingsAction;
    private ZoomSelectedObjectsAction zoomSelectedObjectsAction;
    private ZoomSelectedThemesAction zoomSelectedThemesAction1;

    public WatergisApp() {
        ArrayList<String> messages;
        this.addWindowListener(this);
        CismapBroker.getInstance().setUseInternalDb(true);
        CismapBroker.getInstance().setFeatureStylingComponentKey("Jump");
        CismapBroker.getInstance().setHighlightFeatureOnMouseOver(false);
        CismapBroker.getInstance().setDefaultTranslucency(1.0f);
        StaticSwingTools.tweakUI();
        try {
            this.initConnection();
        }
        catch (Exception e) {
            LOG.error((Object)"Connection exception", (Throwable)e);
            messages = new ArrayList<String>();
            StackTraceElement[] elements = e.getStackTrace();
            messages.add("call server: " + AppBroker.getInstance().getCallserverUrl());
            messages.add("Connection class: " + AppBroker.getInstance().getConnectionClass());
            messages.add("Domain: " + AppBroker.getInstance().getDomain());
            if (ProxyHandler.getInstance().getProxy() != null) {
                messages.add("proxy: " + ProxyHandler.getInstance().getProxy().isEnabled());
            }
            messages.add(e.getMessage());
            for (int i = 0; i < elements.length; ++i) {
                if (elements[i] == null) continue;
                messages.add(elements[i].toString());
            }
            ExceptionManager.getManager().showExceptionDialog((JFrame)this, 2, "Exception", e.getMessage(), messages);
        }
        try {
            H2FeatureServiceFactory.tryDBConnection(null);
        }
        catch (SQLException e) {
            System.err.println("Database is already in use");
            messages = new ArrayList();
            messages.add("Die interne Datenbank wird bereits genutzt. Wahrscheinlich l\u00e4uft bereits eine Instanz der Anwendung und es k\u00f6nnen keine 2 Instanzen parallel laufen.");
            ExceptionManager.getManager().showExceptionDialog((JFrame)this, 2, "Exception", e.getMessage(), messages);
            System.exit(1);
        }
        H2FeatureService.clearLocks();
        H2FeatureService.removeUnusedSequences();
        HashMap<HostConfiguration, Integer> maxHostConnections = new HashMap<HostConfiguration, Integer>();
        maxHostConnections.put(HostConfiguration.ANY_HOST_CONFIGURATION, 128);
        HttpConnectionManagerParams.getDefaultParams().setParameter("http.connection-manager.max-per-host", maxHostConnections);
        HttpConnectionManagerParams.getDefaultParams().setIntParameter("http.connection-manager.max-total", 128);
        HttpConnectionManagerParams.getDefaultParams().setIntParameter("http.socket.linger", 2);
        configManager.addConfigurable((Configurable)this);
        configManager.configure((Configurable)this);
        ClassCacheMultiple.setInstance((String)"DLM25W");
        AppBroker.setConfigManager(configManager);
        UIManager.put("Table.selectionBackground", new Color(195, 212, 232));
        UIManager.put("Tree.selectionBackground", new Color(195, 212, 232));
        UIManager.put("Cismap.featureSelectionForeground", new Color(255, 0, 0));
        this.initCismap();
        configManager.addConfigurable((Configurable)OptionsClient.getInstance());
        configManager.configure((Configurable)OptionsClient.getInstance());
        this.routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
        this.wwGrMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_ww_gr");
        this.initComponents();
        boolean backgroundChecksEnabled = false;
        try {
            backgroundChecksEnabled = SessionManager.getProxy().getConfigAttr(SessionManager.getSession().getUser(), "backgroundChecksEnabled", connectionContext) != null;
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Cannot check for backgroundChecks permission", (Throwable)ex);
        }
        this.statusPanel1.setVisible(backgroundChecksEnabled);
        this.menSteckbriefWasserkoerper.setVisible(false);
        this.selectionModeAction.setButton(this.cmdSelectionMode);
        this.configureButtons();
        this.cmdSelectAll.setVisible(false);
        this.cmdInvertSelection.setVisible(false);
        this.cmdZoomIn.setVisible(false);
        this.cmdZoomOut.setVisible(false);
        this.mniOverview.setVisible(false);
        this.cmdDrawingMode.setVisible(false);
        this.cmdRefresh.setVisible(false);
        CismapBroker.getInstance().addMapDnDListener((MapDnDListener)this);
        this.cmdAnnex.setAction(new AnnexAction(true));
        this.cmdAnnex.setEnabled(false);
        if (this.simpleMemoryMonitoringToolbarWidget1.isVisible()) {
            this.jToolBar1.add((Action)this.simpleMemoryMonitoringToolbarWidget1);
        }
        ((NewDrawingButton)((Object)this.cmdDrawingMode)).setButtonGroup(this.btnGroupMapMode);
        this.exportIgmAction.setExport(this.exportAction1);
        this.retrievePermissionbeans();
        if (!SessionManager.getSession().getUser().getUserGroup().getName().equalsIgnoreCase("administratoren")) {
            this.mniCheckLawa.setEnabled(false);
            this.mniCheckLawaConnection.setEnabled(false);
            this.mniCreateDbUser.setEnabled(false);
            this.mniRefreshDbUser.setEnabled(false);
            this.mniSb.setEnabled(false);
            this.mniFl.setEnabled(false);
            this.mniGewaesserRep1.setEnabled(false);
            this.mniGewaesserRep2.setEnabled(false);
            this.mniGemeinde2.setEnabled(false);
            this.mniSb2.setEnabled(false);
            this.mniFl2.setEnabled(false);
            this.mniGemeinde1.setEnabled(false);
            this.mniSb1.setEnabled(false);
            this.mniFl1.setEnabled(false);
            this.menWsg.setVisible(false);
        }
        if (!AppBroker.getInstance().isAdminUser() && !AppBroker.getInstance().isGu()) {
            this.mniCheckAusbau.setEnabled(false);
            this.mniCheckBasisRoutes.setEnabled(false);
            this.mniCheckBauwerke.setEnabled(false);
            this.mniCheckSonstige.setEnabled(false);
            this.mniCheckVerwaltung.setEnabled(false);
        }
        if (!AppBroker.getInstance().isWawiOrAdminUser()) {
            this.mniIgmExport.setEnabled(false);
            this.mniExport.setEnabled(false);
            this.mniExportOption.setEnabled(false);
        }
        ((MeasureButton)((Object)this.tbtnMeasure)).setButtonGroup(this.btnGroupMapMode);
        ((SelectionButton)((Object)this.cmdSelectionMode)).setButtonGroup(this.btnGroupMapMode);
        boolean drawingsExists = DrawingManager.getInstance().featuresExists();
        this.cmdSaveDrawings.setEnabled(drawingsExists);
        this.mniSaveDrawings.setEnabled(drawingsExists);
        this.mniZoomAllDrawings.setEnabled(drawingsExists);
        this.cmdZoomToAllDrawings.setEnabled(drawingsExists);
        this.cmdSelectAllDrawings.setEnabled(drawingsExists);
        this.mniSelectAllDrawing.setEnabled(drawingsExists);
        this.initDefaultPanels();
        if (backgroundChecksEnabled) {
            this.initialiseStatusPanel();
        }
        this.initMapModes();
        this.initHistoryButtonsAndRecentlyOpenedFiles();
        this.initInfoNode();
        this.initAttributeTable();
        this.configureFileMenu();
        this.initLog4JQuickConfig();
        this.initBookmarkManager();
        this.retrieveValidLawaCodes();
        AppBroker.getInstance().setInfoWindowAction(this.infoWindowAction);
        if (!EventQueue.isDispatchThread()) {
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        WatergisApp.this.loadLayout(FILEPATH_DEFAULT_LAYOUT);
                        WatergisApp.this.isInit = false;
                    }
                });
            }
            catch (InterruptedException ex) {
                LOG.fatal((Object)"Problem during loading layout.", (Throwable)ex);
            }
            catch (InvocationTargetException ex) {
                LOG.fatal((Object)"Problem during loading layout.", (Throwable)ex);
            }
        } else {
            this.loadLayout(FILEPATH_DEFAULT_LAYOUT);
            this.isInit = false;
        }
        if (!StaticDebuggingTools.checkHomeForFile((String)"cismetTurnOffInternalWebserver")) {
            this.initHttpServer();
        }
        this.panMain.add((Component)this.rootWindow, "Center");
        this.setWindowSize();
        this.mappingComponent.unlock();
        this.pOverview.getOverviewMap().unlock();
        this.pTopicTree.addThemeLayerListener((ThemeLayerListener)this);
        AppBroker.getInstance().setPhotoExport(this.exportActionPhoto);
        AppBroker.getInstance().setGafExport(this.exportActionGaf);
        AppBroker.getInstance().setPhotoPrint(this.reportAction1);
        AppBroker.getInstance().setGafPrint(this.reportActionGaf);
        SelectionManager.getInstance().addSelectionChangedListener((SelectionChangedListener)this);
        DrawingManager.getInstance().addDrawingsListener(new DrawingsListener(){

            @Override
            public void drawingsCountChanged(DrawingCountChangedEvent e) {
                boolean featuresExists = DrawingManager.getInstance().featuresExists();
                boolean drawsSelected = !RemoveDrawingModeAction.getSelectedDrawings().isEmpty();
                WatergisApp.this.cmdSaveDrawings.setEnabled(featuresExists);
                WatergisApp.this.mniZoomAllDrawings.setEnabled(featuresExists);
                WatergisApp.this.cmdZoomToAllDrawings.setEnabled(featuresExists);
                WatergisApp.this.mniSaveDrawings.setEnabled(featuresExists);
                WatergisApp.this.cmdSelectAllDrawings.setEnabled(featuresExists);
                WatergisApp.this.mniSelectAllDrawing.setEnabled(featuresExists);
                WatergisApp.this.cmdRemoveGeometry.setEnabled(drawsSelected);
                WatergisApp.this.mniRemoveDrawing.setEnabled(drawsSelected);
                WatergisApp.this.mniZoomSelectedDrawings.setEnabled(drawsSelected);
                WatergisApp.this.cmdZoomToSelectedDrawings.setEnabled(drawsSelected);
                WatergisApp.this.mniUnselectAllDrawing.setEnabled(drawsSelected);
                WatergisApp.this.cmdUnselectDrawings.setEnabled(drawsSelected);
            }
        });
        this.mappingComponent.addCustomInputListener("REMOVE_MULTIPOLYGON", (PBasicInputEventHandler)new DeleteFeatureListener(this.mappingComponent));
        this.mappingComponent.addCustomInputListener("CHANGE_MULTIPOLYGON", (PBasicInputEventHandler)new PolygonChangeListener(this.mappingComponent));
        AppBroker.getInstance().switchMapMode(this.mappingComponent.getInteractionMode());
        String interactionMode = CismapBroker.getInstance().getMappingComponent().getHandleInteractionMode();
        if (interactionMode.equals("MOVE_HANDLE")) {
            this.cmdNodeMove.setSelected(true);
        } else if (interactionMode.equals("ADD_HANDLE")) {
            this.cmdNodeAdd.setSelected(true);
        } else if (interactionMode.equals("REMOVE_HANDLE")) {
            this.cmdNodeRemove.setSelected(true);
        } else {
            CismapBroker.getInstance().getMappingComponent().setHandleInteractionMode("ADD_HANDLE");
            this.cmdNodeMove.setSelected(true);
        }
        this.addThemeAction1.init(this.pCapabilities, this.rootWindow, this.vCapability);
        this.addThemeTreeAction.init(this.pCapabilities, this.rootWindow, this.vCapability);
        this.initThemeCombo();
        AutoCompleteDecorator.decorate((JComboBox)this.cboTheme);
        HashMap<String, JMenu> menues = new HashMap<String, JMenu>();
        for (TemplateExportAction action : this.allTemplates) {
            String folder = action.getFolder();
            if (folder != null) {
                JMenu menu = (JMenu)menues.get(folder);
                if (menu == null) {
                    menu = new JMenu(folder);
                    menues.put(folder, menu);
                    this.menSchablonen.add(menu);
                }
                menu.add(action);
                continue;
            }
            this.menSchablonen.add(action);
        }
        this.mniGafUpload.setVisible(false);
        boolean checkForQP = false;
        try {
            checkForQP = SessionManager.getProxy().getConfigAttr(SessionManager.getSession().getUser(), "qpAllowed", connectionContext) != null;
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Cannot check for qp permission", (Throwable)ex);
        }
        this.mniGafUpload.setEnabled(checkForQP);
        this.mniGafUpload.setVisible(checkForQP);
        boolean checkForTechProf = AppBroker.getInstance().isAdminUser() || AppBroker.getInstance().getOwnWwGr().getProperty("ww_gr").equals(3100);
        this.mniTechProf.setVisible(checkForTechProf);
        this.mniTechProf.setEnabled(checkForTechProf);
        this.checkForCreatedObjects();
        Double scaleForPoint = 500.0;
        try {
            scaleForPoint = Double.valueOf(SessionManager.getProxy().getConfigAttr(SessionManager.getSession().getUser(), "zoomScaleForPointFeature", connectionContext));
        }
        catch (Exception ex) {
            LOG.warn((Object)"zoomScaleForPointFeature is not set or not valid. 500 will be assumed", (Throwable)ex);
        }
        ZoomToFeaturesWorker.setScaleForPoint((Double)500.0);
        try {
            String zoomPercentage = SessionManager.getProxy().getConfigAttr(SessionManager.getSession().getUser(), "pfbZoomFactor", connectionContext);
            if (zoomPercentage != null) {
                AppBroker.getInstance().setProblemFeatureGeometryIncrease(Integer.parseInt(zoomPercentage));
            }
        }
        catch (ConnectionException ex) {
            LOG.error((Object)"Cannot check for qp permission", (Throwable)ex);
        }
        List crsList = this.mappingComponent.getCrsList();
        CismapBroker.getInstance().addCrsChangeListener((CrsChangeListener)this.mappingComponent);
        for (Crs crs : crsList) {
            if (!crs.getCode().equals(CrsTransformer.createCrsFromSrid((int)5650))) continue;
            CismapBroker.getInstance().setSrs(crs);
        }
    }

    private void initThemeCombo() {
        this.cboTheme.setModel(new DefaultComboBoxModel<Object>(new Object[]{"Lade ..."}));
        SwingWorker<MetaObject[], Void> sw = new SwingWorker<MetaObject[], Void>(){

            @Override
            protected MetaObject[] doInBackground() throws Exception {
                MetaClass MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.k_kate_such_1", (ConnectionContext)connectionContext);
                String query = "select " + MC.getID() + ", " + MC.getPrimaryKey() + " from " + MC.getTableName();
                query = query + " order by index";
                MetaObject[] metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0, connectionContext);
                return metaObjects;
            }

            @Override
            protected void done() {
                try {
                    MetaObject[] mos = (MetaObject[])this.get();
                    WatergisApp.this.cboTheme.setModel(new DefaultComboBoxModel<MetaObject>(mos));
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error((Object)"Error while initializing the model of the theme combobox", (Throwable)e);
                }
            }
        };
        CismetConcurrency.getInstance((String)"watergis").getDefaultExecutor().execute(sw);
    }

    private void checkForCreatedObjects() {
        try {
            User user = SessionManager.getSession().getUser();
            InetAddress addr = InetAddress.getLocalHost();
            CheckForCreatedObjectTable cleanup = new CheckForCreatedObjectTable(user.getDomain() + "." + user.getName(), addr.getHostName());
            ArrayList objects = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)cleanup);
            this.removeOldLocks();
            if (objects != null && objects.size() > 0) {
                HashMap<Integer, ArrayList<Integer>> objectList = new HashMap<Integer, ArrayList<Integer>>();
                for (ArrayList object : objects) {
                    ArrayList<Integer> oList = (ArrayList<Integer>)objectList.get((Integer)object.get(0));
                    if (oList == null) {
                        oList = new ArrayList<Integer>();
                        objectList.put((Integer)object.get(0), oList);
                    }
                    oList.add((Integer)object.get(1));
                }
                for (Integer classId : objectList.keySet()) {
                    AttributeTable table;
                    CidsLayer layer;
                    List objectIds = (List)objectList.get(classId);
                    MetaClass mc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (int)classId);
                    if (mc == null) continue;
                    List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree(mc.getName());
                    if (services == null || services.isEmpty()) {
                        layer = new CidsLayer(mc);
                        AppBroker.getInstance().getMappingComponent().getMappingModel().addLayer((RetrievalServiceLayer)layer);
                        AttributeTableFactory.getInstance().switchProcessingMode((AbstractFeatureService)layer);
                    } else {
                        layer = services.get(0);
                        if (!SelectionManager.getInstance().getEditableServices().contains(services.get(0))) {
                            AttributeTableFactory.getInstance().switchProcessingMode(services.get(0));
                        }
                    }
                    if ((table = this.getAttributeTableByFeatureService((AbstractFeatureService)layer)) == null) continue;
                    ArrayList<FeatureServiceFeature> featureList = new ArrayList<FeatureServiceFeature>();
                    for (Integer objectId : objectIds) {
                        FeatureServiceFeature feature = table.getFeatureById(objectId.intValue());
                        if (feature == null) continue;
                        featureList.add(feature);
                        table.markFeatureAsNewFeature((DefaultFeatureServiceFeature)feature);
                    }
                    table.makeFeaturesEditable(featureList);
                    SelectionManager.getInstance().addSelectedFeatures(featureList);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking for incomplete created objects", (Throwable)e);
        }
    }

    public void initRouteCombo() {
        this.routeZoomPanel.init();
    }

    private void removeOldLocks() {
        try {
            String user = SessionManager.getSession().getUser().getName();
            InetAddress addr = InetAddress.getLocalHost();
            String computerName = addr.getHostName();
            RemoveOldLocks removeLocks = new RemoveOldLocks(user, computerName);
            SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)removeLocks);
        }
        catch (Exception e) {
            LOG.error((Object)"cannot remove old locks", (Throwable)e);
        }
    }

    public String getCurrentLayoutFile() {
        return this.currentLayoutFile;
    }

    public void setCurrentLayoutFile(String currentLayoutFile) {
        this.currentLayoutFile = currentLayoutFile;
    }

    private void initCismap() {
        CismapBroker.getInstance().setEnableDummyLayerWhenAvailable(false);
        this.mappingComponent = new MappingComponent(true);
        this.mappingComponent.addCustomInputListener("SELECT", (PBasicInputEventHandler)new SelectionListener(){

            protected Color getFillingColor() {
                return new Color(255, 0, 0, 80);
            }
        });
        AppBroker.getInstance().setMappingComponent(this.mappingComponent);
        SelectionListener sl = (SelectionListener)this.mappingComponent.getInputEventListener().get("SELECT");
        sl.setFeaturesFromServicesSelectable(true);
        sl.setSelectMultipleFeatures(true);
        SimpleMoveListener motion = (SimpleMoveListener)this.mappingComponent.getInputEventListener().get("MOTION");
        motion.setUnderlyingObjectHalo(0.01);
        this.mappingModel.setInitalLayerConfigurationFromServer(false);
        configManager.addConfigurable((Configurable)this.mappingComponent);
        configManager.addConfigurable((Configurable)this.mappingModel);
        this.mappingComponent.preparationSetMappingModel((MappingModel)this.mappingModel);
        configManager.configure((Configurable)this.mappingComponent);
        configManager.configure((Configurable)this.mappingModel);
        this.mappingComponent.setMappingModel((MappingModel)this.mappingModel);
        this.mappingComponent.setInternalLayerWidgetAvailable(true);
        ((Observable)this.mappingComponent.getMemUndo()).addObserver(this);
        ((Observable)this.mappingComponent.getMemRedo()).addObserver(this);
        this.mappingComponent.getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this);
        this.mappingComponent.getInputEventListener().put("FOTO_INFO_LISTENER", new PhotoInfoListener(this.mappingComponent));
        this.mappingComponent.getInputEventListener().put("FOTO_ANGLE_LISTENER", new PhotoAngleListener(this.mappingComponent));
        this.mappingComponent.getInputEventListener().put("GAF_INFO_LISTENER", new GafInfoListener(this.mappingComponent));
        this.mappingComponent.putCursor("FOTO_INFO_LISTENER", new Cursor(12));
        this.mappingComponent.putCursor("FOTO_ANGLE_LISTENER", new Cursor(1));
        this.mappingComponent.putCursor("GAF_INFO_LISTENER", new Cursor(12));
        this.mappingComponent.setSnappingRectSize(40);
        CismapBroker.getInstance().setMappingComponent(this.mappingComponent);
        this.mappingComponent.setCrossHairColor(new Color(255, 0, 0, 255));
        this.mappingComponent.setCrossHairThickness(4);
        WFSCapabilitiesTreeCellRenderer.showTitle = true;
        PointReferencingDialog.setMIN_X((Double)3.3E7);
        PointReferencingDialog.setMAX_X((Double)3.3999999E7);
        PointReferencingDialog.setMIN_Y((Double)5600000.0);
        PointReferencingDialog.setMAX_Y((Double)6399999.0);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Thread t = new Thread("checkMapConfiguration"){

                    @Override
                    public void run() {
                        WatergisApp.this.checkMapConfiguration(null);
                    }
                };
                t.start();
            }
        });
    }

    public void checkMapConfiguration(File file) {
        final ActiveLayerModel model = (ActiveLayerModel)this.mappingComponent.getMappingModel();
        TreeMap services = new TreeMap(model.getMapServices());
        boolean layersChanged = false;
        for (Integer key : services.keySet()) {
            MapService service = (MapService)services.get(key);
            if (!(service instanceof CidsLayer)) continue;
            final CidsLayer layer = (CidsLayer)service;
            if (layer.getMetaClass() == null || layer.getMetaClass().getClassAttribute("cidsLayer") == null) {
                layersChanged = true;
                EventQueue.invokeLater(new Thread("removeLayer"){

                    @Override
                    public void run() {
                        model.removeLayer((RetrievalServiceLayer)layer);
                    }
                });
                continue;
            }
            try {
                final CidsLayer serverLayer = new CidsLayer(layer.getMetaClass());
                serverLayer.initAndWait();
                Map attrMap = layer.getLayerProperties().getFeatureService().getFeatureServiceAttributes();
                Map serverAttrMap = serverLayer.getLayerProperties().getFeatureService().getFeatureServiceAttributes();
                for (String attrKey : attrMap.keySet()) {
                    String type = ((FeatureServiceAttribute)attrMap.get(attrKey)).getType();
                    if (serverAttrMap.get(attrKey) != null && (serverAttrMap.get(attrKey) == null || ((FeatureServiceAttribute)serverAttrMap.get(attrKey)).getType().equals(type))) continue;
                    layersChanged = true;
                    EventQueue.invokeLater(new Thread("switchLayer"){

                        @Override
                        public void run() {
                            if (!model.switchLayer((Object)layer, (Object)serverLayer)) {
                                model.removeLayer((RetrievalServiceLayer)layer);
                                model.addLayer((RetrievalServiceLayer)serverLayer);
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                layersChanged = true;
                EventQueue.invokeLater(new Thread("removeLayer"){

                    @Override
                    public void run() {
                        model.removeLayer((RetrievalServiceLayer)layer);
                    }
                });
            }
        }
        if (layersChanged && file != null) {
            LOG.info((Object)"rewrite configuration file");
            this.saveToSameFileProjectAction1.actionPerformed(null);
        }
    }

    private void retrievePermissionbeans() {
        try {
            String query = "select " + this.wwGrMc.getID() + ", " + this.wwGrMc.getTableName() + "." + this.wwGrMc.getPrimaryKey() + " from " + this.wwGrMc.getTableName() + " WHERE owner ilike '" + SessionManager.getSession().getUser().getUserGroup().getName() + "'";
            MetaObject[] mos = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            ArrayList<Object> beans = new ArrayList<CidsBean>();
            if (mos != null) {
                for (MetaObject mo : mos) {
                    beans.add(mo.getBean());
                }
            }
            AppBroker.getInstance().setOwnWwGr(beans);
            String NoOneQuery = "select " + this.wwGrMc.getID() + ", " + this.wwGrMc.getTableName() + "." + this.wwGrMc.getPrimaryKey() + " from " + this.wwGrMc.getTableName() + " WHERE owner = 'NIEMAND'";
            MetaObject[] noOneMos = SessionManager.getProxy().getMetaObjectByQuery(NoOneQuery, 0);
            if (noOneMos != null) {
                MetaObject[] metaObjectArray = noOneMos;
                int n = metaObjectArray.length;
                for (int i = 0; i < n; ++i) {
                    MetaObject mo = metaObjectArray[i];
                    AppBroker.getInstance().setNiemandWwGr(mo.getBean());
                }
            }
            query = "select " + this.wwGrMc.getID() + ", " + this.wwGrMc.getTableName() + "." + this.wwGrMc.getPrimaryKey() + " from " + this.wwGrMc.getTableName();
            mos = SessionManager.getProxy().getMetaObjectByQuery(query, 0);
            beans = new ArrayList();
            if (mos != null) {
                for (MetaObject mo : mos) {
                    beans.add(mo.getBean());
                }
            }
            AppBroker.getInstance().setWwGr(beans);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot retrieve premission beans", (Throwable)e);
        }
    }

    private void retrieveValidLawaCodes() {
        try {
            ValidLawaCodes search = new ValidLawaCodes();
            ArrayList res = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
            Object[] lawaCodes = new String[res.size()];
            for (int i = 0; i < res.size(); ++i) {
                lawaCodes[i] = ((ArrayList)res.get(i)).get(0).toString();
            }
            Arrays.sort(lawaCodes);
            AppBroker.getInstance().setValidLawaCodes((String[])lawaCodes);
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot retrieve premission beans", (Throwable)e);
        }
    }

    private void initLog4JQuickConfig() {
        KeyStroke configLoggerKeyStroke = KeyStroke.getKeyStroke(76, 192);
        AbstractAction configAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Log4JQuickConfig.getSingletonInstance().setVisible(true);
                    }
                });
            }
        };
        this.getRootPane().getInputMap(2).put(configLoggerKeyStroke, "CONFIGLOGGING");
        this.getRootPane().getActionMap().put("CONFIGLOGGING", configAction);
    }

    private void initHistoryButtonsAndRecentlyOpenedFiles() {
        ((JHistoryButton)this.cmdNextExtend).setDirection(1);
        ((JHistoryButton)this.cmdPreviousExtend).setDirection(2);
        ((JHistoryButton)this.cmdNextExtend).setHistoryModel((HistoryModel)this.mappingComponent);
        ((JHistoryButton)this.cmdPreviousExtend).setHistoryModel((HistoryModel)this.mappingComponent);
        RecentlyOpenedFilesList recentlyOpenedFilesList = new RecentlyOpenedFilesList();
        configManager.addConfigurable((Configurable)recentlyOpenedFilesList);
        configManager.configure((Configurable)recentlyOpenedFilesList);
        AppBroker.getInstance().setRecentlyOpenedFilesList(recentlyOpenedFilesList);
    }

    private void initHttpServer() {
        GeoLinkServer.startServer();
    }

    private static void initLog4J() {
        try (InputStream configStream = WatergisApp.class.getResourceAsStream("/de/cismet/watergis/configuration/log4j.xml");){
            ConfigurationSource source = new ConfigurationSource(configStream);
            LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);
            context.start((Configuration)new XmlConfiguration(context, source));
            LOG.info((Object)"Log4J System was configured successfully");
        }
        catch (Exception ex) {
            System.err.println("Error during the initialisation");
            ex.printStackTrace();
        }
    }

    private void initDefaultPanels() {
        this.pMap = new MapPanel();
        this.pPhoto = new Photo();
        this.pGaf = new GafProf();
        this.pTopicTree = new ThemeLayerWidget();
        this.pInfo = new InfoPanel();
        this.pSelection = new SelectionPanel();
        this.pTopicTree.setMappingModel(this.mappingModel);
        this.addThemeTreeAction = new AddThemeAction(this.pCapabilities, this.rootWindow, this.vCapability);
        this.pTopicTree.addAddThemeMenuItemListener((ActionListener)this.addThemeTreeAction);
        this.pTopicTree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                WatergisApp.this.topicTreeSelectionChanged(e);
            }
        });
        this.pTopicTree.insertMenuItemIntoContextMenu(18, (ThemeLayerMenuItem)new MetaDocumentMenuItem());
        this.pTopicTree.insertMenuItemIntoContextMenu(18, (ThemeLayerMenuItem)new ExportMenuItem());
        this.pTopicTree.insertMenuItemIntoContextMenu(18, (ThemeLayerMenuItem)new DeleteMenuItem());
        this.pTopicTree.insertMenuItemIntoContextMenu(18, (ThemeLayerMenuItem)new PasteMenuItem());
        this.pTopicTree.insertMenuItemIntoContextMenu(18, (ThemeLayerMenuItem)new CopyMenuItem());
        this.pTopicTree.insertMenuItemIntoContextMenu(18, (ThemeLayerMenuItem)new ExportOptionsMenuItem());
        this.pOverview = new OverviewComponent();
        this.pOverview.setMasterMap(this.mappingComponent);
        configManager.addConfigurable((Configurable)this.pOverview);
        configManager.configure((Configurable)this.pOverview);
        this.pCapabilities = new CapabilityWidget();
        CapabilityWidgetOptionsPanel.setCapabilityWidget((CapabilityWidget)this.pCapabilities);
        CismapBroker.getInstance().addMapBoundsListener((MapBoundsListener)this.pCapabilities);
        configManager.addConfigurable((Configurable)this.exportAction1);
        configManager.configure((Configurable)this.exportAction1);
        configManager.addConfigurable((Configurable)this.pCapabilities);
        configManager.configure((Configurable)this.pCapabilities);
        try {
            AppBroker.getInstance().initComponentRegistry(this);
            if (!AppBroker.getInstance().getOwner().startsWith("gaeste")) {
                this.pTable = AppBroker.getInstance().getComponentRegistry().getCatalogueTree();
                this.pTablePane.setViewportView((Component)this.pTable);
                PureTreeNode treeNode = (PureTreeNode)((RootTreeNode)this.pTable.getModel().getRoot()).getChildAt(0);
                String childStat = treeNode.getMetaNode().getDynamicChildrenStatement();
                String user = "null";
                if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("administratoren")) {
                    user = "'" + AppBroker.getInstance().getOwner() + "'";
                }
                childStat = childStat.replace("$user", user);
                treeNode.getMetaNode().setDynamicChildrenStatement(childStat);
            } else {
                this.mniShowProblems.setVisible(false);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"The problem tree cannot be created", (Throwable)e);
            this.pTable.setModel(null);
        }
        if (AppBroker.getInstance().getOwner().equalsIgnoreCase("administratoren")) {
            this.cmdAnnex.setEnabled(false);
            this.cmdRelease.setEnabled(false);
        }
        AppBroker.getInstance().addComponent(ComponentName.MAP, this.pMap);
        AppBroker.getInstance().addComponent(ComponentName.PHOTO, this.pPhoto);
        AppBroker.getInstance().addComponent(ComponentName.GAF_PROF, this.pGaf);
        AppBroker.getInstance().addComponent(ComponentName.TREE, (Component)this.pTopicTree);
        AppBroker.getInstance().addComponent(ComponentName.INFO, this.pInfo);
        AppBroker.getInstance().addComponent(ComponentName.SELECTION, this.pSelection);
        AppBroker.getInstance().addComponent(ComponentName.TABLE, (Component)this.pTable);
        AppBroker.getInstance().addComponent(ComponentName.OVERVIEW, (Component)this.pOverview);
        AppBroker.getInstance().addComponent(ComponentName.CAPABILITIES, (Component)this.pCapabilities);
        AppBroker.getInstance().addComponent(ComponentName.MENU_BOOKMARK, this.menBookmark);
        AppBroker.getInstance().addComponent(ComponentName.STATUSBAR, this.statusBar1);
        CismapBroker.getInstance().addStatusListener((StatusListener)this.statusBar1);
        CismapBroker.getInstance().addActiveLayerListener((ActiveLayerListener)this.statusBar1);
        LOG.info((Object)("set refernence for the main application in Broker: " + this));
        AppBroker.getInstance().addComponent(ComponentName.MAIN, this);
    }

    private void initialiseStatusPanel() {
        CheckBackgroundWorker worker = new CheckBackgroundWorker();
        worker.addBackgroundCheckListener(new BackgroundCheckListener(){

            @Override
            public void checkComplete(BackgroundCheckEvent e) {
                StatusPanel.IconColor icon;
                String text;
                AbstractCheckResult result = e.getResult();
                int index = e.getIndex();
                if (result == null) {
                    text = e.getCheck().getValue("Name") + ":\nW\u00e4hrend der Pr\u00fcfung trat ein Fehler auf. ";
                    icon = StatusPanel.IconColor.RED;
                } else {
                    int problems = 0;
                    for (String check : result.getCheckNames()) {
                        problems += result.getErrorsPerCheck(check);
                    }
                    if (problems == 0) {
                        text = e.getCheck().getValue("Name").toString();
                        icon = StatusPanel.IconColor.GREEN;
                    } else {
                        text = e.getCheck().getValue("Name").toString() + ":\nEs wurden " + problems + " Probleme festgestellt";
                        icon = StatusPanel.IconColor.RED;
                    }
                }
                WatergisApp.this.statusPanel1.setStatusIcon(index, icon);
                WatergisApp.this.statusPanel1.setTooltip(index, text);
                WatergisApp.this.statusPanel1.updateUI();
                WatergisApp.this.statusPanel1.repaint();
            }
        });
        this.statusPanel1.setCount(worker.getChecks().length);
        for (int i = 0; i < worker.getChecks().length; ++i) {
            this.statusPanel1.setTooltip(i, (String)worker.getChecks()[i].getValue("Name"));
        }
        worker.start();
    }

    private void initMapModes() {
        AppBroker.getInstance().addMapMode("PAN", this.panAction);
        AppBroker.getInstance().addMapMode("MOVE_POLYGON", this.moveModeAction);
        AppBroker.getInstance().addMapMode("ZOOM", this.zoomModeAction);
        AppBroker.getInstance().addMapMode("SELECT", this.selectionModeAction);
        AppBroker.getInstance().addMapMode("FEATURE_INFO_MULTI_GEOM", this.infoWindowAction);
        AppBroker.getInstance().addMapMode("NEW_POLYGON", this.newLinestringModeAction);
        AppBroker.getInstance().addMapMode("REMOVE_POLYGON", this.removeDrawingModeAction);
        AppBroker.getInstance().addMapMode("MEASURE_MODE", this.measureAction);
        AppBroker.getInstance().addMapMode("SimpleGeometryCreater", this.newObjectAction);
        AppBroker.getInstance().addMapMode("LINEMEASUREMENT", this.measureLineAction);
        AppBroker.getInstance().addMapMode("CREATE_NEW_STATION_LINE", this.newObjectAction);
        AppBroker.getInstance().addMapMode("CREATE_NEW_STATION", this.newObjectAction);
        AppBroker.getInstance().addMapMode("FOTO_INFO_LISTENER", this.fotoInfoAction1);
        AppBroker.getInstance().addMapMode("GAF_INFO_LISTENER", this.gafInfoAction);
        AppBroker.getInstance().switchMapMode(this.mappingComponent.getInteractionMode());
    }

    private void initInfoNode() {
        String title = NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().TopicTree");
        this.vTopicTree = new View(title, null, (Component)this.pTopicTree);
        this.viewMap.addView(title, this.vTopicTree);
        title = NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().Map");
        this.vMap = new View(title, null, (Component)this.pMap);
        this.viewMap.addView(title, this.vMap);
        title = NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().Photo");
        this.vPhoto = new View(title, null, (Component)this.pPhoto);
        this.viewMap.addView(title, this.vPhoto);
        AppBroker.getInstance().setPhotoView(this.vPhoto);
        this.vPhoto.addListener((DockingWindowListener)new DockingWindowAdapter(){

            public void windowClosed(DockingWindow window) {
                WatergisApp.this.pPhoto.dispose();
            }
        });
        title = NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().Gaf");
        this.vGaf = new View(title, null, (Component)this.pGaf);
        this.viewMap.addView(title, this.vGaf);
        AppBroker.getInstance().setGafView(this.vGaf);
        this.vGaf.addListener((DockingWindowListener)new DockingWindowAdapter(){

            public void windowClosed(DockingWindow window) {
                WatergisApp.this.pGaf.dispose();
            }
        });
        title = NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().Table");
        this.vTable = new View(title, null, (Component)this.pTablePane);
        this.viewMap.addView(title, this.vTable);
        title = NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().Overview");
        this.vOverview = new View(title, null, (Component)this.pOverview);
        this.showHideOverviewWindowAction.setView(this.vOverview);
        this.viewMap.addView(title, this.vOverview);
        title = NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().Capabilities");
        this.vCapability = new View(title, null, (Component)this.pCapabilities);
        this.viewMap.addView(title, this.vCapability);
        this.rootWindow = DockingUtil.createRootWindow((AbstractViewMap)this.viewMap, (boolean)true);
        this.rootWindow.getRootWindowProperties().getFloatingWindowProperties().setUseFrame(true);
        this.rootWindow.addListener((DockingWindowListener)new DockingWindowAdapter(){

            public void windowClosed(DockingWindow window) {
                for (int i = 0; i < window.getChildWindowCount(); ++i) {
                    if (!window.getChildWindow(i).getTitle().startsWith("Attribute") || window.getChildWindow(i).getChildWindowCount() != 1) continue;
                    window.getChildWindow(i).getChildWindow(0).close();
                }
                super.windowClosed(window);
            }
        });
        AppBroker.getInstance().setRootWindow(this.rootWindow);
        this.rootWindow.addTabMouseButtonListener(DockingWindowActionMouseButtonListener.MIDDLE_BUTTON_CLOSE_LISTENER);
        ShapedGradientDockingTheme theme = new ShapedGradientDockingTheme();
        this.rootWindow.getRootWindowProperties().addSuperObject(theme.getRootWindowProperties());
        RootWindowProperties titleBarStyleProperties = PropertiesUtil.createTitleBarStyleRootWindowProperties();
        this.rootWindow.getRootWindowProperties().addSuperObject(titleBarStyleProperties);
        this.rootWindow.getRootWindowProperties().getDockingWindowProperties().setUndockEnabled(true);
        AlphaGradientComponentPainter x = new AlphaGradientComponentPainter((Color)SystemColor.inactiveCaptionText, (Color)SystemColor.activeCaptionText, (Color)SystemColor.activeCaptionText, (Color)SystemColor.inactiveCaptionText);
        this.rootWindow.getRootWindowProperties().getDragRectangleShapedPanelProperties().setComponentPainter((ComponentPainter)x);
        AppBroker.getInstance().setTitleBarComponentpainter(AppBroker.DEFAULT_MODE_COLOR);
        this.rootWindow.getRootWindowProperties().getTabWindowProperties().getTabbedPanelProperties().getTabAreaProperties().setTabAreaVisiblePolicy(TabAreaVisiblePolicy.ALWAYS);
        this.rootWindow.getRootWindowProperties().getTabWindowProperties().getTabbedPanelProperties().setPaintTabAreaShadow(true);
        this.rootWindow.getRootWindowProperties().getTabWindowProperties().getTabbedPanelProperties().setShadowSize(10);
        this.rootWindow.getRootWindowProperties().getTabWindowProperties().getTabbedPanelProperties().setShadowStrength(0.8f);
    }

    public void showWindow(String id) {
        View view = this.viewMap.getView(id);
        if (!view.isClosable()) {
            view.restore();
            if (view == this.vTable) {
                final TreePath selectionPath = this.pTable.getSelectionPath();
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        ((DefaultTreeModel)WatergisApp.this.pTable.getModel()).reload();
                        if (selectionPath != null && selectionPath.getPath().length > 0) {
                            WatergisApp.this.pTable.exploreSubtree(selectionPath);
                        }
                    }
                };
                if (EventQueue.isDispatchThread()) {
                    r.run();
                } else {
                    EventQueue.invokeLater(r);
                }
            }
        }
    }

    public StringViewMap getViewMap() {
        return this.viewMap;
    }

    private void configureFileMenu() {
        configManager.addConfigurable((Configurable)((FileMenu)this.menFile));
        configManager.configure((Configurable)((FileMenu)this.menFile));
    }

    private void configureButtons() {
        configManager.addConfigurable((Configurable)((SelectionButton)((Object)this.cmdSelectionMode)));
        configManager.configure((Configurable)((SelectionButton)((Object)this.cmdSelectionMode)));
        configManager.addConfigurable((Configurable)((MeasureButton)((Object)this.tbtnMeasure)));
        configManager.configure((Configurable)((MeasureButton)((Object)this.tbtnMeasure)));
        configManager.addConfigurable((Configurable)((GeometryOpButton)((Object)this.cmdGeometryOpMode)));
        configManager.configure((Configurable)((GeometryOpButton)((Object)this.cmdGeometryOpMode)));
        configManager.addConfigurable((Configurable)((SnappingButton)((Object)this.cmdSnappingMode)));
        configManager.configure((Configurable)((SnappingButton)((Object)this.cmdSnappingMode)));
    }

    public void topicTreeSelectionChanged(TreeSelectionEvent e) {
        TreePath tp = this.pTopicTree.getLeadSelectionPath();
        this.tbtNewObject.setEnabled(false);
        this.cmdCopy.setEnabled(false);
        this.cmdPaste.setEnabled(false);
        this.cmdDelete.setEnabled(false);
        this.mniZoomSelectedThemes.setEnabled(false);
        this.cmdZoomSelectedThemes.setEnabled(false);
        this.newObjectAction.setSelectedService(null);
        if (this.tbtNewObject.isSelected() && e != null) {
            this.selectionModeAction.actionPerformed(null);
        }
        if (tp != null && this.pTopicTree.getSelectionPath() != null && this.pTopicTree.getSelectionPath().length == 1) {
            Object o = tp.getLastPathComponent();
            if (o instanceof AbstractFeatureService) {
                List selectedFeatures;
                AbstractFeatureService service = (AbstractFeatureService)o;
                if (service.isEditable() && SelectionManager.getInstance().getEditableServices().contains(service) && service.getLayerProperties() != null && service.getLayerProperties().getAttributeTableRuleSet() != null && service.getLayerProperties().getAttributeTableRuleSet().getFeatureCreator() != null) {
                    AttributeTable table;
                    this.tbtNewObject.setEnabled(true);
                    this.newObjectAction.setSelectedService(service);
                    selectedFeatures = SelectionManager.getInstance().getSelectedFeatures(service);
                    if (selectedFeatures != null && !selectedFeatures.isEmpty()) {
                        boolean enable = false;
                        for (Feature f : selectedFeatures) {
                            if (!(f instanceof FeatureServiceFeature) || !((FeatureServiceFeature)f).isEditable()) continue;
                            enable = true;
                            break;
                        }
                        if (enable) {
                            this.cmdDelete.setEnabled(true);
                        }
                    }
                    if ((table = this.getAttributeTableByFeatureService(service)) != null && table.isPasteButtonEnabled()) {
                        this.cmdPaste.setEnabled(true);
                    }
                }
                if ((selectedFeatures = SelectionManager.getInstance().getSelectedFeatures(service)) != null && !selectedFeatures.isEmpty()) {
                    this.cmdCopy.setEnabled(true);
                }
            }
            this.mniZoomSelectedThemes.setEnabled(true);
            this.cmdZoomSelectedThemes.setEnabled(true);
        } else if (tp != null) {
            this.mniZoomSelectedThemes.setEnabled(true);
            this.cmdZoomSelectedThemes.setEnabled(true);
        }
    }

    private void initAttributeTable() {
        AttributeTableFactory.getInstance().setMappingComponent(this.mappingComponent);
        AttributeTableFactory.getInstance().setAttributeTableListener(new AttributeTableListener(){

            public void showAttributeTable(AttributeTable table, String id, String name, String tooltip) {
                View view = (View)WatergisApp.this.attributeTableMap.get(id);
                WatergisApp.this.setTabWindow();
                table.setExportEnabled(WatergisApp.this.isExportEnabled(table.getFeatureService()));
                if (view != null) {
                    int viewIndex = WatergisApp.this.tabWindow.getChildWindowIndex((DockingWindow)view);
                    if (viewIndex != -1) {
                        WatergisApp.this.tabWindow.setSelectedTab(viewIndex);
                    } else {
                        view.requestFocusInWindow();
                    }
                } else {
                    String newName = name;
                    if (newName.indexOf(" ") != -1) {
                        newName = newName.substring(newName.indexOf(" ") + 1);
                    }
                    view = new View(newName, null, (Component)table);
                    WatergisApp.this.addAttributeTableWindowListener(view, table);
                    WatergisApp.this.viewMap.addView(id, view);
                    WatergisApp.this.attributeTableMap.put(id, view);
                    WatergisApp.this.tabWindow.addTab((DockingWindow)view);
                    SelectionManager.getInstance().addConsideredAttributeTable(table);
                }
            }

            public void changeName(String id, String name) {
                View view = (View)WatergisApp.this.attributeTableMap.get(id);
                if (view != null) {
                    view.getViewProperties().setTitle(name);
                }
            }

            public void processingModeChanged(final AbstractFeatureService service, boolean active) {
                List editableServices;
                SelectionManager.getInstance().switchProcessingMode(service);
                if (!active) {
                    TreeSet rejectedFeatures;
                    TreeSet features;
                    WatergisApp.this.splitAction;
                    SplitAction.undo(service);
                    AttributeTable table = this.getAttributeTable(AttributeTableFactory.createId((AbstractFeatureService)service));
                    if (table != null && service.getLayerProperties() != null && service.getLayerProperties().getFeatureService() != null && service.getLayerProperties().getFeatureService() instanceof CidsLayer && ((CidsLayer)service.getLayerProperties().getFeatureService()).getMetaClass().getTableName().equalsIgnoreCase("dlm25w.fg_bak") && !(features = new TreeSet(rejectedFeatures = table.getRejectedNewFeatures())).isEmpty()) {
                        Thread t = new Thread("removeFeaturesOnRoute"){

                            @Override
                            public void run() {
                                this.removeCat2ObjectsOnRoutes(features);
                            }
                        };
                        t.start();
                    }
                    if (service instanceof CidsLayer && service.getLayerProperties() != null && service.getLayerProperties().getFeatureService() != null && ((CidsLayer)service.getLayerProperties().getFeatureService()).getMetaClass() != null) {
                        Thread t = new Thread("cleanupCreatedObjects"){

                            @Override
                            public void run() {
                                int classId = ((CidsLayer)service.getLayerProperties().getFeatureService()).getMetaClass().getID();
                                this.cleanupCreatedObjectTable(classId);
                            }
                        };
                        t.start();
                    }
                    if (service instanceof CidsLayer) {
                        CidsLayer cl = (CidsLayer)service;
                        if (cl.getMetaClass().getName().equals("foto")) {
                            if (WatergisApp.this.vPhoto.isClosable()) {
                                WatergisApp.this.vPhoto.close();
                            }
                        } else if (cl.getMetaClass().getName().equals("qp") && WatergisApp.this.vGaf.isClosable()) {
                            WatergisApp.this.vGaf.close();
                        }
                    }
                }
                WatergisApp.this.topicTreeSelectionChanged(null);
                if (WatergisApp.this.tbtNewObject.isSelected()) {
                    TreePath[] path = WatergisApp.this.pTopicTree.getSelectionPath();
                    if (path != null && path.length > 1) {
                        WatergisApp.this.selectionModeAction.actionPerformed(null);
                    } else if (path != null && path.length == 1 && path[0].getLastPathComponent().equals(service)) {
                        WatergisApp.this.selectionModeAction.actionPerformed(null);
                    }
                }
                boolean savePossible = (editableServices = SelectionManager.getInstance().getEditableServices()) != null && !editableServices.isEmpty();
                WatergisApp.this.butIntermediateSave.setEnabled(savePossible);
                if (service.isEditable() && !SelectionManager.getInstance().getEditableServices().contains(service)) {
                    WatergisApp.this.removeObjectsFromMap();
                    FeatureCreator creator = AppBroker.getInstance().getActiveFeatureCreator();
                    if (creator != null) {
                        creator.cancel();
                    }
                    AppBroker.getInstance().setActiveFeatureCreator(null);
                }
            }

            private void cleanupCreatedObjectTable(int classid) {
                try {
                    User user = SessionManager.getSession().getUser();
                    CleanupCreatedObjectTable cleanup = new CleanupCreatedObjectTable(user.getDomain() + "." + user.getName(), Integer.valueOf(classid));
                    SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)cleanup);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while removing unused stations", (Throwable)e);
                }
            }

            private void removeCat2ObjectsOnRoutes(TreeSet<DefaultFeatureServiceFeature> features) {
                for (FeatureServiceFeature featureServiceFeature : features) {
                    try {
                        RemoveUnnusedRoute nodesSearch = new RemoveUnnusedRoute(featureServiceFeature.getId(), 3);
                        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)nodesSearch);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while removing unused stations", (Throwable)e);
                    }
                    List selectedFeatures = SelectionManager.getInstance().getSelectedFeatures();
                    ArrayList<Feature> selectedFeaturesToRemove = new ArrayList<Feature>();
                    for (Feature f : selectedFeatures) {
                        String deletedFeatureBaCd;
                        String selectedFeatureBaCd;
                        CidsLayerFeature clf;
                        if (!(f instanceof CidsLayerFeature) || (clf = (CidsLayerFeature)f).getProperty("ba_cd") == null || featureServiceFeature.getProperty("ba_cd") == null || !(selectedFeatureBaCd = String.valueOf(clf.getProperty("ba_cd"))).equals(deletedFeatureBaCd = String.valueOf(featureServiceFeature.getProperty("ba_cd")))) continue;
                        selectedFeaturesToRemove.add(f);
                    }
                    for (String tableId : WatergisApp.this.attributeTableMap.keySet()) {
                        AttributeTable table = this.getAttributeTable(tableId);
                        AbstractFeatureService service = table.getFeatureService();
                        Object masterBaCd = featureServiceFeature.getProperty("ba_cd");
                        if (service instanceof CidsLayer && ((CidsLayer)service).getMetaClass().getTableName().equalsIgnoreCase("dlm25w.fg_bak") || table == null || !(service instanceof CidsLayer)) continue;
                        AttributeTableRuleSet ruleSet = ((CidsLayer)service).getLayerProperties().getAttributeTableRuleSet();
                        FeatureServiceFeature f = table.getFeatureByRow(0);
                        if (f.getProperty("ba_cd") == null) continue;
                        for (int i = 0; i < table.getFeatureCount(); ++i) {
                            FeatureServiceFeature fe = table.getFeatureByRow(i);
                            Object baCd = fe.getProperty("ba_cd");
                            if (baCd == null || !baCd.equals(masterBaCd)) continue;
                            if (ruleSet == null || ruleSet.isCatThree()) {
                                fe.setProperty("ba_cd", null);
                                if (fe.getProperty("ba_st_von") != null) {
                                    fe.setProperty("ba_st_von", null);
                                }
                                if (fe.getProperty("ba_st_bis") != null) {
                                    fe.setProperty("ba_st_bis", null);
                                }
                                if (fe.getProperty("ba_st") != null) {
                                    fe.setProperty("ba_st", null);
                                }
                                if (!fe.isEditable()) continue;
                                ((CidsLayerFeature)fe).removeStations();
                                continue;
                            }
                            table.removeFeatureFromModel((DefaultFeatureServiceFeature)fe);
                        }
                    }
                    if (selectedFeaturesToRemove.isEmpty()) continue;
                    SelectionManager.getInstance().removeSelectedFeatures(selectedFeaturesToRemove);
                }
            }

            public void closeAttributeTable(AbstractFeatureService service) {
                View attributeTableView = (View)WatergisApp.this.attributeTableMap.remove(AttributeTableFactory.createId((AbstractFeatureService)service));
                if (attributeTableView != null) {
                    attributeTableView.close();
                }
            }

            public AttributeTable getAttributeTable(String id) {
                Component c;
                View view = (View)WatergisApp.this.attributeTableMap.get(id);
                if (view != null && (c = view.getComponent()) instanceof AttributeTable) {
                    return (AttributeTable)c;
                }
                return null;
            }

            public void switchProcessingMode(final AbstractFeatureService service, final String id) {
                if (!WatergisApp.this.switchProcessingMode(service)) {
                    WatergisApp.this.setTabWindow();
                    int index = -1;
                    if (WatergisApp.this.tabWindow != null && WatergisApp.this.tabWindow.getSelectedWindow() != null) {
                        index = WatergisApp.this.tabWindow.getChildWindowIndex(WatergisApp.this.tabWindow.getSelectedWindow());
                    }
                    AttributeTableFactory.getInstance().showAttributeTable(service);
                    if (index != -1 && index < WatergisApp.this.tabWindow.getChildWindowCount()) {
                        WatergisApp.this.tabWindow.setSelectedTab(index);
                    }
                    WaitingDialogThread<Void> wdt = new WaitingDialogThread<Void>((Frame)WatergisApp.this, true, NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.EditModeMenuItem.actionPerformed().wait"), null, 200){

                        protected Void doInBackground() throws Exception {
                            Component c;
                            View view = (View)WatergisApp.this.attributeTableMap.get(id);
                            if (view != null && (c = view.getComponent()) instanceof AttributeTable) {
                                AttributeTable attrTable = (AttributeTable)c;
                                while (attrTable.isLoading()) {
                                    Thread.sleep(100L);
                                }
                            }
                            return null;
                        }

                        protected void done() {
                            WatergisApp.this.switchProcessingMode(service);
                        }
                    };
                    wdt.start();
                }
            }
        });
    }

    private boolean isExportEnabled(AbstractFeatureService service) {
        if (service instanceof CidsLayer) {
            CidsLayer layer = (CidsLayer)service;
            return layer.isDownloadAllowed();
        }
        return true;
    }

    private void setTabWindow() {
        if (this.vMap != null && this.vMap.getWindowParent() != null && this.vMap.getWindowParent() instanceof TabWindow) {
            this.tabWindow = (TabWindow)this.vMap.getWindowParent();
        }
        if (this.tabWindow == null) {
            this.tabWindow = (TabWindow)((SplitWindow)this.rootWindow.getWindow()).getRightWindow();
        }
    }

    public void refreshAttributeTable(AbstractFeatureService service) {
        Component c;
        View view = this.attributeTableMap.get(AttributeTableFactory.createId((AbstractFeatureService)service));
        if (view != null && (c = view.getComponent()) instanceof AttributeTable) {
            AttributeTable attrTable = (AttributeTable)c;
            attrTable.reload();
        }
    }

    public void addFeatureToAttributeTable(FeatureServiceFeature feature) {
        Component c;
        if (feature.getLayerProperties() == null) {
            return;
        }
        AbstractFeatureService service = feature.getLayerProperties().getFeatureService();
        View view = this.attributeTableMap.get(AttributeTableFactory.createId((AbstractFeatureService)service));
        if (view != null && (c = view.getComponent()) instanceof AttributeTable) {
            AttributeTable attrTable = (AttributeTable)c;
            attrTable.addFeature(feature);
        }
    }

    public AttributeTable getAttributeTableByFeature(FeatureServiceFeature feature) {
        if (feature.getLayerProperties() == null) {
            return null;
        }
        AbstractFeatureService service = feature.getLayerProperties().getFeatureService();
        return this.getAttributeTableByFeatureService(service);
    }

    public AttributeTable getAttributeTableByFeatureService(AbstractFeatureService service) {
        Component c;
        View view = this.attributeTableMap.get(AttributeTableFactory.createId((AbstractFeatureService)service));
        if (view != null && (c = view.getComponent()) instanceof AttributeTable) {
            return (AttributeTable)c;
        }
        return null;
    }

    public boolean switchProcessingMode(AbstractFeatureService service) {
        return this.switchProcessingMode(service, false);
    }

    public boolean switchProcessingMode(AbstractFeatureService service, boolean forceSave) {
        Component c;
        View view = this.attributeTableMap.get(AttributeTableFactory.createId((AbstractFeatureService)service));
        if (view != null && (c = view.getComponent()) instanceof AttributeTable) {
            final AttributeTable attrTable = (AttributeTable)c;
            attrTable.changeProcessingMode(forceSave);
            if (attrTable.isProcessingModeActive() && attrTable.isLoading()) {
                WaitingDialogThread wdt = new WaitingDialogThread(this, true, "Bearbeitungsmodus wird gestartet", null, 500){

                    protected Object doInBackground() throws Exception {
                        while (attrTable.isLoading()) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ex) {
                                LOG.warn((Object)"interrupted", (Throwable)ex);
                            }
                        }
                        return null;
                    }
                };
                wdt.start();
            }
            return true;
        }
        return false;
    }

    public boolean isProcessingModeActive(AbstractFeatureService service) {
        Component c;
        View view = this.attributeTableMap.get(AttributeTableFactory.createId((AbstractFeatureService)service));
        if (view != null && (c = view.getComponent()) instanceof AttributeTable) {
            AttributeTable attrTable = (AttributeTable)c;
            return attrTable.isProcessingModeActive();
        }
        return false;
    }

    private void addAttributeTableWindowListener(final View view, final AttributeTable table) {
        final AttributeTableAncestorListener aListener = new AttributeTableAncestorListener(view, table);
        DockingWindowAdapter listener = new DockingWindowAdapter(){

            public void windowClosing(DockingWindow window) throws OperationAbortedException {
                boolean disposeCompleted = table.dispose();
                if (!disposeCompleted) {
                    throw new OperationAbortedException();
                }
            }

            public void windowClosed(DockingWindow window) {
                WatergisApp.this.disposeTable(view, table, aListener, (DockingWindowListener)this);
            }
        };
        aListener.setDockingWindowListener((DockingWindowListener)listener);
        view.addAncestorListener((AncestorListener)aListener);
        view.addListener((DockingWindowListener)listener);
    }

    private void disposeTable(View view, AttributeTable table, AncestorListener aListener, DockingWindowListener listener) {
        view.removeListener(listener);
        view.removeAncestorListener(aListener);
        if (view.getParent() != null) {
            view.getParent().remove((Component)view);
        }
        this.viewMap.removeView("Attributtabelle " + table.getFeatureService().getName());
        this.attributeTableMap.remove(AttributeTableFactory.createId((AbstractFeatureService)table.getFeatureService()));
        SelectionManager.getInstance().removeConsideredAttributeTable(table);
        view.close();
        this.rootWindow.removeView(view);
    }

    private void initBookmarkManager() {
        BookmarkManager manager = new BookmarkManager();
        configManager.addConfigurable((Configurable)manager);
        configManager.configure((Configurable)manager);
        AppBroker.getInstance().setBookmarkManager(manager);
    }

    public void doLayoutInfoNode() {
        this.tabWindow = new TabWindow(new DockingWindow[]{this.vMap});
        SplitWindow treeWindow = new SplitWindow(false, 0.6f, (DockingWindow)this.vTopicTree, (DockingWindow)this.vOverview);
        this.rootWindow.setWindow((DockingWindow)new SplitWindow(true, 0.22901994f, (DockingWindow)treeWindow, (DockingWindow)this.tabWindow));
        this.vMap.restoreFocus();
        ObjectInputStream in = null;
        InputStream layoutInput = null;
        try {
            layoutInput = WatergisApp.class.getResourceAsStream("/de/cismet/watergis/configuration/defaultLayout.layout");
            if (layoutInput != null) {
                in = new ObjectInputStream(layoutInput);
                this.rootWindow.read(in);
                in.close();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while loading default layout", (Throwable)e);
        }
    }

    private void initComponents() {
        this.exportMapAction = new ExportMapAction();
        this.closeAction = new CloseAction();
        this.openProjectAction = new OpenProjectAction();
        this.optionsAction = new OptionsAction();
        this.printAction = new PrintAction();
        this.saveProjectAction = new SaveProjectAction();
        this.windowAction = new WindowAction();
        this.createGeoLinkAction = new CreateGeoLinkAction();
        this.selectionAttributeAction = new SelectionAttributeAction();
        this.selectionLocationAction = new SelectionLocationAction();
        this.removeSelectionAllTopicsAction = new RemoveSelectionAllTopicsAction();
        this.zoomSelectedObjectsAction = new ZoomSelectedObjectsAction();
        this.selectAllAction = new SelectAllAction();
        this.invertSelectionAction = new InvertSelectionAction();
        this.fullExtendAction = new FullExtendAction();
        this.goToAction = new GoToAction();
        this.measureAction = new MeasureAction();
        this.nextExtendAction = new NextExtendAction();
        this.panAction = new PanModeAction();
        this.previousExtendAction = new PreviousExtendAction();
        this.zoomInAction = new ZoomInAction();
        this.zoomOutAction = new ZoomOutAction();
        this.centralConfigAction = new CentralConfigAction();
        this.infoAction = new InfoAction();
        this.infoWindowAction = new InfoWindowAction();
        this.localConfigAction = new LocalConfigAction();
        this.onlineHelpAction = new OnlineHelpAction();
        this.presentationAction = new PresentationAction();
        this.zoomModeAction = new ZoomModeAction();
        this.selectionModeAction = new SelectionModeAction();
        this.btnGroupMapMode = new ButtonGroup();
        this.downloadManagerAction = new DownloadManagerAction();
        this.showManageBookmarksDialogAction = new ShowManageBookmarksDialogAction();
        this.showCreateBookmarkDialogAction = new ShowCreateBookmarkDialogAction();
        this.exportMapToFileAction = new ExportMapToFileAction();
        this.showHideOverviewWindowAction = new ShowHideOverviewWindowAction();
        this.selectionPolygonAction = new SelectionPolygonAction();
        this.selectionEllipseAction = new SelectionEllipseAction();
        this.selectionRectangleAction = new SelectionRectangleAction();
        this.editGroup = new ButtonGroup();
        this.newObjectAction = new NewObjectAction();
        this.mergeAction = new MergeAction();
        this.splitAction = new SplitAction();
        this.releaseAction = new ReleaseAction();
        this.annexAction = new AnnexAction();
        this.measureLineAction = new MeasureLineAction();
        this.flipAction = new FlipAction();
        this.intermediateSaveAction = new IntermediateSaveAction();
        this.gWKConnectionCheckAction = new GWKConnectionCheckAction();
        this.moveModeAction = new MoveModeAction();
        this.newLinestringModeAction = new NewLinestringModeAction();
        this.newRectangleModeAction = new NewRectangleModeAction();
        this.newMarkerModeAction = new NewMarkerModeAction();
        this.removeDrawingModeAction = new RemoveDrawingModeAction();
        this.newTextModeAction = new NewTextModeAction();
        this.loadDrawingsAction = new LoadDrawingsAction();
        this.saveDrawingsAction = new SaveDrawingsAction();
        this.selectAllDrawingsAction = new SelectAllDrawingsAction();
        this.bufferGeoprocessingAction = new BufferGeoprocessingAction();
        this.clipGeoprocessingAction = new ClipGeoprocessingAction();
        this.dissolveGeoprocessingAction = new DissolveGeoprocessingAction();
        this.mergeGeoprocessingAction = new MergeGeoprocessingAction();
        this.pointInLineGeoprocessingAction = new PointInLineGeoprocessingAction();
        this.pointInPolygonGeoprocessingAction = new PointInPolygonGeoprocessingAction();
        this.unionGeoprocessingAction = new UnionGeoprocessingAction();
        this.basicRoutesCheckAction1 = new BasicRoutesCheckAction();
        this.exportAction1 = new de.cismet.watergis.gui.actions.ExportAction();
        this.lawaCheckAction = new LawaCheckAction();
        this.verwaltungCheckAction = new VerwaltungCheckAction();
        this.sonstigeCheckAction = new SonstigeCheckAction();
        this.bauwerkeCheckAction = new BauwerkeCheckAction();
        this.ausbauCheckAction = new AusbauCheckAction();
        this.exportOptionAction = new ExportOptionAction();
        this.exportIgmAction = new ExportIgmAction();
        this.gewaesserReportAction = new GewaesserReportAction();
        this.gemeindenReportAction = new KatasterGemeindenReportAction();
        this.sbReportAction = new KatasterSbReportAction();
        this.gewaesserGewReportAction = new KatasterGewaesserReportAction();
        this.flaechenReportAction1 = new KatasterFlaechenReportAction();
        this.rlDDueReportAction = new GerinneGGemeindeReportAction();
        this.fotoInfoAction1 = new FotoInfoAction();
        this.deleteAction1 = new de.cismet.watergis.gui.actions.foto.DeleteAction();
        this.exportActionPhoto = new ExportAction();
        this.reportAction1 = new de.cismet.watergis.gui.actions.foto.ReportAction();
        this.uploadAction1 = new UploadAction();
        this.optionAction1 = new OptionAction();
        this.checkAction1 = new CheckAction();
        this.uploadActionGaf = new de.cismet.watergis.gui.actions.gaf.UploadAction();
        this.reportActionGaf = new ReportAction();
        this.optionActionGaf = new de.cismet.watergis.gui.actions.gaf.OptionAction();
        this.exportActionGaf = new de.cismet.watergis.gui.actions.gaf.ExportAction();
        this.deleteActionGaf = new DeleteAction();
        this.gafInfoAction = new GafInfoAction();
        this.gerinneGGewaesserReportAction1 = new GerinneGGewaesserReportAction();
        this.optionModeAction1 = new OptionModeAction();
        this.gerinneGSbReportAction1 = new GerinneGSbReportAction();
        this.gerinneGFlReportAction1 = new GerinneGFlReportAction();
        this.wkFgReportAction = new WkFgReportAction();
        this.unselectAllDrawingsAction = new UnselectAllDrawingsAction();
        this.zoomSelectedDrawingsAction = new ZoomSelectedDrawingsAction();
        this.zoomAllDrawingsAction = new ZoomAllDrawingsAction();
        this.reloadAction1 = new ReloadAction();
        this.drawingGroup = new ButtonGroup();
        this.gerogaRsAction1 = new GerogaRsAction();
        this.gerinneOGemeindeReportAction = new GerinneOGemeindeReportAction();
        this.gerinneOGewReportAction = new GerinneOGewReportAction();
        this.gerinneOSbReportAction = new GerinneOSbReportAction();
        this.gerinneOFlReportAction1 = new GerinneOFlReportAction();
        this.showMap = new ShowWindowAction(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().Map"));
        this.showTree = new ShowWindowAction(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().TopicTree"));
        this.showOverview = new ShowWindowAction(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().Overview"));
        this.showDatasource = new ShowWindowAction(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().Capabilities"));
        this.showInfo = new ShowWindowAction();
        this.showProblems = new ShowWindowAction(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().Table"));
        this.showPhoto = new ShowWindowAction(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().Photo"));
        this.showProfiles = new ShowWindowAction(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().Gaf"));
        this.showInfoWindowAction = new InfoWindowAction(true);
        this.defaultConfigAction1 = new DefaultConfigAction();
        this.defaultConfig2Action1 = new DefaultConfig2Action();
        this.copyObjectAction1 = new CopyObjectAction();
        this.pasteObjectAction1 = new PasteObjectAction();
        this.deleteObjectAction1 = new DeleteObjectAction();
        this.saveToSameFileProjectAction1 = new SaveToSameFileProjectAction();
        this.zoomSelectedThemesAction1 = new ZoomSelectedThemesAction();
        this.simpleMemoryMonitoringToolbarWidget1 = new SimpleMemoryMonitoringToolbarWidget();
        this.showLegend = new ShowWindowAction(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.initInfoNode().Legend"));
        this.removeModeAction1 = new RemoveModeAction();
        this.changePolygonModeAction1 = new ChangePolygonModeAction();
        this.stationAction1 = new StationAction();
        this.addThemeAction1 = new AddThemeAction();
        this.createViewsForUser1 = new CreateViewsForUser();
        this.techProfAction1 = new TechProfAction();
        this.wsgAction1 = new WsgAction();
        this.rechtsgrundlageAction1 = new RechtsgrundlageAction();
        this.refreshViewsForUser1 = new RefreshViewsForUser();
        this.wsgWaldAction1 = new WsgWaldAction();
        this.tobDLM25W = new JToolBar();
        this.cmdOpenProject = new JButton();
        this.cmdSaveSameFileProject = new JButton();
        this.cmdSaveProject = new JButton();
        this.cmdPrint = new JButton();
        this.cmdExportMap1 = new JButton();
        this.cmdExportMap2 = new JButton();
        this.cmdGeoLink = new JButton();
        this.cmdDownloadManager = new JButton();
        this.cmdDownloadManager1 = new JButton();
        this.jSeparator14 = new JToolBar.Separator();
        this.cboScale = new ScaleJComboBox();
        this.lblPlaceholder = new JLabel();
        this.panSearch = new JPanel();
        this.routeZoomPanel = new RouteZoomPanel();
        this.cboTheme = new JComboBox();
        this.jSeparator15 = new JToolBar.Separator();
        this.cmdRefresh = new JButton();
        this.tbtnZoomMode = new JToggleButton();
        this.cmdZoomIn = new JButton();
        this.cmdZoomOut = new JButton();
        this.tbtnPanMode = new JToggleButton();
        this.cmdGoTo = new JButton();
        this.cmdFullExtend = new JButton();
        this.cmdPreviousExtend = new JHistoryButton(false);
        this.cmdNextExtend = new JHistoryButton(false);
        this.cmdSelectionMode = new SelectionButton();
        this.cmdSelectionAttribute = new JButton();
        this.cmdSelectionLocation = new JButton();
        this.cmdZoomSelectedObjects = new JButton();
        this.cmdZoomSelectedThemes = new JButton();
        this.cmdSelectAll = new JButton();
        this.cmdInvertSelection = new JButton();
        this.cmdRemoveSelectionAllThemes = new JButton();
        this.tbtnInfo = new JToggleButton();
        this.tbtnMeasure = new MeasureButton();
        this.tbtnMeasureLineMode = new JToggleButton();
        this.cmdFreeStat = new JButton();
        this.cmdAddBookmark = new JButton();
        this.cmdManageBookmarks = new JButton();
        this.tbtnPhotoInfoMode = new JToggleButton();
        this.tbtnProfileInfoMode = new JToggleButton();
        this.cmdOnlineHelp = new JButton();
        this.jToolBar1 = new JToolBar();
        this.jLabel1 = new JLabel();
        this.tbtNewObject = new JToggleButton();
        this.butIntermediateSave = new JButton();
        this.cmdUndo = new JButton();
        this.cmdNodeMove = new JToggleButton();
        this.cmdNodeAdd = new JToggleButton();
        this.cmdNodeRemove = new JToggleButton();
        this.tbtnAddMode = new JToggleButton();
        this.tbtnRemoveMode = new JToggleButton();
        this.cmdSnappingMode = new SnappingButton();
        this.cmdPresentation = new JButton();
        this.cmdMoveGeometry = new JToggleButton();
        this.cmdMerge = new JButton();
        this.cmdSplit = new JButton();
        this.cmdRelease = new JButton();
        this.cmdAnnex = new JButton();
        this.cmdCopy = new JButton();
        this.cmdPaste = new JButton();
        this.cmdDelete = new JButton();
        this.cmdGeometryOpMode = new GeometryOpButton();
        this.jSeparator11 = new JToolBar.Separator();
        this.jLabel2 = new JLabel();
        this.cmdLoadDrawings = new JButton();
        this.cmdSaveDrawings = new JButton();
        this.cmdNewPolygon = new JToggleButton();
        this.cmdNewLinestring = new JToggleButton();
        this.cmdNewPoint = new JToggleButton();
        this.cmdNewText = new JToggleButton();
        this.cmdSelectAllDrawings = new JButton();
        this.cmdUnselectDrawings = new JButton();
        this.cmdZoomToAllDrawings = new JButton();
        this.cmdZoomToSelectedDrawings = new JButton();
        this.cmdRemoveGeometry = new JButton();
        this.cmdDrawingOptions = new JButton();
        this.cmdDrawingMode = new NewDrawingButton();
        this.statusPanel1 = new StatusPanel();
        this.panMain = new JPanel();
        this.statusBar1 = new StatusBar();
        this.jMenuBar1 = new JMenuBar();
        this.menFile = new FileMenu();
        this.mniOpenProject = new JMenuItem();
        this.mniSaveProject1 = new JMenuItem();
        this.mniSaveProject = new JMenuItem();
        this.mniOverview = new JMenuItem();
        this.mniPrint = new JMenuItem();
        this.mniSaveMapToFile = new JMenuItem();
        this.mniExportMap = new JMenuItem();
        this.mniCreateGeoLink = new JMenuItem();
        this.mniDownloadManager = new JMenuItem();
        this.mniFileOptions = new JMenuItem();
        this.sepCentralFilesStart = new JPopupMenu.Separator();
        this.sepCentralFilesEnd = new JPopupMenu.Separator();
        this.sepLocalFilesEnd = new JPopupMenu.Separator();
        this.mniClose = new JMenuItem();
        this.menSelection = new JMenu();
        this.mniSelectRectangle = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.mniSelectPolygon = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.mniSelectEllipse = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
        this.mniSelectAttribute = new JMenuItem();
        this.mniSelectLocation = new JMenuItem();
        this.mniZoomSelectedObjects = new JMenuItem();
        this.mniZoomSelectedThemes = new JMenuItem();
        this.mniRemoveSelection = new JMenuItem();
        this.menTools = new JMenu();
        this.menGeoProcessing = new JMenu();
        this.mniBuffer = new JMenuItem();
        this.mniClip = new JMenuItem();
        this.mniUnion = new JMenuItem();
        this.mniMerge = new JMenuItem();
        this.mniDissolve = new JMenuItem();
        this.mniPointInLine = new JMenuItem();
        this.mniPointInPolygon = new JMenuItem();
        this.jSeparator1 = new JPopupMenu.Separator();
        this.mniStation = new JMenuItem();
        this.mniTechProf = new JMenuItem();
        this.menChecks = new JMenu();
        this.menBasicChecks = new JMenu();
        this.mniCheckBasisRoutes = new JMenuItem();
        this.mniCheckVerwaltung = new JMenuItem();
        this.mniCheckAusbau = new JMenuItem();
        this.mniCheckBauwerke = new JMenuItem();
        this.mniCheckSonstige = new JMenuItem();
        this.menExtendedChecks = new JMenu();
        this.mniCheckLawaConnection = new JMenuItem();
        this.mniCheckLawa = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.menChecks1 = new JMenu();
        this.mniExport = new JMenuItem();
        this.mniIgmExport = new JMenuItem();
        this.mniExportOption = new JMenuItem();
        this.jMenu1 = new JMenu();
        this.mniCreateDbUser = new JMenuItem();
        this.mniRefreshDbUser = new JMenuItem();
        this.menReport = new JMenu();
        this.menSteckbrief = new JMenu();
        this.menSteckbriefGewaesser = new JMenu();
        this.mniGewaesser = new JMenuItem();
        this.menSteckbriefWasserkoerper = new JMenu();
        this.mniFG = new JMenuItem();
        this.menSteckbriefPhotos = new JMenu();
        this.mniPrintPhoto = new JMenuItem();
        this.menSteckbriefQp = new JMenu();
        this.mniPrintQp = new JMenuItem();
        this.menStatistik = new JMenu();
        this.menGewaesser = new JMenu();
        this.mniGewaesserRep = new JMenuItem();
        this.mniGemeinde = new JMenuItem();
        this.mniSb = new JMenuItem();
        this.mniFl = new JMenuItem();
        this.menGewaesser2 = new JMenu();
        this.mniGewaesserRep2 = new JMenuItem();
        this.mniGemeinde2 = new JMenuItem();
        this.mniSb2 = new JMenuItem();
        this.mniFl2 = new JMenuItem();
        this.menGewaesser1 = new JMenu();
        this.mniGewaesserRep1 = new JMenuItem();
        this.mniGemeinde1 = new JMenuItem();
        this.mniSb1 = new JMenuItem();
        this.mniFl1 = new JMenuItem();
        this.menGewaesser3 = new JMenu();
        this.mniGewaesserRep3 = new JMenuItem();
        this.menSchablonen = new JMenu();
        this.menWsg = new JMenu();
        this.mniFlNu = new JMenuItem();
        this.mniRechtsgrundlage = new JMenuItem();
        this.mniRechtsgrundlage1 = new JMenuItem();
        this.menPhoto = new JMenu();
        this.mniUpload = new JMenuItem();
        this.mniPhotoInfo = new JMenuItem();
        this.mniReportPhoto = new JMenuItem();
        this.mniExportPhoto = new JMenuItem();
        this.mniDeletePhoto = new JMenuItem();
        this.mniPhotoOptions = new JMenuItem();
        this.menProfiles = new JMenu();
        this.mniGafUpload = new JMenuItem();
        this.mniGafInfo = new JMenuItem();
        this.mniReportGaf = new JMenuItem();
        this.mniExportGaf = new JMenuItem();
        this.mniDeleteGaf = new JMenuItem();
        this.mniGafOptions = new JMenuItem();
        this.menBookmark = new JMenu();
        this.mniCreateBookmark = new JMenuItem();
        this.mniManageBookmarks = new JMenuItem();
        this.menDrawings = new JMenu();
        this.mniLoadDrawings = new JMenuItem();
        this.mniSaveDrawings = new JMenuItem();
        this.sepDrawingOperation = new JPopupMenu.Separator();
        this.mniNewRectangleDrawing = new JMenuItem();
        this.mniNewLineStringDrawing = new JMenuItem();
        this.mniNewMarkerDrawing = new JMenuItem();
        this.mniNewTextDrawing = new JMenuItem();
        this.sepDrawingOperation1 = new JPopupMenu.Separator();
        this.mniSelectAllDrawing = new JMenuItem();
        this.mniUnselectAllDrawing = new JMenuItem();
        this.mniZoomAllDrawings = new JMenuItem();
        this.mniZoomSelectedDrawings = new JMenuItem();
        this.mniRemoveDrawing = new JMenuItem();
        this.mniDrawingOptions = new JMenuItem();
        this.menWindow = new JMenu();
        this.mniShowMap = new JMenuItem();
        this.mniShowTree = new JMenuItem();
        this.mniShowOverview = new JMenuItem();
        this.mniShowDatasource = new JMenuItem();
        this.mniShowInfo = new JMenuItem();
        this.mniShowProblems = new JMenuItem();
        this.mniShowPhotos = new JMenuItem();
        this.mniShowProfiles = new JMenuItem();
        this.mniShowLegend = new JMenuItem();
        this.sepWindowSeparator = new JPopupMenu.Separator();
        this.mniDefaultConfig = new JMenuItem();
        this.mniShowDefaultConfig2 = new JMenuItem();
        this.menHelp = new JMenu();
        this.mniHelp = new JMenuItem();
        this.mniInfo = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.title"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.tobDLM25W.setFloatable(false);
        this.tobDLM25W.setRollover(true);
        this.tobDLM25W.setMaximumSize(new Dimension(2000, 28));
        this.tobDLM25W.setMinimumSize(new Dimension(200, 28));
        this.tobDLM25W.setPreferredSize(new Dimension(691, 28));
        this.cmdOpenProject.setAction(this.openProjectAction);
        this.cmdOpenProject.setFocusable(false);
        this.cmdOpenProject.setHideActionText(true);
        this.cmdOpenProject.setHorizontalTextPosition(0);
        this.cmdOpenProject.setMaximumSize(new Dimension(26, 26));
        this.cmdOpenProject.setMinimumSize(new Dimension(26, 26));
        this.cmdOpenProject.setPreferredSize(new Dimension(26, 26));
        this.cmdOpenProject.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdOpenProject);
        this.cmdSaveSameFileProject.setAction(this.saveToSameFileProjectAction1);
        this.cmdSaveSameFileProject.setFocusable(false);
        this.cmdSaveSameFileProject.setHideActionText(true);
        this.cmdSaveSameFileProject.setHorizontalTextPosition(0);
        this.cmdSaveSameFileProject.setMaximumSize(new Dimension(26, 26));
        this.cmdSaveSameFileProject.setMinimumSize(new Dimension(26, 26));
        this.cmdSaveSameFileProject.setPreferredSize(new Dimension(26, 26));
        this.cmdSaveSameFileProject.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdSaveSameFileProject);
        this.cmdSaveProject.setAction(this.saveProjectAction);
        this.cmdSaveProject.setFocusable(false);
        this.cmdSaveProject.setHideActionText(true);
        this.cmdSaveProject.setHorizontalTextPosition(0);
        this.cmdSaveProject.setMaximumSize(new Dimension(26, 26));
        this.cmdSaveProject.setMinimumSize(new Dimension(26, 26));
        this.cmdSaveProject.setPreferredSize(new Dimension(26, 26));
        this.cmdSaveProject.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdSaveProject);
        this.cmdPrint.setAction(this.printAction);
        this.cmdPrint.setFocusable(false);
        this.cmdPrint.setHideActionText(true);
        this.cmdPrint.setHorizontalTextPosition(0);
        this.cmdPrint.setMaximumSize(new Dimension(26, 26));
        this.cmdPrint.setMinimumSize(new Dimension(26, 26));
        this.cmdPrint.setPreferredSize(new Dimension(26, 26));
        this.cmdPrint.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdPrint);
        this.cmdExportMap1.setAction(this.exportMapToFileAction);
        this.cmdExportMap1.setFocusable(false);
        this.cmdExportMap1.setHideActionText(true);
        this.cmdExportMap1.setHorizontalTextPosition(0);
        this.cmdExportMap1.setMaximumSize(new Dimension(26, 26));
        this.cmdExportMap1.setMinimumSize(new Dimension(26, 26));
        this.cmdExportMap1.setPreferredSize(new Dimension(26, 26));
        this.cmdExportMap1.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdExportMap1);
        this.cmdExportMap2.setAction(this.exportMapAction);
        this.cmdExportMap2.setFocusable(false);
        this.cmdExportMap2.setHideActionText(true);
        this.cmdExportMap2.setHorizontalTextPosition(0);
        this.cmdExportMap2.setMaximumSize(new Dimension(26, 26));
        this.cmdExportMap2.setMinimumSize(new Dimension(26, 26));
        this.cmdExportMap2.setPreferredSize(new Dimension(26, 26));
        this.cmdExportMap2.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdExportMap2);
        this.cmdGeoLink.setAction(this.createGeoLinkAction);
        this.cmdGeoLink.setFocusable(false);
        this.cmdGeoLink.setHideActionText(true);
        this.cmdGeoLink.setHorizontalTextPosition(0);
        this.cmdGeoLink.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdGeoLink);
        this.cmdDownloadManager.setAction(this.downloadManagerAction);
        this.cmdDownloadManager.setFocusable(false);
        this.cmdDownloadManager.setHideActionText(true);
        this.cmdDownloadManager.setHorizontalTextPosition(0);
        this.cmdDownloadManager.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdDownloadManager);
        this.cmdDownloadManager1.setAction(this.addThemeAction1);
        this.cmdDownloadManager1.setFocusable(false);
        this.cmdDownloadManager1.setHideActionText(true);
        this.cmdDownloadManager1.setHorizontalTextPosition(0);
        this.cmdDownloadManager1.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdDownloadManager1);
        this.jSeparator14.setOpaque(true);
        this.jSeparator14.setSeparatorSize(new Dimension(20, 20));
        this.tobDLM25W.add(this.jSeparator14);
        this.cboScale.setEditable(true);
        this.cboScale.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.cboScale.toolTipText"));
        this.cboScale.setMaximumSize(new Dimension(90, 24));
        this.cboScale.setMinimumSize(new Dimension(90, 24));
        this.cboScale.setPreferredSize(new Dimension(90, 24));
        this.tobDLM25W.add(this.cboScale);
        this.lblPlaceholder.setMaximumSize(new Dimension(4, 1));
        this.lblPlaceholder.setMinimumSize(new Dimension(4, 1));
        this.lblPlaceholder.setPreferredSize(new Dimension(4, 1));
        this.tobDLM25W.add(this.lblPlaceholder);
        this.panSearch.setMaximumSize(new Dimension(240, 24));
        this.panSearch.setMinimumSize(new Dimension(240, 24));
        this.panSearch.setPreferredSize(new Dimension(240, 24));
        this.panSearch.setLayout(new GridBagLayout());
        this.routeZoomPanel.setMaximumSize(new Dimension(240, 24));
        this.routeZoomPanel.setMinimumSize(new Dimension(245, 24));
        this.routeZoomPanel.setPreferredSize(new Dimension(245, 24));
        this.panSearch.add((Component)this.routeZoomPanel, new GridBagConstraints());
        this.tobDLM25W.add(this.panSearch);
        this.cboTheme.setEditable(true);
        this.cboTheme.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.cboTheme.toolTipText_1"));
        this.cboTheme.setMaximumSize(new Dimension(163, 24));
        this.cboTheme.setMinimumSize(new Dimension(163, 24));
        this.cboTheme.setPreferredSize(new Dimension(163, 24));
        this.cboTheme.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                WatergisApp.this.cboThemeItemStateChanged(evt);
            }
        });
        this.tobDLM25W.add(this.cboTheme);
        this.jSeparator15.setOpaque(true);
        this.jSeparator15.setSeparatorSize(new Dimension(20, 20));
        this.tobDLM25W.add(this.jSeparator15);
        this.cmdRefresh.setAction(this.reloadAction1);
        this.cmdRefresh.setFocusable(false);
        this.cmdRefresh.setHideActionText(true);
        this.cmdRefresh.setHorizontalTextPosition(0);
        this.cmdRefresh.setMaximumSize(new Dimension(26, 26));
        this.cmdRefresh.setMinimumSize(new Dimension(26, 26));
        this.cmdRefresh.setPreferredSize(new Dimension(26, 26));
        this.cmdRefresh.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdRefresh);
        this.tbtnZoomMode.setAction(this.zoomModeAction);
        this.btnGroupMapMode.add(this.tbtnZoomMode);
        this.tbtnZoomMode.setFocusable(false);
        this.tbtnZoomMode.setHideActionText(true);
        this.tbtnZoomMode.setHorizontalTextPosition(0);
        this.tbtnZoomMode.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.tbtnZoomMode);
        this.cmdZoomIn.setAction(this.zoomInAction);
        this.cmdZoomIn.setFocusable(false);
        this.cmdZoomIn.setHideActionText(true);
        this.cmdZoomIn.setHorizontalTextPosition(0);
        this.cmdZoomIn.setMaximumSize(new Dimension(26, 26));
        this.cmdZoomIn.setMinimumSize(new Dimension(26, 26));
        this.cmdZoomIn.setPreferredSize(new Dimension(26, 26));
        this.cmdZoomIn.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdZoomIn);
        this.cmdZoomOut.setAction(this.zoomOutAction);
        this.cmdZoomOut.setFocusable(false);
        this.cmdZoomOut.setHideActionText(true);
        this.cmdZoomOut.setHorizontalTextPosition(0);
        this.cmdZoomOut.setMaximumSize(new Dimension(26, 26));
        this.cmdZoomOut.setMinimumSize(new Dimension(26, 26));
        this.cmdZoomOut.setPreferredSize(new Dimension(26, 26));
        this.cmdZoomOut.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdZoomOut);
        this.tbtnPanMode.setAction(this.panAction);
        this.btnGroupMapMode.add(this.tbtnPanMode);
        this.tbtnPanMode.setFocusable(false);
        this.tbtnPanMode.setHideActionText(true);
        this.tbtnPanMode.setHorizontalTextPosition(0);
        this.tbtnPanMode.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.tbtnPanMode);
        this.cmdGoTo.setAction(this.goToAction);
        this.cmdGoTo.setFocusable(false);
        this.cmdGoTo.setHideActionText(true);
        this.cmdGoTo.setHorizontalTextPosition(0);
        this.cmdGoTo.setMaximumSize(new Dimension(26, 26));
        this.cmdGoTo.setMinimumSize(new Dimension(26, 26));
        this.cmdGoTo.setPreferredSize(new Dimension(26, 26));
        this.cmdGoTo.setVerticalTextPosition(3);
        this.cmdGoTo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatergisApp.this.cmdGoToActionPerformed(evt);
            }
        });
        this.tobDLM25W.add(this.cmdGoTo);
        this.cmdFullExtend.setAction(this.fullExtendAction);
        this.cmdFullExtend.setFocusable(false);
        this.cmdFullExtend.setHideActionText(true);
        this.cmdFullExtend.setHorizontalTextPosition(0);
        this.cmdFullExtend.setMaximumSize(new Dimension(26, 26));
        this.cmdFullExtend.setMinimumSize(new Dimension(26, 26));
        this.cmdFullExtend.setPreferredSize(new Dimension(26, 26));
        this.cmdFullExtend.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdFullExtend);
        this.cmdPreviousExtend.setAction(this.previousExtendAction);
        this.cmdPreviousExtend.setFocusable(false);
        this.cmdPreviousExtend.setHideActionText(true);
        this.cmdPreviousExtend.setHorizontalTextPosition(0);
        this.cmdPreviousExtend.setMaximumSize(new Dimension(26, 26));
        this.cmdPreviousExtend.setMinimumSize(new Dimension(26, 26));
        this.cmdPreviousExtend.setPreferredSize(new Dimension(26, 26));
        this.cmdPreviousExtend.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdPreviousExtend);
        this.cmdNextExtend.setAction(this.nextExtendAction);
        this.cmdNextExtend.setFocusable(false);
        this.cmdNextExtend.setHideActionText(true);
        this.cmdNextExtend.setHorizontalTextPosition(0);
        this.cmdNextExtend.setMaximumSize(new Dimension(26, 26));
        this.cmdNextExtend.setMinimumSize(new Dimension(26, 26));
        this.cmdNextExtend.setPreferredSize(new Dimension(26, 26));
        this.cmdNextExtend.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdNextExtend);
        this.cmdSelectionMode.setAction(this.selectionModeAction);
        this.cmdSelectionMode.setFocusable(false);
        this.cmdSelectionMode.setHideActionText(true);
        this.cmdSelectionMode.setHorizontalTextPosition(0);
        this.cmdSelectionMode.setMaximumSize(new Dimension(26, 26));
        this.cmdSelectionMode.setMinimumSize(new Dimension(26, 26));
        this.cmdSelectionMode.setPreferredSize(new Dimension(26, 26));
        this.cmdSelectionMode.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdSelectionMode);
        this.cmdSelectionAttribute.setAction(this.selectionAttributeAction);
        this.cmdSelectionAttribute.setFocusable(false);
        this.cmdSelectionAttribute.setHideActionText(true);
        this.cmdSelectionAttribute.setHorizontalTextPosition(0);
        this.cmdSelectionAttribute.setMaximumSize(new Dimension(26, 26));
        this.cmdSelectionAttribute.setMinimumSize(new Dimension(26, 26));
        this.cmdSelectionAttribute.setPreferredSize(new Dimension(26, 26));
        this.cmdSelectionAttribute.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdSelectionAttribute);
        this.cmdSelectionLocation.setAction(this.selectionLocationAction);
        this.cmdSelectionLocation.setFocusable(false);
        this.cmdSelectionLocation.setHideActionText(true);
        this.cmdSelectionLocation.setHorizontalTextPosition(0);
        this.cmdSelectionLocation.setMaximumSize(new Dimension(26, 26));
        this.cmdSelectionLocation.setMinimumSize(new Dimension(26, 26));
        this.cmdSelectionLocation.setPreferredSize(new Dimension(26, 26));
        this.cmdSelectionLocation.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdSelectionLocation);
        this.cmdZoomSelectedObjects.setAction(this.zoomSelectedObjectsAction);
        this.cmdZoomSelectedObjects.setEnabled(false);
        this.cmdZoomSelectedObjects.setFocusable(false);
        this.cmdZoomSelectedObjects.setHideActionText(true);
        this.cmdZoomSelectedObjects.setHorizontalTextPosition(0);
        this.cmdZoomSelectedObjects.setMaximumSize(new Dimension(26, 26));
        this.cmdZoomSelectedObjects.setMinimumSize(new Dimension(26, 26));
        this.cmdZoomSelectedObjects.setPreferredSize(new Dimension(26, 26));
        this.cmdZoomSelectedObjects.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdZoomSelectedObjects);
        this.cmdZoomSelectedThemes.setAction(this.zoomSelectedThemesAction1);
        this.cmdZoomSelectedThemes.setEnabled(false);
        this.cmdZoomSelectedThemes.setFocusable(false);
        this.cmdZoomSelectedThemes.setHideActionText(true);
        this.cmdZoomSelectedThemes.setHorizontalTextPosition(0);
        this.cmdZoomSelectedThemes.setMaximumSize(new Dimension(26, 26));
        this.cmdZoomSelectedThemes.setMinimumSize(new Dimension(26, 26));
        this.cmdZoomSelectedThemes.setPreferredSize(new Dimension(26, 26));
        this.cmdZoomSelectedThemes.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdZoomSelectedThemes);
        this.cmdSelectAll.setAction(this.selectAllAction);
        Mnemonics.setLocalizedText((AbstractButton)this.cmdSelectAll, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.cmdSelectAll.text"));
        this.cmdSelectAll.setFocusable(false);
        this.cmdSelectAll.setHideActionText(true);
        this.cmdSelectAll.setHorizontalTextPosition(0);
        this.cmdSelectAll.setMaximumSize(new Dimension(26, 26));
        this.cmdSelectAll.setMinimumSize(new Dimension(26, 26));
        this.cmdSelectAll.setPreferredSize(new Dimension(26, 26));
        this.cmdSelectAll.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdSelectAll);
        this.cmdInvertSelection.setAction(this.invertSelectionAction);
        this.cmdInvertSelection.setFocusable(false);
        this.cmdInvertSelection.setHideActionText(true);
        this.cmdInvertSelection.setHorizontalTextPosition(0);
        this.cmdInvertSelection.setMaximumSize(new Dimension(26, 26));
        this.cmdInvertSelection.setMinimumSize(new Dimension(26, 26));
        this.cmdInvertSelection.setPreferredSize(new Dimension(26, 26));
        this.cmdInvertSelection.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdInvertSelection);
        this.cmdRemoveSelectionAllThemes.setAction(this.removeSelectionAllTopicsAction);
        this.cmdRemoveSelectionAllThemes.setEnabled(false);
        this.cmdRemoveSelectionAllThemes.setFocusable(false);
        this.cmdRemoveSelectionAllThemes.setHideActionText(true);
        this.cmdRemoveSelectionAllThemes.setHorizontalTextPosition(0);
        this.cmdRemoveSelectionAllThemes.setMaximumSize(new Dimension(26, 26));
        this.cmdRemoveSelectionAllThemes.setMinimumSize(new Dimension(26, 26));
        this.cmdRemoveSelectionAllThemes.setPreferredSize(new Dimension(26, 26));
        this.cmdRemoveSelectionAllThemes.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdRemoveSelectionAllThemes);
        this.tbtnInfo.setAction(this.infoWindowAction);
        this.btnGroupMapMode.add(this.tbtnInfo);
        this.tbtnInfo.setFocusable(false);
        this.tbtnInfo.setHideActionText(true);
        this.tbtnInfo.setHorizontalTextPosition(0);
        this.tbtnInfo.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.tbtnInfo);
        this.tbtnMeasure.setAction(this.measureAction);
        this.tbtnMeasure.setFocusable(false);
        this.tbtnMeasure.setHideActionText(true);
        this.tbtnMeasure.setHorizontalTextPosition(0);
        this.tbtnMeasure.setMaximumSize(new Dimension(26, 26));
        this.tbtnMeasure.setMinimumSize(new Dimension(26, 26));
        this.tbtnMeasure.setPreferredSize(new Dimension(26, 26));
        this.tbtnMeasure.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.tbtnMeasure);
        this.tbtnMeasureLineMode.setAction(this.measureLineAction);
        this.btnGroupMapMode.add(this.tbtnMeasureLineMode);
        this.tbtnMeasureLineMode.setFocusable(false);
        this.tbtnMeasureLineMode.setHideActionText(true);
        this.tbtnMeasureLineMode.setHorizontalTextPosition(0);
        this.tbtnMeasureLineMode.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.tbtnMeasureLineMode);
        this.cmdFreeStat.setAction(this.stationAction1);
        this.cmdFreeStat.setFocusable(false);
        this.cmdFreeStat.setHideActionText(true);
        this.cmdFreeStat.setHorizontalTextPosition(0);
        this.cmdFreeStat.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdFreeStat);
        this.cmdAddBookmark.setAction(this.showCreateBookmarkDialogAction);
        this.cmdAddBookmark.setFocusable(false);
        this.cmdAddBookmark.setHideActionText(true);
        this.cmdAddBookmark.setHorizontalTextPosition(0);
        this.cmdAddBookmark.setMaximumSize(new Dimension(26, 26));
        this.cmdAddBookmark.setMinimumSize(new Dimension(26, 26));
        this.cmdAddBookmark.setPreferredSize(new Dimension(26, 26));
        this.cmdAddBookmark.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdAddBookmark);
        this.cmdManageBookmarks.setAction(this.showManageBookmarksDialogAction);
        this.cmdManageBookmarks.setFocusable(false);
        this.cmdManageBookmarks.setHideActionText(true);
        this.cmdManageBookmarks.setHorizontalTextPosition(0);
        this.cmdManageBookmarks.setMaximumSize(new Dimension(26, 26));
        this.cmdManageBookmarks.setMinimumSize(new Dimension(26, 26));
        this.cmdManageBookmarks.setPreferredSize(new Dimension(26, 26));
        this.cmdManageBookmarks.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdManageBookmarks);
        this.tbtnPhotoInfoMode.setAction(this.fotoInfoAction1);
        this.btnGroupMapMode.add(this.tbtnPhotoInfoMode);
        this.tbtnPhotoInfoMode.setFocusable(false);
        this.tbtnPhotoInfoMode.setHideActionText(true);
        this.tbtnPhotoInfoMode.setHorizontalTextPosition(0);
        this.tbtnPhotoInfoMode.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.tbtnPhotoInfoMode);
        this.tbtnProfileInfoMode.setAction(this.gafInfoAction);
        this.btnGroupMapMode.add(this.tbtnProfileInfoMode);
        this.tbtnProfileInfoMode.setFocusable(false);
        this.tbtnProfileInfoMode.setHideActionText(true);
        this.tbtnProfileInfoMode.setHorizontalTextPosition(0);
        this.tbtnProfileInfoMode.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.tbtnProfileInfoMode);
        this.cmdOnlineHelp.setAction(this.onlineHelpAction);
        this.cmdOnlineHelp.setBorderPainted(false);
        this.cmdOnlineHelp.setFocusPainted(false);
        this.cmdOnlineHelp.setFocusable(false);
        this.cmdOnlineHelp.setHideActionText(true);
        this.cmdOnlineHelp.setHorizontalTextPosition(0);
        this.cmdOnlineHelp.setMaximumSize(new Dimension(26, 26));
        this.cmdOnlineHelp.setMinimumSize(new Dimension(26, 26));
        this.cmdOnlineHelp.setPreferredSize(new Dimension(26, 26));
        this.cmdOnlineHelp.setVerticalTextPosition(3);
        this.tobDLM25W.add(this.cmdOnlineHelp);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.tobDLM25W, gridBagConstraints);
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMaximumSize(new Dimension(2000, 28));
        this.jToolBar1.setMinimumSize(new Dimension(200, 28));
        this.jToolBar1.setPreferredSize(new Dimension(691, 28));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.jLabel1.text", (Object[])new Object[0]));
        this.jToolBar1.add(this.jLabel1);
        this.tbtNewObject.setAction(this.newObjectAction);
        this.btnGroupMapMode.add(this.tbtNewObject);
        this.tbtNewObject.setFocusable(false);
        this.tbtNewObject.setHideActionText(true);
        this.tbtNewObject.setHorizontalTextPosition(0);
        this.tbtNewObject.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbtNewObject);
        this.butIntermediateSave.setAction(this.intermediateSaveAction);
        this.butIntermediateSave.setEnabled(false);
        this.butIntermediateSave.setFocusable(false);
        this.butIntermediateSave.setHideActionText(true);
        this.butIntermediateSave.setHorizontalTextPosition(0);
        this.butIntermediateSave.setVerticalTextPosition(3);
        this.jToolBar1.add(this.butIntermediateSave);
        this.cmdUndo.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons22/undo.png")));
        this.cmdUndo.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.cmdUndo.toolTipText"));
        this.cmdUndo.setBorderPainted(false);
        this.cmdUndo.setEnabled(false);
        this.cmdUndo.setFocusPainted(false);
        this.cmdUndo.setFocusable(false);
        this.cmdUndo.setHorizontalTextPosition(0);
        this.cmdUndo.setVerticalTextPosition(3);
        this.cmdUndo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatergisApp.this.cmdUndomniUndoPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdUndo);
        this.editGroup.add(this.cmdNodeMove);
        this.cmdNodeMove.setIcon(new ImageIcon(this.getClass().getResource("/images/moveNodes.png")));
        this.cmdNodeMove.setSelected(true);
        this.cmdNodeMove.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.cmdNodeMove.toolTipText"));
        this.cmdNodeMove.setBorderPainted(false);
        this.cmdNodeMove.setEnabled(false);
        this.cmdNodeMove.setFocusPainted(false);
        this.cmdNodeMove.setFocusable(false);
        this.cmdNodeMove.setHorizontalTextPosition(0);
        this.cmdNodeMove.setVerticalTextPosition(3);
        this.cmdNodeMove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatergisApp.this.cmdNodeMoveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdNodeMove);
        this.editGroup.add(this.cmdNodeAdd);
        this.cmdNodeAdd.setIcon(new ImageIcon(this.getClass().getResource("/images/insertNodes.png")));
        this.cmdNodeAdd.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.cmdNodeAdd.toolTipText"));
        this.cmdNodeAdd.setBorderPainted(false);
        this.cmdNodeAdd.setEnabled(false);
        this.cmdNodeAdd.setFocusPainted(false);
        this.cmdNodeAdd.setFocusable(false);
        this.cmdNodeAdd.setHorizontalTextPosition(0);
        this.cmdNodeAdd.setVerticalTextPosition(3);
        this.cmdNodeAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatergisApp.this.cmdNodeAddActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdNodeAdd);
        this.editGroup.add(this.cmdNodeRemove);
        this.cmdNodeRemove.setIcon(new ImageIcon(this.getClass().getResource("/images/removeNodes.png")));
        this.cmdNodeRemove.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.cmdNodeRemove.toolTipText"));
        this.cmdNodeRemove.setBorderPainted(false);
        this.cmdNodeRemove.setEnabled(false);
        this.cmdNodeRemove.setFocusPainted(false);
        this.cmdNodeRemove.setFocusable(false);
        this.cmdNodeRemove.setHorizontalTextPosition(0);
        this.cmdNodeRemove.setVerticalTextPosition(3);
        this.cmdNodeRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WatergisApp.this.cmdNodeRemoveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.cmdNodeRemove);
        this.tbtnAddMode.setAction(this.changePolygonModeAction1);
        this.btnGroupMapMode.add(this.tbtnAddMode);
        this.tbtnAddMode.setEnabled(false);
        this.tbtnAddMode.setFocusable(false);
        this.tbtnAddMode.setHideActionText(true);
        this.tbtnAddMode.setHorizontalTextPosition(0);
        this.tbtnAddMode.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbtnAddMode);
        this.tbtnRemoveMode.setAction(this.removeModeAction1);
        this.btnGroupMapMode.add(this.tbtnRemoveMode);
        this.tbtnRemoveMode.setEnabled(false);
        this.tbtnRemoveMode.setFocusable(false);
        this.tbtnRemoveMode.setHideActionText(true);
        this.tbtnRemoveMode.setHorizontalTextPosition(0);
        this.tbtnRemoveMode.setVerticalTextPosition(3);
        this.jToolBar1.add(this.tbtnRemoveMode);
        this.cmdSnappingMode.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-snaptogrid.png")));
        this.cmdSnappingMode.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.cmdSnappingMode.toolTipText", (Object[])new Object[0]));
        this.cmdSnappingMode.setFocusable(false);
        this.cmdSnappingMode.setHideActionText(true);
        this.cmdSnappingMode.setHorizontalTextPosition(0);
        this.cmdSnappingMode.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdSnappingMode);
        this.cmdPresentation.setAction(this.flipAction);
        this.cmdPresentation.setEnabled(false);
        this.cmdPresentation.setFocusable(false);
        this.cmdPresentation.setHideActionText(true);
        this.cmdPresentation.setHorizontalTextPosition(0);
        this.cmdPresentation.setMaximumSize(new Dimension(26, 26));
        this.cmdPresentation.setMinimumSize(new Dimension(26, 26));
        this.cmdPresentation.setPreferredSize(new Dimension(26, 26));
        this.cmdPresentation.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdPresentation);
        this.cmdMoveGeometry.setAction(this.moveModeAction);
        this.btnGroupMapMode.add(this.cmdMoveGeometry);
        this.cmdMoveGeometry.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.cmdMoveGeometry.toolTipText"));
        this.cmdMoveGeometry.setBorderPainted(false);
        this.cmdMoveGeometry.setEnabled(false);
        this.cmdMoveGeometry.setFocusPainted(false);
        this.cmdMoveGeometry.setFocusable(false);
        this.cmdMoveGeometry.setHideActionText(true);
        this.cmdMoveGeometry.setHorizontalTextPosition(0);
        this.cmdMoveGeometry.setMaximumSize(new Dimension(29, 29));
        this.cmdMoveGeometry.setMinimumSize(new Dimension(29, 29));
        this.cmdMoveGeometry.setPreferredSize(new Dimension(29, 29));
        this.cmdMoveGeometry.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdMoveGeometry);
        this.cmdMerge.setAction(this.mergeAction);
        this.cmdMerge.setBorderPainted(false);
        this.cmdMerge.setEnabled(false);
        this.cmdMerge.setFocusPainted(false);
        this.cmdMerge.setFocusable(false);
        this.cmdMerge.setHorizontalTextPosition(0);
        this.cmdMerge.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdMerge);
        this.cmdSplit.setAction(this.splitAction);
        this.cmdSplit.setBorderPainted(false);
        this.cmdSplit.setEnabled(false);
        this.cmdSplit.setFocusPainted(false);
        this.cmdSplit.setFocusable(false);
        this.cmdSplit.setHorizontalTextPosition(0);
        this.cmdSplit.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdSplit);
        this.cmdRelease.setAction(this.releaseAction);
        this.cmdRelease.setBorderPainted(false);
        this.cmdRelease.setEnabled(false);
        this.cmdRelease.setFocusPainted(false);
        this.cmdRelease.setFocusable(false);
        this.cmdRelease.setHorizontalTextPosition(0);
        this.cmdRelease.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdRelease);
        this.cmdAnnex.setAction(this.annexAction);
        this.cmdAnnex.setBorderPainted(false);
        this.cmdAnnex.setEnabled(false);
        this.cmdAnnex.setFocusPainted(false);
        this.cmdAnnex.setFocusable(false);
        this.cmdAnnex.setHorizontalTextPosition(0);
        this.cmdAnnex.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdAnnex);
        this.cmdCopy.setAction(this.copyObjectAction1);
        this.cmdCopy.setBorderPainted(false);
        this.cmdCopy.setEnabled(false);
        this.cmdCopy.setFocusPainted(false);
        this.cmdCopy.setFocusable(false);
        this.cmdCopy.setHideActionText(true);
        this.cmdCopy.setHorizontalTextPosition(0);
        this.cmdCopy.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdCopy);
        this.cmdPaste.setAction(this.pasteObjectAction1);
        this.cmdPaste.setBorderPainted(false);
        this.cmdPaste.setEnabled(false);
        this.cmdPaste.setFocusPainted(false);
        this.cmdPaste.setFocusable(false);
        this.cmdPaste.setHideActionText(true);
        this.cmdPaste.setHorizontalTextPosition(0);
        this.cmdPaste.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdPaste);
        this.cmdDelete.setAction(this.deleteObjectAction1);
        this.cmdDelete.setBorderPainted(false);
        this.cmdDelete.setEnabled(false);
        this.cmdDelete.setFocusPainted(false);
        this.cmdDelete.setFocusable(false);
        this.cmdDelete.setHideActionText(true);
        this.cmdDelete.setHorizontalTextPosition(0);
        this.cmdDelete.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdDelete);
        this.cmdGeometryOpMode.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-wizard.png")));
        this.cmdGeometryOpMode.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.cmdGeometryOpMode.toolTipText", (Object[])new Object[0]));
        this.cmdGeometryOpMode.setFocusable(false);
        this.cmdGeometryOpMode.setHideActionText(true);
        this.cmdGeometryOpMode.setHorizontalTextPosition(0);
        this.cmdGeometryOpMode.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdGeometryOpMode);
        this.jSeparator11.setOpaque(true);
        this.jSeparator11.setSeparatorSize(new Dimension(20, 20));
        this.jToolBar1.add(this.jSeparator11);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.jLabel2.text", (Object[])new Object[0]));
        this.jToolBar1.add(this.jLabel2);
        this.cmdLoadDrawings.setAction(this.loadDrawingsAction);
        this.cmdLoadDrawings.setBorderPainted(false);
        this.cmdLoadDrawings.setFocusPainted(false);
        this.cmdLoadDrawings.setFocusable(false);
        this.cmdLoadDrawings.setHideActionText(true);
        this.cmdLoadDrawings.setHorizontalTextPosition(0);
        this.cmdLoadDrawings.setMaximumSize(new Dimension(26, 26));
        this.cmdLoadDrawings.setMinimumSize(new Dimension(26, 26));
        this.cmdLoadDrawings.setPreferredSize(new Dimension(26, 26));
        this.cmdLoadDrawings.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdLoadDrawings);
        this.cmdSaveDrawings.setAction(this.saveDrawingsAction);
        this.cmdSaveDrawings.setBorderPainted(false);
        this.cmdSaveDrawings.setFocusPainted(false);
        this.cmdSaveDrawings.setFocusable(false);
        this.cmdSaveDrawings.setHideActionText(true);
        this.cmdSaveDrawings.setHorizontalTextPosition(0);
        this.cmdSaveDrawings.setMaximumSize(new Dimension(26, 26));
        this.cmdSaveDrawings.setMinimumSize(new Dimension(26, 26));
        this.cmdSaveDrawings.setPreferredSize(new Dimension(26, 26));
        this.cmdSaveDrawings.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdSaveDrawings);
        this.cmdNewPolygon.setAction(this.newRectangleModeAction);
        this.btnGroupMapMode.add(this.cmdNewPolygon);
        this.cmdNewPolygon.setBorderPainted(false);
        this.cmdNewPolygon.setFocusPainted(false);
        this.cmdNewPolygon.setFocusable(false);
        this.cmdNewPolygon.setHideActionText(true);
        this.cmdNewPolygon.setHorizontalTextPosition(0);
        this.cmdNewPolygon.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdNewPolygon);
        this.cmdNewLinestring.setAction(this.newLinestringModeAction);
        this.btnGroupMapMode.add(this.cmdNewLinestring);
        this.cmdNewLinestring.setBorderPainted(false);
        this.cmdNewLinestring.setFocusPainted(false);
        this.cmdNewLinestring.setFocusable(false);
        this.cmdNewLinestring.setHideActionText(true);
        this.cmdNewLinestring.setHorizontalTextPosition(0);
        this.cmdNewLinestring.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdNewLinestring);
        this.cmdNewPoint.setAction(this.newMarkerModeAction);
        this.btnGroupMapMode.add(this.cmdNewPoint);
        this.cmdNewPoint.setBorderPainted(false);
        this.cmdNewPoint.setFocusPainted(false);
        this.cmdNewPoint.setFocusable(false);
        this.cmdNewPoint.setHideActionText(true);
        this.cmdNewPoint.setHorizontalTextPosition(0);
        this.cmdNewPoint.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdNewPoint);
        this.cmdNewText.setAction(this.newTextModeAction);
        this.btnGroupMapMode.add(this.cmdNewText);
        this.cmdNewText.setBorderPainted(false);
        this.cmdNewText.setFocusPainted(false);
        this.cmdNewText.setFocusable(false);
        this.cmdNewText.setHideActionText(true);
        this.cmdNewText.setHorizontalTextPosition(0);
        this.cmdNewText.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdNewText);
        this.cmdSelectAllDrawings.setAction(this.selectAllDrawingsAction);
        this.cmdSelectAllDrawings.setFocusable(false);
        this.cmdSelectAllDrawings.setHideActionText(true);
        this.cmdSelectAllDrawings.setHorizontalTextPosition(0);
        this.cmdSelectAllDrawings.setMaximumSize(new Dimension(26, 26));
        this.cmdSelectAllDrawings.setMinimumSize(new Dimension(26, 26));
        this.cmdSelectAllDrawings.setPreferredSize(new Dimension(26, 26));
        this.cmdSelectAllDrawings.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdSelectAllDrawings);
        this.cmdUnselectDrawings.setAction(this.unselectAllDrawingsAction);
        this.cmdUnselectDrawings.setBorderPainted(false);
        this.cmdUnselectDrawings.setEnabled(false);
        this.cmdUnselectDrawings.setFocusPainted(false);
        this.cmdUnselectDrawings.setFocusable(false);
        this.cmdUnselectDrawings.setHideActionText(true);
        this.cmdUnselectDrawings.setHorizontalTextPosition(0);
        this.cmdUnselectDrawings.setMaximumSize(new Dimension(26, 26));
        this.cmdUnselectDrawings.setMinimumSize(new Dimension(26, 26));
        this.cmdUnselectDrawings.setPreferredSize(new Dimension(26, 26));
        this.cmdUnselectDrawings.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdUnselectDrawings);
        this.cmdZoomToAllDrawings.setAction(this.zoomAllDrawingsAction);
        this.cmdZoomToAllDrawings.setBorderPainted(false);
        this.cmdZoomToAllDrawings.setFocusPainted(false);
        this.cmdZoomToAllDrawings.setFocusable(false);
        this.cmdZoomToAllDrawings.setHideActionText(true);
        this.cmdZoomToAllDrawings.setHorizontalTextPosition(0);
        this.cmdZoomToAllDrawings.setMaximumSize(new Dimension(26, 26));
        this.cmdZoomToAllDrawings.setMinimumSize(new Dimension(26, 26));
        this.cmdZoomToAllDrawings.setPreferredSize(new Dimension(26, 26));
        this.cmdZoomToAllDrawings.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdZoomToAllDrawings);
        this.cmdZoomToSelectedDrawings.setAction(this.zoomSelectedDrawingsAction);
        this.cmdZoomToSelectedDrawings.setBorderPainted(false);
        this.cmdZoomToSelectedDrawings.setEnabled(false);
        this.cmdZoomToSelectedDrawings.setFocusPainted(false);
        this.cmdZoomToSelectedDrawings.setFocusable(false);
        this.cmdZoomToSelectedDrawings.setHideActionText(true);
        this.cmdZoomToSelectedDrawings.setHorizontalTextPosition(0);
        this.cmdZoomToSelectedDrawings.setMaximumSize(new Dimension(26, 26));
        this.cmdZoomToSelectedDrawings.setMinimumSize(new Dimension(26, 26));
        this.cmdZoomToSelectedDrawings.setPreferredSize(new Dimension(26, 26));
        this.cmdZoomToSelectedDrawings.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdZoomToSelectedDrawings);
        this.cmdRemoveGeometry.setAction(this.removeDrawingModeAction);
        this.cmdRemoveGeometry.setBorderPainted(false);
        this.cmdRemoveGeometry.setEnabled(false);
        this.cmdRemoveGeometry.setFocusPainted(false);
        this.cmdRemoveGeometry.setFocusable(false);
        this.cmdRemoveGeometry.setHideActionText(true);
        this.cmdRemoveGeometry.setHorizontalTextPosition(0);
        this.cmdRemoveGeometry.setMaximumSize(new Dimension(26, 26));
        this.cmdRemoveGeometry.setMinimumSize(new Dimension(26, 26));
        this.cmdRemoveGeometry.setPreferredSize(new Dimension(26, 26));
        this.cmdRemoveGeometry.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdRemoveGeometry);
        this.cmdDrawingOptions.setAction(this.optionModeAction1);
        this.cmdDrawingOptions.setFocusable(false);
        this.cmdDrawingOptions.setHideActionText(true);
        this.cmdDrawingOptions.setHorizontalTextPosition(0);
        this.cmdDrawingOptions.setMaximumSize(new Dimension(26, 26));
        this.cmdDrawingOptions.setMinimumSize(new Dimension(26, 26));
        this.cmdDrawingOptions.setPreferredSize(new Dimension(26, 26));
        this.cmdDrawingOptions.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdDrawingOptions);
        this.cmdDrawingMode.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-palette-painting.png")));
        this.cmdDrawingMode.setFocusable(false);
        this.cmdDrawingMode.setHideActionText(true);
        this.cmdDrawingMode.setHorizontalTextPosition(0);
        this.cmdDrawingMode.setVerticalTextPosition(3);
        this.jToolBar1.add(this.cmdDrawingMode);
        this.jToolBar1.add(this.statusPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jToolBar1, gridBagConstraints);
        this.panMain.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.panMain, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.statusBar1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.menFile, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menFile.text"));
        this.mniOpenProject.setAction(this.openProjectAction);
        this.mniOpenProject.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniOpenProject.toolTipText", (Object[])new Object[0]));
        this.menFile.add(this.mniOpenProject);
        this.mniSaveProject1.setAction(this.saveToSameFileProjectAction1);
        this.mniSaveProject1.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniSaveProject1.toolTipText", (Object[])new Object[0]));
        this.menFile.add(this.mniSaveProject1);
        this.mniSaveProject.setAction(this.saveProjectAction);
        this.mniSaveProject.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniSaveProject.toolTipText", (Object[])new Object[0]));
        this.menFile.add(this.mniSaveProject);
        this.mniOverview.setAction(this.showHideOverviewWindowAction);
        this.mniOverview.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniOverview.toolTipText", (Object[])new Object[0]));
        this.menFile.add(this.mniOverview);
        this.mniPrint.setAction(this.printAction);
        this.mniPrint.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniPrint.toolTipText", (Object[])new Object[0]));
        this.menFile.add(this.mniPrint);
        this.mniSaveMapToFile.setAction(this.exportMapToFileAction);
        this.mniSaveMapToFile.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniSaveMapToFile.toolTipText", (Object[])new Object[0]));
        this.menFile.add(this.mniSaveMapToFile);
        this.mniExportMap.setAction(this.exportMapAction);
        this.mniExportMap.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniExportMap.toolTipText", (Object[])new Object[0]));
        this.menFile.add(this.mniExportMap);
        this.mniCreateGeoLink.setAction(this.createGeoLinkAction);
        this.mniCreateGeoLink.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniCreateGeoLink.toolTipText", (Object[])new Object[0]));
        this.menFile.add(this.mniCreateGeoLink);
        this.mniDownloadManager.setAction(this.downloadManagerAction);
        this.mniDownloadManager.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniDownloadManager.toolTipText", (Object[])new Object[0]));
        this.menFile.add(this.mniDownloadManager);
        this.mniFileOptions.setAction(this.optionsAction);
        this.mniFileOptions.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniFileOptions.toolTipText", (Object[])new Object[0]));
        this.menFile.add(this.mniFileOptions);
        this.sepCentralFilesStart.setName("sepCentralFilesStart");
        this.menFile.add(this.sepCentralFilesStart);
        this.sepCentralFilesEnd.setName("sepCentralFilesEnd");
        this.menFile.add(this.sepCentralFilesEnd);
        this.sepLocalFilesEnd.setName("sepLocalFilesEnd");
        this.menFile.add(this.sepLocalFilesEnd);
        this.mniClose.setAction(this.closeAction);
        this.mniClose.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniClose.toolTipText", (Object[])new Object[0]));
        this.menFile.add(this.mniClose);
        this.jMenuBar1.add(this.menFile);
        ((FileMenu)this.menFile).saveComponentsAfterInitialisation();
        Mnemonics.setLocalizedText((AbstractButton)this.menSelection, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menSelection.text"));
        this.mniSelectRectangle.setAction(this.selectionRectangleAction);
        this.mniSelectRectangle.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniSelectRectangle.toolTipText"));
        this.menSelection.add(this.mniSelectRectangle);
        this.mniSelectPolygon.setAction(this.selectionPolygonAction);
        this.mniSelectPolygon.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniSelectPolygon.toolTipText"));
        this.mniSelectPolygon.setLabel(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniSelectPolygon.label"));
        this.menSelection.add(this.mniSelectPolygon);
        this.mniSelectEllipse.setAction(this.selectionEllipseAction);
        this.mniSelectEllipse.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniSelectEllipse.toolTipText"));
        this.mniSelectEllipse.setLabel(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniSelectEllipse.label"));
        this.menSelection.add(this.mniSelectEllipse);
        this.mniSelectAttribute.setAction(this.selectionAttributeAction);
        this.mniSelectAttribute.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniSelectAttribute.toolTipText", (Object[])new Object[0]));
        this.menSelection.add(this.mniSelectAttribute);
        this.mniSelectLocation.setAction(this.selectionLocationAction);
        this.mniSelectLocation.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniSelectLocation.toolTipText", (Object[])new Object[0]));
        this.menSelection.add(this.mniSelectLocation);
        this.mniZoomSelectedObjects.setAction(this.zoomSelectedObjectsAction);
        this.mniZoomSelectedObjects.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniZoomSelectedObjects.toolTipText", (Object[])new Object[0]));
        this.mniZoomSelectedObjects.setEnabled(false);
        this.menSelection.add(this.mniZoomSelectedObjects);
        this.mniZoomSelectedThemes.setAction(this.zoomSelectedThemesAction1);
        this.mniZoomSelectedThemes.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniZoomSelectedThemes.toolTipText", (Object[])new Object[0]));
        this.mniZoomSelectedThemes.setEnabled(false);
        this.menSelection.add(this.mniZoomSelectedThemes);
        this.mniRemoveSelection.setAction(this.removeSelectionAllTopicsAction);
        this.mniRemoveSelection.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-selectionremove.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.mniRemoveSelection, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniRemoveSelection.text"));
        this.mniRemoveSelection.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniRemoveSelection.toolTipText", (Object[])new Object[0]));
        this.mniRemoveSelection.setEnabled(false);
        this.menSelection.add(this.mniRemoveSelection);
        this.jMenuBar1.add(this.menSelection);
        Mnemonics.setLocalizedText((AbstractButton)this.menTools, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menTools.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.menGeoProcessing, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menGeoProcessing.text"));
        this.mniBuffer.setAction(this.bufferGeoprocessingAction);
        this.mniBuffer.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniBuffer.toolTipText", (Object[])new Object[0]));
        this.menGeoProcessing.add(this.mniBuffer);
        this.mniClip.setAction(this.clipGeoprocessingAction);
        this.mniClip.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniClip.toolTipText", (Object[])new Object[0]));
        this.menGeoProcessing.add(this.mniClip);
        this.mniUnion.setAction(this.unionGeoprocessingAction);
        this.mniUnion.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniUnion.toolTipText", (Object[])new Object[0]));
        this.menGeoProcessing.add(this.mniUnion);
        this.mniMerge.setAction(this.mergeGeoprocessingAction);
        this.mniMerge.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniMerge.toolTipText", (Object[])new Object[0]));
        this.menGeoProcessing.add(this.mniMerge);
        this.mniDissolve.setAction(this.dissolveGeoprocessingAction);
        this.mniDissolve.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniDissolve.toolTipText", (Object[])new Object[0]));
        this.menGeoProcessing.add(this.mniDissolve);
        this.mniPointInLine.setAction(this.pointInLineGeoprocessingAction);
        this.mniPointInLine.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniPointInLine.toolTipText", (Object[])new Object[0]));
        this.menGeoProcessing.add(this.mniPointInLine);
        this.mniPointInPolygon.setAction(this.pointInPolygonGeoprocessingAction);
        this.mniPointInPolygon.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniPointInPolygon.toolTipText", (Object[])new Object[0]));
        this.menGeoProcessing.add(this.mniPointInPolygon);
        this.menGeoProcessing.add(this.jSeparator1);
        this.mniStation.setAction(this.stationAction1);
        this.mniStation.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniStation.toolTipText", (Object[])new Object[0]));
        this.menGeoProcessing.add(this.mniStation);
        this.mniTechProf.setAction(this.techProfAction1);
        this.mniTechProf.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniTechProf.toolTipText", (Object[])new Object[0]));
        this.menGeoProcessing.add(this.mniTechProf);
        this.menTools.add(this.menGeoProcessing);
        Mnemonics.setLocalizedText((AbstractButton)this.menChecks, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menChecks.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.menBasicChecks, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menBasicChecks.text"));
        this.mniCheckBasisRoutes.setAction(this.basicRoutesCheckAction1);
        Mnemonics.setLocalizedText((AbstractButton)this.mniCheckBasisRoutes, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniCheckBasisRoutes.text", (Object[])new Object[0]));
        this.mniCheckBasisRoutes.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniCheckBasisRoutes.toolTipText", (Object[])new Object[0]));
        this.menBasicChecks.add(this.mniCheckBasisRoutes);
        this.mniCheckVerwaltung.setAction(this.verwaltungCheckAction);
        this.mniCheckVerwaltung.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniCheckVerwaltung.toolTipText", (Object[])new Object[0]));
        this.menBasicChecks.add(this.mniCheckVerwaltung);
        this.mniCheckAusbau.setAction(this.ausbauCheckAction);
        this.mniCheckAusbau.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniCheckAusbau.toolTipText", (Object[])new Object[0]));
        this.menBasicChecks.add(this.mniCheckAusbau);
        this.mniCheckBauwerke.setAction(this.bauwerkeCheckAction);
        this.mniCheckBauwerke.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniCheckBauwerke.toolTipText", (Object[])new Object[0]));
        this.menBasicChecks.add(this.mniCheckBauwerke);
        this.mniCheckSonstige.setAction(this.sonstigeCheckAction);
        this.mniCheckSonstige.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniCheckSonstige.toolTipText", (Object[])new Object[0]));
        this.menBasicChecks.add(this.mniCheckSonstige);
        this.menChecks.add(this.menBasicChecks);
        Mnemonics.setLocalizedText((AbstractButton)this.menExtendedChecks, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menExtendedChecks.text"));
        this.mniCheckLawaConnection.setAction(this.gWKConnectionCheckAction);
        this.mniCheckLawaConnection.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniCheckLawaConnection.toolTipText", (Object[])new Object[0]));
        this.menExtendedChecks.add(this.mniCheckLawaConnection);
        this.mniCheckLawa.setAction(this.lawaCheckAction);
        this.mniCheckLawa.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniCheckLawa.toolTipText", (Object[])new Object[0]));
        this.menExtendedChecks.add(this.mniCheckLawa);
        this.menChecks.add(this.menExtendedChecks);
        this.menTools.add(this.menChecks);
        this.menTools.add(this.jSeparator2);
        Mnemonics.setLocalizedText((AbstractButton)this.menChecks1, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menChecks1.text"));
        this.mniExport.setAction(this.exportAction1);
        this.mniExport.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniExport.toolTipText", (Object[])new Object[0]));
        this.menChecks1.add(this.mniExport);
        this.mniIgmExport.setAction(this.exportIgmAction);
        this.mniIgmExport.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniIgmExport.toolTipText", (Object[])new Object[0]));
        this.menChecks1.add(this.mniIgmExport);
        this.mniExportOption.setAction(this.exportOptionAction);
        this.mniExportOption.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniExportOption.toolTipText", (Object[])new Object[0]));
        this.menChecks1.add(this.mniExportOption);
        this.menTools.add(this.menChecks1);
        Mnemonics.setLocalizedText((AbstractButton)this.jMenu1, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.jMenu1.text", (Object[])new Object[0]));
        this.mniCreateDbUser.setAction(this.createViewsForUser1);
        this.jMenu1.add(this.mniCreateDbUser);
        this.mniRefreshDbUser.setAction(this.refreshViewsForUser1);
        this.jMenu1.add(this.mniRefreshDbUser);
        this.menTools.add(this.jMenu1);
        this.jMenuBar1.add(this.menTools);
        Mnemonics.setLocalizedText((AbstractButton)this.menReport, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menReport.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.menSteckbrief, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menSteckbrief.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.menSteckbriefGewaesser, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menSteckbriefGewaesser.text"));
        this.mniGewaesser.setAction(this.gewaesserReportAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniGewaesser, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniGewaesser.text", (Object[])new Object[0]));
        this.mniGewaesser.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniGewaesser.toolTipText", (Object[])new Object[0]));
        this.menSteckbriefGewaesser.add(this.mniGewaesser);
        this.menSteckbrief.add(this.menSteckbriefGewaesser);
        Mnemonics.setLocalizedText((AbstractButton)this.menSteckbriefWasserkoerper, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menSteckbriefWasserkoerper.text"));
        this.mniFG.setAction(this.wkFgReportAction);
        Mnemonics.setLocalizedText((AbstractButton)this.mniFG, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniFG.text", (Object[])new Object[0]));
        this.mniFG.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniFG.toolTipText", (Object[])new Object[0]));
        this.menSteckbriefWasserkoerper.add(this.mniFG);
        this.menSteckbrief.add(this.menSteckbriefWasserkoerper);
        Mnemonics.setLocalizedText((AbstractButton)this.menSteckbriefPhotos, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menSteckbriefPhotos.text"));
        this.mniPrintPhoto.setAction(this.reportAction1);
        this.mniPrintPhoto.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniPrintPhoto.toolTipText", (Object[])new Object[0]));
        this.menSteckbriefPhotos.add(this.mniPrintPhoto);
        this.menSteckbrief.add(this.menSteckbriefPhotos);
        Mnemonics.setLocalizedText((AbstractButton)this.menSteckbriefQp, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menSteckbriefQp.text"));
        this.mniPrintQp.setAction(this.reportActionGaf);
        this.mniPrintQp.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniPrintQp.toolTipText", (Object[])new Object[0]));
        this.menSteckbriefQp.add(this.mniPrintQp);
        this.menSteckbrief.add(this.menSteckbriefQp);
        this.menReport.add(this.menSteckbrief);
        Mnemonics.setLocalizedText((AbstractButton)this.menStatistik, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menStatistik.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.menGewaesser, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menGewaesser.text"));
        this.mniGewaesserRep.setAction(this.gewaesserGewReportAction);
        this.menGewaesser.add(this.mniGewaesserRep);
        this.mniGemeinde.setAction(this.gemeindenReportAction);
        this.menGewaesser.add(this.mniGemeinde);
        this.mniSb.setAction(this.sbReportAction);
        this.menGewaesser.add(this.mniSb);
        this.mniFl.setAction(this.flaechenReportAction1);
        this.menGewaesser.add(this.mniFl);
        this.menStatistik.add(this.menGewaesser);
        Mnemonics.setLocalizedText((AbstractButton)this.menGewaesser2, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menGewaesser2.text"));
        this.mniGewaesserRep2.setAction(this.gerinneOGewReportAction);
        this.menGewaesser2.add(this.mniGewaesserRep2);
        this.mniGemeinde2.setAction(this.gerinneOGemeindeReportAction);
        this.menGewaesser2.add(this.mniGemeinde2);
        this.mniSb2.setAction(this.gerinneOSbReportAction);
        this.menGewaesser2.add(this.mniSb2);
        this.mniFl2.setAction(this.gerinneOFlReportAction1);
        this.menGewaesser2.add(this.mniFl2);
        this.menStatistik.add(this.menGewaesser2);
        Mnemonics.setLocalizedText((AbstractButton)this.menGewaesser1, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menGewaesser1.text"));
        this.mniGewaesserRep1.setAction(this.gerinneGGewaesserReportAction1);
        this.menGewaesser1.add(this.mniGewaesserRep1);
        this.mniGemeinde1.setAction(this.rlDDueReportAction);
        this.menGewaesser1.add(this.mniGemeinde1);
        this.mniSb1.setAction(this.gerinneGSbReportAction1);
        this.menGewaesser1.add(this.mniSb1);
        this.mniFl1.setAction(this.gerinneGFlReportAction1);
        this.menGewaesser1.add(this.mniFl1);
        this.menStatistik.add(this.menGewaesser1);
        this.menReport.add(this.menStatistik);
        Mnemonics.setLocalizedText((AbstractButton)this.menGewaesser3, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menGewaesser3.text"));
        this.mniGewaesserRep3.setAction(this.gerogaRsAction1);
        Mnemonics.setLocalizedText((AbstractButton)this.mniGewaesserRep3, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniGewaesserRep3.text", (Object[])new Object[0]));
        this.menGewaesser3.add(this.mniGewaesserRep3);
        this.menReport.add(this.menGewaesser3);
        Mnemonics.setLocalizedText((AbstractButton)this.menSchablonen, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menSchablonen.text"));
        this.menReport.add(this.menSchablonen);
        Mnemonics.setLocalizedText((AbstractButton)this.menWsg, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menWsg.text"));
        this.mniFlNu.setAction(this.wsgAction1);
        Mnemonics.setLocalizedText((AbstractButton)this.mniFlNu, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniFlNu.text", (Object[])new Object[0]));
        this.mniFlNu.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniFlNu.toolTipText", (Object[])new Object[0]));
        this.menWsg.add(this.mniFlNu);
        this.mniRechtsgrundlage.setAction(this.rechtsgrundlageAction1);
        Mnemonics.setLocalizedText((AbstractButton)this.mniRechtsgrundlage, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniRechtsgrundlage.text", (Object[])new Object[0]));
        this.mniRechtsgrundlage.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniRechtsgrundlage.toolTipText", (Object[])new Object[0]));
        this.menWsg.add(this.mniRechtsgrundlage);
        this.mniRechtsgrundlage1.setAction(this.wsgWaldAction1);
        Mnemonics.setLocalizedText((AbstractButton)this.mniRechtsgrundlage1, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniRechtsgrundlage1.text", (Object[])new Object[0]));
        this.mniRechtsgrundlage1.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniRechtsgrundlage1.toolTipText", (Object[])new Object[0]));
        this.menWsg.add(this.mniRechtsgrundlage1);
        this.menReport.add(this.menWsg);
        this.jMenuBar1.add(this.menReport);
        Mnemonics.setLocalizedText((AbstractButton)this.menPhoto, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menPhoto.text"));
        this.mniUpload.setAction(this.uploadAction1);
        this.mniUpload.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniUpload.toolTipText", (Object[])new Object[0]));
        this.menPhoto.add(this.mniUpload);
        this.mniPhotoInfo.setAction(this.fotoInfoAction1);
        this.mniPhotoInfo.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniPhotoInfo.toolTipText", (Object[])new Object[0]));
        this.menPhoto.add(this.mniPhotoInfo);
        this.mniReportPhoto.setAction(this.reportAction1);
        this.mniReportPhoto.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniReportPhoto.toolTipText", (Object[])new Object[0]));
        this.mniReportPhoto.setEnabled(false);
        this.menPhoto.add(this.mniReportPhoto);
        this.mniExportPhoto.setAction(this.exportActionPhoto);
        this.mniExportPhoto.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniExportPhoto.toolTipText", (Object[])new Object[0]));
        this.mniExportPhoto.setEnabled(false);
        this.menPhoto.add(this.mniExportPhoto);
        this.mniDeletePhoto.setAction(this.deleteAction1);
        this.mniDeletePhoto.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniDeletePhoto.toolTipText", (Object[])new Object[0]));
        this.mniDeletePhoto.setEnabled(false);
        this.menPhoto.add(this.mniDeletePhoto);
        this.mniPhotoOptions.setAction(this.optionAction1);
        this.mniPhotoOptions.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniPhotoOptions.toolTipText", (Object[])new Object[0]));
        this.menPhoto.add(this.mniPhotoOptions);
        this.jMenuBar1.add(this.menPhoto);
        Mnemonics.setLocalizedText((AbstractButton)this.menProfiles, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menProfiles.text"));
        this.mniGafUpload.setAction(this.uploadActionGaf);
        this.mniGafUpload.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniGafUpload.toolTipText", (Object[])new Object[0]));
        this.mniGafUpload.setEnabled(false);
        this.menProfiles.add(this.mniGafUpload);
        this.mniGafInfo.setAction(this.gafInfoAction);
        this.mniGafInfo.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniGafInfo.toolTipText", (Object[])new Object[0]));
        this.menProfiles.add(this.mniGafInfo);
        this.mniReportGaf.setAction(this.reportActionGaf);
        this.mniReportGaf.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniReportGaf.toolTipText", (Object[])new Object[0]));
        this.mniReportGaf.setEnabled(false);
        this.menProfiles.add(this.mniReportGaf);
        this.mniExportGaf.setAction(this.exportActionGaf);
        this.mniExportGaf.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniExportGaf.toolTipText", (Object[])new Object[0]));
        this.mniExportGaf.setEnabled(false);
        this.menProfiles.add(this.mniExportGaf);
        this.mniDeleteGaf.setAction(this.deleteActionGaf);
        this.mniDeleteGaf.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniDeleteGaf.toolTipText", (Object[])new Object[0]));
        this.mniDeleteGaf.setEnabled(false);
        this.menProfiles.add(this.mniDeleteGaf);
        this.mniGafOptions.setAction(this.optionActionGaf);
        this.mniGafOptions.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniGafOptions.toolTipText", (Object[])new Object[0]));
        this.menProfiles.add(this.mniGafOptions);
        this.jMenuBar1.add(this.menProfiles);
        Mnemonics.setLocalizedText((AbstractButton)this.menBookmark, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menBookmark.text"));
        this.mniCreateBookmark.setAction(this.showCreateBookmarkDialogAction);
        this.mniCreateBookmark.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniCreateBookmark.toolTipText", (Object[])new Object[0]));
        this.menBookmark.add(this.mniCreateBookmark);
        this.mniManageBookmarks.setAction(this.showManageBookmarksDialogAction);
        this.mniManageBookmarks.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniManageBookmarks.toolTipText", (Object[])new Object[0]));
        this.menBookmark.add(this.mniManageBookmarks);
        this.jMenuBar1.add(this.menBookmark);
        Mnemonics.setLocalizedText((AbstractButton)this.menDrawings, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menDrawings.text"));
        this.mniLoadDrawings.setAction(this.loadDrawingsAction);
        this.mniLoadDrawings.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniLoadDrawings.toolTipText", (Object[])new Object[0]));
        this.menDrawings.add(this.mniLoadDrawings);
        this.mniSaveDrawings.setAction(this.saveDrawingsAction);
        this.mniSaveDrawings.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniSaveDrawings.toolTipText", (Object[])new Object[0]));
        this.menDrawings.add(this.mniSaveDrawings);
        this.sepDrawingOperation.setName("sepCentralFilesStart");
        this.menDrawings.add(this.sepDrawingOperation);
        this.mniNewRectangleDrawing.setAction(this.newRectangleModeAction);
        this.mniNewRectangleDrawing.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniNewRectangleDrawing.toolTipText", (Object[])new Object[0]));
        this.menDrawings.add(this.mniNewRectangleDrawing);
        this.mniNewLineStringDrawing.setAction(this.newLinestringModeAction);
        this.mniNewLineStringDrawing.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniNewLineStringDrawing.toolTipText", (Object[])new Object[0]));
        this.menDrawings.add(this.mniNewLineStringDrawing);
        this.mniNewMarkerDrawing.setAction(this.newMarkerModeAction);
        this.mniNewMarkerDrawing.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniNewMarkerDrawing.toolTipText", (Object[])new Object[0]));
        this.menDrawings.add(this.mniNewMarkerDrawing);
        this.mniNewTextDrawing.setAction(this.newTextModeAction);
        this.mniNewTextDrawing.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniNewTextDrawing.toolTipText", (Object[])new Object[0]));
        this.menDrawings.add(this.mniNewTextDrawing);
        this.sepDrawingOperation1.setName("sepCentralFilesStart");
        this.menDrawings.add(this.sepDrawingOperation1);
        this.mniSelectAllDrawing.setAction(this.selectAllDrawingsAction);
        this.mniSelectAllDrawing.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniSelectAllDrawing.toolTipText", (Object[])new Object[0]));
        this.menDrawings.add(this.mniSelectAllDrawing);
        this.mniUnselectAllDrawing.setAction(this.unselectAllDrawingsAction);
        this.mniUnselectAllDrawing.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniUnselectAllDrawing.toolTipText", (Object[])new Object[0]));
        this.mniUnselectAllDrawing.setEnabled(false);
        this.menDrawings.add(this.mniUnselectAllDrawing);
        this.mniZoomAllDrawings.setAction(this.zoomAllDrawingsAction);
        this.mniZoomAllDrawings.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniZoomAllDrawings.toolTipText", (Object[])new Object[0]));
        this.menDrawings.add(this.mniZoomAllDrawings);
        this.mniZoomSelectedDrawings.setAction(this.zoomSelectedDrawingsAction);
        this.mniZoomSelectedDrawings.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniZoomSelectedDrawings.toolTipText", (Object[])new Object[0]));
        this.mniZoomSelectedDrawings.setEnabled(false);
        this.menDrawings.add(this.mniZoomSelectedDrawings);
        this.mniRemoveDrawing.setAction(this.removeDrawingModeAction);
        this.mniRemoveDrawing.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniRemoveDrawing.toolTipText", (Object[])new Object[0]));
        this.mniRemoveDrawing.setEnabled(false);
        this.menDrawings.add(this.mniRemoveDrawing);
        this.mniDrawingOptions.setAction(this.optionModeAction1);
        this.mniDrawingOptions.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniDrawingOptions.toolTipText", (Object[])new Object[0]));
        this.menDrawings.add(this.mniDrawingOptions);
        this.jMenuBar1.add(this.menDrawings);
        this.menDrawings.getAccessibleContext().setAccessibleName(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menDrawings.AccessibleContext.accessibleName", (Object[])new Object[0]));
        Mnemonics.setLocalizedText((AbstractButton)this.menWindow, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menWindow.text"));
        this.mniShowMap.setAction(this.showMap);
        this.mniShowMap.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniShowMap.toolTipText", (Object[])new Object[0]));
        this.menWindow.add(this.mniShowMap);
        this.mniShowTree.setAction(this.showTree);
        this.mniShowTree.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniShowTree.toolTipText", (Object[])new Object[0]));
        this.menWindow.add(this.mniShowTree);
        this.mniShowOverview.setAction(this.showOverview);
        this.mniShowOverview.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniShowOverview.toolTipText", (Object[])new Object[0]));
        this.menWindow.add(this.mniShowOverview);
        this.mniShowDatasource.setAction(this.showDatasource);
        this.mniShowDatasource.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniShowDatasource.toolTipText", (Object[])new Object[0]));
        this.menWindow.add(this.mniShowDatasource);
        this.mniShowInfo.setAction(this.showInfoWindowAction);
        this.mniShowInfo.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniShowInfo.toolTipText", (Object[])new Object[0]));
        this.menWindow.add(this.mniShowInfo);
        this.mniShowProblems.setAction(this.showProblems);
        this.mniShowProblems.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniShowProblems.toolTipText", (Object[])new Object[0]));
        this.menWindow.add(this.mniShowProblems);
        this.mniShowPhotos.setAction(this.showPhoto);
        this.mniShowPhotos.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniShowPhotos.toolTipText", (Object[])new Object[0]));
        this.menWindow.add(this.mniShowPhotos);
        this.mniShowProfiles.setAction(this.showProfiles);
        this.mniShowProfiles.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniShowProfiles.toolTipText", (Object[])new Object[0]));
        this.menWindow.add(this.mniShowProfiles);
        this.mniShowLegend.setAction(this.showLegend);
        this.mniShowLegend.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniShowLegend.toolTipText", (Object[])new Object[0]));
        this.menWindow.add(this.mniShowLegend);
        this.sepWindowSeparator.setName("sepCentralFilesStart");
        this.menWindow.add(this.sepWindowSeparator);
        this.mniDefaultConfig.setAction(this.defaultConfigAction1);
        this.mniDefaultConfig.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniDefaultConfig.toolTipText", (Object[])new Object[0]));
        this.menWindow.add(this.mniDefaultConfig);
        this.mniShowDefaultConfig2.setAction(this.defaultConfig2Action1);
        this.mniShowDefaultConfig2.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniShowDefaultConfig2.toolTipText", (Object[])new Object[0]));
        this.menWindow.add(this.mniShowDefaultConfig2);
        this.jMenuBar1.add(this.menWindow);
        Mnemonics.setLocalizedText((AbstractButton)this.menHelp, (String)NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.menHelp.text"));
        this.mniHelp.setAction(this.onlineHelpAction);
        this.mniHelp.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniHelp.toolTipText", (Object[])new Object[0]));
        this.menHelp.add(this.mniHelp);
        this.mniInfo.setAction(this.infoAction);
        this.mniInfo.setToolTipText(NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.mniInfo.toolTipText", (Object[])new Object[0]));
        this.menHelp.add(this.mniInfo);
        this.jMenuBar1.add(this.menHelp);
        this.setJMenuBar(this.jMenuBar1);
        this.pack();
    }

    private void cmdUndomniUndoPerformed(ActionEvent evt) {
        CustomAction a = CismapBroker.getInstance().getMappingComponent().getMemUndo().getLastAction();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("... execute action: " + a.info()));
        }
        try {
            a.doAction();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while executing action", (Throwable)e);
        }
        CustomAction inverse = a.getInverse();
        CismapBroker.getInstance().getMappingComponent().getMemRedo().addAction(inverse);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("... new action on REDO stack: " + inverse));
            LOG.debug((Object)"... completed");
        }
    }

    private void cmdNodeMoveActionPerformed(final ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapBroker.getInstance().getMappingComponent().setHandleInteractionMode("MOVE_HANDLE");
                WatergisApp.this.cmdSelectionMode.setSelected(true);
                WatergisApp.this.selectionModeAction.actionPerformed(evt);
            }
        });
    }

    private void cmdNodeAddActionPerformed(final ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapBroker.getInstance().getMappingComponent().setHandleInteractionMode("ADD_HANDLE");
                WatergisApp.this.cmdSelectionMode.setSelected(true);
                WatergisApp.this.selectionModeAction.actionPerformed(evt);
            }
        });
    }

    private void cmdNodeRemoveActionPerformed(final ActionEvent evt) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CismapBroker.getInstance().getMappingComponent().setHandleInteractionMode("REMOVE_HANDLE");
                WatergisApp.this.cmdSelectionMode.setSelected(true);
                WatergisApp.this.selectionModeAction.actionPerformed(evt);
            }
        });
    }

    private void cmdGoToActionPerformed(ActionEvent evt) {
    }

    private void cboThemeItemStateChanged(ItemEvent evt) {
        Object o = this.cboTheme.getSelectedItem();
        if (o instanceof MetaObject) {
            MetaObject selectedObject = (MetaObject)o;
            if (((MetaObject)o).getBean().getProperty("name").equals("FG: Code")) {
                this.routeZoomPanel.setVisible(true);
                for (int i = 0; i < this.panSearch.getComponentCount(); ++i) {
                    if (this.panSearch.getComponent(i).getClass() == RouteZoomPanel.class) continue;
                    this.panSearch.remove(this.panSearch.getComponent(i));
                }
            } else {
                this.routeZoomPanel.setVisible(false);
                for (int i = 0; i < this.panSearch.getComponentCount(); ++i) {
                    if (this.panSearch.getComponent(i).getClass() == RouteZoomPanel.class) continue;
                    this.panSearch.remove(this.panSearch.getComponent(i));
                }
                MetaClass MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)("dlm25w." + selectedObject.getBean().getProperty("thema")), (ConnectionContext)connectionContext);
                this.panSearch.add(new ZoomPanel(MC, (String)selectedObject.getBean().getProperty("thema"), (String)selectedObject.getBean().getProperty("attr")));
            }
        }
    }

    private void initConnection() throws ConnectionException, InterruptedException {
        PropertyManager propertyManager = PropertyManager.getManager();
        propertyManager.load(this.getClass().getResourceAsStream("/cfg/navigator.cfg"));
        Proxy proxyConfig = ProxyHandler.getInstance().init(propertyManager.getProxyProperties());
        Connection connection = ConnectionFactory.getFactory().createConnection(AppBroker.getInstance().getConnectionClass(), AppBroker.getInstance().getCallserverUrl(), proxyConfig, propertyManager.isCompressionEnabled());
        ConnectionSession session = null;
        ConnectionProxy proxy = null;
        if (AppBroker.getInstance().getConnectionInfo() != null) {
            try {
                session = ConnectionFactory.getFactory().createSession(connection, AppBroker.getInstance().getConnectionInfo(), true);
                proxy = ConnectionFactory.getFactory().createProxy("Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler", session);
                SessionManager.init((ConnectionProxy)proxy);
            }
            catch (UserException uexp) {
                LOG.error((Object)"autologin failed", (Throwable)uexp);
                session = null;
            }
        }
        if (session == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"performing login");
            }
            try {
                ConnectionInfo connInfo = new ConnectionInfo();
                connInfo.setCallserverURL(AppBroker.getInstance().getCallserverUrl());
                session = ConnectionFactory.getFactory().createSession(connection, connInfo, false);
            }
            catch (UserException connInfo) {
                // empty catch block
            }
            proxy = ConnectionFactory.getFactory().createProxy("Sirius.navigator.connection.proxy.DefaultConnectionProxyHandler", session);
            SessionManager.init((ConnectionProxy)proxy);
            LoginDialog loginDialog = new LoginDialog((Frame)this);
            StaticSwingTools.showDialog((JDialog)loginDialog);
        }
    }

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)DefaultNavigatorExceptionHandler.getInstance());
        WatergisApp.initLog4J();
        try {
            String loginInfos;
            StringTokenizer st;
            InputStream is = WatergisApp.class.getResourceAsStream(CONNECTION_PROPERTIES_FILE);
            if (is != null) {
                String domain;
                String connectionClass;
                Properties props = new Properties();
                props.load(is);
                String callserverUrl = props.getProperty("CallserverUrl");
                if (callserverUrl != null) {
                    AppBroker.getInstance().setCallserverUrl(callserverUrl);
                }
                if ((connectionClass = props.getProperty("ConnectionClass")) != null) {
                    AppBroker.getInstance().setConnectionClass(connectionClass);
                }
                if ((domain = props.getProperty("Domain")) != null) {
                    AppBroker.getInstance().setDomain(domain);
                }
            }
            LOG.warn((Object)("args: " + args.length));
            Options options = new Options();
            options.addOption("u", true, "CallserverUrl");
            options.addOption("c", true, "ConnectionClass");
            options.addOption("d", true, "Domain");
            options.addOption("l", true, "Login");
            PosixParser parser = new PosixParser();
            CommandLine cmd = parser.parse(options, args);
            if (cmd.hasOption("u") && AppBroker.getInstance().getCallserverUrl() == null) {
                AppBroker.getInstance().setCallserverUrl(cmd.getOptionValue("u"));
            } else if (AppBroker.getInstance().getCallserverUrl() == null) {
                LOG.warn((Object)"No Callserverhost specified, please specify it with the option -u.");
                System.exit(1);
            }
            if (cmd.hasOption("c") && AppBroker.getInstance().getConnectionClass() == null) {
                AppBroker.getInstance().setConnectionClass(cmd.getOptionValue("c"));
            } else if (AppBroker.getInstance().getConnectionClass() == null) {
                LOG.warn((Object)"No ConnectionClass specified, please specify it with the option -c.");
                System.exit(1);
            }
            if (cmd.hasOption("d") && AppBroker.getInstance().getDomain() == null) {
                AppBroker.getInstance().setDomain(cmd.getOptionValue("d"));
            } else if (AppBroker.getInstance().getDomain() == null) {
                LOG.error((Object)"No Domain specified, please specify it with the option -d.");
                System.exit(1);
            }
            if (cmd.hasOption("l") && (st = new StringTokenizer(loginInfos = cmd.getOptionValue("l"), ";")).countTokens() == 6) {
                String callServer = st.nextToken();
                String password = st.nextToken();
                String userDomain = st.nextToken();
                String userGroup = st.nextToken();
                String usergroupDomain = st.nextToken();
                String username = st.nextToken();
                ConnectionInfo i = new ConnectionInfo();
                i.setCallserverURL(callServer);
                i.setPassword(password);
                i.setUserDomain(userDomain);
                i.setUsergroup(userGroup);
                i.setUsergroupDomain(usergroupDomain);
                if (username.endsWith("\"")) {
                    username = username.substring(0, username.length() - 1);
                }
                i.setUsername(username);
                AppBroker.getInstance().setConnectionInfo(i);
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while reading the command-line parameters.", (Throwable)ex);
            System.exit(1);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    PlasticXPLookAndFeel lf = new PlasticXPLookAndFeel();
                    UIManager.setLookAndFeel((LookAndFeel)lf);
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while setting the Look & Feel", (Throwable)ex);
                }
                try {
                    AppBroker.getInstance().setLoggedIn(true);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Login successful");
                    }
                    WatergisApp app = new WatergisApp();
                    app.setVisible(true);
                    if (SPLASH != null) {
                        SPLASH.dispose();
                    }
                    SPLASH = null;
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error during the Loginframe", (Throwable)ex);
                    System.exit(0);
                }
            }
        });
    }

    public Element getConfiguration() {
        boolean windowMaximised;
        Element ret = new Element("cismapPluginUIPreferences");
        Element window = new Element("window");
        int windowHeight = this.getHeight();
        int windowWidth = this.getWidth();
        int windowX = (int)this.getLocation().getX();
        int windowY = (int)this.getLocation().getY();
        boolean bl = windowMaximised = this.getExtendedState() == 6;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Windowsize: width " + windowWidth + " height " + windowHeight));
        }
        window.setAttribute("height", "" + windowHeight);
        window.setAttribute("width", "" + windowWidth);
        window.setAttribute("x", "" + windowX);
        window.setAttribute("y", "" + windowY);
        window.setAttribute("max", "" + windowMaximised);
        ret.addContent((Content)window);
        return ret;
    }

    public void masterConfigure(Element parent) {
        Element prefs = parent.getChild("urls");
        try {
            Element help_url_element = prefs.getChild("onlineHelp");
            Element info_url_element = prefs.getChild("info");
            this.helpURL = help_url_element.getText();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("helpUrl:" + this.helpURL));
            }
            this.infoURL = info_url_element.getText();
        }
        catch (Throwable t) {
            LOG.error((Object)("Error while loading the help urls (" + prefs.getChildren() + ")"), t);
        }
        Element ports = parent.getChild("ports");
        Element httpInterfacePortElement = ports.getChild("httpInterfacePort");
        try {
            this.httpInterfacePort = new Integer(httpInterfacePortElement.getText());
        }
        catch (Throwable t) {
            LOG.warn((Object)("httpInterface was not configured. Set default value: " + this.httpInterfacePort), t);
        }
        Element templates = parent.getChild("TemplateActions");
        if (templates != null) {
            try {
                List templateList = templates.getChildren("Template");
                for (Element templateElement : templateList) {
                    TemplateExportAction action = new TemplateExportAction(templateElement);
                    this.allTemplates.add(action);
                }
                Collections.sort(this.allTemplates);
            }
            catch (Throwable t) {
                LOG.error((Object)"Error while loading the templates", t);
            }
        }
    }

    @Override
    public void dispose() {
        try {
            boolean bl;
            for (String string : this.attributeTableMap.keySet()) {
                AttributeTable attrTable;
                Component c;
                View attributeTableView = this.attributeTableMap.get(string);
                if (attributeTableView == null || !((c = attributeTableView.getComponent()) instanceof AttributeTable) || !(attrTable = (AttributeTable)c).isProcessingModeActive()) continue;
                String message = NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.dispose().singleTable.message", (Object)attrTable.getFeatureService().getName());
                int ans = JOptionPane.showConfirmDialog(this, message, NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.dispose().title"), 1);
                if (ans == 0) {
                    attrTable.changeProcessingMode(true);
                    continue;
                }
                if (ans == 1) {
                    attrTable.unlockAll();
                    continue;
                }
                this.setDefaultCloseOperation(0);
                return;
            }
            boolean runningOrWaitingDownload = false;
            for (Object d : DownloadManager.instance().getDownloads()) {
                if (d.getStatus() != Download.State.RUNNING && d.getStatus() != Download.State.WAITING) continue;
                runningOrWaitingDownload = true;
                break;
            }
            if (runningOrWaitingDownload) {
                int n = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.dispose().downloadMessage"), NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.dispose().downloadTitle"), 0);
                if (n == 0) {
                    for (Download d : DownloadManager.instance().getDownloads()) {
                        if (d.getStatus() == Download.State.WAITING) {
                            DownloadManager.instance().removeDownload(d);
                            continue;
                        }
                        if (d.getStatus() != Download.State.RUNNING || !(d instanceof AbstractCancellableDownload)) continue;
                        ((AbstractCancellableDownload)d).cancel();
                    }
                } else {
                    this.setDefaultCloseOperation(0);
                    return;
                }
            }
            boolean bl2 = false;
            do {
                bl = false;
                for (Thread thread : Thread.getAllStackTraces().keySet()) {
                    StackTraceElement[] stack;
                    if (!thread.getThreadGroup().getName().equals("DownloadThreadPool") || !thread.isAlive() || (stack = Thread.getAllStackTraces().get(thread)).length <= 0 || stack[0].getMethodName().equalsIgnoreCase("park")) continue;
                    bl = true;
                    break;
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            } while (bl);
            if (this.vPhoto.isClosable()) {
                this.vPhoto.close();
            }
            if (this.vGaf.isClosable()) {
                this.vGaf.close();
            }
            try {
                StaticStartupTools.saveScreenshotOfFrame((JFrame)this, (String)FILEPATH_SCREEN);
            }
            catch (Exception ex) {
                LOG.fatal((Object)"Error while capturing the app content", (Throwable)ex);
            }
            this.setVisible(false);
            LOG.info((Object)"Dispose(): Watergis is going to shut down");
            configManager.writeConfiguration();
            this.saveLayout(FILEPATH_DEFAULT_LAYOUT);
            super.dispose();
        }
        catch (RuntimeException ex) {
            LOG.error((Object)"Error while disposing main window", (Throwable)ex);
        }
        LOG.info((Object)"Dispose(): exit");
        this.setDefaultCloseOperation(3);
        System.exit(0);
    }

    public void saveLayout(String file) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Saving Layout.. to " + file));
        }
        File layoutFile = new File(file);
        try {
            if (!layoutFile.exists()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Saving Layout.. File '" + file + "' does not exit"));
                }
                layoutFile.createNewFile();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Saving Layout.. File '" + file + "' does exit"));
            }
            FileOutputStream layoutOutput = new FileOutputStream(layoutFile);
            ObjectOutputStream out = new ObjectOutputStream(layoutOutput);
            AppBroker.getInstance().getInfoWindowAction().dispose();
            HashMap<String, View> attributeTables = new HashMap<String, View>(this.attributeTableMap);
            for (String key : attributeTables.keySet()) {
                View attrTableView = (View)attributeTables.get(key);
                if (attrTableView == null) continue;
                attrTableView.close();
            }
            this.rootWindow.write(out);
            out.flush();
            out.close();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Saving Layout.. to " + file + " successfull"));
            }
        }
        catch (IOException ex) {
            String message = NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.saveLayout().MessageDialog.message");
            String title = NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.saveLayout().MessageDialog.title");
            JOptionPane.showMessageDialog(this, message, title, 1);
            LOG.error((Object)("A failure occured during writing the layout file " + file), (Throwable)ex);
        }
    }

    public void loadLayout(String file) {
        block12: {
            File layoutFile;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Load Layout.. from " + file));
            }
            if ((layoutFile = new File(file)).exists()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Layout File exists");
                }
                try {
                    FileInputStream layoutInput = new FileInputStream(layoutFile);
                    ObjectInputStream in = new ObjectInputStream(layoutInput);
                    this.rootWindow.read(in);
                    in.close();
                    this.rootWindow.getWindowBar(Direction.LEFT).setEnabled(true);
                    this.rootWindow.getWindowBar(Direction.RIGHT).setEnabled(true);
                    if (this.isInit) {
                        int count = this.viewMap.getViewCount();
                        for (int i = 0; i < count; ++i) {
                            View current = this.viewMap.getViewAtIndex(i);
                            if (!current.isUndocked()) continue;
                            current.dock();
                        }
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"Loading Layout successfull");
                    }
                }
                catch (IOException ex) {
                    LOG.error((Object)"Layout File IO Exception --> loading default Layout", (Throwable)ex);
                    if (this.isInit) {
                        JOptionPane.showMessageDialog(this, "W\u00e4hrend dem Laden des Layouts ist ein Fehler aufgetreten.\n Das Layout wird zur\u00fcckgesetzt.", "Fehler", 1);
                        this.doLayoutInfoNode();
                        break block12;
                    }
                    JOptionPane.showMessageDialog(this, "W\u00e4hrend dem Laden des Layouts ist ein Fehler aufgetreten.\n Das Layout wird zur\u00fcckgesetzt.", "Fehler", 1);
                }
            } else if (this.isInit) {
                LOG.warn((Object)"Datei exitstiert nicht --> default layout (init)");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WatergisApp.this.doLayoutInfoNode();
                    }
                });
            } else {
                LOG.warn((Object)"Datei exitstiert nicht)");
                JOptionPane.showMessageDialog(this, "Das angegebene Layout konnte nicht gefunden werden.", "Fehler", 1);
            }
        }
    }

    public void configure(Element parent) {
        Element prefs = parent.getChild("cismapPluginUIPreferences");
        if (prefs == null) {
            LOG.warn((Object)"there is no local configuration 'cismapPluginUIPreferences'");
        } else {
            try {
                Element window;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"setting windowsize of application");
                }
                if ((window = prefs.getChild("window")) == null) {
                    LOG.warn((Object)"there is no 'window' configuration in 'cismapPluginUIPreferences'");
                } else {
                    int windowHeight = window.getAttribute("height").getIntValue();
                    int windowWidth = window.getAttribute("width").getIntValue();
                    int windowX = window.getAttribute("x").getIntValue();
                    int windowY = window.getAttribute("y").getIntValue();
                    boolean windowMaximised = window.getAttribute("max").getBooleanValue();
                    this.windowSize = new Dimension(windowWidth, windowHeight);
                    this.windowLocation = new Point(windowX, windowY);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("windowSize: width " + windowWidth + " heigth " + windowHeight));
                    }
                    if (windowMaximised) {
                        this.setExtendedState(6);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"setting of window successful");
                    }
                }
            }
            catch (Exception t) {
                LOG.error((Object)"Error while setting windowsize", (Throwable)t);
            }
        }
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"windowClosing():");
        }
        this.cleanUp();
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    private void cleanUp() {
    }

    private void setWindowSize() {
        if (this.windowSize != null && this.windowLocation != null) {
            this.setSize(this.windowSize);
            this.setLocation(this.windowLocation);
        } else {
            this.pack();
        }
    }

    public String getHelpURL() {
        return this.helpURL;
    }

    public String getInfoURL() {
        return this.infoURL;
    }

    public Integer getHttpInterfacePort() {
        return this.httpInterfacePort;
    }

    public static String getDIRECTORYPATH_WATERGIS() {
        return DIRECTORYPATH_WATERGIS;
    }

    @Override
    public void update(Observable o, Object arg) {
        MappingComponent mapC = CismapBroker.getInstance().getMappingComponent();
        if (o.equals(mapC.getMemUndo())) {
            if (arg.equals("ACTIVATE") && !this.cmdUndo.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"activate UNDO button");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WatergisApp.this.cmdUndo.setEnabled(true);
                    }
                });
            } else if (arg.equals("DEACTIVATE") && this.cmdUndo.isEnabled()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"deactivate UNDO button");
                }
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WatergisApp.this.cmdUndo.setEnabled(false);
                    }
                });
            }
        }
    }

    public void featuresAdded(FeatureCollectionEvent fce) {
    }

    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
    }

    public void featuresRemoved(FeatureCollectionEvent fce) {
    }

    public void featuresChanged(FeatureCollectionEvent fce) {
    }

    public void featureSelectionChanged(FeatureCollectionEvent fce) {
        this.selectedFeaturesChanged();
    }

    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
    }

    public void featureCollectionChanged() {
    }

    private void removeObjectsFromMap() {
        WatergisTreeNodeVisualizationService.removeVisualisedFeatures();
    }

    private void selectedFeaturesChanged() {
        this.watergisSingleThreadExecutor.execute(new Runnable(){

            @Override
            public void run() {
                SelectionListener sl = (SelectionListener)WatergisApp.this.mappingComponent.getInputEventListener().get("SELECT");
                List selectedFeatures = SelectionManager.getInstance().getSelectedFeatures();
                final boolean featuresSelected = !selectedFeatures.isEmpty();
                final boolean enableAnnex = WatergisApp.this.releaseAction.containsAnyRelevantFeature(selectedFeatures, false);
                final boolean enableRelease = WatergisApp.this.releaseAction.containsAnyRelevantFeature(selectedFeatures, true);
                final boolean photoSelected = WatergisApp.this.containsAnyRelevantFeature(selectedFeatures, "foto");
                final boolean profileSelected = WatergisApp.this.containsAnyRelevantFeature(selectedFeatures, "qp_upl");
                final boolean drawsSelected = !RemoveDrawingModeAction.getSelectedDrawings().isEmpty();
                boolean oneEditableFeature = false;
                boolean selectedFeatueIsPolygon = false;
                boolean mergeAllowed = false;
                AbstractFeatureService editableService = null;
                boolean editFeature = false;
                if (selectedFeatures.size() > 0) {
                    for (int i = 0; i < selectedFeatures.size(); ++i) {
                        Object serviceFeature;
                        Feature f = (Feature)selectedFeatures.get(i);
                        if (!(f instanceof DefaultFeatureServiceFeature) || (serviceFeature = (DefaultFeatureServiceFeature)f).getLayerProperties() == null || serviceFeature.getLayerProperties().getFeatureService() == null) continue;
                        AbstractFeatureService service = serviceFeature.getLayerProperties().getFeatureService();
                        if (!SelectionManager.getInstance().getEditableServices().contains(service) || !serviceFeature.isEditable()) continue;
                        if (editableService == null) {
                            editableService = serviceFeature.getLayerProperties().getFeatureService();
                            oneEditableFeature = true;
                            if (!(serviceFeature.getGeometry() instanceof Polygon) && !(serviceFeature.getGeometry() instanceof MultiPolygon)) continue;
                            selectedFeatueIsPolygon = true;
                            continue;
                        }
                        if (!editableService.equals(serviceFeature.getLayerProperties().getFeatureService())) {
                            mergeAllowed = false;
                            oneEditableFeature = false;
                            break;
                        }
                        if (!editableService.equals(serviceFeature.getLayerProperties().getFeatureService())) continue;
                        mergeAllowed = true;
                        oneEditableFeature = false;
                    }
                }
                List selectedPFeature = sl.getAllSelectedPFeatures();
                Collection selectedMapFeatures = WatergisApp.this.mappingComponent.getFeatureCollection().getSelectedFeatures();
                if (selectedPFeature != null && selectedPFeature.size() > 0) {
                    for (PFeature f : selectedPFeature) {
                        if (!(f.getFeature() instanceof DrawingSLDStyledFeature)) continue;
                        editFeature = true;
                        break;
                    }
                }
                if (selectedMapFeatures != null && selectedMapFeatures.size() > 0) {
                    for (PFeature f : selectedMapFeatures) {
                        if (!f.isEditable()) continue;
                        editFeature = true;
                        break;
                    }
                }
                final boolean splitEnabled = oneEditableFeature;
                final boolean polygonOperationEnabled = oneEditableFeature && selectedFeatueIsPolygon;
                final boolean mergeEnabled = mergeAllowed;
                final boolean editOperationsEnabled = editFeature;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        WatergisApp.this.cmdMerge.setEnabled(mergeEnabled);
                        WatergisApp.this.cmdSplit.setEnabled(splitEnabled);
                        WatergisApp.this.mniRemoveSelection.setEnabled(featuresSelected);
                        WatergisApp.this.mniZoomSelectedObjects.setEnabled(featuresSelected);
                        WatergisApp.this.cmdRemoveSelectionAllThemes.setEnabled(featuresSelected);
                        WatergisApp.this.cmdZoomSelectedObjects.setEnabled(featuresSelected);
                        if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("administratoren")) {
                            WatergisApp.this.cmdAnnex.setEnabled(enableAnnex);
                            WatergisApp.this.cmdRelease.setEnabled(enableRelease);
                        }
                        WatergisApp.this.mniReportPhoto.setEnabled(photoSelected);
                        WatergisApp.this.mniExportPhoto.setEnabled(photoSelected);
                        WatergisApp.this.mniDeletePhoto.setEnabled(photoSelected);
                        WatergisApp.this.mniPrintPhoto.setEnabled(photoSelected);
                        WatergisApp.this.mniExportGaf.setEnabled(profileSelected);
                        WatergisApp.this.mniDeleteGaf.setEnabled(profileSelected);
                        WatergisApp.this.mniPrintQp.setEnabled(profileSelected);
                        WatergisApp.this.cmdRemoveGeometry.setEnabled(drawsSelected);
                        WatergisApp.this.mniRemoveDrawing.setEnabled(drawsSelected);
                        WatergisApp.this.cmdZoomToSelectedDrawings.setEnabled(drawsSelected);
                        WatergisApp.this.cmdUnselectDrawings.setEnabled(drawsSelected);
                        WatergisApp.this.mniZoomSelectedDrawings.setEnabled(drawsSelected);
                        WatergisApp.this.mniUnselectAllDrawing.setEnabled(drawsSelected);
                        WatergisApp.this.cmdNodeAdd.setEnabled(editOperationsEnabled);
                        WatergisApp.this.cmdNodeMove.setEnabled(editOperationsEnabled);
                        WatergisApp.this.cmdNodeRemove.setEnabled(editOperationsEnabled);
                        WatergisApp.this.cmdPresentation.setEnabled(editOperationsEnabled);
                        WatergisApp.this.cmdMoveGeometry.setEnabled(editOperationsEnabled);
                        WatergisApp.this.tbtnAddMode.setEnabled(polygonOperationEnabled);
                        WatergisApp.this.tbtnRemoveMode.setEnabled(polygonOperationEnabled);
                        if (!polygonOperationEnabled && (WatergisApp.this.tbtnAddMode.isSelected() || WatergisApp.this.tbtnRemoveMode.isSelected())) {
                            WatergisApp.this.cmdSelectionMode.getAction().actionPerformed(null);
                        }
                        WatergisApp.this.topicTreeSelectionChanged(null);
                    }
                });
            }
        });
    }

    public boolean containsAnyRelevantFeature(List<Feature> features, String className) {
        for (Feature f : features) {
            CidsLayerFeature cidsFeature;
            CidsLayer cidsLayer;
            if (!(f instanceof CidsLayerFeature) || !(cidsLayer = (CidsLayer)(cidsFeature = (CidsLayerFeature)f).getLayerProperties().getFeatureService()).getMetaClass().getName().toLowerCase().equals(className)) continue;
            return true;
        }
        return false;
    }

    public void removeLayer(ThemeLayerEvent e) throws VetoException {
        String id;
        View attributeTableView;
        if (e.getLayer() instanceof AbstractFeatureService && (attributeTableView = this.attributeTableMap.get(id = AttributeTableFactory.createId((AbstractFeatureService)((AbstractFeatureService)e.getLayer())))) != null) {
            try {
                attributeTableView.closeWithAbort();
            }
            catch (OperationAbortedException ex) {
                throw new VetoException();
            }
        }
    }

    public void dropOnMap(MapDnDEvent mde) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"drop on map");
        }
        if (mde.getDte() instanceof DropTargetDropEvent) {
            DropTargetDropEvent dtde = (DropTargetDropEvent)mde.getDte();
            MappingComponent map = CismapBroker.getInstance().getMappingComponent();
            if (dtde.getTransferable().isDataFlavorSupported(this.CAPABILITY_WIDGET_FLAVOR)) {
                LayerDropUtils.drop((DropTargetDropEvent)dtde, (ActiveLayerModel)((ActiveLayerModel)map.getMappingModel()), (JComponent)map);
            } else if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || dtde.isDataFlavorSupported(DnDUtils.URI_LIST_FLAVOR)) {
                if (DnDUtils.isFilesOrUriList((DropTargetDropEvent)((DropTargetDropEvent)mde.getDte()))) {
                    dtde.acceptDrop(1);
                    try {
                        List files = DnDUtils.getFilesFrom((DropTargetDropEvent)dtde);
                        for (File file : files) {
                            if (!ImageFileUtils.isImageFileEnding((String)file.getName())) continue;
                            ImageFileMetaData metaData = null;
                            try {
                                switch (ImageFileUtils.determineMode((File)file)) {
                                    case WORLDFILE: {
                                        metaData = ImageFileUtils.getWorldFileMetaData((File)file, (File)ImageFileUtils.getWorldFile((File)file));
                                    }
                                    case TIFF: {
                                        metaData = ImageFileUtils.getTiffMetaData((File)file);
                                    }
                                }
                            }
                            catch (Exception ex) {
                                LOG.warn((Object)"Failure during drag & drop opertation", (Throwable)ex);
                            }
                            if (metaData != null) continue;
                            JOptionPane.showMessageDialog(StaticSwingTools.getParentFrame((Component)this), NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.dropOnMap.noGeoInfo.msg", (Object)file.getName()), NbBundle.getMessage(WatergisApp.class, (String)"WatergisApp.dropOnMap.noGeoInfo.title"), 2);
                        }
                    }
                    catch (Exception ex) {
                        LOG.error((Object)"Failure during drag & drop opertation", (Throwable)ex);
                    }
                }
                LayerDropUtils.drop((DropTargetDropEvent)((DropTargetDropEvent)mde.getDte()), (ActiveLayerModel)((ActiveLayerModel)map.getMappingModel()), (JComponent)map);
            } else {
                LOG.error((Object)("Unable to process the datatype." + dtde.getTransferable().getTransferDataFlavors()[0]));
            }
        }
    }

    public void dragOverMap(MapDnDEvent mde) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectedFeaturesChanged();
    }

    static {
        configManager = new ConfigurationManager();
        DIRECTORYPATH_HOME = System.getProperty("user.home");
        DIRECTORYEXTENSION = System.getProperty("directory.extension");
        FILESEPARATOR = System.getProperty("file.separator");
        DIRECTORYNAME_WATERGISHOME = ".watergis" + (DIRECTORYEXTENSION != null ? DIRECTORYEXTENSION : "");
        DIRECTORYPATH_WATERGIS = DIRECTORYPATH_HOME + FILESEPARATOR + DIRECTORYNAME_WATERGISHOME;
        FILEPATH_DEFAULT_LAYOUT = DIRECTORYPATH_WATERGIS + FILESEPARATOR + "watergis.layout";
        FILEPATH_PLUGIN_LAYOUT = DIRECTORYPATH_WATERGIS + FILESEPARATOR + "pluginWatergis.layout";
        FILEPATH_DEFAULT_APP_DATA = DIRECTORYPATH_WATERGIS + FILESEPARATOR + "watergis.data";
        FILEPATH_SCREEN = DIRECTORYPATH_WATERGIS + FILESEPARATOR + "watergis.screen";
        connectionContext = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.STARTUP, (String)"WatergisApp");
        configManager.setDefaultFileName(FILENAME_WATERGIS_CONFIGURATION);
        configManager.setFileName(FILENAME_LOCAL_WATERGIS_CONFIGURATION);
        configManager.setClassPathFolder(CLASSPATH_WATERGIS_CONFIGURATION);
        configManager.setFolder(DIRECTORYNAME_WATERGISHOME);
    }

    private class AttributeTableAncestorListener
    implements AncestorListener {
        private DockingWindowListener listener = null;
        private final View view;
        private final AttributeTable table;

        public AttributeTableAncestorListener(View view, AttributeTable table) {
            this.view = view;
            this.table = table;
        }

        public void setDockingWindowListener(DockingWindowListener listener) {
            this.listener = listener;
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            if (StaticSwingTools.getParentFrame((Component)event.getComponent()) != WatergisApp.this) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AttributeTableAncestorListener.this.view.dock();
                    }
                });
            }
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }

    private class RouteElement {
        private XBoundingBox env;
        private final String name;
        private final int id;

        public RouteElement(int id, String name, Geometry g) {
            this.name = name;
            this.id = id;
            if (g != null) {
                this.env = new XBoundingBox(g);
            }
        }

        public XBoundingBox getEnvelope() {
            return this.env;
        }

        public String toString() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }
    }

    private class DeleteMenuItem
    extends ThemeLayerMenuItem {
        public DeleteMenuItem() {
            super(NbBundle.getMessage(DeleteMenuItem.class, (String)"WatergisApp.DeleteMenuItem.DeleteMenuItem().title"), 498);
        }

        public void actionPerformed(ActionEvent e) {
            TreePath[] tps = WatergisApp.this.pTopicTree.getSelectionPath();
            if (tps != null && tps.length == 1) {
                AbstractFeatureService service = (AbstractFeatureService)tps[0].getLastPathComponent();
                List features = SelectionManager.getInstance().getSelectedFeatures(service);
                ArrayList<FeatureServiceFeature> featureServiceFeatures = new ArrayList<FeatureServiceFeature>();
                for (Feature f : features) {
                    if (!(f instanceof FeatureServiceFeature)) continue;
                    featureServiceFeatures.add((FeatureServiceFeature)f);
                }
                if (!featureServiceFeatures.isEmpty()) {
                    AttributeTable table = AppBroker.getInstance().getWatergisApp().getAttributeTableByFeature((FeatureServiceFeature)featureServiceFeatures.get(0));
                    table.deleteFeatures();
                }
            }
        }

        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }

        public boolean isSelectable(int mask) {
            TreePath[] paths;
            boolean selectable = super.isSelectable(mask);
            if (selectable && (paths = WatergisApp.this.pTopicTree.getSelectionPath()).length == 1 && paths[0].getLastPathComponent() instanceof AbstractFeatureService) {
                List selectedFeatures;
                AbstractFeatureService service = (AbstractFeatureService)paths[0].getLastPathComponent();
                if (SelectionManager.getInstance().getEditableServices().contains(service) && (selectedFeatures = SelectionManager.getInstance().getSelectedFeatures(service)) != null && !selectedFeatures.isEmpty()) {
                    boolean enable = false;
                    for (Feature f : selectedFeatures) {
                        if (!(f instanceof FeatureServiceFeature) || !((FeatureServiceFeature)f).isEditable()) continue;
                        enable = true;
                        break;
                    }
                    if (enable) {
                        return true;
                    }
                }
            }
            return false;
        }
    }

    private class PasteMenuItem
    extends ThemeLayerMenuItem {
        public PasteMenuItem() {
            super(NbBundle.getMessage(PasteMenuItem.class, (String)"WatergisApp.PasteMenuItem.PasteMenuItem().title"), 498);
        }

        public void actionPerformed(ActionEvent e) {
            TreePath[] tps = WatergisApp.this.pTopicTree.getSelectionPath();
            if (tps != null && tps.length == 1) {
                AbstractFeatureService service = (AbstractFeatureService)tps[0].getLastPathComponent();
                AttributeTable table = AppBroker.getInstance().getWatergisApp().getAttributeTableByFeatureService(service);
                table.pasteSelectedFeaturesfromClipboard();
            }
        }

        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }

        public boolean isSelectable(int mask) {
            TreePath[] paths;
            boolean selectable = super.isSelectable(mask);
            if (selectable && (paths = WatergisApp.this.pTopicTree.getSelectionPath()).length == 1 && paths[0].getLastPathComponent() instanceof AbstractFeatureService) {
                AbstractFeatureService service = (AbstractFeatureService)paths[0].getLastPathComponent();
                if (SelectionManager.getInstance().getEditableServices().contains(service)) {
                    AttributeTable table = WatergisApp.this.getAttributeTableByFeatureService(service);
                    return table != null && table.isPasteButtonEnabled();
                }
            }
            return false;
        }
    }

    private class CopyMenuItem
    extends ThemeLayerMenuItem {
        public CopyMenuItem() {
            super(NbBundle.getMessage(CopyMenuItem.class, (String)"WatergisApp.CopyMenuItem.CopyMenuItem().title"), 498, 242);
        }

        public void actionPerformed(ActionEvent e) {
            TreePath[] tps = WatergisApp.this.pTopicTree.getSelectionPath();
            if (tps != null && tps.length == 1) {
                AbstractFeatureService service = (AbstractFeatureService)tps[0].getLastPathComponent();
                List features = SelectionManager.getInstance().getSelectedFeatures(service);
                ArrayList<FeatureServiceFeature> featureServiceFeatures = new ArrayList<FeatureServiceFeature>();
                for (Feature f : features) {
                    if (!(f instanceof FeatureServiceFeature)) continue;
                    featureServiceFeatures.add((FeatureServiceFeature)f);
                }
                AttributeTable.copySelectedFeaturesToClipboard(featureServiceFeatures);
                WatergisApp.this.topicTreeSelectionChanged(null);
            }
        }

        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }
    }

    private class ExportOptionsMenuItem
    extends ThemeLayerMenuItem {
        public ExportOptionsMenuItem() {
            super(NbBundle.getMessage(MetaDocumentMenuItem.class, (String)"WatergisApp.ExportOptionsMenuItem.ExportOptionsMenuItem().title"), 481);
            this.newSection = true;
        }

        public void actionPerformed(ActionEvent e) {
            StaticSwingTools.showDialog((JDialog)ThemeExportDialog.getInstance());
        }

        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask;
        }

        public boolean isSelectable(int mask) {
            return super.isSelectable(mask);
        }
    }

    private class MetaDocumentMenuItem
    extends ThemeLayerMenuItem {
        public MetaDocumentMenuItem() {
            super(NbBundle.getMessage(MetaDocumentMenuItem.class, (String)"WatergisApp.MetaDocumentMenuItem.MetaDocumentMenuItem().title"), 498);
        }

        public void actionPerformed(ActionEvent e) {
            TreePath[] paths;
            for (TreePath path : paths = WatergisApp.this.pTopicTree.getSelectionPath()) {
                if (!(path.getLastPathComponent() instanceof CidsLayer)) continue;
                CidsLayer service = (CidsLayer)path.getLastPathComponent();
                try {
                    URL u = new URL(service.getMetaDocumentLink());
                    try {
                        BrowserLauncher.openURL((String)u.toString());
                    }
                    catch (Exception ex) {
                        LOG.error((Object)("Cannot open the url:" + u), (Throwable)ex);
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }

        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }

        public boolean isSelectable(int mask) {
            TreePath[] paths;
            boolean selectable = super.isSelectable(mask);
            if (selectable && (paths = WatergisApp.this.pTopicTree.getSelectionPath()).length == 1 && paths[0].getLastPathComponent() instanceof CidsLayer) {
                CidsLayer layer = (CidsLayer)paths[0].getLastPathComponent();
                return layer.getMetaDocumentLink() != null;
            }
            return false;
        }
    }

    private class ExportMenuItem
    extends ThemeLayerMenuItem {
        private Filter filter;

        public ExportMenuItem() {
            super(NbBundle.getMessage(ThemeLayerWidget.class, (String)"ThemeLayerWidget.ExportMenuItem.pmenuItem.text"), 498);
            this.filter = new Filter();
            this.newSection = true;
        }

        public void setFilter(Filter filter) {
            this.filter = filter;
        }

        public boolean isVisible(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }

        public boolean isSelectable(List<ServiceLayer> serviceLayerList) {
            for (ServiceLayer layer : serviceLayerList) {
                if (this.filter.isValid(layer)) continue;
                return false;
            }
            return true;
        }

        public boolean isSelectable(int mask) {
            return (this.visibility & mask) == mask && (mask & 0x10) != 0;
        }

        public void actionPerformed(ActionEvent e) {
            TreePath[] paths = WatergisApp.this.pTopicTree.getSelectionPath();
            if (paths.length == 1) {
                TreePath o = paths[0];
                AbstractFeatureService afs = (AbstractFeatureService)o.getLastPathComponent();
                if (afs.getLayerProperties().getAttributeTableRuleSet() != null && afs.getLayerProperties().getAttributeTableRuleSet().hasCustomExportFeaturesMethod()) {
                    afs.getLayerProperties().getAttributeTableRuleSet().exportFeatures();
                    return;
                }
                List features = SelectionManager.getInstance().getSelectedFeatures(afs);
                if (features == null || features.isEmpty()) {
                    features = null;
                }
                DefaultFeatureServiceFeature[] featureArray = null;
                if (features != null) {
                    featureArray = new DefaultFeatureServiceFeature[features.size()];
                    for (int i = 0; i < features.size(); ++i) {
                        featureArray[i] = (DefaultFeatureServiceFeature)features.get(i);
                    }
                }
                if (WatergisApp.this.lastExportPath == null) {
                    if (DownloadManager.instance().getDestinationDirectory() != null) {
                        WatergisApp.this.lastExportPath = DownloadManager.instance().getDestinationDirectory().toString();
                    }
                    if (WatergisApp.this.lastExportPath == null) {
                        WatergisApp.this.lastExportPath = DIRECTORYPATH_WATERGIS;
                    }
                }
                File outputFile = null;
                try {
                    afs.initAndWait();
                }
                catch (Exception ex) {
                    LOG.error((Object)"Cannot initialise service.", (Throwable)ex);
                }
                String geometryType = afs.getGeometryType();
                outputFile = geometryType == null || geometryType.equals(AbstractFeatureService.UNKNOWN) || geometryType.equals(AbstractFeatureService.NONE) ? StaticSwingTools.chooseFileWithMultipleFilters((String)WatergisApp.this.lastExportPath, (boolean)true, (String[])new String[]{"dbf", "csv", "txt"}, (String[])new String[]{"dbf", "csv", "txt"}, (Component)((Object)this)) : StaticSwingTools.chooseFileWithMultipleFilters((String)WatergisApp.this.lastExportPath, (boolean)true, (String[])new String[]{"shp", "dbf", "csv", "txt"}, (String[])new String[]{"shp", "dbf", "csv", "txt"}, (Component)((Object)this));
                if (outputFile != null) {
                    ExportDbfDownload ed;
                    List<String[]> attributeNames = !outputFile.getName().toLowerCase().endsWith("csv") && !outputFile.getName().toLowerCase().endsWith("txt") ? this.getAliasAttributeList(afs, true) : this.getAliasAttributeList(afs, false);
                    String query = null;
                    if (!(!this.hasArrayValue(attributeNames, "ww_gr") || !(afs instanceof CidsLayer) || ThemeExportDialog.getInstance().has1501() && ThemeExportDialog.getInstance().has1502() && ThemeExportDialog.getInstance().has1503() && ThemeExportDialog.getInstance().has1504() && ThemeExportDialog.getInstance().has1505())) {
                        ArrayList<String> wdms = new ArrayList<String>();
                        if (ThemeExportDialog.getInstance().has1501()) {
                            wdms.add("1501");
                        }
                        if (ThemeExportDialog.getInstance().has1502()) {
                            wdms.add("1502");
                        }
                        if (ThemeExportDialog.getInstance().has1503()) {
                            wdms.add("1503");
                        }
                        if (ThemeExportDialog.getInstance().has1504()) {
                            wdms.add("1504");
                        }
                        if (ThemeExportDialog.getInstance().has1505()) {
                            wdms.add("1505");
                        }
                        query = query == null ? "dlm25wPk_ww_gr1.wdm in " + this.listToString(wdms) : query + " and dlm25wPk_ww_gr1.wdm in " + this.listToString(wdms);
                    }
                    if (outputFile.getName().toLowerCase().endsWith("dbf")) {
                        ed = new ExportDbfDownload();
                        ed.init(outputFile.getAbsolutePath(), "", (FeatureServiceFeature[])featureArray, afs, attributeNames, query);
                    } else if (outputFile.getName().toLowerCase().endsWith("csv")) {
                        ed = new ExportCsvDownload();
                        ed.init(outputFile.getAbsolutePath(), "", (FeatureServiceFeature[])featureArray, afs, attributeNames, query);
                    } else if (outputFile.getName().toLowerCase().endsWith("txt")) {
                        ed = new ExportTxtDownload();
                        ed.init(outputFile.getAbsolutePath(), "", (FeatureServiceFeature[])featureArray, afs, attributeNames, query);
                    } else {
                        ed = new ExportShapeDownload();
                        ed.init(outputFile.getAbsolutePath(), "", (FeatureServiceFeature[])featureArray, afs, attributeNames, query);
                    }
                    WatergisApp.this.lastExportPath = outputFile.getParent();
                    DownloadManager.instance().add((Download)ed);
                }
            }
        }

        private String listToString(List<String> list) {
            StringBuilder string = new StringBuilder("(");
            boolean first = true;
            for (String tmp : list) {
                if (first) {
                    string.append(tmp);
                    first = false;
                    continue;
                }
                string.append(",").append(tmp);
            }
            string.append(")");
            return string.toString();
        }

        private boolean hasArrayValue(List<String[]> array, String value) {
            for (String[] tmp : array) {
                if (!tmp[0].equals(value)) continue;
                return true;
            }
            return false;
        }

        private List<String[]> getAliasAttributeList(AbstractFeatureService service, boolean withGeometryColumn) {
            ArrayList<String[]> attrNames = new ArrayList<String[]>();
            Map attributeMap = service.getFeatureServiceAttributes();
            for (Object name : service.getOrderedFeatureServiceAttributes()) {
                FeatureServiceAttribute attr = (FeatureServiceAttribute)attributeMap.get(name);
                if (attr != null && (!attr.isVisible() || !withGeometryColumn && attr.isGeometry()) && (!withGeometryColumn || !attr.isGeometry())) continue;
                String[] aliasAttr = new String[]{attr.getAlias().equals("") ? attr.getName() : attr.getAlias(), attr.getName()};
                attrNames.add(aliasAttr);
            }
            return attrNames;
        }

        private class Filter {
            private Filter() {
            }

            public boolean isValid(ServiceLayer layer) {
                if (layer instanceof CidsLayer) {
                    return WatergisApp.this.isExportEnabled((AbstractFeatureService)((CidsLayer)layer));
                }
                return true;
            }
        }
    }
}

