/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import de.cismet.cismap.commons.gui.capabilitywidget.CapabilityWidget;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.View;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class AddThemeAction
extends AbstractAction
implements ActionListener {
    private static final Logger LOG = Logger.getLogger(AddThemeAction.class);
    private CapabilityWidget pCapabilities;
    private RootWindow rootWindow;
    private View vCapability;

    public AddThemeAction() {
        this.init(null, null, null);
    }

    public AddThemeAction(CapabilityWidget pCapabilities, RootWindow rootWindow, View vCapability) {
        this.init(pCapabilities, rootWindow, vCapability);
    }

    public void init(CapabilityWidget pCapabilities, RootWindow rootWindow, View vCapability) {
        this.pCapabilities = pCapabilities;
        this.rootWindow = rootWindow;
        this.vCapability = vCapability;
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-layers.png");
        String text = "Thema hinzuf\u00fcgen";
        String tooltiptext = "Thema hinzuf\u00fcgen";
        String mnemonic = "T";
        try {
            text = NbBundle.getMessage(AddThemeAction.class, (String)"AddThemeAction.text");
            tooltiptext = NbBundle.getMessage(AddThemeAction.class, (String)"AddThemeAction.toolTipText");
            mnemonic = NbBundle.getMessage(AddThemeAction.class, (String)"AddThemeAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("ShortDescription", tooltiptext);
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showView();
    }

    private void showView() {
        Dimension prefSize = this.pCapabilities.getPreferredSize();
        Dimension size = this.pCapabilities.getSize();
        Dimension sizeToUse = prefSize.height * prefSize.width >= size.height * size.width ? prefSize : size;
        FloatingWindow fw = this.rootWindow.createFloatingWindow(this.getPointOfCenterOfScreen(sizeToUse), sizeToUse, (DockingWindow)this.vCapability);
        fw.getTopLevelAncestor().setVisible(true);
    }

    public Point getPointOfCenterOfScreen(Dimension d) {
        PointerInfo pInfo = MouseInfo.getPointerInfo();
        Point pointerLocation = pInfo.getLocation();
        GraphicsConfiguration[] cfgArr = pInfo.getDevice().getConfigurations();
        Rectangle bounds = null;
        for (int i = 0; i < cfgArr.length; ++i) {
            bounds = cfgArr[i].getBounds();
            if (pointerLocation.x <= bounds.x) break;
        }
        int x = (int)((double)bounds.x + ((double)bounds.width - d.getWidth()) / 2.0);
        int y = (int)((double)bounds.y + ((double)bounds.height - d.getHeight()) / 2.0);
        return new Point(x, y);
    }
}

