/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.raster.wms.AbstractWMS;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.WatergisApp;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import org.apache.log4j.Logger;

public class AdoptServerConfigFileAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(AdoptServerConfigFileAction.class);
    String path;
    String name;

    public AdoptServerConfigFileAction(String path) {
        this(path, "");
    }

    public AdoptServerConfigFileAction(String path, String name) {
        this.path = path;
        this.name = name;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            final MappingComponent mappingComponent = AppBroker.getInstance().getMappingComponent();
            ((ActiveLayerModel)mappingComponent.getMappingModel()).removeAllLayers();
            AppBroker.getConfigManager().configureFromClasspath(this.path, null);
            AppBroker.getInstance().switchMapMode(mappingComponent.getInteractionMode());
            AppBroker.getInstance().getWatergisApp().setTitle("FIS Gew\u00e4sser \u2013 Projekt: " + this.name);
            String fileName = this.path.substring(this.path.lastIndexOf("/") + 1);
            WatergisApp watergisApp = AppBroker.getInstance().getWatergisApp();
            StringBuilder stringBuilder = new StringBuilder();
            AppBroker.getInstance().getWatergisApp();
            watergisApp.setCurrentLayoutFile(stringBuilder.append(WatergisApp.getDIRECTORYPATH_WATERGIS()).append(System.getProperty("file.separator")).append(fileName).toString());
            EventQueue.invokeLater(new Thread("Initialise layers"){

                @Override
                public void run() {
                    TreeMap map = ((ActiveLayerModel)mappingComponent.getMappingModel()).getMapServices();
                    if (map != null && map.keySet() != null) {
                        for (Integer key : map.keySet()) {
                            MapService service = (MapService)map.get((int)key);
                            if (!(service instanceof AbstractWMS) || ((AbstractWMS)service).isVisible()) continue;
                            ((AbstractWMS)service).setSize(mappingComponent.getHeight(), mappingComponent.getWidth());
                        }
                    }
                }
            });
        }
        catch (Throwable ex) {
            LOG.fatal((Object)"No ServerProfile", ex);
        }
    }

    public void adoptConfigFile() {
        this.actionPerformed(null);
    }
}

