/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.DefaultCidsLayerBindableReferenceCombo;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.cismap.custom.attributerule.ConfirmDialog;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.ReleaseAction;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class AnnexAction
extends ReleaseAction {
    private static final Logger LOG = Logger.getLogger(AnnexAction.class);

    public AnnexAction() {
        this(false);
    }

    public AnnexAction(boolean loadPermissions) {
        String tooltip = NbBundle.getMessage(AnnexAction.class, (String)"AnnexAction.AnnexAction().toolTipText", (Object[])new Object[]{" "});
        this.putValue("ShortDescription", tooltip);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-addfriend.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final CidsLayerFeature[] features = this.getRelevantFeatures(SelectionManager.getInstance().getSelectedFeatures(), false);
        this.featureCount = 0;
        if (AppBroker.getInstance().getOwnWwGrList() == null || AppBroker.getInstance().getOwnWwGrList().isEmpty()) {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(AnnexAction.class, (String)"AnnexAction.actionPerformed.noGroup.message", (Object)AppBroker.getInstance().getOwner()), NbBundle.getMessage(AnnexAction.class, (String)"AnnexAction.actionPerformed.noGroup.title"), 0);
            return;
        }
        if (features != null && features.length > 0) {
            final CidsBean newWwGr = AppBroker.getInstance().getOwnWwGr();
            ConfirmDialog dialog = new ConfirmDialog(AppBroker.getInstance().getWatergisApp(), true, NbBundle.getMessage(ReleaseAction.class, (String)"AnnexAction.done().title"), NbBundle.getMessage(ReleaseAction.class, (String)"AnnexAction.done().message", (Object)features.length), NbBundle.getMessage(ReleaseAction.class, (String)"AnnexAction.done().execute"), NbBundle.getMessage(ReleaseAction.class, (String)"AnnexAction.done().cancel"));
            dialog.setSize(350, 120);
            StaticSwingTools.showDialog((JDialog)dialog);
            if (dialog.getButtonClicked() != 1) {
                return;
            }
            WaitingDialogThread<TreeSet<AbstractFeatureService>> wdt = new WaitingDialogThread<TreeSet<AbstractFeatureService>>((Frame)AppBroker.getInstance().getWatergisApp(), true, NbBundle.getMessage(AnnexAction.class, (String)"AnnexAction.actionPerformed.WaitingDialogThread.message"), null, 100){

                protected TreeSet<AbstractFeatureService> doInBackground() throws Exception {
                    TreeSet<AbstractFeatureService> services = new TreeSet<AbstractFeatureService>(new ReleaseAction.AbstractFeatureServiceComparator());
                    boolean annexAll = true;
                    for (CidsLayerFeature cidsFeature : features) {
                        CidsBean cidsBean = cidsFeature.getBean();
                        try {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("annex object with id " + cidsFeature.getId()));
                            }
                            if (cidsFeature.getLayerProperties() != null && cidsFeature.getLayerProperties().getFeatureService() != null) {
                                services.add(cidsFeature.getLayerProperties().getFeatureService());
                            }
                            cidsBean.setProperty("ww_gr", (Object)newWwGr);
                            cidsFeature.setProperty("ww_gr", newWwGr.getProperty("ww_gr"));
                            DefaultCidsLayerBindableReferenceCombo combo = cidsFeature.getCatalogueCombo("ww_gr");
                            if (combo != null) {
                                for (int i = 0; i < combo.getItemCount(); ++i) {
                                    Object o = combo.getItemAt(i);
                                    if (!(o instanceof CidsLayerFeature) || ((CidsLayerFeature)o).getId() != newWwGr.getPrimaryKeyValue().intValue()) continue;
                                    combo.setSelectedIndex(i);
                                    break;
                                }
                            }
                            if (cidsBean.getProperty("ba_cd") == null || !((String)cidsBean.getProperty("ba_cd")).startsWith((String)AppBroker.getInstance().getOwnWwGr().getProperty("praefix"))) {
                                String baCd = AppBroker.getInstance().getOwnWwGr().getProperty("praefix") + ":" + cidsBean.hashCode();
                                cidsFeature.setProperty("ba_cd", (Object)baCd);
                                cidsBean.setProperty("ba_cd", (Object)baCd);
                            }
                            cidsFeature.saveChangesWithoutReload();
                            cidsBean.persist();
                            ++AnnexAction.this.featureCount;
                        }
                        catch (Exception ex) {
                            LOG.error((Object)"Cannot annex feature", (Throwable)ex);
                        }
                    }
                    return services;
                }

                protected void done() {
                    try {
                        TreeSet services = (TreeSet)this.get();
                        AnnexAction.this.refreshServiceAttributeTables(services);
                        AppBroker.getInstance().getWatergisApp().initRouteCombo();
                        AnnexAction.this.refreshServiceLayer(services);
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while annexing objects.", (Throwable)e);
                    }
                }
            };
            wdt.start();
        } else {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(AnnexAction.class, (String)"AnnexAction.actionPerformed.noFeature.message"), NbBundle.getMessage(AnnexAction.class, (String)"AnnexAction.actionPerformed.noFeature.title"), 0);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

