/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import Sirius.navigator.connection.SessionManager;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import de.cismet.cids.custom.watergis.server.search.MergeBakAe;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.ModifiableFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.math.geometry.StaticGeometryFunctions;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.merge.FeatureMerger;
import de.cismet.watergis.gui.actions.merge.FeatureMergerFactory;
import de.cismet.watergis.gui.actions.merge.MergeException;
import de.cismet.watergis.gui.components.AttributeTableDialog;
import de.cismet.watergis.utils.GeometryUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class MergeAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(MergeAction.class);

    public MergeAction() {
        String tooltip = NbBundle.getMessage(MergeAction.class, (String)"MergeAction.MergeAction().toolTipText", (Object[])new Object[]{" "});
        this.putValue("ShortDescription", tooltip);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-mergeshapes.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final List<FeatureServiceFeature> allValidFeatures = this.determineAllValidFeature();
        if (allValidFeatures != null) {
            AttributeTableDialog dialog = new AttributeTableDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.actionPerformed.dialog.title"), true);
            dialog.setData(allValidFeatures.get(0).getLayerProperties().getFeatureService(), allValidFeatures);
            dialog.setCustomText(NbBundle.getMessage(MergeAction.class, (String)"MergeAction.actionPerformed.dialog.message"));
            dialog.setSize(650, 300);
            StaticSwingTools.showDialog((JDialog)dialog);
            final FeatureServiceFeature masterFeature = dialog.getReturnValue();
            if (masterFeature == null) {
                return;
            }
            WaitingDialogThread wdt = new WaitingDialogThread(AppBroker.getInstance().getWatergisApp(), true, "Zusammenf\u00fcgen", null, 500){

                protected Object doInBackground() throws Exception {
                    FeatureServiceFeature resultedFeature = masterFeature;
                    List sortedFeaturesWithoutMaster = MergeAction.this.sortAndAdjustFeaturesForMerge(masterFeature, allValidFeatures, 0.01);
                    if (sortedFeaturesWithoutMaster != null && sortedFeaturesWithoutMaster.size() < allValidFeatures.size() - 1) {
                        JOptionPane.showMessageDialog((Component)this.wd, NbBundle.getMessage(MergeAction.class, (String)"MergeAction.actionPerformed.dataTypeChanged"), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.actionPerformed.dataTypeChanged.title"), 0);
                        return null;
                    }
                    FeatureMerger merger = new FeatureMergerFactory().getFeatureMergerForFeature((Feature)resultedFeature);
                    String geometryType = resultedFeature.getGeometry().getGeometryType();
                    try {
                        for (Feature f : sortedFeaturesWithoutMaster) {
                            if ((resultedFeature = merger.merge((Feature)resultedFeature, f)) != null) continue;
                            JOptionPane.showMessageDialog((Component)this.wd, NbBundle.getMessage(MergeAction.class, (String)"MergeAction.actionPerformed.mergeFailed"), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.actionPerformed.mergeFailed.title"), 0);
                            break;
                        }
                    }
                    catch (MergeException ex) {
                        JOptionPane.showMessageDialog((Component)this.wd, ex.getMessage(), "Fehler", 0);
                        if (resultedFeature instanceof ModifiableFeature) {
                            ((ModifiableFeature)resultedFeature).undoAll();
                        }
                        return null;
                    }
                    if (resultedFeature != null) {
                        if (geometryType.toLowerCase().startsWith("multi") && !geometryType.equals(resultedFeature.getGeometry().getGeometryType())) {
                            Geometry g = resultedFeature.getGeometry();
                            resultedFeature.setGeometry(StaticGeometryFunctions.toMultiGeometry((Geometry)g));
                        }
                        if (geometryType.equals(resultedFeature.getGeometry().getGeometryType()) && resultedFeature instanceof ModifiableFeature) {
                            ModifiableFeature serviceFeature = (ModifiableFeature)resultedFeature;
                            try {
                                CidsLayerFeature clf;
                                DefaultFeatureServiceFeature dfsf;
                                if (serviceFeature instanceof DefaultFeatureServiceFeature && (dfsf = (DefaultFeatureServiceFeature)serviceFeature).getLayerProperties() != null && dfsf.getLayerProperties().getAttributeTableRuleSet() != null) {
                                    AttributeTableRuleSet ruleSet = dfsf.getLayerProperties().getAttributeTableRuleSet();
                                    ruleSet.beforeSave((FeatureServiceFeature)dfsf);
                                    ArrayList<DefaultFeatureServiceFeature> list = new ArrayList<DefaultFeatureServiceFeature>();
                                    list.add(dfsf);
                                    if (!ruleSet.prepareForSave(list)) {
                                        return null;
                                    }
                                }
                                try {
                                    serviceFeature.saveChangesWithoutReload();
                                }
                                catch (Exception ex) {
                                    JOptionPane.showMessageDialog((Component)this.wd, ex.getMessage(), "Fehler", 0);
                                    return null;
                                }
                                for (Feature f : sortedFeaturesWithoutMaster) {
                                    if (!(f instanceof ModifiableFeature)) continue;
                                    AttributeTable table = AppBroker.getInstance().getWatergisApp().getAttributeTableByFeature((FeatureServiceFeature)f);
                                    if (table != null) {
                                        table.removeFeature((FeatureServiceFeature)f);
                                    } else {
                                        ((ModifiableFeature)f).delete();
                                    }
                                    SelectionManager.getInstance().removeSelectedFeatures(f);
                                }
                                serviceFeature.setEditable(false);
                                serviceFeature.setEditable(true);
                                if (serviceFeature instanceof CidsLayerFeature && (clf = (CidsLayerFeature)serviceFeature).getBean().getMetaObject().getMetaClass().getTableName().endsWith("fg_bak")) {
                                    MergeBakAe search = new MergeBakAe(Integer.valueOf(clf.getId()));
                                    SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
                                }
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Error while saving changes", (Throwable)ex);
                            }
                            AppBroker.getInstance().getMappingComponent().refresh();
                        } else if (!geometryType.equals(resultedFeature.getGeometry().getGeometryType())) {
                            JOptionPane.showMessageDialog((Component)this.wd, NbBundle.getMessage(MergeAction.class, (String)"MergeAction.actionPerformed.dataTypeChanged"), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.actionPerformed.dataTypeChanged.title"), 0);
                            if (resultedFeature instanceof ModifiableFeature) {
                                ((ModifiableFeature)resultedFeature).undoAll();
                            }
                        } else {
                            LOG.error((Object)("Feature is not modifiable " + resultedFeature.getClass().getName()));
                        }
                    }
                    return null;
                }
            };
            wdt.start();
        }
    }

    private List<FeatureServiceFeature> sortAndAdjustFeaturesForMerge(FeatureServiceFeature masterFeature, List<FeatureServiceFeature> allValidFeatures, double tolerance) {
        ArrayList<FeatureServiceFeature> featuresWithoutMaster = new ArrayList<FeatureServiceFeature>(allValidFeatures);
        featuresWithoutMaster.remove(masterFeature);
        if (masterFeature.getGeometry().getGeometryType().toUpperCase().contains("LINE")) {
            int n;
            ArrayList<Coordinate> endpoints = new ArrayList<Coordinate>();
            ArrayList<Coordinate> startpoints = new ArrayList<Coordinate>();
            HashMap<FeatureServiceFeature, FeatureServiceFeature> successors = new HashMap<FeatureServiceFeature, FeatureServiceFeature>();
            HashMap<FeatureServiceFeature, FeatureServiceFeature> predecessors = new HashMap<FeatureServiceFeature, FeatureServiceFeature>();
            for (int i = -1; i < featuresWithoutMaster.size(); ++i) {
                FeatureServiceFeature feature = i == -1 ? masterFeature : (FeatureServiceFeature)featuresWithoutMaster.get(i);
                Geometry currentLine = feature.getGeometry();
                Coordinate startpoint = currentLine.getCoordinates()[0];
                Coordinate endpoint = currentLine.getCoordinates()[currentLine.getNumPoints() - 1];
                if (endpoints.size() > 0) {
                    FeatureServiceFeature predecessor;
                    FeatureServiceFeature successor;
                    double dist;
                    int n2;
                    for (n2 = 0; n2 < endpoints.size(); ++n2) {
                        dist = ((Coordinate)endpoints.get(n2)).distance(startpoint);
                        if (!(dist < tolerance)) continue;
                        successor = feature;
                        predecessor = n2 == 0 ? masterFeature : (FeatureServiceFeature)featuresWithoutMaster.get(n2 - 1);
                        successors.put(predecessor, successor);
                        predecessors.put(successor, predecessor);
                        if (dist == 0.0) continue;
                        endpoints.set(n2, startpoint);
                        predecessor.setGeometry(GeometryUtils.setEndpointOfLine(predecessor.getGeometry(), startpoint));
                        break;
                    }
                    for (n2 = 0; n2 < startpoints.size(); ++n2) {
                        dist = ((Coordinate)startpoints.get(n2)).distance(endpoint);
                        if (!(dist < tolerance)) continue;
                        successor = n2 == 0 ? masterFeature : (FeatureServiceFeature)featuresWithoutMaster.get(n2 - 1);
                        predecessor = feature;
                        successors.put(predecessor, successor);
                        predecessors.put(successor, predecessor);
                        if (dist == 0.0) continue;
                        endpoint = (Coordinate)startpoints.get(n2);
                        predecessor.setGeometry(GeometryUtils.setEndpointOfLine(predecessor.getGeometry(), (Coordinate)startpoints.get(n2)));
                        break;
                    }
                }
                startpoints.add(startpoint);
                endpoints.add(endpoint);
            }
            ArrayList<FeatureServiceFeature> result = new ArrayList<FeatureServiceFeature>();
            FeatureServiceFeature next = (FeatureServiceFeature)successors.get(masterFeature);
            for (n = 0; next != null && n <= allValidFeatures.size(); ++n) {
                if (!result.contains(next)) {
                    result.add(next);
                }
                next = (FeatureServiceFeature)successors.get(next);
            }
            FeatureServiceFeature prev = (FeatureServiceFeature)predecessors.get(masterFeature);
            n = 0;
            while (prev != null && n <= allValidFeatures.size()) {
                if (!result.contains(prev)) {
                    result.add(prev);
                }
                prev = (FeatureServiceFeature)predecessors.get(prev);
            }
            return result;
        }
        if (masterFeature.getGeometry().getGeometryType().toUpperCase().contains("POLYGON")) {
            Collections.sort(featuresWithoutMaster, new DistanceComparator(masterFeature));
            return featuresWithoutMaster;
        }
        return featuresWithoutMaster;
    }

    private List<FeatureServiceFeature> determineAllValidFeature() {
        List allSelectedFeatures = SelectionManager.getInstance().getSelectedFeatures();
        ArrayList<Feature> features = new ArrayList<Feature>();
        ArrayList<FeatureServiceFeature> allValidFeatures = new ArrayList<FeatureServiceFeature>();
        FeatureServiceFeature type = null;
        for (Feature f : allSelectedFeatures) {
            FeatureServiceFeature serviceFeature;
            AbstractFeatureService service;
            if (!(f instanceof FeatureServiceFeature) || (service = (serviceFeature = (FeatureServiceFeature)f).getLayerProperties().getFeatureService()) == null || !SelectionManager.getInstance().getEditableServices().contains(service)) continue;
            features.add(f);
        }
        for (Feature f : features) {
            if (type == null) {
                if (f instanceof FeatureServiceFeature) {
                    type = (FeatureServiceFeature)f;
                    allValidFeatures.add(type);
                    continue;
                }
                JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.determineAllValidFeature.noFeatureServiceFeature"), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.determineAllValidFeature.noFeatureServiceFeature.title"), 0);
                break;
            }
            if (f instanceof FeatureServiceFeature) {
                FeatureServiceFeature toCheck = (FeatureServiceFeature)f;
                if (type.getLayerProperties().getFeatureService().equals(toCheck.getLayerProperties().getFeatureService())) {
                    allValidFeatures.add(toCheck);
                    continue;
                }
                JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.determineAllValidFeature.differentTypes"), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.determineAllValidFeature.differentTypes.title"), 0);
                break;
            }
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.determineAllValidFeature.noFeatureServiceFeature"), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.determineAllValidFeature.noFeatureServiceFeature.title"), 0);
            break;
        }
        if (allValidFeatures.size() == features.size() && allValidFeatures.size() > 0) {
            List selectedFeatures;
            AttributeTable table = AppBroker.getInstance().getWatergisApp().getAttributeTableByFeature((FeatureServiceFeature)allValidFeatures.get(0));
            if (((FeatureServiceFeature)allValidFeatures.get(0)).getGeometry() instanceof Point) {
                JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.determineAllValidFeature.pointFeaturesFound.message"), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.determineAllValidFeature.pointFeaturesFound.title"), 0);
                return null;
            }
            if (table != null && (selectedFeatures = table.getSelectedFeatures()).equals(allValidFeatures)) {
                return selectedFeatures;
            }
            return allValidFeatures;
        }
        if (features.isEmpty()) {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.determineAllValidFeature.noFeatureFound"), NbBundle.getMessage(MergeAction.class, (String)"MergeAction.determineAllValidFeature.noFeatureFound.title"), 0);
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private static class DistanceComparator
    implements Comparator<FeatureServiceFeature> {
        private final FeatureServiceFeature masterFeature;

        public DistanceComparator(FeatureServiceFeature masterFeature) {
            this.masterFeature = masterFeature;
        }

        @Override
        public int compare(FeatureServiceFeature o1, FeatureServiceFeature o2) {
            Double distanceO1 = this.masterFeature.getGeometry().distance(o1.getGeometry());
            Double distanceO2 = this.masterFeature.getGeometry().distance(o2.getGeometry());
            return distanceO1.compareTo(distanceO2);
        }
    }
}

