/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.ModifiableFeature;
import de.cismet.cismap.commons.features.PermissionProvider;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreatedEvent;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreatedListener;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.creator.WithoutGeometryCreator;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.retrieval.RetrievalEvent;
import de.cismet.cismap.commons.retrieval.RetrievalListener;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.watergis.broker.AppBroker;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class NewObjectAction
extends AbstractAction {
    private AbstractFeatureService service;
    private boolean firstCall = true;

    public NewObjectAction() {
        String tooltip = NbBundle.getMessage(NewObjectAction.class, (String)"NewObjectAction.cmdNewObject.toolTipText", (Object[])new Object[]{" ", ""});
        this.putValue("ShortDescription", tooltip);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-plus-sign.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.service != null && (this.firstCall || !e.getSource().equals(AppBroker.getInstance()))) {
            AttributeTableRuleSet ruleSet = this.service.getLayerProperties().getAttributeTableRuleSet();
            FeatureCreator creator = ruleSet.getFeatureCreator();
            if (!creator.isCreationAllowed(CismapBroker.getInstance().getMappingComponent())) {
                return;
            }
            FeatureServiceFeature feature = this.service.getFeatureFactory().createNewFeature();
            FeatureCreator activeCreator = AppBroker.getInstance().getActiveFeatureCreator();
            if (activeCreator != null && activeCreator.getService().equals(this.service)) {
                activeCreator.resume();
            } else {
                ruleSet.beforeSave(feature);
                CustomCreatedListener listener = new CustomCreatedListener(this.service, feature);
                creator.addFeatureCreatedListener((FeatureCreatedListener)listener);
                creator.createFeature(CismapBroker.getInstance().getMappingComponent(), feature);
                AppBroker.getInstance().setActiveFeatureCreator(creator);
            }
        }
        this.firstCall = false;
    }

    @Override
    public boolean isEnabled() {
        return this.service != null;
    }

    public void setSelectedService(AbstractFeatureService service) {
        this.service = service;
        if (service == null) {
            String tooltip = NbBundle.getMessage(NewObjectAction.class, (String)"NewObjectAction.cmdNewObject.toolTipText", (Object[])new Object[]{" ", ""});
            this.putValue("ShortDescription", tooltip);
        } else {
            String type = "";
            String tooltip = NbBundle.getMessage(NewObjectAction.class, (String)"NewObjectAction.cmdNewObject.toolTipText", (Object[])new Object[]{": " + service.getName() + " ", ""});
            this.putValue("ShortDescription", tooltip);
        }
    }

    private static class CustomCreatedListener
    implements FeatureCreatedListener {
        private static final Logger LOG = Logger.getLogger(CustomCreatedListener.class);
        private List<FeatureServiceFeature> createdFeatures = new ArrayList<FeatureServiceFeature>();
        private final AbstractFeatureService service;
        private final FeatureServiceFeature feature;

        public CustomCreatedListener(AbstractFeatureService service, FeatureServiceFeature feature) {
            this.service = service;
            this.feature = feature;
            this.createdFeatures.add(feature);
        }

        public CustomCreatedListener(AbstractFeatureService service, FeatureServiceFeature feature, List<FeatureServiceFeature> createdFeatures) {
            this.service = service;
            this.feature = feature;
            this.createdFeatures.addAll(createdFeatures);
            this.createdFeatures.add(feature);
        }

        public void featureCreated(FeatureCreatedEvent event) {
            AttributeTableRuleSet ruleSet;
            FeatureCreator creator;
            AbstractFeatureService service;
            LayerProperties props = this.feature.getLayerProperties();
            if (this.feature.getProperty("id") != null) {
                PermissionProvider permissionprovider;
                this.feature.setId(((Number)this.feature.getProperty("id")).intValue());
                if (this.feature instanceof PermissionProvider && !(permissionprovider = (PermissionProvider)this.feature).hasWritePermissions()) {
                    if (this.feature instanceof ModifiableFeature) {
                        try {
                            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(NewObjectAction.class, (String)"NewObjectAction.actionPerformed().featureCreated().message"), NbBundle.getMessage(NewObjectAction.class, (String)"NewObjectAction.actionPerformed().featureCreated().title"), 0);
                            ((ModifiableFeature)this.feature).delete();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Cannot delete feature", (Throwable)e);
                        }
                    }
                    return;
                }
            }
            if (props != null && (service = props.getFeatureService()) != null) {
                service.retrieve(true);
                service.addRetrievalListener(new RetrievalListener(){

                    public void retrievalStarted(RetrievalEvent e) {
                    }

                    public void retrievalProgress(RetrievalEvent e) {
                    }

                    public void retrievalComplete(RetrievalEvent e) {
                        AppBroker.getInstance().getWatergisApp().addFeatureToAttributeTable(feature);
                        SelectionManager.getInstance().addSelectedFeatures(createdFeatures);
                        service.removeRetrievalListener((RetrievalListener)this);
                    }

                    public void retrievalAborted(RetrievalEvent e) {
                    }

                    public void retrievalError(RetrievalEvent e) {
                    }
                });
                Timer t = new Timer("reload");
                t.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        TreeMap services = AppBroker.getInstance().getMappingComponent().getMappingModel().getRasterServices();
                        for (MapService mapService : services.values()) {
                            if (mapService.equals(service) || !mapService.isVisible()) continue;
                            mapService.retrieve(true);
                        }
                    }
                }, 1000L);
            }
            if ((creator = (ruleSet = this.service.getLayerProperties().getAttributeTableRuleSet()).getFeatureCreator()) instanceof WithoutGeometryCreator) {
                CismapBroker.getInstance().getMappingComponent().setInteractionMode("SELECT");
                AppBroker.getInstance().setActiveFeatureCreator(null);
                return;
            }
            FeatureServiceFeature feature = this.service.getFeatureFactory().createNewFeature();
            ruleSet.beforeSave(feature);
            CustomCreatedListener listener = new CustomCreatedListener(this.service, feature, this.createdFeatures);
            creator.addFeatureCreatedListener((FeatureCreatedListener)listener);
            creator.createFeature(CismapBroker.getInstance().getMappingComponent(), feature);
            AppBroker.getInstance().setActiveFeatureCreator(creator);
        }
    }
}

