/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions;

import Sirius.navigator.connection.SessionManager;
import Sirius.navigator.exception.ConnectionException;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import de.cismet.cids.custom.watergis.server.search.MoveFgBaAfterSplit;
import de.cismet.cids.custom.watergis.server.search.MoveFgBakAfterSplit;
import de.cismet.cids.custom.watergis.server.search.RecoverFgBaAfterSplit;
import de.cismet.cids.custom.watergis.server.search.RecoverFgBakAfterSplit;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureWithId;
import de.cismet.cismap.commons.features.ModifiableFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.creator.GeometryFinishedListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.split.FeatureSplitter;
import de.cismet.watergis.gui.actions.split.FeatureSplitterFactory;
import de.cismet.watergis.utils.SplitGeometryListener;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SplitAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(SplitAction.class);
    private static final Map<AbstractFeatureService, List<FeatureSplitter>> undoMap = new HashMap<AbstractFeatureService, List<FeatureSplitter>>();
    private static final Map<AbstractFeatureService, List<FgBaAndStations>> undoStationMap = new HashMap<AbstractFeatureService, List<FgBaAndStations>>();
    private static final Map<AbstractFeatureService, List<FgBaAndStations>> undoBakStationMap = new HashMap<AbstractFeatureService, List<FgBaAndStations>>();
    private SplitGeometryListener splitListener;
    private FeatureServiceFeature lastFeature;

    public SplitAction() {
        String tooltip = NbBundle.getMessage(SplitAction.class, (String)"SplitAction.cmdSplitAction.toolTipText", (Object[])new Object[]{" "});
        this.putValue("ShortDescription", tooltip);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-divide.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final FeatureServiceFeature validFeature = this.determineValidFeature();
        final MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
        if (validFeature != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String oldInteractionMode = mc.getInteractionMode();
                    SplitGeometryListener listener = null;
                    listener = "SplitGeometryListener" != oldInteractionMode && SplitAction.this.lastFeature != null && SplitAction.this.splitListener != null && validFeature.equals(SplitAction.this.lastFeature) ? SplitAction.this.splitListener : new SplitGeometryListener(mc, new SplitFinishedListener(mc, oldInteractionMode, validFeature));
                    SplitAction.this.splitListener = listener;
                    SplitAction.this.lastFeature = validFeature;
                    mc.addInputListener("SplitGeometryListener", (PBasicInputEventHandler)listener);
                    mc.putCursor("SplitGeometryListener", new Cursor(1));
                    mc.setInteractionMode("SplitGeometryListener");
                }
            });
        }
    }

    public static void undo(final AbstractFeatureService service) {
        WaitingDialogThread wdt = new WaitingDialogThread(AppBroker.getInstance().getWatergisApp(), true, "Mache Teilen R\u00fcckg\u00e4ngig", null, 100){

            protected Object doInBackground() throws Exception {
                List bakStationList;
                List splitterList = (List)undoMap.get(service);
                if (splitterList != null && !splitterList.isEmpty()) {
                    for (int i = splitterList.size() - 1; i >= 0; --i) {
                        ((FeatureSplitter)splitterList.get(i)).undo();
                    }
                }
                undoMap.remove(service);
                List stationList = (List)undoStationMap.get(service);
                if (stationList != null && !stationList.isEmpty()) {
                    for (int i = stationList.size() - 1; i >= 0; --i) {
                        FgBaAndStations stations = (FgBaAndStations)stationList.get(i);
                        int[] stationArray = new int[stations.getStations().size()];
                        for (int index = 0; index < stations.getStations().size(); ++index) {
                            stationArray[index] = stations.getStations().get(index);
                        }
                        try {
                            SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new RecoverFgBaAfterSplit(stations.getFgBaId(), stationArray));
                            continue;
                        }
                        catch (ConnectionException ex) {
                            LOG.error((Object)"Error during undo process", (Throwable)ex);
                        }
                    }
                    undoStationMap.remove(service);
                }
                if ((bakStationList = (List)undoBakStationMap.get(service)) != null && !bakStationList.isEmpty()) {
                    for (int i = bakStationList.size() - 1; i >= 0; --i) {
                        FgBaAndStations stations = (FgBaAndStations)bakStationList.get(i);
                        int[] stationArray = new int[stations.getStations().size()];
                        for (int index = 0; index < stations.getStations().size(); ++index) {
                            stationArray[index] = stations.getStations().get(index);
                        }
                        try {
                            SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new RecoverFgBakAfterSplit(stations.getFgBaId(), stationArray));
                            continue;
                        }
                        catch (ConnectionException ex) {
                            LOG.error((Object)"Error during undo process", (Throwable)ex);
                        }
                    }
                    undoBakStationMap.remove(service);
                }
                return null;
            }
        };
        wdt.start();
    }

    public static void commit(AbstractFeatureService service) {
        List<FgBaAndStations> bakStationList;
        List<FgBaAndStations> stationList;
        List<FeatureSplitter> splitterList = undoMap.get(service);
        if (splitterList != null && !splitterList.isEmpty()) {
            for (FeatureSplitter splitter : splitterList) {
                splitter.unlockObjects();
            }
            undoMap.remove(service);
        }
        if ((stationList = undoStationMap.get(service)) != null && !stationList.isEmpty()) {
            undoStationMap.remove(service);
        }
        if ((bakStationList = undoBakStationMap.get(service)) != null && !bakStationList.isEmpty()) {
            undoBakStationMap.remove(service);
        }
    }

    private FeatureServiceFeature determineValidFeature() {
        List features = SelectionManager.getInstance().getSelectedFeatures();
        if (features != null && features.size() > 0) {
            for (Feature f : features) {
                if (f.getGeometry().getGeometryType().equalsIgnoreCase("POINT") || !(f instanceof FeatureServiceFeature)) continue;
                FeatureServiceFeature feature = (FeatureServiceFeature)f;
                AttributeTable table = AppBroker.getInstance().getWatergisApp().getAttributeTableByFeature(feature);
                if (table == null || !table.isProcessingModeActive()) continue;
                List selectedFeatures = table.getSelectedFeatures();
                for (FeatureServiceFeature sf : selectedFeatures) {
                    if (!sf.equals(feature) || !sf.isEditable()) continue;
                    return sf;
                }
                return feature;
            }
        } else {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(SplitAction.class, (String)"SplitAction.determineValidFeature().message"), NbBundle.getMessage(SplitAction.class, (String)"SplitAction.determineValidFeature().title"), 0);
        }
        return null;
    }

    private Feature getAttributeTableFeature(FeatureServiceFeature f) {
        List selectedFeatures;
        AttributeTable table = AppBroker.getInstance().getWatergisApp().getAttributeTableByFeature(f);
        if (table != null && ((FeatureServiceFeature)(selectedFeatures = table.getSelectedFeatures()).get(0)).equals(f)) {
            return (Feature)selectedFeatures.get(0);
        }
        return f;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    private class FgBaAndStations {
        private List<Integer> stations;
        private int fgBaId;

        public FgBaAndStations(List<Integer> stations, int fgBaId) {
            this.stations = stations;
            this.fgBaId = fgBaId;
        }

        public List<Integer> getStations() {
            return this.stations;
        }

        public int getFgBaId() {
            return this.fgBaId;
        }
    }

    private class SplitFinishedListener
    implements GeometryFinishedListener {
        private final MappingComponent mc;
        private final String oldInteractionMode;
        private final FeatureServiceFeature validFeature;

        public SplitFinishedListener(MappingComponent mc, String oldInteractionMode, FeatureServiceFeature validFeature) {
            this.mc = mc;
            this.oldInteractionMode = oldInteractionMode;
            this.validFeature = validFeature;
        }

        public void geometryFinished(final Geometry g) {
            WaitingDialogThread<Feature[]> wdt = new WaitingDialogThread<Feature[]>((Frame)AppBroker.getInstance().getWatergisApp(), true, "Teile", null, 500){

                protected Feature[] doInBackground() throws Exception {
                    Feature[] newFeatures;
                    SplitFinishedListener.this.mc.setInteractionMode(SplitFinishedListener.this.oldInteractionMode);
                    FeatureSplitterFactory factory = new FeatureSplitterFactory();
                    FeatureSplitter splitter = factory.getFeatureMergerForFeature((Feature)SplitFinishedListener.this.validFeature);
                    if (splitter != null && (newFeatures = splitter.split((Feature)SplitFinishedListener.this.validFeature, (LineString)g)) != null && newFeatures.length > 0) {
                        AttributeTableRuleSet ruleSet = this.getRuleSet((Feature)SplitFinishedListener.this.validFeature);
                        int progress = 0;
                        this.wd.setMax(newFeatures.length + 1 + splitter.getAdditionalFeaturesToSave().size());
                        if (splitter.getAdditionalFeaturesToSave().size() > 0 && SplitFinishedListener.this.validFeature.getLayerProperties() != null && SplitFinishedListener.this.validFeature.getLayerProperties().getFeatureService() != null) {
                            Object list = (List)undoMap.get(SplitFinishedListener.this.validFeature.getLayerProperties().getFeatureService());
                            if (list == null) {
                                list = new ArrayList();
                                undoMap.put(SplitFinishedListener.this.validFeature.getLayerProperties().getFeatureService(), list);
                            }
                            list.add(splitter);
                        }
                        for (Object newFeature : newFeatures) {
                            if (newFeature instanceof ModifiableFeature) {
                                if (newFeature instanceof DefaultFeatureServiceFeature && ruleSet != null) {
                                    ruleSet.beforeSave((FeatureServiceFeature)((DefaultFeatureServiceFeature)newFeature));
                                }
                                try {
                                    ((ModifiableFeature)newFeature).saveChangesWithoutReload();
                                    AppBroker.getInstance().getWatergisApp().addFeatureToAttributeTable((FeatureServiceFeature)newFeature);
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"Splitted features saved");
                                    }
                                    this.wd.setProgress(++progress);
                                }
                                catch (Exception ex) {
                                    LOG.error((Object)"Error while saving changes", (Throwable)ex);
                                    this.wd.setProgress(++progress);
                                }
                                continue;
                            }
                            LOG.error((Object)"Feature is not modifiable");
                        }
                        for (FeatureServiceFeature newFeature : splitter.getAdditionalFeaturesToSave()) {
                            if (newFeature instanceof ModifiableFeature) {
                                AttributeTableRuleSet featureRuleSet = this.getRuleSet((Feature)newFeature);
                                if (newFeature instanceof DefaultFeatureServiceFeature && featureRuleSet != null) {
                                    featureRuleSet.beforeSave((FeatureServiceFeature)((DefaultFeatureServiceFeature)newFeature));
                                }
                                try {
                                    if (newFeature instanceof CidsLayerFeature) {
                                        ((CidsLayerFeature)newFeature).setId(-20);
                                    }
                                    ((ModifiableFeature)newFeature).saveChangesWithoutReload();
                                    if (LOG.isDebugEnabled()) {
                                        LOG.debug((Object)"Splitted features saved");
                                    }
                                    this.wd.setProgress(++progress);
                                }
                                catch (Exception ex) {
                                    LOG.error((Object)"Error while saving changes", (Throwable)ex);
                                    this.wd.setProgress(++progress);
                                }
                                continue;
                            }
                            LOG.error((Object)"Feature is not modifiable");
                        }
                        if (SplitFinishedListener.this.validFeature instanceof CidsLayerFeature && ((CidsLayerFeature)SplitFinishedListener.this.validFeature).getBean().getMetaObject().getMetaClass().getTableName().equalsIgnoreCase("dlm25w.fg_bak")) {
                            for (Object newFeature : newFeatures) {
                                ArrayList bakStationList;
                                List<Integer> bakClasses;
                                ArrayList stationList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new MoveFgBaAfterSplit(SplitFinishedListener.this.validFeature.getId(), ((FeatureWithId)newFeature).getId()));
                                List<Integer> classes = this.toIntegerList(stationList);
                                if (!classes.isEmpty() && SplitFinishedListener.this.validFeature.getLayerProperties() != null && SplitFinishedListener.this.validFeature.getLayerProperties().getFeatureService() != null) {
                                    ArrayList<FgBaAndStations> list = (ArrayList<FgBaAndStations>)undoStationMap.get(SplitFinishedListener.this.validFeature.getLayerProperties().getFeatureService());
                                    if (list == null) {
                                        list = new ArrayList<FgBaAndStations>();
                                        undoStationMap.put(SplitFinishedListener.this.validFeature.getLayerProperties().getFeatureService(), list);
                                    }
                                    list.add(new FgBaAndStations(classes, SplitFinishedListener.this.validFeature.getId()));
                                }
                                if ((bakClasses = this.toIntegerList(bakStationList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new MoveFgBakAfterSplit(SplitFinishedListener.this.validFeature.getId(), ((FeatureWithId)newFeature).getId())))).isEmpty() || SplitFinishedListener.this.validFeature.getLayerProperties() == null || SplitFinishedListener.this.validFeature.getLayerProperties().getFeatureService() == null) continue;
                                ArrayList<FgBaAndStations> list = (ArrayList<FgBaAndStations>)undoBakStationMap.get(SplitFinishedListener.this.validFeature.getLayerProperties().getFeatureService());
                                if (list == null) {
                                    list = new ArrayList<FgBaAndStations>();
                                    undoBakStationMap.put(SplitFinishedListener.this.validFeature.getLayerProperties().getFeatureService(), list);
                                }
                                list.add(new FgBaAndStations(bakClasses, SplitFinishedListener.this.validFeature.getId()));
                            }
                        }
                        if (SplitFinishedListener.this.validFeature instanceof ModifiableFeature) {
                            try {
                                if (ruleSet != null) {
                                    ruleSet.beforeSave(SplitFinishedListener.this.validFeature);
                                }
                                if (SplitFinishedListener.this.validFeature instanceof CidsLayerFeature) {
                                    ((CidsLayerFeature)SplitFinishedListener.this.validFeature).setDoNotChangeBackup(true);
                                }
                                ((ModifiableFeature)SplitFinishedListener.this.validFeature).saveChangesWithoutReload();
                                SplitFinishedListener.this.validFeature.setEditable(false);
                                SplitFinishedListener.this.validFeature.setEditable(true);
                                if (SplitFinishedListener.this.validFeature instanceof CidsLayerFeature) {
                                    ((CidsLayerFeature)SplitFinishedListener.this.validFeature).setDoNotChangeBackup(false);
                                }
                                this.wd.setProgress(++progress);
                            }
                            catch (Exception ex) {
                                LOG.error((Object)"Error while saving changes", (Throwable)ex);
                            }
                        }
                        AppBroker.getInstance().getMappingComponent().refresh();
                        return newFeatures;
                    }
                    return null;
                }

                private List<Integer> toIntegerList(ArrayList<ArrayList> stationList) {
                    ArrayList<Integer> classes = new ArrayList<Integer>();
                    if (stationList != null && !stationList.isEmpty()) {
                        for (int i = 0; i < stationList.size(); ++i) {
                            ArrayList innerList = stationList.get(i);
                            if (innerList == null || innerList.isEmpty()) continue;
                            classes.add((Integer)innerList.get(0));
                        }
                    }
                    return classes;
                }

                private AttributeTableRuleSet getRuleSet(Feature f) {
                    DefaultFeatureServiceFeature dfsf;
                    if (f instanceof DefaultFeatureServiceFeature && (dfsf = (DefaultFeatureServiceFeature)f).getLayerProperties() != null && dfsf.getLayerProperties().getAttributeTableRuleSet() != null) {
                        return dfsf.getLayerProperties().getAttributeTableRuleSet();
                    }
                    return null;
                }

                protected void done() {
                    try {
                        Feature[] newFeatures = (Feature[])this.get();
                        if (newFeatures != null && SplitFinishedListener.this.validFeature instanceof FeatureServiceFeature) {
                            SplitFinishedListener.this.validFeature.getLayerProperties().getFeatureService().retrieve(true);
                            SelectionManager.getInstance().addSelectedFeatures(Arrays.asList(newFeatures));
                            SelectionManager.getInstance().addSelectedFeatures(Collections.nCopies(1, SplitFinishedListener.this.validFeature));
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error during split operation", (Throwable)e);
                    }
                }
            };
            wdt.start();
        }
    }
}

