/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.checks;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.custom.watergis.server.search.FgBakCount;
import de.cismet.cids.custom.watergis.server.search.FgBakIdsByFgBaIds;
import de.cismet.cids.custom.watergis.server.search.MergeBakAe;
import de.cismet.cids.custom.watergis.server.search.RemoveDuplicatedNodesFromFgBak;
import de.cismet.cids.custom.watergis.server.search.RouteProblemsCountAndClasses;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitDialog;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.checks.AbstractCheckAction;
import de.cismet.watergis.gui.actions.checks.AbstractCheckResult;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;

public class BasicRoutesCheckAction
extends AbstractCheckAction {
    private static final MetaClass BAK_AE_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_ae");
    private static final MetaClass BAK_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak");
    private static String QUERY_AE;
    private static String QUERY_FG_BAK_LENGTH;
    private static String QUERY_CROSSING_LINES;
    private static String QUERY_WITHOUT_BA_CD;
    private static String QUERY_DUPLICATED_BA_CD;
    private static String QUERY_PREFIX;
    private static String QUERY_PREFIX_ME_WW_GR_OTHER;
    private static final String CHECK_BASISROUTENWW_GR = "Pr\u00fcfungen->Basisrouten->ww_gr";
    private static final String CHECK_BASISROUTEN_PRAEFIX = "Pr\u00fcfungen->Basisrouten->Pr\u00e4fix";
    private static final String CHECK_BASISROUTEN_AUS_EINLEITUNG = "Pr\u00fcfungen->Basisrouten->Aus-/Einleitung";
    private static final String CHECK_BASISROUTEN_GEWAESSERCODE_MEHRFACH = "Pr\u00fcfungen->Basisrouten->Gew\u00e4ssercode_mehrfach";
    private static final String CHECK_BASISROUTEN_GEWAESSERCODE_FEHLT = "Pr\u00fcfungen->Basisrouten->Gew\u00e4ssercode_fehlt";
    private static final String CHECK_BASISROUTEN_GEWAESSER_SCHNEIDEND = "Pr\u00fcfungen->Basisrouten->Gew\u00e4sser_schneidend";
    private static final String CHECK_BASISROUTEN_GEWAESSER_ZU_KURZ = "Pr\u00fcfungen->Basisrouten->Gew\u00e4sser_zu_kurz";
    private static final String[] ALL_CHECKS;
    private static final int[] USED_CLASS_IDS;
    private boolean successful = true;

    public BasicRoutesCheckAction() {
        this(false);
    }

    public BasicRoutesCheckAction(boolean isBackgroundCheck) {
        super(isBackgroundCheck);
        String tooltip = NbBundle.getMessage(BasicRoutesCheckAction.class, (String)"BasicRoutesCheckAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(BasicRoutesCheckAction.class, (String)"BasicRoutesCheckAction.text");
        this.putValue("Name", text);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-zoom.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public int getProgressSteps() {
        return 9;
    }

    @Override
    public boolean startCheckInternal(final boolean isExport, WaitDialog wd, List<H2FeatureService> result) {
        if (isExport) {
            try {
                CheckResult cr = this.check(isExport, wd);
                if (result != null) {
                    this.addService(result, cr.getAusEinleitungService());
                    this.addService(result, cr.getCrossedService());
                    this.addService(result, cr.getMissingCodeService());
                    this.addService(result, cr.getNotUniqueCodeService());
                    this.addService(result, cr.getPrefixService());
                    this.addService(result, cr.getShortService());
                    this.addService(result, cr.getWwGrService());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while performing check", (Throwable)e);
                return false;
            }
            return true;
        }
        WaitingDialogThread<CheckResult> wdt = new WaitingDialogThread<CheckResult>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, NbBundle.getMessage(BasicRoutesCheckAction.class, (String)"BasicRoutesCheckAction.actionPerformed().dialog"), null, 100){

            protected CheckResult doInBackground() throws Exception {
                this.wd.setMax(BasicRoutesCheckAction.this.getProgressSteps());
                return BasicRoutesCheckAction.this.check(isExport, this.wd);
            }

            protected void done() {
                try {
                    CheckResult result = (CheckResult)this.get();
                    BasicRoutesCheckAction.this.removeServicesFromLayerModel(ALL_CHECKS);
                    if (isExport) {
                        return;
                    }
                    if (result.getProblemTreeObjectCount() == null || result.getProblemTreeObjectCount().getCount() == 0) {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(BasicRoutesCheckAction.class, (String)"BasicRoutesCheckAction.actionPerformed().result.text.withoutProblems", (Object[])new Object[]{result.getBakCount(), result.getShortErrors(), result.getCrossedErrors(), result.getMissingCodeErrors(), result.getNotUniqueCodeErrors(), result.getAusEinleitungErrors(), result.getPrefixErrors(), result.getWwGrErrors(), 0}), NbBundle.getMessage(BasicRoutesCheckAction.class, (String)"BasicRoutesCheckAction.actionPerformed().result.title"), 1);
                    } else {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(BasicRoutesCheckAction.class, (String)"BasicRoutesCheckAction.actionPerformed().result.text", (Object[])new Object[]{result.getBakCount(), result.getShortErrors(), result.getCrossedErrors(), result.getMissingCodeErrors(), result.getNotUniqueCodeErrors(), result.getAusEinleitungErrors(), result.getPrefixErrors(), result.getWwGrErrors(), result.getProblemTreeObjectCount().getCount(), result.getProblemTreeObjectCount().getClasses()}), NbBundle.getMessage(BasicRoutesCheckAction.class, (String)"BasicRoutesCheckAction.actionPerformed().result.title"), 1);
                    }
                    if (result.getWwGrService() != null) {
                        BasicRoutesCheckAction.this.showService(result.getWwGrService(), "Pr\u00fcfungen->Basisrouten");
                    }
                    if (result.getPrefixService() != null) {
                        BasicRoutesCheckAction.this.showService(result.getPrefixService(), "Pr\u00fcfungen->Basisrouten");
                    }
                    if (result.getAusEinleitungService() != null) {
                        BasicRoutesCheckAction.this.showService(result.getAusEinleitungService(), "Pr\u00fcfungen->Basisrouten");
                    }
                    if (result.getNotUniqueCodeService() != null) {
                        BasicRoutesCheckAction.this.showService(result.getNotUniqueCodeService(), "Pr\u00fcfungen->Basisrouten");
                    }
                    if (result.getMissingCodeService() != null) {
                        BasicRoutesCheckAction.this.showService(result.getMissingCodeService(), "Pr\u00fcfungen->Basisrouten");
                    }
                    if (result.getCrossedService() != null) {
                        BasicRoutesCheckAction.this.showService(result.getCrossedService(), "Pr\u00fcfungen->Basisrouten");
                    }
                    if (result.getShortService() != null) {
                        BasicRoutesCheckAction.this.showService(result.getShortService(), "Pr\u00fcfungen->Basisrouten");
                    }
                    BasicRoutesCheckAction.this.refreshTree();
                    BasicRoutesCheckAction.this.refreshMap();
                }
                catch (Exception e) {
                    AbstractCheckAction.LOG.error((Object)"Error while performing the route analyse.", (Throwable)e);
                    BasicRoutesCheckAction.this.successful = false;
                }
            }
        };
        wdt.start();
        return this.successful;
    }

    @Override
    protected CheckResult check(boolean isExport, WaitDialog wd) throws Exception {
        ArrayList innerList;
        CheckResult result = new CheckResult();
        String user = AppBroker.getInstance().getOwner();
        int[] selectedIds = null;
        if (user.equalsIgnoreCase("Administratoren")) {
            user = null;
        }
        this.removeServicesFromDb(ALL_CHECKS);
        if (!this.isBackgroundCheck) {
            if (isExport) {
                ArrayList innerList2;
                ArrayList countList;
                if (user == null && (countList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new FgBakIdsByFgBaIds(this.getIdsOfSelectedObjects("fg_ba")))) != null && !countList.isEmpty() && (innerList2 = (ArrayList)countList.get(0)) != null && !innerList2.isEmpty()) {
                    selectedIds = new int[innerList2.size()];
                    int index = -1;
                    for (Object tmp : innerList2) {
                        selectedIds[++index] = ((Number)tmp).intValue();
                    }
                }
            } else {
                selectedIds = this.getIdsOfSelectedObjects("fg_bak");
            }
        }
        MergeBakAe search = new MergeBakAe(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)search);
        this.increaseProgress(wd, 1);
        RemoveDuplicatedNodesFromFgBak nodesSearch = new RemoveDuplicatedNodesFromFgBak(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)nodesSearch);
        this.increaseProgress(wd, 1);
        boolean useExpCond = user != null;
        String expCondition = isExport && useExpCond ? " exists(select id from dlm25w.fg_ba_exp_complete where owner = '" + user + "' and bak_id = bak.id)" : "false";
        String query = useExpCond ? String.format(QUERY_FG_BAK_LENGTH, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_FG_BAK_LENGTH, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setShortService(this.analyseByQuery(BAK_MC, query, CHECK_BASISROUTEN_GEWAESSER_ZU_KURZ));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_CROSSING_LINES, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_CROSSING_LINES, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setCrossedService(this.analyseByQuery(BAK_MC, query, CHECK_BASISROUTEN_GEWAESSER_SCHNEIDEND));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_WITHOUT_BA_CD, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_WITHOUT_BA_CD, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setMissingCodeService(this.analyseByQuery(BAK_MC, query, CHECK_BASISROUTEN_GEWAESSERCODE_FEHLT));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_DUPLICATED_BA_CD, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_DUPLICATED_BA_CD, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setNotUniqueCodeService(this.analyseByQuery(BAK_MC, query, CHECK_BASISROUTEN_GEWAESSERCODE_MEHRFACH));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_AE, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_AE, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setAusEinleitungService(this.analyseByQuery(BAK_AE_MC, query, CHECK_BASISROUTEN_AUS_EINLEITUNG));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_PREFIX, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_PREFIX, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setPrefixService(this.analyseByQuery(BAK_MC, query, CHECK_BASISROUTEN_PRAEFIX));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_PREFIX_ME_WW_GR_OTHER, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_PREFIX_ME_WW_GR_OTHER, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setWwGrService(this.analyseByQuery(BAK_MC, query, CHECK_BASISROUTENWW_GR));
        this.increaseProgress(wd, 1);
        ArrayList countList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new FgBakCount(user, null, selectedIds));
        if (countList != null && !countList.isEmpty() && (innerList = (ArrayList)countList.get(0)) != null && !innerList.isEmpty() && innerList.get(0) instanceof Number) {
            result.setBakCount(((Number)innerList.get(0)).intValue());
        }
        String owner = null;
        if (!AppBroker.getInstance().getOwner().equalsIgnoreCase("administratoren")) {
            owner = AppBroker.getInstance().getOwner();
        }
        ArrayList problemCountList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new RouteProblemsCountAndClasses(owner, selectedIds, USED_CLASS_IDS, true, isExport));
        String count = null;
        ArrayList<String> classes = new ArrayList<String>();
        if (problemCountList != null && !problemCountList.isEmpty()) {
            ArrayList innerList3;
            for (int i = 0; i < problemCountList.size() - 1; ++i) {
                innerList3 = (ArrayList)problemCountList.get(i);
                if (innerList3 == null || innerList3.isEmpty()) continue;
                classes.add((String)innerList3.get(0));
            }
            innerList3 = (ArrayList)problemCountList.get(problemCountList.size() - 1);
            if (innerList3 != null && !innerList3.isEmpty()) {
                count = (String)innerList3.get(0);
            }
        }
        if (count != null) {
            AbstractCheckAction.ProblemCountAndClasses problems = new AbstractCheckAction.ProblemCountAndClasses(count, classes.toArray(new String[classes.size()]));
            result.setErrorTree(problems);
        }
        if (result.getAusEinleitungService() != null) {
            result.setAusEinleitungErrors(result.getAusEinleitungService().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getCrossedService() != null) {
            result.setCrossedErrors(result.getCrossedService().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getMissingCodeService() != null) {
            result.setMissingCodeErrors(result.getMissingCodeService().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getNotUniqueCodeService() != null) {
            result.setNotUniqueCodeErrors(result.getNotUniqueCodeService().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getPrefixService() != null) {
            result.setPrefixErrors(result.getPrefixService().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getShortService() != null) {
            result.setShortErrors(result.getShortService().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getWwGrService() != null) {
            result.setWwGrErrors(result.getWwGrService().getFeatureCount(null));
            this.successful = false;
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    static {
        ALL_CHECKS = new String[]{CHECK_BASISROUTENWW_GR, CHECK_BASISROUTEN_PRAEFIX, CHECK_BASISROUTEN_AUS_EINLEITUNG, CHECK_BASISROUTEN_GEWAESSERCODE_MEHRFACH, CHECK_BASISROUTEN_GEWAESSERCODE_FEHLT, CHECK_BASISROUTEN_GEWAESSER_SCHNEIDEND, CHECK_BASISROUTEN_GEWAESSER_ZU_KURZ};
        USED_CLASS_IDS = new int[]{BAK_AE_MC != null ? BAK_AE_MC.getId() : -1};
        if (BAK_AE_MC != null && BAK_MC != null) {
            User user = SessionManager.getSession().getUser();
            QUERY_FG_BAK_LENGTH = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + BAK_MC.getID() + ", bak." + BAK_MC.getPrimaryKey() + " from dlm25w.fg_bak bak \njoin geom g on (bak.geom = g.id) \nwhere (%1$s is null or bak.id = any(%1$s)) and st_length(geo_field) < 0.5" : "select " + BAK_MC.getID() + ", bak." + BAK_MC.getPrimaryKey() + " from dlm25w.fg_bak bak \njoin geom g on (bak.geom = g.id) \njoin dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or bak.id = any(%1$s)) and st_length(geo_field) < 0.5 and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_CROSSING_LINES = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + BAK_MC.getID() + ", bak." + BAK_MC.getPrimaryKey() + " from dlm25w.fg_bak bak \njoin geom g on (bak.geom = g.id) \nwhere (%1$s is null or bak.id = any(%1$s)) and not dlm25w.check_for_crossed_lines(geo_field)" : "select " + BAK_MC.getID() + ", bak." + BAK_MC.getPrimaryKey() + " from dlm25w.fg_bak bak \njoin geom g on (bak.geom = g.id) \njoin dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or bak.id = any(%1$s)) and not dlm25w.check_for_crossed_lines(geo_field) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_WITHOUT_BA_CD = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + BAK_MC.getID() + ", bak." + BAK_MC.getPrimaryKey() + " from dlm25w.fg_bak bak \nwhere (%1$s is null or bak.id = any(%1$s)) and ba_cd is null OR ba_cd = ''" : "select " + BAK_MC.getID() + ", bak." + BAK_MC.getPrimaryKey() + " from dlm25w.fg_bak bak \njoin dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or bak.id = any(%1$s)) and (ba_cd is null OR ba_cd = '') and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_DUPLICATED_BA_CD = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + BAK_MC.getID() + ", bak." + BAK_MC.getPrimaryKey() + " from dlm25w.fg_bak bak \nwhere (%1$s is null or bak.id = any(%1$s)) and ba_cd in (select ba_cd from dlm25w.fg_bak group by ba_cd having count(ba_cd) > 1)" : "select " + BAK_MC.getID() + ", bak." + BAK_MC.getPrimaryKey() + " from dlm25w.fg_bak bak \njoin dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or bak.id = any(%1$s)) and ba_cd in (select ba_cd from dlm25w.fg_bak group by ba_cd having count(ba_cd) > 1) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_PREFIX = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + BAK_MC.getID() + ", bak." + BAK_MC.getPrimaryKey() + " from dlm25w.fg_bak bak \nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or bak.id = any(%1$s)) and (bak.ww_gr is null or substr(ba_cd, 1, length(gr.praefix) + 1) <>  (gr.praefix || ':'))" : "select " + BAK_MC.getID() + ", bak." + BAK_MC.getPrimaryKey() + " from dlm25w.fg_bak bak \nleft join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or bak.id = any(%1$s)) and (bak.ww_gr is null or  substr(ba_cd, 1, length(gr.praefix) + 1) <>  (gr.praefix || ':')) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_PREFIX_ME_WW_GR_OTHER = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + BAK_MC.getID() + ", bak." + BAK_MC.getPrimaryKey() + " from dlm25w.fg_bak bak join dlm25w.k_ww_gr gr on (substr(ba_cd, 1, length(gr.praefix) + 1) = (gr.praefix || ':'))\nleft join dlm25w.k_ww_gr gr1 on (bak.ww_gr = gr1.id)\nwhere (%1$s is null or bak.id = any(%1$s)) and (gr1.praefix is null or substr(ba_cd, 1, length(gr1.praefix) + 1) <>  (gr1.praefix || ':'))" : "select " + BAK_MC.getID() + ", bak." + BAK_MC.getPrimaryKey() + " from dlm25w.fg_bak bak join dlm25w.k_ww_gr gr on (substr(ba_cd, 1, length(gr.praefix) + 1) = (gr.praefix || ':'))\nleft join dlm25w.k_ww_gr gr1 on (bak.ww_gr = gr1.id)\nwhere (%1$s is null or bak.id = any(%1$s)) and (gr1.praefix is null or substr(ba_cd, 1, length(gr1.praefix) + 1) <>  (gr1.praefix || ':'))and (gr1.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_AE = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + BAK_AE_MC.getID() + ", ae." + BAK_AE_MC.getPrimaryKey() + " from dlm25w.fg_bak_ae ae \njoin dlm25w.fg_bak_linie linie on (ae.bak_st = linie.id) \njoin dlm25w.fg_bak_punkt von on (linie.von = von.id)\njoin dlm25w.fg_bak_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_bak bak on (von.route = bak.id) \njoin geom on (bak.geom = geom.id) \nwhere (%1$s is null or bak.id = any(%1$s)) and \n(von.wert > 0.05 and abs(bis.wert - st_length(geo_field)) >= 0.05)" : "select " + BAK_AE_MC.getID() + ", ae." + BAK_AE_MC.getPrimaryKey() + " from dlm25w.fg_bak_ae ae \njoin dlm25w.fg_bak_linie linie on (ae.bak_st = linie.id) \njoin dlm25w.fg_bak_punkt von on (linie.von = von.id)\njoin dlm25w.fg_bak_punkt bis on (linie.bis = bis.id)\njoin dlm25w.fg_bak bak on (von.route = bak.id) \nleft join dlm25w.k_ww_gr gr1 on (bak.ww_gr = gr1.id)\njoin geom on (bak.geom = geom.id) \nwhere (%1$s is null or bak.id = any(%1$s)) and \n(von.wert > 0.05 and abs(bis.wert - st_length(geo_field)) >= 0.05)and (gr1.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
        }
    }

    protected static class CheckResult
    extends AbstractCheckResult {
        private static final String[] CHECK_NAMES = new String[]{"SHORT", "CROSSED", "MISSING_CODE", "NOT_UNIQUE", "AUS_EINLEITUNG", "PREFIX", "WW_GR"};
        private int shortErrors;
        private int crossedErrors;
        private int missingCodeErrors;
        private int notUniqueCodeErrors;
        private int ausEinleitungErrors;
        private int prefixErrors;
        private int wwGrErrors;
        private AbstractCheckAction.ProblemCountAndClasses errorTree;
        private int bakCount;
        private H2FeatureService shortService;
        private H2FeatureService crossedService;
        private H2FeatureService missingCodeService;
        private H2FeatureService notUniqueCodeService;
        private H2FeatureService ausEinleitungService;
        private H2FeatureService prefixService;
        private H2FeatureService wwGrService;

        protected CheckResult() {
        }

        public int getShortErrors() {
            return this.shortErrors;
        }

        public void setShortErrors(int shortErrors) {
            this.shortErrors = shortErrors;
        }

        public int getCrossedErrors() {
            return this.crossedErrors;
        }

        public void setCrossedErrors(int crossedErrors) {
            this.crossedErrors = crossedErrors;
        }

        public int getMissingCodeErrors() {
            return this.missingCodeErrors;
        }

        public void setMissingCodeErrors(int missingCodeErrors) {
            this.missingCodeErrors = missingCodeErrors;
        }

        public int getNotUniqueCodeErrors() {
            return this.notUniqueCodeErrors;
        }

        public void setNotUniqueCodeErrors(int notUniqueCodeErrors) {
            this.notUniqueCodeErrors = notUniqueCodeErrors;
        }

        public int getAusEinleitungErrors() {
            return this.ausEinleitungErrors;
        }

        public void setAusEinleitungErrors(int ausEinleitungErrors) {
            this.ausEinleitungErrors = ausEinleitungErrors;
        }

        public int getPrefixErrors() {
            return this.prefixErrors;
        }

        public void setPrefixErrors(int prefixErrors) {
            this.prefixErrors = prefixErrors;
        }

        public int getWwGrErrors() {
            return this.wwGrErrors;
        }

        public void setWwGrErrors(int wwGrErrors) {
            this.wwGrErrors = wwGrErrors;
        }

        @Override
        public AbstractCheckAction.ProblemCountAndClasses getProblemTreeObjectCount() {
            return this.errorTree;
        }

        public void setErrorTree(AbstractCheckAction.ProblemCountAndClasses errorTree) {
            this.errorTree = errorTree;
        }

        public int getBakCount() {
            return this.bakCount;
        }

        public void setBakCount(int bakCount) {
            this.bakCount = bakCount;
        }

        public H2FeatureService getShortService() {
            return this.shortService;
        }

        public void setShortService(H2FeatureService shortService) {
            this.shortService = shortService;
        }

        public H2FeatureService getCrossedService() {
            return this.crossedService;
        }

        public void setCrossedService(H2FeatureService crossedService) {
            this.crossedService = crossedService;
        }

        public H2FeatureService getMissingCodeService() {
            return this.missingCodeService;
        }

        public void setMissingCodeService(H2FeatureService missingCodeService) {
            this.missingCodeService = missingCodeService;
        }

        public H2FeatureService getNotUniqueCodeService() {
            return this.notUniqueCodeService;
        }

        public void setNotUniqueCodeService(H2FeatureService notUniqueCodeService) {
            this.notUniqueCodeService = notUniqueCodeService;
        }

        public H2FeatureService getAusEinleitungService() {
            return this.ausEinleitungService;
        }

        public void setAusEinleitungService(H2FeatureService ausEinleitungService) {
            this.ausEinleitungService = ausEinleitungService;
        }

        public H2FeatureService getPrefixService() {
            return this.prefixService;
        }

        public void setPrefixService(H2FeatureService prefixService) {
            this.prefixService = prefixService;
        }

        public H2FeatureService getWwGrService() {
            return this.wwGrService;
        }

        public void setWwGrService(H2FeatureService wwGrService) {
            this.wwGrService = wwGrService;
        }

        @Override
        public String[] getCheckNames() {
            return CHECK_NAMES;
        }

        @Override
        public int getErrorsPerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.shortErrors;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.crossedErrors;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.missingCodeErrors;
            }
            if (checkName.equals(CHECK_NAMES[3])) {
                return this.notUniqueCodeErrors;
            }
            if (checkName.equals(CHECK_NAMES[4])) {
                return this.ausEinleitungErrors;
            }
            if (checkName.equals(CHECK_NAMES[5])) {
                return this.prefixErrors;
            }
            if (checkName.equals(CHECK_NAMES[6])) {
                return this.wwGrErrors;
            }
            return 0;
        }

        @Override
        public H2FeatureService getErrorTablePerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.shortService;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.crossedService;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.missingCodeService;
            }
            if (checkName.equals(CHECK_NAMES[3])) {
                return this.notUniqueCodeService;
            }
            if (checkName.equals(CHECK_NAMES[4])) {
                return this.ausEinleitungService;
            }
            if (checkName.equals(CHECK_NAMES[5])) {
                return this.prefixService;
            }
            if (checkName.equals(CHECK_NAMES[6])) {
                return this.wwGrService;
            }
            return null;
        }
    }
}

