/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.checks;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.BakWithIncompleteGbkCoverage;
import de.cismet.cids.custom.watergis.server.search.FgBakCount;
import de.cismet.cids.custom.watergis.server.search.GbkInIncorrectEzg;
import de.cismet.cids.custom.watergis.server.search.GwkLaCdFailure;
import de.cismet.cids.custom.watergis.server.search.MergeBaGbkDelta;
import de.cismet.cids.custom.watergis.server.search.MergeBakGbk;
import de.cismet.cids.custom.watergis.server.search.MergeBakGn;
import de.cismet.cids.custom.watergis.server.search.MergeFgBakGwk;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitDialog;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.checks.AbstractCheckAction;
import de.cismet.watergis.gui.actions.checks.AbstractCheckResult;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;

public class LawaCheckAction
extends AbstractCheckAction {
    private static final MetaClass FG_BAK = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak");
    private static final MetaClass FG_BAK_GBK = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gbk");
    private static final MetaClass FG_BA_GBK_DELTA = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_gbk_delta");
    private static final MetaClass FG_BAK_GWK = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gwk");
    private static final MetaClass FG_BAK_GN1 = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gn1");
    private static final MetaClass FG_BAK_GN2 = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gn2");
    private static final MetaClass FG_BAK_GN3 = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gn3");
    private static String QUERY_GBK_CATALOGUE;
    private static String QUERY_GWK_CATALOGUE;
    private static final String CHECKEZG_DELTA_GBK = "Pr\u00fcfungen->LAWA-Schl\u00fcssel->fg_bak_gbk vs EZG";
    private static final String CHECK_GWK_DELTA_GWK = "Pr\u00fcfungen->LAWA-Schl\u00fcssel->fg_bak_gwk mit Delta GWK/GBK";
    private static final String CHECK_GBK_CAT_GWK = "Pr\u00fcfungen->LAWA-Schl\u00fcssel->fg_bak_gwk mit Katalogfehler k_gwk_lawa";
    private static final String CHECK_GBK_CAT_LAWA = "Pr\u00fcfungen->LAWA-Schl\u00fcssel->fg_bak_gbk mit Katalogfehler k_gbk_lawa";
    private static final String CHECK_BAK_OHNE_GBK = "Pr\u00fcfungen->LAWA-Schl\u00fcssel->fg_bak ohne fg_bak_gbk";
    private static final String[] ALL_CHECKS;
    private static final int[] USED_CLASS_IDS;
    private boolean successful = true;

    public LawaCheckAction() {
        this(false);
    }

    public LawaCheckAction(boolean isBackgroundCheck) {
        super(isBackgroundCheck);
        String tooltip = NbBundle.getMessage(LawaCheckAction.class, (String)"LawaCheckAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(LawaCheckAction.class, (String)"LawaCheckAction.text");
        this.putValue("Name", text);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-forkcms.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public int getProgressSteps() {
        return 10;
    }

    @Override
    public boolean startCheckInternal(final boolean isExport, WaitDialog wd, List<H2FeatureService> result) {
        WaitingDialogThread<CheckResult> wdt = new WaitingDialogThread<CheckResult>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, NbBundle.getMessage(LawaCheckAction.class, (String)"LawaCheckAction.actionPerformed().dialog"), null, 100){

            protected CheckResult doInBackground() throws Exception {
                this.wd.setMax(LawaCheckAction.this.getProgressSteps());
                return LawaCheckAction.this.check(isExport, this.wd);
            }

            protected void done() {
                try {
                    CheckResult result = (CheckResult)this.get();
                    LawaCheckAction.this.removeServicesFromLayerModel(ALL_CHECKS);
                    if (isExport) {
                        return;
                    }
                    if (result.getProblemTreeObjectCount() == null || result.getProblemTreeObjectCount().getCount() == 0) {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(LawaCheckAction.class, (String)"LawaCheckAction.actionPerformed().result.text.withoutProblems", (Object[])new Object[]{result.getBakCount(), result.getFgBakWithoutGbkErrors(), result.getGbkCatErrors(), result.getGwkCatErrors(), result.getGwkGbkErrors(), result.getGbkInIncorrectEzgErrors(), 0}), NbBundle.getMessage(LawaCheckAction.class, (String)"LawaCheckAction.actionPerformed().result.title"), 1);
                    } else {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(LawaCheckAction.class, (String)"LawaCheckAction.actionPerformed().result.text", (Object[])new Object[]{result.getBakCount(), result.getFgBakWithoutGbkErrors(), result.getGbkCatErrors(), result.getGwkCatErrors(), result.getGwkGbkErrors(), result.getGbkInIncorrectEzgErrors(), result.getProblemTreeObjectCount().getCount(), result.getProblemTreeObjectCount().getClasses()}), NbBundle.getMessage(LawaCheckAction.class, (String)"LawaCheckAction.actionPerformed().result.title"), 1);
                    }
                    if (result.getGbkInIncorrectEzg() != null) {
                        LawaCheckAction.this.showService(result.getGbkInIncorrectEzg(), "Pr\u00fcfungen->LAWA-Schl\u00fcssel");
                    }
                    if (result.getGwkGbk() != null) {
                        LawaCheckAction.this.showService(result.getGwkGbk(), "Pr\u00fcfungen->LAWA-Schl\u00fcssel");
                    }
                    if (result.getGwkCat() != null) {
                        LawaCheckAction.this.showService(result.getGwkCat(), "Pr\u00fcfungen->LAWA-Schl\u00fcssel");
                    }
                    if (result.getGbkCat() != null) {
                        LawaCheckAction.this.showService(result.getGbkCat(), "Pr\u00fcfungen->LAWA-Schl\u00fcssel");
                    }
                    if (result.getFgBakWithoutGbk() != null) {
                        LawaCheckAction.this.showService(result.getFgBakWithoutGbk(), "Pr\u00fcfungen->LAWA-Schl\u00fcssel");
                    }
                    LawaCheckAction.this.refreshTree();
                    LawaCheckAction.this.refreshMap();
                }
                catch (Exception e) {
                    AbstractCheckAction.LOG.error((Object)"Error while performing the lawa analyse.", (Throwable)e);
                    LawaCheckAction.this.successful = false;
                }
            }
        };
        wdt.start();
        return this.successful;
    }

    @Override
    protected CheckResult check(boolean isExport, WaitDialog wd) throws Exception {
        ArrayList innerList;
        CheckResult result = new CheckResult();
        String user = AppBroker.getInstance().getOwner();
        if (user.equalsIgnoreCase("Administratoren")) {
            user = null;
        }
        this.removeServicesFromDb(ALL_CHECKS);
        ArrayList countList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new FgBakCount(user, null, null));
        if (countList != null && !countList.isEmpty() && (innerList = (ArrayList)countList.get(0)) != null && !innerList.isEmpty() && innerList.get(0) instanceof Number) {
            result.setBakCount(((Number)innerList.get(0)).intValue());
        }
        this.increaseProgress(wd, 1);
        MergeFgBakGwk mergeGwk = new MergeFgBakGwk(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeGwk);
        this.increaseProgress(wd, 1);
        MergeBakGbk mergeGbk = new MergeBakGbk(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeGbk);
        this.increaseProgress(wd, 1);
        MergeBakGn mergeGn = new MergeBakGn(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeGn);
        this.increaseProgress(wd, 1);
        MergeBaGbkDelta mergeGbkDelta = new MergeBaGbkDelta(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeGbkDelta);
        this.increaseProgress(wd, 1);
        ArrayList<FeatureServiceAttribute> gbkServiceAttributeDefinition = new ArrayList<FeatureServiceAttribute>();
        FeatureServiceAttribute serviceAttribute = new FeatureServiceAttribute("id", String.valueOf(4), true);
        gbkServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("geom", String.valueOf(10012), true);
        gbkServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_cd", String.valueOf(12), true);
        gbkServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("bak_st_von", String.valueOf(8), true);
        gbkServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("bak_st_bis", String.valueOf(8), true);
        gbkServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("gbk_lawa", String.valueOf(12), true);
        gbkServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("laenge", String.valueOf(8), true);
        gbkServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_date", String.valueOf(93), true);
        gbkServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_user", String.valueOf(12), true);
        gbkServiceAttributeDefinition.add(serviceAttribute);
        result.setFgBakWithoutGbk(this.analyseByCustomSearch((CidsServerSearch)new BakWithIncompleteGbkCoverage(user, null, false), CHECK_BAK_OHNE_GBK, gbkServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setGbkCat(this.analyseByQuery(FG_BAK_GBK, QUERY_GBK_CATALOGUE, CHECK_GBK_CAT_LAWA));
        this.increaseProgress(wd, 1);
        result.setGwkCat(this.analyseByQuery(FG_BAK_GWK, QUERY_GWK_CATALOGUE, CHECK_GBK_CAT_GWK));
        this.increaseProgress(wd, 1);
        ArrayList<FeatureServiceAttribute> serviceAttributeDefinition = new ArrayList<FeatureServiceAttribute>();
        serviceAttribute = new FeatureServiceAttribute("id", String.valueOf(4), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("geom", String.valueOf(10012), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_cd", String.valueOf(12), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("bak_st_von", String.valueOf(8), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("bak_st_bis", String.valueOf(8), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("la_cd", String.valueOf(2), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("gbk_lawa", String.valueOf(2), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("laenge", String.valueOf(2), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_date", String.valueOf(93), true);
        serviceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_user", String.valueOf(12), true);
        serviceAttributeDefinition.add(serviceAttribute);
        result.setGwkGbk(this.analyseByCustomSearch((CidsServerSearch)new GwkLaCdFailure(user, null, false), CHECK_GWK_DELTA_GWK, serviceAttributeDefinition));
        this.increaseProgress(wd, 1);
        ArrayList<FeatureServiceAttribute> serviceAttributeDefinitionFgBa = new ArrayList<FeatureServiceAttribute>();
        serviceAttribute = new FeatureServiceAttribute("id", String.valueOf(4), true);
        serviceAttributeDefinitionFgBa.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("geom", String.valueOf(10012), true);
        serviceAttributeDefinitionFgBa.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_cd", String.valueOf(12), true);
        serviceAttributeDefinitionFgBa.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("bak_st_von", String.valueOf(8), true);
        serviceAttributeDefinitionFgBa.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("bak_st_bis", String.valueOf(8), true);
        serviceAttributeDefinitionFgBa.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ezg", String.valueOf(2), true);
        serviceAttributeDefinitionFgBa.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("gbk_lawa", String.valueOf(12), true);
        serviceAttributeDefinitionFgBa.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("laenge", String.valueOf(8), true);
        serviceAttributeDefinitionFgBa.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_date", String.valueOf(93), true);
        serviceAttributeDefinitionFgBa.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_user", String.valueOf(12), true);
        serviceAttributeDefinitionFgBa.add(serviceAttribute);
        result.setGbkInIncorrectEzg(this.analyseByCustomSearch((CidsServerSearch)new GbkInIncorrectEzg(user, null, false), CHECKEZG_DELTA_GBK, serviceAttributeDefinitionFgBa));
        this.increaseProgress(wd, 1);
        result.setProblemTreeObjectCount(this.getErrorObjectsFromTree(user, null, USED_CLASS_IDS, isExport));
        if (result.getFgBakWithoutGbk() != null) {
            result.setFgBakWithoutGbkErrors(result.getFgBakWithoutGbk().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getGbkCat() != null) {
            result.setGbkCatErrors(result.getGbkCat().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getGwkCat() != null) {
            result.setGwkCatErrors(result.getGwkCat().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getGwkGbk() != null) {
            result.setGwkGbkErrors(result.getGwkGbk().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getGbkInIncorrectEzg() != null) {
            result.setGbkInIncorrectEzgErrors(result.getGbkInIncorrectEzg().getFeatureCount(null));
            this.successful = false;
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    static {
        ALL_CHECKS = new String[]{CHECKEZG_DELTA_GBK, CHECK_GWK_DELTA_GWK, CHECK_GBK_CAT_GWK, CHECK_GBK_CAT_LAWA, CHECK_BAK_OHNE_GBK};
        USED_CLASS_IDS = new int[]{FG_BAK_GBK != null ? FG_BAK_GBK.getId() : -1, FG_BAK_GWK != null ? FG_BAK_GWK.getId() : -1, FG_BA_GBK_DELTA != null ? FG_BA_GBK_DELTA.getId() : -1, FG_BAK_GN1 != null ? FG_BAK_GN1.getId() : -1, FG_BAK_GN2 != null ? FG_BAK_GN2.getId() : -1, FG_BAK_GN3 != null ? FG_BAK_GN3.getId() : -1};
        if (FG_BAK_GBK != null && FG_BAK_GWK != null && FG_BAK != null) {
            User user = SessionManager.getSession().getUser();
            QUERY_GBK_CATALOGUE = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BAK_GBK.getID() + ", t." + FG_BAK_GBK.getPrimaryKey() + " from " + FG_BAK_GBK.getTableName() + " t\njoin dlm25w.fg_bak_linie linie on (bak_st = linie.id) join dlm25w.fg_bak_punkt von on (linie.von = von.id) join dlm25w.fg_bak bak on (von.route = bak.id) where not exists (select 1 from dlm25w.k_gbk_lawa where id = t.gbk_lawa)" : "select " + FG_BAK_GBK.getID() + ", t." + FG_BAK_GBK.getPrimaryKey() + " from " + FG_BAK_GBK.getTableName() + " t \njoin dlm25w.fg_bak_linie linie on (bak_st = linie.id) join dlm25w.fg_bak_punkt von on (linie.von = von.id) join dlm25w.fg_bak bak on (von.route = bak.id) join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere not exists (select 1 from dlm25w.k_gbk_lawa where id = t.gbk_lawa) and gr.owner = '" + user.getUserGroup().getName() + "'";
            QUERY_GWK_CATALOGUE = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select " + FG_BAK_GWK.getID() + ", t." + FG_BAK_GWK.getPrimaryKey() + " from " + FG_BAK_GWK.getTableName() + " t\njoin dlm25w.fg_bak_linie linie on (bak_st = linie.id) join dlm25w.fg_bak_punkt von on (linie.von = von.id) join dlm25w.fg_bak bak on (von.route = bak.id) where not exists (select 1 from dlm25w.k_gwk_lawa where id = t.la_cd)" : "select " + FG_BAK_GWK.getID() + ", t." + FG_BAK_GWK.getPrimaryKey() + " from " + FG_BAK_GWK.getTableName() + " t \njoin dlm25w.fg_bak_linie linie on (bak_st = linie.id) join dlm25w.fg_bak_punkt von on (linie.von = von.id) join dlm25w.fg_bak bak on (von.route = bak.id) join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere not exists (select 1 from dlm25w.k_gwk_lawa where id = t.la_cd) and gr.owner = '" + user.getUserGroup().getName() + "'";
        }
    }

    protected static class CheckResult
    extends AbstractCheckResult {
        private static final String[] CHECK_NAMES = new String[]{"FG_BAK_WITHOUT_GBK", "GBK_CAT", "GWK_CAT", "GWK_GBK", "GBK_IN_INCORRECT_EZG"};
        private int fgBakWithoutGbkErrors;
        private int gbkCatErrors;
        private int gwkCatErrors;
        private int gwkGbkErrors;
        private int bakCount;
        private int gbkInIncorrectEzgErrors;
        private AbstractCheckAction.ProblemCountAndClasses problemTreeObjectCount;
        private H2FeatureService fgBakWithoutGbk;
        private H2FeatureService gbkCat;
        private H2FeatureService gwkCat;
        private H2FeatureService gwkGbk;
        private H2FeatureService gbkInIncorrectEzg;

        protected CheckResult() {
        }

        @Override
        public AbstractCheckAction.ProblemCountAndClasses getProblemTreeObjectCount() {
            return this.problemTreeObjectCount;
        }

        public void setProblemTreeObjectCount(AbstractCheckAction.ProblemCountAndClasses problemTreeObjectCount) {
            this.problemTreeObjectCount = problemTreeObjectCount;
        }

        public int getFgBakWithoutGbkErrors() {
            return this.fgBakWithoutGbkErrors;
        }

        public void setFgBakWithoutGbkErrors(int fgBakWithoutGbkErrors) {
            this.fgBakWithoutGbkErrors = fgBakWithoutGbkErrors;
        }

        public H2FeatureService getFgBakWithoutGbk() {
            return this.fgBakWithoutGbk;
        }

        public void setFgBakWithoutGbk(H2FeatureService fgBakWithoutGbk) {
            this.fgBakWithoutGbk = fgBakWithoutGbk;
        }

        public int getGbkCatErrors() {
            return this.gbkCatErrors;
        }

        public void setGbkCatErrors(int gbkCatErrors) {
            this.gbkCatErrors = gbkCatErrors;
        }

        public int getGwkCatErrors() {
            return this.gwkCatErrors;
        }

        public void setGwkCatErrors(int gwkCatErrors) {
            this.gwkCatErrors = gwkCatErrors;
        }

        public H2FeatureService getGbkCat() {
            return this.gbkCat;
        }

        public void setGbkCat(H2FeatureService gbkCat) {
            this.gbkCat = gbkCat;
        }

        public H2FeatureService getGwkCat() {
            return this.gwkCat;
        }

        public void setGwkCat(H2FeatureService gwkCat) {
            this.gwkCat = gwkCat;
        }

        public int getGwkGbkErrors() {
            return this.gwkGbkErrors;
        }

        public void setGwkGbkErrors(int gwkGbkErrors) {
            this.gwkGbkErrors = gwkGbkErrors;
        }

        public H2FeatureService getGwkGbk() {
            return this.gwkGbk;
        }

        public void setGwkGbk(H2FeatureService gwkGbk) {
            this.gwkGbk = gwkGbk;
        }

        public int getBakCount() {
            return this.bakCount;
        }

        public void setBakCount(int bakCount) {
            this.bakCount = bakCount;
        }

        public int getGbkInIncorrectEzgErrors() {
            return this.gbkInIncorrectEzgErrors;
        }

        public void setGbkInIncorrectEzgErrors(int gbkInIncorrectEzgErrors) {
            this.gbkInIncorrectEzgErrors = gbkInIncorrectEzgErrors;
        }

        public H2FeatureService getGbkInIncorrectEzg() {
            return this.gbkInIncorrectEzg;
        }

        public void setGbkInIncorrectEzg(H2FeatureService gbkInIncorrectEzg) {
            this.gbkInIncorrectEzg = gbkInIncorrectEzg;
        }

        @Override
        public String[] getCheckNames() {
            return CHECK_NAMES;
        }

        @Override
        public int getErrorsPerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.fgBakWithoutGbkErrors;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.gbkCatErrors;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.gwkCatErrors;
            }
            if (checkName.equals(CHECK_NAMES[3])) {
                return this.gwkGbkErrors;
            }
            if (checkName.equals(CHECK_NAMES[4])) {
                return this.gbkInIncorrectEzgErrors;
            }
            return 0;
        }

        @Override
        public H2FeatureService getErrorTablePerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.fgBakWithoutGbk;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.gbkCat;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.gwkCat;
            }
            if (checkName.equals(CHECK_NAMES[3])) {
                return this.gwkGbk;
            }
            if (checkName.equals(CHECK_NAMES[4])) {
                return this.gbkInIncorrectEzg;
            }
            return null;
        }
    }
}

