/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.checks;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.helper.SQLFormatter;
import de.cismet.cids.custom.watergis.server.search.BakWithIncompleteGbCoverage;
import de.cismet.cids.custom.watergis.server.search.BakWithIncompleteGmdCoverage;
import de.cismet.cids.custom.watergis.server.search.BakWithIncompleteSbCoverage;
import de.cismet.cids.custom.watergis.server.search.DeleteInvalidFgBaExp;
import de.cismet.cids.custom.watergis.server.search.FgBakCount;
import de.cismet.cids.custom.watergis.server.search.MergeBaExp;
import de.cismet.cids.custom.watergis.server.search.MergeBaSb;
import de.cismet.cids.custom.watergis.server.search.OverlappedGb;
import de.cismet.cids.custom.watergis.server.search.OverlappedGmd;
import de.cismet.cids.custom.watergis.server.search.OverlappedSb;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitDialog;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.checks.AbstractCheckAction;
import de.cismet.watergis.gui.actions.checks.AbstractCheckResult;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import org.openide.util.NbBundle;

public class VerwaltungCheckAction
extends AbstractCheckAction {
    private static final MetaClass FG_BAK = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak");
    private static final MetaClass FG_BA_SB = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_sb");
    private static final MetaClass FG_BA_GB = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_gb");
    private static final MetaClass FG_BA_GMD = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_gmd");
    private static final MetaClass FG_BA_EXP = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_exp");
    private static String QUERY_GB_CATALOGUE;
    private static String QUERY_GMD_CATALOGUE;
    private static String QUERY_GB_STATUS;
    private static String QUERY_GMD_STATUS;
    private static String QUERY_SB_CATALOGUE;
    private static String QUERY_EXP;
    private static final String CHECK_VERWALTUNG_SB_UEBERLAPPUNG = "Pr\u00fcfungen->Verwaltung->SB->SB: \u00dcberlappung";
    private static final String CHECK_VERWALTUNG_GB_UEBERLAPPUNG = "Pr\u00fcfungen->Verwaltung->GB->GB: \u00dcberlappung";
    private static final String CHECK_VERWALTUNG_GMD_UEBERLAPPUNG = "Pr\u00fcfungen->Verwaltung->GMD->GMD: \u00dcberlappung";
    private static final String CHECK_VERWALTUNG_EXP_BELEGUNG = "Pr\u00fcfungen->Verwaltung->EXP->EXP: Belegung";
    private static final String CHECK_VERWALTUNG_SB_KATALOG = "Pr\u00fcfungen->Verwaltung->SB->SB: Katalog";
    private static final String CHECK_VERWALTUNG_GMD_KATALOG = "Pr\u00fcfungen->Verwaltung->GMD->GMD: Referenz GMD";
    private static final String CHECK_VERWALTUNG_GB_KATALOG = "Pr\u00fcfungen->Verwaltung->GB->GB: Referenz KREIS";
    private static final String CHECK_VERWALTUNG_SB_LUECKE = "Pr\u00fcfungen->Verwaltung->SB->SB: L\u00fccke";
    private static final String CHECK_VERWALTUNG_GB_LUECKE = "Pr\u00fcfungen->Verwaltung->GB->GB: L\u00fccke";
    private static final String CHECK_VERWALTUNG_GMD_LUECKE = "Pr\u00fcfungen->Verwaltung->GMD->GMD: L\u00fccke";
    private static final String[] ALL_CHECKS;
    private static int[] USED_CLASS_IDS;
    private boolean successful = true;

    public VerwaltungCheckAction() {
        this(false);
    }

    public VerwaltungCheckAction(boolean isBackgroundCheck) {
        super(isBackgroundCheck);
        String tooltip = NbBundle.getMessage(VerwaltungCheckAction.class, (String)"VerwaltungCheckAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(VerwaltungCheckAction.class, (String)"VerwaltungCheckAction.text");
        this.putValue("Name", text);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-zoom.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public int getProgressSteps() {
        return 15;
    }

    @Override
    public boolean startCheckInternal(final boolean isExport, WaitDialog wd, List<H2FeatureService> result) {
        if (isExport) {
            try {
                CheckResult cr = this.check(isExport, wd);
                if (result != null) {
                    this.addService(result, cr.getExp());
                    this.addService(result, cr.getIncompleteGb());
                    this.addService(result, cr.getIncompleteGmd());
                    this.addService(result, cr.getIncompleteSb());
                    this.addService(result, cr.getInvalidAttributeGb());
                    this.addService(result, cr.getInvalidAttributeGmd());
                    this.addService(result, cr.getInvalidAttributeSb());
                    this.addService(result, cr.getOverlappedGb());
                    this.addService(result, cr.getOverlappedGmd());
                    this.addService(result, cr.getOverlappedSb());
                    this.addService(result, cr.getStGb());
                    this.addService(result, cr.getStGmd());
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while performing check", (Throwable)e);
                return false;
            }
            return true;
        }
        WaitingDialogThread<CheckResult> wdt = new WaitingDialogThread<CheckResult>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, NbBundle.getMessage(VerwaltungCheckAction.class, (String)"VerwaltungCheckAction.actionPerformed().dialog"), null, 100){

            protected CheckResult doInBackground() throws Exception {
                this.wd.setMax(VerwaltungCheckAction.this.getProgressSteps());
                return VerwaltungCheckAction.this.check(isExport, this.wd);
            }

            protected void done() {
                try {
                    CheckResult result = (CheckResult)this.get();
                    VerwaltungCheckAction.this.removeServicesFromLayerModel(ALL_CHECKS);
                    if (isExport) {
                        return;
                    }
                    if (result.getProblemTreeObjectCount() == null || result.getProblemTreeObjectCount().getCount() == 0) {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(VerwaltungCheckAction.class, (String)"VerwaltungCheckAction.actionPerformed().result.text.withoutProblems", (Object[])new Object[]{result.getBakCount(), result.getIncompleteGmdErrors(), result.getIncompleteGbErrors(), result.getIncompleteSbErrors(), result.getInvalidAttributeGmdErrors(), result.getInvalidAttributeGbErrors(), result.getInvalidAttributeSbErrors(), result.getStGmdErrors(), result.getStGbErrors(), result.getOverlappedGmdErrors(), result.getOverlappedGbErrors(), result.getOverlappedSbErrors(), result.getExpErrors(), 0}), NbBundle.getMessage(VerwaltungCheckAction.class, (String)"VerwaltungCheckAction.actionPerformed().result.title"), 1);
                    } else {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(VerwaltungCheckAction.class, (String)"VerwaltungCheckAction.actionPerformed().result.text", (Object[])new Object[]{result.getBakCount(), result.getIncompleteGmdErrors(), result.getIncompleteGbErrors(), result.getIncompleteSbErrors(), result.getInvalidAttributeGmdErrors(), result.getInvalidAttributeGbErrors(), result.getInvalidAttributeSbErrors(), result.getStGmdErrors(), result.getStGbErrors(), result.getOverlappedGmdErrors(), result.getOverlappedGbErrors(), result.getOverlappedSbErrors(), result.getExpErrors(), result.getProblemTreeObjectCount().getCount(), result.getProblemTreeObjectCount().getClasses()}), NbBundle.getMessage(VerwaltungCheckAction.class, (String)"VerwaltungCheckAction.actionPerformed().result.title"), 1);
                    }
                    if (result.getExp() != null) {
                        VerwaltungCheckAction.this.showService(result.getExp(), "Pr\u00fcfungen->Verwaltung->EXP");
                    }
                    if (result.getOverlappedSb() != null) {
                        VerwaltungCheckAction.this.showService(result.getOverlappedSb(), "Pr\u00fcfungen->Verwaltung->SB");
                    }
                    if (result.getInvalidAttributeSb() != null) {
                        VerwaltungCheckAction.this.showService(result.getInvalidAttributeSb(), "Pr\u00fcfungen->Verwaltung->SB");
                    }
                    if (result.getIncompleteSb() != null) {
                        VerwaltungCheckAction.this.showService(result.getIncompleteSb(), "Pr\u00fcfungen->Verwaltung->SB");
                    }
                    if (result.getOverlappedGb() != null) {
                        VerwaltungCheckAction.this.showService(result.getOverlappedGb(), "Pr\u00fcfungen->Verwaltung->GB");
                    }
                    if (result.getInvalidAttributeGb() != null) {
                        VerwaltungCheckAction.this.showService(result.getInvalidAttributeGb(), "Pr\u00fcfungen->Verwaltung->GB");
                    }
                    if (result.getIncompleteGb() != null) {
                        VerwaltungCheckAction.this.showService(result.getIncompleteGb(), "Pr\u00fcfungen->Verwaltung->GB");
                    }
                    if (result.getOverlappedGmd() != null) {
                        VerwaltungCheckAction.this.showService(result.getOverlappedGmd(), "Pr\u00fcfungen->Verwaltung->GMD");
                    }
                    if (result.getInvalidAttributeGmd() != null) {
                        VerwaltungCheckAction.this.showService(result.getInvalidAttributeGmd(), "Pr\u00fcfungen->Verwaltung->GMD");
                    }
                    if (result.getIncompleteGmd() != null) {
                        VerwaltungCheckAction.this.showService(result.getIncompleteGmd(), "Pr\u00fcfungen->Verwaltung->GMD");
                    }
                    VerwaltungCheckAction.this.refreshTree();
                    VerwaltungCheckAction.this.refreshMap();
                }
                catch (Exception e) {
                    AbstractCheckAction.LOG.error((Object)"Error while performing the verwaltung analyse.", (Throwable)e);
                    VerwaltungCheckAction.this.successful = false;
                }
            }
        };
        wdt.start();
        return this.successful;
    }

    @Override
    protected CheckResult check(boolean isExport, WaitDialog wd) throws Exception {
        ArrayList innerList;
        CheckResult result = new CheckResult();
        String user = AppBroker.getInstance().getOwner();
        int[] selectedIds = this.getSelectedIds(isExport);
        if (user.equalsIgnoreCase("Administratoren")) {
            user = null;
        }
        this.removeServicesFromDb(ALL_CHECKS);
        ArrayList countList = (ArrayList)SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)new FgBakCount(user, selectedIds, null));
        if (countList != null && !countList.isEmpty() && (innerList = (ArrayList)countList.get(0)) != null && !innerList.isEmpty() && innerList.get(0) instanceof Number) {
            result.setBakCount(((Number)innerList.get(0)).intValue());
        }
        MergeBaSb mergeSb = new MergeBaSb(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeSb);
        this.increaseProgress(wd, 1);
        MergeBaExp mergeExp = new MergeBaExp(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)mergeExp);
        this.increaseProgress(wd, 1);
        DeleteInvalidFgBaExp deletBaExp = new DeleteInvalidFgBaExp(user);
        SessionManager.getProxy().customServerSearch(SessionManager.getSession().getUser(), (CidsServerSearch)deletBaExp);
        this.increaseProgress(wd, 1);
        boolean useExpCond = user != null;
        boolean export = isExport && useExpCond;
        String expCondition = isExport && useExpCond ? " exists(select id from dlm25w.fg_ba_exp_complete where owner = '" + user + "' and bak_id = bak.id)" : "false";
        ArrayList<FeatureServiceAttribute> baGmdServiceAttributeDefinition = new ArrayList<FeatureServiceAttribute>();
        FeatureServiceAttribute serviceAttribute = new FeatureServiceAttribute("id", String.valueOf(4), true);
        baGmdServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("geom", String.valueOf(10012), true);
        baGmdServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ww_gr", String.valueOf(4), true);
        baGmdServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_cd", String.valueOf(12), true);
        baGmdServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_st_von", String.valueOf(8), true);
        baGmdServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_st_bis", String.valueOf(8), true);
        baGmdServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("laenge", String.valueOf(8), true);
        baGmdServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_date", String.valueOf(93), true);
        baGmdServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_user", String.valueOf(12), true);
        baGmdServiceAttributeDefinition.add(serviceAttribute);
        result.setIncompleteGmd(this.analyseByCustomSearch((CidsServerSearch)new BakWithIncompleteGmdCoverage(user, selectedIds, export), CHECK_VERWALTUNG_GMD_LUECKE, baGmdServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        ArrayList<FeatureServiceAttribute> baGbServiceAttributeDefinition = new ArrayList<FeatureServiceAttribute>();
        serviceAttribute = new FeatureServiceAttribute("id", String.valueOf(4), true);
        baGbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("geom", String.valueOf(10012), true);
        baGbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ww_gr", String.valueOf(4), true);
        baGbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_cd", String.valueOf(12), true);
        baGbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_st_von", String.valueOf(8), true);
        baGbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_st_bis", String.valueOf(8), true);
        baGbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("laenge", String.valueOf(8), true);
        baGbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_date", String.valueOf(93), true);
        baGbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_user", String.valueOf(12), true);
        baGbServiceAttributeDefinition.add(serviceAttribute);
        result.setIncompleteGb(this.analyseByCustomSearch((CidsServerSearch)new BakWithIncompleteGbCoverage(user, selectedIds, export), CHECK_VERWALTUNG_GB_LUECKE, baGbServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        ArrayList<FeatureServiceAttribute> baSbServiceAttributeDefinition = new ArrayList<FeatureServiceAttribute>();
        serviceAttribute = new FeatureServiceAttribute("id", String.valueOf(4), true);
        baSbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("geom", String.valueOf(10012), true);
        baSbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ww_gr", String.valueOf(4), true);
        baSbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_cd", String.valueOf(12), true);
        baSbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_st_von", String.valueOf(8), true);
        baSbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("ba_st_bis", String.valueOf(8), true);
        baSbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("laenge", String.valueOf(8), true);
        baSbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_date", String.valueOf(93), true);
        baSbServiceAttributeDefinition.add(serviceAttribute);
        serviceAttribute = new FeatureServiceAttribute("fis_g_user", String.valueOf(12), true);
        baSbServiceAttributeDefinition.add(serviceAttribute);
        result.setIncompleteSb(this.analyseByCustomSearch((CidsServerSearch)new BakWithIncompleteSbCoverage(user, selectedIds, export), CHECK_VERWALTUNG_SB_LUECKE, baSbServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        String query = useExpCond ? String.format(QUERY_GB_CATALOGUE, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_GB_CATALOGUE, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setInvalidAttributeGb(this.analyseByQuery(FG_BA_GB, query, CHECK_VERWALTUNG_GB_KATALOG));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_GMD_CATALOGUE, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_GMD_CATALOGUE, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setInvalidAttributeGmd(this.analyseByQuery(FG_BA_GMD, query, CHECK_VERWALTUNG_GMD_KATALOG));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_SB_CATALOGUE, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_SB_CATALOGUE, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setInvalidAttributeSb(this.analyseByQuery(FG_BA_SB, query, CHECK_VERWALTUNG_SB_KATALOG));
        this.increaseProgress(wd, 1);
        query = useExpCond ? String.format(QUERY_EXP, SQLFormatter.createSqlArrayString((int[])selectedIds), expCondition) : String.format(QUERY_EXP, SQLFormatter.createSqlArrayString((int[])selectedIds));
        result.setExp(this.analyseByQuery(FG_BA_EXP, query, CHECK_VERWALTUNG_EXP_BELEGUNG));
        this.increaseProgress(wd, 1);
        result.setOverlappedGmd(this.analyseByCustomSearch((CidsServerSearch)new OverlappedGmd(user, selectedIds, export), CHECK_VERWALTUNG_GMD_UEBERLAPPUNG, baGmdServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setOverlappedGb(this.analyseByCustomSearch((CidsServerSearch)new OverlappedGb(user, selectedIds, export), CHECK_VERWALTUNG_GB_UEBERLAPPUNG, baGbServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setOverlappedSb(this.analyseByCustomSearch((CidsServerSearch)new OverlappedSb(user, selectedIds, export), CHECK_VERWALTUNG_SB_UEBERLAPPUNG, baSbServiceAttributeDefinition));
        this.increaseProgress(wd, 1);
        result.setProblemTreeObjectCount(this.getErrorObjectsFromTree(user, selectedIds, USED_CLASS_IDS, isExport));
        if (result.getIncompleteGb() != null) {
            result.setIncompleteGbErrors(result.getIncompleteGb().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getIncompleteGmd() != null) {
            result.setIncompleteGmdErrors(result.getIncompleteGmd().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getIncompleteSb() != null) {
            result.setIncompleteSbErrors(result.getIncompleteSb().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getInvalidAttributeGb() != null) {
            result.setInvalidAttributeGbErrors(result.getInvalidAttributeGb().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getInvalidAttributeGmd() != null) {
            result.setInvalidAttributeGmdErrors(result.getInvalidAttributeGmd().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getInvalidAttributeSb() != null) {
            result.setInvalidAttributeSbErrors(result.getInvalidAttributeSb().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getExp() != null) {
            result.setExpErrors(result.getExp().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getOverlappedGb() != null) {
            result.setOverlappedGbErrors(result.getOverlappedGb().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getOverlappedGmd() != null) {
            result.setOverlappedGmdErrors(result.getOverlappedGmd().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getOverlappedSb() != null) {
            result.setOverlappedSbErrors(result.getOverlappedSb().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getStGmd() != null) {
            result.setStGmdErrors(result.getStGmd().getFeatureCount(null));
            this.successful = false;
        }
        if (result.getStGb() != null) {
            result.setStGbErrors(result.getStGb().getFeatureCount(null));
            this.successful = false;
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    static {
        ALL_CHECKS = new String[]{CHECK_VERWALTUNG_SB_UEBERLAPPUNG, CHECK_VERWALTUNG_GB_UEBERLAPPUNG, CHECK_VERWALTUNG_GMD_UEBERLAPPUNG, CHECK_VERWALTUNG_EXP_BELEGUNG, CHECK_VERWALTUNG_SB_KATALOG, CHECK_VERWALTUNG_GMD_KATALOG, CHECK_VERWALTUNG_GB_KATALOG, CHECK_VERWALTUNG_SB_LUECKE, CHECK_VERWALTUNG_GB_LUECKE, CHECK_VERWALTUNG_GMD_LUECKE};
        USED_CLASS_IDS = new int[]{FG_BA_SB != null ? FG_BA_SB.getId() : -1, FG_BA_GB != null ? FG_BA_GB.getId() : -1, FG_BA_GMD != null ? FG_BA_GMD.getId() : -1};
        if (FG_BA_EXP != null) {
            USED_CLASS_IDS = new int[]{FG_BA_SB != null ? FG_BA_SB.getId() : -1, FG_BA_GB != null ? FG_BA_GB.getId() : -1, FG_BA_GMD != null ? FG_BA_GMD.getId() : -1, FG_BA_EXP.getId()};
        }
        if (FG_BA_SB != null && FG_BA_GB != null && FG_BA_GMD != null && FG_BAK != null && FG_BA_EXP != null) {
            User user = SessionManager.getSession().getUser();
            QUERY_GMD_CATALOGUE = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_GMD.getID() + ", t." + FG_BA_GMD.getPrimaryKey() + " from " + FG_BA_GMD.getTableName() + " t\njoin dlm25w.fg_ba_linie linie on (ba_st = linie.id) join dlm25w.fg_ba_punkt von on (linie.von = von.id) join dlm25w.fg_ba ba on (von.route = ba.id) where (%1$s is null or ba.id = any(%1$s)) and (((nr_li is not null or name_li is not null) and not exists (select 1 from dlm25w.vw_alk_gmd where gmd_nr = nr_li and gmd_name = name_li limit 1)) or ((nr_re is not null or name_re is not null) and not exists (select 1 from dlm25w.vw_alk_gmd where gmd_nr = nr_re and gmd_name = name_re limit 1)));" : "select distinct " + FG_BA_GMD.getID() + ", t." + FG_BA_GMD.getPrimaryKey() + " from " + FG_BA_GMD.getTableName() + " t \njoin dlm25w.fg_ba_linie linie on (ba_st = linie.id) join dlm25w.fg_ba_punkt von on (linie.von = von.id) join dlm25w.fg_ba ba on (von.route = ba.id) join dlm25w.fg_bak bak on (ba.bak_id = bak.id) join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or ba.id = any(%1$s)) and (((nr_li is not null or name_li is not null) and not exists (select 1 from dlm25w.vw_alk_gmd where gmd_nr = nr_li and gmd_name = name_li limit 1)) or ((nr_re is not null or name_re is not null) and not exists (select 1 from dlm25w.vw_alk_gmd where gmd_nr = nr_re and gmd_name = name_re limit 1))) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_GB_CATALOGUE = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_GB.getID() + ", t." + FG_BA_GB.getPrimaryKey() + " from " + FG_BA_GB.getTableName() + " t\njoin dlm25w.fg_ba_linie linie on (ba_st = linie.id) join dlm25w.fg_ba_punkt von on (linie.von = von.id) join dlm25w.fg_ba ba on (von.route = ba.id) where (%1$s is null or ba.id = any(%1$s)) and (((nr_li is not null) and not exists (select 1 from dlm25w.vw_alk_kreis where kreis_nr = nr_li limit 1)) or ((nr_re is not null) and not exists (select 1 from dlm25w.vw_alk_kreis where kreis_nr = nr_re limit 1)));" : "select distinct " + FG_BA_GB.getID() + ", t." + FG_BA_GB.getPrimaryKey() + " from " + FG_BA_GB.getTableName() + " t \njoin dlm25w.fg_ba_linie linie on (ba_st = linie.id) join dlm25w.fg_ba_punkt von on (linie.von = von.id) join dlm25w.fg_ba ba on (von.route = ba.id) join dlm25w.fg_bak bak on (ba.bak_id = bak.id) join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or ba.id = any(%1$s)) and (((nr_li is not null) and not exists (select 1 from dlm25w.vw_alk_kreis where kreis_nr = nr_li limit 1)) or ((nr_re is not null) and not exists (select 1 from dlm25w.vw_alk_kreis where kreis_nr = nr_re limit 1))) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_GMD_STATUS = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_GMD.getID() + ", t." + FG_BA_GMD.getPrimaryKey() + " from " + FG_BA_GMD.getTableName() + " t\njoin dlm25w.fg_ba_linie linie on (ba_st = linie.id) join dlm25w.fg_ba_punkt von on (linie.von = von.id) join dlm25w.fg_ba ba on (von.route = ba.id) where (%1$s is null or ba.id = any(%1$s)) and (((nr_li is not null) and not exists (select 1 from dlm25w.vw_alk_gmd where kreis_nr = nr_li limit 1)) or ((nr_re is not null) and not exists (select 1 from dlm25w.vw_alk_kreis where kreis_nr = nr_re limit 1)));" : "select distinct " + FG_BA_GMD.getID() + ", t." + FG_BA_GMD.getPrimaryKey() + " from " + FG_BA_GMD.getTableName() + " t \njoin dlm25w.fg_ba_linie linie on (ba_st = linie.id) join dlm25w.fg_ba_punkt von on (linie.von = von.id) join dlm25w.fg_ba ba on (von.route = ba.id) join dlm25w.fg_bak bak on (ba.bak_id = bak.id) join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or ba.id = any(%1$s)) and (((nr_li is not null) and not exists (select 1 from dlm25w.vw_alk_gmd where kreis_nr = nr_li limit 1)) or ((nr_re is not null) and not exists (select 1 from dlm25w.vw_alk_kreis where kreis_nr = nr_re limit 1))) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_GB_STATUS = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_GB.getID() + ", t." + FG_BA_GB.getPrimaryKey() + " from " + FG_BA_GB.getTableName() + " t\njoin dlm25w.fg_ba_linie linie on (ba_st = linie.id) join dlm25w.fg_ba_punkt von on (linie.von = von.id) join dlm25w.fg_ba ba on (von.route = ba.id) where (%1$s is null or ba.id = any(%1$s)) ;" : "select distinct " + FG_BA_GB.getID() + ", t." + FG_BA_GB.getPrimaryKey() + " from " + FG_BA_GB.getTableName() + " t \njoin dlm25w.fg_ba_linie linie on (ba_st = linie.id) join dlm25w.fg_ba_punkt von on (linie.von = von.id) join dlm25w.fg_ba ba on (von.route = ba.id) join dlm25w.fg_bak bak on (ba.bak_id = bak.id) join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\nwhere (%1$s is null or ba.id = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_SB_CATALOGUE = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_SB.getID() + ", t." + FG_BA_SB.getPrimaryKey() + " from " + FG_BA_SB.getTableName() + " t\nleft join dlm25w.k_sb k on (k.id = t.sb) \njoin dlm25w.fg_ba_linie linie on (ba_st = linie.id) join dlm25w.fg_ba_punkt von on (linie.von = von.id) join dlm25w.fg_ba ba on (von.route = ba.id) join dlm25w.k_ww_gr sbgr on (k.ww_gr = sbgr.id) join dlm25w.k_ww_gr bagr on (ba.ww_gr = bagr.id)where (%1$s is null or ba.id = any(%1$s)) and ((k.id is null and t.sb is not null) or sbgr.owner <> bagr.owner);" : "select distinct " + FG_BA_SB.getID() + ", t." + FG_BA_SB.getPrimaryKey() + " from " + FG_BA_SB.getTableName() + " t \nleft join dlm25w.k_sb k on (k.id = t.sb) \njoin dlm25w.fg_ba_linie linie on (ba_st = linie.id) join dlm25w.fg_ba_punkt von on (linie.von = von.id) join dlm25w.fg_ba ba on (von.route = ba.id) join dlm25w.fg_bak bak on (ba.bak_id = bak.id) join dlm25w.k_ww_gr gr on (bak.ww_gr = gr.id)\njoin dlm25w.k_ww_gr sbgr on (k.ww_gr = sbgr.id) join dlm25w.k_ww_gr bagr on (ba.ww_gr = bagr.id)where (%1$s is null or ba.id = any(%1$s)) and ((k.id is null and t.sb is not null) or sbgr.owner <> bagr.owner) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s)";
            QUERY_EXP = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? "select distinct " + FG_BA_EXP.getID() + ", unnest(array_agg(exp.id)) as id  from " + FG_BA_EXP.getTableName() + " exp\njoin dlm25w.fg_ba_linie linie on (exp.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba ba on (von.route =  ba.id)\nwhere  (%1$s is null or ba.id = any(%1$s)) \ngroup by ba.id, exp.ww_gr\nhaving count(*) > 1" : "select distinct " + FG_BA_EXP.getID() + ", unnest(array_agg(exp.id)) as id  from " + FG_BA_EXP.getTableName() + " exp \njoin dlm25w.fg_ba_linie linie on (exp.ba_st = linie.id)\njoin dlm25w.fg_ba_punkt von on (linie.von = von.id)\njoin dlm25w.fg_ba ba on (von.route =  ba.id)\njoin dlm25w.k_ww_gr gr on (exp.ww_gr = gr.id)\nwhere (%1$s is null or ba.id = any(%1$s)) and (gr.owner = '" + user.getUserGroup().getName() + "' or %2$s) \ngroup by ba.id, exp.ww_gr\nhaving count(*) > 1";
        }
    }

    protected static class CheckResult
    extends AbstractCheckResult {
        private static final String[] CHECK_NAMES = new String[]{"INCOMPLETE_GB", "INCOMPLETE_SB", "INCOMPLETE_GMD", "INVALID_ATTRIBUTE_GMD", "INVALID_ATTRIBUTE_GB", "INVALID_ATTRIBUTE_SB", "exp", "OVERLAPPED_GMD", "OVERLAPPED_GB", "OVERLAPPEDSB", "ST_GB", "ST_GMD"};
        private int incompleteGbErrors;
        private int incompleteSbErrors;
        private int incompleteGmdErrors;
        private int invalidAttributeGmdErrors;
        private int invalidAttributeGbErrors;
        private int invalidAttributeSbErrors;
        private int expErrors;
        private int bakCount;
        private int overlappedGmdErrors;
        private int overlappedGbErrors;
        private int overlappedSbErrors;
        private int stGbErrors;
        private int stGmdErrors;
        private AbstractCheckAction.ProblemCountAndClasses problemTreeObjectCount;
        private H2FeatureService incompleteGb;
        private H2FeatureService incompleteSb;
        private H2FeatureService incompleteGmd;
        private H2FeatureService invalidAttributeGmd;
        private H2FeatureService invalidAttributeGb;
        private H2FeatureService invalidAttributeSb;
        private H2FeatureService exp;
        private H2FeatureService overlappedGmd;
        private H2FeatureService overlappedGb;
        private H2FeatureService overlappedSb;
        private H2FeatureService stGb;
        private H2FeatureService stGmd;

        protected CheckResult() {
        }

        @Override
        public AbstractCheckAction.ProblemCountAndClasses getProblemTreeObjectCount() {
            return this.problemTreeObjectCount;
        }

        public void setProblemTreeObjectCount(AbstractCheckAction.ProblemCountAndClasses problemTreeObjectCount) {
            this.problemTreeObjectCount = problemTreeObjectCount;
        }

        public int getIncompleteGbErrors() {
            return this.incompleteGbErrors;
        }

        public void setIncompleteGbErrors(int incompleteGbErrors) {
            this.incompleteGbErrors = incompleteGbErrors;
        }

        public int getIncompleteSbErrors() {
            return this.incompleteSbErrors;
        }

        public void setIncompleteSbErrors(int incompleteSbErrors) {
            this.incompleteSbErrors = incompleteSbErrors;
        }

        public int getIncompleteGmdErrors() {
            return this.incompleteGmdErrors;
        }

        public void setIncompleteGmdErrors(int incompleteGmdErrors) {
            this.incompleteGmdErrors = incompleteGmdErrors;
        }

        public int getInvalidAttributeGmdErrors() {
            return this.invalidAttributeGmdErrors;
        }

        public void setInvalidAttributeGmdErrors(int invalidAttributeGmdErrors) {
            this.invalidAttributeGmdErrors = invalidAttributeGmdErrors;
        }

        public int getInvalidAttributeGbErrors() {
            return this.invalidAttributeGbErrors;
        }

        public void setInvalidAttributeGbErrors(int invalidAttributeGbErrors) {
            this.invalidAttributeGbErrors = invalidAttributeGbErrors;
        }

        public int getInvalidAttributeSbErrors() {
            return this.invalidAttributeSbErrors;
        }

        public void setInvalidAttributeSbErrors(int invalidAttributeSbErrors) {
            this.invalidAttributeSbErrors = invalidAttributeSbErrors;
        }

        public H2FeatureService getIncompleteGb() {
            return this.incompleteGb;
        }

        public void setIncompleteGb(H2FeatureService incompleteGb) {
            this.incompleteGb = incompleteGb;
        }

        public H2FeatureService getIncompleteSb() {
            return this.incompleteSb;
        }

        public void setIncompleteSb(H2FeatureService incompleteSb) {
            this.incompleteSb = incompleteSb;
        }

        public H2FeatureService getIncompleteGmd() {
            return this.incompleteGmd;
        }

        public void setIncompleteGmd(H2FeatureService incompleteGmd) {
            this.incompleteGmd = incompleteGmd;
        }

        public H2FeatureService getInvalidAttributeGmd() {
            return this.invalidAttributeGmd;
        }

        public void setInvalidAttributeGmd(H2FeatureService invalidAttributeGmd) {
            this.invalidAttributeGmd = invalidAttributeGmd;
        }

        public H2FeatureService getInvalidAttributeGb() {
            return this.invalidAttributeGb;
        }

        public void setInvalidAttributeGb(H2FeatureService invalidAttributeGb) {
            this.invalidAttributeGb = invalidAttributeGb;
        }

        public H2FeatureService getInvalidAttributeSb() {
            return this.invalidAttributeSb;
        }

        public void setInvalidAttributeSb(H2FeatureService invalidAttributeSb) {
            this.invalidAttributeSb = invalidAttributeSb;
        }

        public int getExpErrors() {
            return this.expErrors;
        }

        public void setExpErrors(int expErrors) {
            this.expErrors = expErrors;
        }

        public H2FeatureService getExp() {
            return this.exp;
        }

        public void setExp(H2FeatureService exp) {
            this.exp = exp;
        }

        public int getBakCount() {
            return this.bakCount;
        }

        public void setBakCount(int bakCount) {
            this.bakCount = bakCount;
        }

        public int getOverlappedGmdErrors() {
            return this.overlappedGmdErrors;
        }

        public void setOverlappedGmdErrors(int overlappedGmdErrors) {
            this.overlappedGmdErrors = overlappedGmdErrors;
        }

        public int getOverlappedGbErrors() {
            return this.overlappedGbErrors;
        }

        public void setOverlappedGbErrors(int overlappedGbErrors) {
            this.overlappedGbErrors = overlappedGbErrors;
        }

        public int getOverlappedSbErrors() {
            return this.overlappedSbErrors;
        }

        public void setOverlappedSbErrors(int overlappedSbErrors) {
            this.overlappedSbErrors = overlappedSbErrors;
        }

        public H2FeatureService getOverlappedGmd() {
            return this.overlappedGmd;
        }

        public void setOverlappedGmd(H2FeatureService overlappedGmd) {
            this.overlappedGmd = overlappedGmd;
        }

        public H2FeatureService getOverlappedGb() {
            return this.overlappedGb;
        }

        public void setOverlappedGb(H2FeatureService overlappedGb) {
            this.overlappedGb = overlappedGb;
        }

        public H2FeatureService getOverlappedSb() {
            return this.overlappedSb;
        }

        public void setOverlappedSb(H2FeatureService overlappedSb) {
            this.overlappedSb = overlappedSb;
        }

        public H2FeatureService getStGb() {
            return this.stGb;
        }

        public void setStGb(H2FeatureService stGb) {
            this.stGb = stGb;
        }

        public H2FeatureService getStGmd() {
            return this.stGmd;
        }

        public void setStGmd(H2FeatureService stGmd) {
            this.stGmd = stGmd;
        }

        public int getStGbErrors() {
            return this.stGbErrors;
        }

        public void setStGbErrors(int stGbErrors) {
            this.stGbErrors = stGbErrors;
        }

        public int getStGmdErrors() {
            return this.stGmdErrors;
        }

        public void setStGmdErrors(int stGmdErrors) {
            this.stGmdErrors = stGmdErrors;
        }

        @Override
        public String[] getCheckNames() {
            return CHECK_NAMES;
        }

        @Override
        public int getErrorsPerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.incompleteGbErrors;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.incompleteSbErrors;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.incompleteGmdErrors;
            }
            if (checkName.equals(CHECK_NAMES[3])) {
                return this.invalidAttributeGmdErrors;
            }
            if (checkName.equals(CHECK_NAMES[4])) {
                return this.invalidAttributeGbErrors;
            }
            if (checkName.equals(CHECK_NAMES[5])) {
                return this.invalidAttributeSbErrors;
            }
            if (checkName.equals(CHECK_NAMES[6])) {
                return this.expErrors;
            }
            if (checkName.equals(CHECK_NAMES[7])) {
                return this.overlappedGmdErrors;
            }
            if (checkName.equals(CHECK_NAMES[8])) {
                return this.overlappedGbErrors;
            }
            if (checkName.equals(CHECK_NAMES[9])) {
                return this.overlappedSbErrors;
            }
            if (checkName.equals(CHECK_NAMES[10])) {
                return this.stGbErrors;
            }
            if (checkName.equals(CHECK_NAMES[11])) {
                return this.stGmdErrors;
            }
            return 0;
        }

        @Override
        public H2FeatureService getErrorTablePerCheck(String checkName) {
            if (checkName.equals(CHECK_NAMES[0])) {
                return this.incompleteGb;
            }
            if (checkName.equals(CHECK_NAMES[1])) {
                return this.incompleteSb;
            }
            if (checkName.equals(CHECK_NAMES[2])) {
                return this.incompleteGmd;
            }
            if (checkName.equals(CHECK_NAMES[3])) {
                return this.invalidAttributeGmd;
            }
            if (checkName.equals(CHECK_NAMES[4])) {
                return this.invalidAttributeGb;
            }
            if (checkName.equals(CHECK_NAMES[5])) {
                return this.invalidAttributeSb;
            }
            if (checkName.equals(CHECK_NAMES[6])) {
                return this.exp;
            }
            if (checkName.equals(CHECK_NAMES[7])) {
                return this.overlappedGmd;
            }
            if (checkName.equals(CHECK_NAMES[8])) {
                return this.overlappedGb;
            }
            if (checkName.equals(CHECK_NAMES[9])) {
                return this.overlappedSb;
            }
            if (checkName.equals(CHECK_NAMES[10])) {
                return this.stGb;
            }
            if (checkName.equals(CHECK_NAMES[11])) {
                return this.stGmd;
            }
            return null;
        }
    }
}

