/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.gaf;

import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.commons.security.WebDavClient;
import de.cismet.netutil.ProxyHandler;
import de.cismet.security.WebAccessManager;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.dialog.GafExportDialog;
import de.cismet.watergis.gui.panels.GafProf;
import de.cismet.watergis.gui.panels.Photo;
import de.cismet.watergis.profile.QpUplDownload;
import de.cismet.watergis.utils.FeatureServiceHelper;
import de.cismet.watergis.utils.JumpShapeWriter;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ExportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ExportAction.class);
    private static CidsLayer ppLayer = null;

    public ExportAction() {
        String tooltip = NbBundle.getMessage(ExportAction.class, (String)"ExportAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(ExportAction.class, (String)"ExportAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(ExportAction.class, (String)"ExportAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-exportfile.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("qp_upl");
            if (features == null || features.isEmpty()) {
                List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("qp_upl");
                if (services != null && !services.isEmpty()) {
                    FeatureServiceHelper.getFeatures(services.get(0), false);
                }
            } else {
                LOG.warn((Object)"No qp_upl objects found to create qp_upl export");
            }
            if (!features.isEmpty() && DownloadManagerDialog.showAskingForUserTitle((Component)AppBroker.getInstance().getRootWindow())) {
                String jobname = DownloadManagerDialog.getInstance().getJobName();
                WebDavClient webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), Photo.WEB_DAV_USER, Photo.WEB_DAV_PASSWORD, true);
                File f = new File(DownloadManager.instance().getDestinationDirectory(), jobname);
                DownloadManager.instance().add((Download)new QpUplDownload(webDavClient, f.getAbsolutePath(), "Download Profil", features));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while creating qp_upl export", (Throwable)ex);
        }
    }

    private List<DefaultFeatureServiceFeature> getAllPPFeature(Integer qpNr) throws Exception {
        ppLayer.initAndWait();
        FeatureServiceAttribute attr = (FeatureServiceAttribute)ppLayer.getFeatureServiceAttributes().get("id");
        return ppLayer.getFeatureFactory().createFeatures((Object)("qp_nr = " + qpNr.toString()), null, null, 0, 0, new FeatureServiceAttribute[]{attr});
    }

    private void createShapeAndMetaDoc(List<FeatureServiceFeature> features, String outputFileStem, boolean createPrj) throws Exception {
        ArrayList<String[]> attribList = new ArrayList<String[]>();
        CidsLayer service = (CidsLayer)features.get(0).getLayerProperties().getFeatureService();
        for (String attr : features.get(0).getLayerProperties().getFeatureService().getOrderedFeatureServiceAttributes()) {
            String[] attrName = new String[]{attr, attr};
            attribList.add(attrName);
        }
        JumpShapeWriter shapeWriter = new JumpShapeWriter();
        String charset = Charset.defaultCharset().name();
        shapeWriter.writeShpFile(features.toArray(new FeatureServiceFeature[features.size()]), new File(outputFileStem + ".shp"), null, charset);
        if (createPrj) {
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputFileStem + ".prj"));
            bw.write("PROJCS[\"ETRS_1989_UTM_Zone_33N_zE-N\",GEOGCS[\"GCS_ETRS_1989\",DATUM[\"D_ETRS_1989\",SPHEROID[\"GRS_1980\",6378137.0,298.257222101]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"False_Easting\",33500000.0],PARAMETER[\"False_Northing\",0.0],PARAMETER[\"Central_Meridian\",15.0],PARAMETER[\"Scale_Factor\",0.9996],PARAMETER[\"Latitude_Of_Origin\",0.0],UNIT[\"Meter\",1.0],AUTHORITY[\"EPSG\",5650]]");
            bw.close();
        }
        BufferedWriter bwCpg = new BufferedWriter(new FileWriter(outputFileStem + ".cpg"));
        bwCpg.write(charset);
        bwCpg.close();
        ExportAction.downloadMetaDocument(service, outputFileStem);
    }

    private void createDBF(List<FeatureServiceFeature> features, String outputFileStem) throws Exception {
        this.createShapeAndMetaDoc(features, outputFileStem, false);
        File file = new File(outputFileStem + ".shp");
        if (file.exists()) {
            file.delete();
        }
        if ((file = new File(outputFileStem + ".shx")).exists()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadMetaDocument(CidsLayer service, String outputFileStem) {
        CidsLayer cl;
        String link;
        if (service instanceof CidsLayer && (link = (cl = service).getMetaDocumentLink()) != null) {
            BufferedInputStream bin = null;
            FilterOutputStream out = null;
            try {
                int byteCount;
                URL u = new URL(link);
                InputStream in = WebAccessManager.getInstance().doRequest(u);
                bin = new BufferedInputStream(in);
                out = new BufferedOutputStream(new FileOutputStream(outputFileStem + ".pdf"));
                byte[] tmp = new byte[256];
                while ((byteCount = bin.read(tmp, 0, tmp.length)) != -1) {
                    ((BufferedOutputStream)out).write(tmp, 0, byteCount);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while downloading meta document.", (Throwable)e);
            }
            finally {
                try {
                    if (bin != null) {
                        bin.close();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)"Error while closing stream", (Throwable)e);
                }
            }
        }
    }

    private static void prepareFileNames(Map<String, Boolean> fileNames, List<FeatureServiceFeature> features, File basisPath, File lawaPath) throws Exception {
        for (FeatureServiceFeature feature : features) {
            Boolean multiStation;
            String fileName;
            if (GafExportDialog.getInstance().isBasisSelected() && feature.getProperty("ba_cd") != null) {
                fileName = GafProf.getBasicReportFileName((CidsLayerFeature)feature);
                File basisFile = new File(basisPath, fileName);
                multiStation = fileNames.get(basisFile.getAbsolutePath());
                if (multiStation == null) {
                    fileNames.put(basisFile.getAbsolutePath(), Boolean.FALSE);
                } else if (!multiStation.booleanValue()) {
                    fileNames.put(basisFile.getAbsolutePath(), Boolean.TRUE);
                }
            }
            if (!GafExportDialog.getInstance().isLawaSelected() || feature.getProperty("la_cd") == null) continue;
            fileName = GafProf.getLawaReportFileName((CidsLayerFeature)feature);
            File lawaFile = new File(lawaPath, fileName);
            multiStation = fileNames.get(lawaFile.getAbsolutePath());
            if (multiStation == null) {
                fileNames.put(lawaFile.getAbsolutePath(), Boolean.FALSE);
                continue;
            }
            if (multiStation.booleanValue()) continue;
            fileNames.put(lawaFile.getAbsolutePath(), Boolean.TRUE);
        }
    }

    private static void deleteDirectory(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                ExportAction.deleteDirectory(f);
                continue;
            }
            f.delete();
        }
        dir.delete();
    }

    private static File createTmpDirectory(File directorybase) {
        File tmpSubDirectory = null;
        String subDirName = null;
        Random rand = new Random(new Date().getTime());
        while ((tmpSubDirectory = new File(directorybase, subDirName = "tmp" + rand.nextInt(Integer.MAX_VALUE))).exists()) {
        }
        tmpSubDirectory.mkdirs();
        return tmpSubDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipDirectory(File inputDir, ZipOutputStream out, String dirName) throws Exception {
        int BYTES_ARRAY_LENGTH = 256;
        byte[] tmp = new byte[256];
        for (File f : inputDir.listFiles()) {
            if (f.isDirectory()) {
                String parent = dirName.equals("") ? "" : dirName + "/";
                ExportAction.zipDirectory(f, out, parent + f.getName() + "/");
                continue;
            }
            ZipEntry entry = new ZipEntry(dirName + f.getName());
            out.putNextEntry(entry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            try {
                int byteCount;
                while ((byteCount = bis.read(tmp, 0, 256)) != -1) {
                    out.write(tmp, 0, byteCount);
                }
            }
            finally {
                out.closeEntry();
                bis.close();
            }
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

