/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.geoprocessing;

import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ThemeLayerWidget;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public abstract class AbstractGeoprocessingAction
extends AbstractAction {
    protected static final Logger LOG = Logger.getLogger(AbstractGeoprocessingAction.class);
    protected Collection<ActionListener> listeners = new ArrayList<ActionListener>();

    public AbstractGeoprocessingAction() {
        this.putValue("ShortDescription", this.getShortDescription());
        this.putValue("Name", this.getName());
        this.putValue("SmallIcon", this.getSmallIcon());
        this.setEnabled(false);
    }

    protected List<AbstractFeatureService> getSelectedServices() {
        ArrayList<AbstractFeatureService> serviceList = new ArrayList<AbstractFeatureService>();
        Component c = AppBroker.getInstance().getComponent(ComponentName.TREE);
        ThemeLayerWidget widget = (ThemeLayerWidget)c;
        TreePath[] paths = widget.getSelectionPath();
        if (paths != null) {
            for (TreePath path : paths) {
                if (!(path.getLastPathComponent() instanceof AbstractFeatureService)) continue;
                serviceList.add((AbstractFeatureService)path.getLastPathComponent());
            }
        }
        return serviceList;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fireActionEvent(e);
    }

    public boolean addActionListener(ActionListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeModeListener(ActionListener listener) {
        return this.listeners.remove(listener);
    }

    protected void fireActionEvent(ActionEvent e) {
        for (ActionListener listener : this.listeners) {
            listener.actionPerformed(e);
        }
    }

    public abstract String getName();

    public abstract String getShortDescription();

    public abstract ImageIcon getSmallIcon();

    public abstract int getSortOrder();
}

