/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.map;

import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.CleanUpAction;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class MeasureAction
extends AbstractAction
implements CleanUpAction {
    private static final Logger LOG = Logger.getLogger(MeasureAction.class);

    public MeasureAction() {
        this.setEnabled(false);
        String tooltip = NbBundle.getMessage(MeasureAction.class, (String)"MeasureAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(MeasureAction.class, (String)"MeasureAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(MeasureAction.class, (String)"MeasureAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-ruler.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        MappingComponent map = AppBroker.getInstance().getMappingComponent();
        map.setInteractionMode("MEASURE_MODE");
        map.setCursor(Cursor.getPredefinedCursor(1));
        this.putValue("SwingSelectedKey", Boolean.TRUE);
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public void cleanUp() {
        ((DefaultFeatureCollection)AppBroker.getInstance().getMappingComponent().getFeatureCollection()).removeFeaturesByInstance(PureNewFeature.class);
    }
}

