/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.map;

import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.DrawingSLDStyledFeature;
import de.cismet.cismap.commons.features.FeatureCollection;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.map.AbstractNewGeometryModeAction;
import de.cismet.watergis.gui.components.DrawingMode;
import de.cismet.watergis.gui.dialog.VisualizingDialog;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import org.deegree.style.se.unevaluated.Style;
import org.openide.util.NbBundle;

public class OptionModeAction
extends AbstractNewGeometryModeAction
implements DrawingMode {
    public OptionModeAction() {
        String tooltip = NbBundle.getMessage(OptionModeAction.class, (String)"OptionModeAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(OptionModeAction.class, (String)"OptionModeAction.text");
        this.putValue("Name", text);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-settingsthree-gears.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        VisualizingDialog dialog = VisualizingDialog.getInstance();
        dialog.pack();
        dialog.setResizable(false);
        StaticSwingTools.showDialog((JDialog)dialog);
        if (!dialog.isCanceled()) {
            AppBroker.getInstance().setDrawingStyleLayer(dialog.getStyleLayer());
            MappingComponent mc = AppBroker.getInstance().getMappingComponent();
            FeatureCollection fc = mc.getFeatureCollection();
            ArrayList<DrawingSLDStyledFeature> changedFeatures = new ArrayList<DrawingSLDStyledFeature>();
            for (Object f : fc.getSelectedFeatures()) {
                if (!(f instanceof DrawingSLDStyledFeature)) continue;
                DrawingSLDStyledFeature feature = (DrawingSLDStyledFeature)f;
                this.setStyle(feature, AppBroker.getInstance().getDrawingStyles(feature.getGeometry().getGeometryType()));
                feature.setProperty("sld", (Object)VisualizingDialog.exportSLD(VisualizingDialog.getInstance().getStyleLayer(), feature.getGeometry().getGeometryType()));
                changedFeatures.add(feature);
            }
            if (!changedFeatures.isEmpty() && fc instanceof DefaultFeatureCollection) {
                ((DefaultFeatureCollection)fc).fireFeaturesChanged(changedFeatures);
            }
        }
    }

    public void setStyle(DrawingSLDStyledFeature feature, Map<String, LinkedList<Style>> sldStyle) {
        feature.setSLDStyles((List)sldStyle.get("default"));
        PFeature pfeature = (PFeature)AppBroker.getInstance().getMappingComponent().getPFeatureHM().get(feature);
        if (pfeature != null) {
            pfeature.refreshDesign();
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

