/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.map;

import de.cismet.cismap.DrawingManager;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.DrawingSLDStyledFeature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.DefaultLayerProperties;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.featureservice.factory.H2FeatureServiceFactory;
import de.cismet.cismap.commons.tools.ExportCsvDownload;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.tools.gui.downloadmanager.DownloadManagerDialog;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.broker.ComponentName;
import de.cismet.watergis.gui.WatergisApp;
import de.cismet.watergis.gui.actions.map.RemoveDrawingModeAction;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SaveDrawingsAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(SaveDrawingsAction.class);
    private static final List<String[]> ATTRIBUTE_LIST = new ArrayList<String[]>();

    public SaveDrawingsAction() {
        String tooltip = NbBundle.getMessage(SaveDrawingsAction.class, (String)"SaveDrawingsAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(SaveDrawingsAction.class, (String)"SaveDrawingsAction.text");
        this.putValue("Name", text);
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-save-floppy.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file = StaticSwingTools.chooseFile((String)WatergisApp.getDIRECTORYPATH_WATERGIS(), (boolean)true, (String[])new String[]{"ze"}, (String)NbBundle.getMessage(SaveDrawingsAction.class, (String)"SaveDrawingsAction.actionPerformed.FileFilter.getDescription"), (Component)AppBroker.getInstance().getComponent(ComponentName.MAIN));
        if (file != null) {
            if (file.exists()) {
                file.delete();
            }
            this.saveDrawing(file);
        }
    }

    private void saveDrawing(File file) {
        try {
            ArrayList<DefaultFeatureServiceFeature> featureList = new ArrayList<DefaultFeatureServiceFeature>();
            DefaultLayerProperties layerProps = new DefaultLayerProperties();
            List<DrawingSLDStyledFeature> features = RemoveDrawingModeAction.getSelectedDrawings();
            if (features == null || features.isEmpty()) {
                features = DrawingManager.getInstance().getAllFeatures();
            }
            H2FeatureService service = new H2FeatureService("tmpDrawing", "~/cismap/internalH2", "Zeichnungen", null);
            service.initAndWait();
            layerProps.setFeatureService((AbstractFeatureService)service);
            Base64 base64 = new Base64();
            for (DrawingSLDStyledFeature dFeature : features) {
                DefaultFeatureServiceFeature f = new DefaultFeatureServiceFeature(dFeature.getId(), dFeature.getGeometry(), (LayerProperties)layerProps);
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("id", dFeature.getId());
                properties.put("geom", dFeature.getGeometry());
                properties.put("type", dFeature.getGeometryType().toString());
                properties.put("text", dFeature.getText());
                properties.put("autoscale", dFeature.isAutoscale());
                properties.put("background", dFeature.getPrimaryAnnotationHalo() != null);
                properties.put("fontsize", dFeature.getPrimaryAnnotationFont() != null ? Integer.valueOf(dFeature.getPrimaryAnnotationFont().getSize()) : null);
                properties.put("sld", base64.encodeAsString(((String)dFeature.getProperty("sld")).getBytes()));
                f.setProperties(properties);
                featureList.add(f);
            }
            boolean openAutomatically = DownloadManagerDialog.getInstance().isOpenAutomaticallyEnabled();
            DownloadManagerDialog.getInstance().setOpenAutomaticallyEnabled(false);
            ExportCsvDownload ed = new ExportCsvDownload(file.getName().substring(0, file.getName().lastIndexOf(".")), ".ze", featureList.toArray(new FeatureServiceFeature[featureList.size()]), (AbstractFeatureService)service, ATTRIBUTE_LIST);
            DownloadManager.instance().setDestinationDirectory(file.getParentFile());
            DownloadManager.instance().add((Download)ed);
            ((H2FeatureServiceFactory)service.getFeatureFactory()).closeConnection();
            service = null;
            DownloadManagerDialog.getInstance().setOpenAutomaticallyEnabled(openAutomatically);
        }
        catch (Exception ee) {
            LOG.error((Object)"", (Throwable)ee);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    static {
        ATTRIBUTE_LIST.add(new String[]{"id", "id"});
        ATTRIBUTE_LIST.add(new String[]{"geom", "geom"});
        ATTRIBUTE_LIST.add(new String[]{"type", "type"});
        ATTRIBUTE_LIST.add(new String[]{"text", "text"});
        ATTRIBUTE_LIST.add(new String[]{"autoscale", "autoscale"});
        ATTRIBUTE_LIST.add(new String[]{"background", "background"});
        ATTRIBUTE_LIST.add(new String[]{"fontsize", "fontsize"});
        ATTRIBUTE_LIST.add(new String[]{"sld", "sld"});
    }
}

