/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.map;

import de.cismet.watergis.broker.AppBroker;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class SelectionModeAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(SelectionModeAction.class);
    private JButton button;

    public SelectionModeAction() {
        this.setEnabled(false);
        String tooltip = NbBundle.getMessage(SelectionModeAction.class, (String)"SelectionModeAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(SelectionModeAction.class, (String)"SelectionModeAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(SelectionModeAction.class, (String)"SelectionModeAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/select.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Switch in Selection Mode");
        }
        AppBroker.getInstance().getMappingComponent().setInteractionMode("SELECT");
        this.putValue("SwingSelectedKey", Boolean.TRUE);
        AppBroker.getInstance().getMappingComponent().getHandleLayer().moveToFront();
        if (this.button != null) {
            this.button.setSelected(true);
        }
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void setButton(JButton button) {
        this.button = button;
    }
}

