/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.reports;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.download.FakeFileDownload;
import de.cismet.watergis.gui.dialog.GerinneOSbReportDialog;
import de.cismet.watergis.reports.GerinneOSbReport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class GerinneOSbReportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(GerinneOSbReportAction.class);

    public GerinneOSbReportAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-analytics-piechart.png");
        String text = "Schaubezirke";
        String tooltiptext = "Schaubezirkeauswertung";
        String mnemonic = "S";
        try {
            text = NbBundle.getMessage(GerinneOSbReportAction.class, (String)"GerinneOSbReportAction.text");
            tooltiptext = NbBundle.getMessage(GerinneOSbReportAction.class, (String)"GerinneOSbReportAction.toolTipText");
            mnemonic = NbBundle.getMessage(GerinneOSbReportAction.class, (String)"GerinneOSbReportAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            StaticSwingTools.showDialog((JDialog)GerinneOSbReportDialog.getInstance());
            if (!GerinneOSbReportDialog.getInstance().isCancelled()) {
                WaitingDialogThread<File> wdt = new WaitingDialogThread<File>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "erstelle Auswertung", null, 100, true){

                    protected File doInBackground() throws Exception {
                        ArrayList<Integer> baCdList = new ArrayList<Integer>();
                        if (GerinneOSbReportDialog.getInstance().isSelectionGew()) {
                            for (FeatureServiceFeature feature : GerinneOSbReportDialog.getInstance().getSelectedGew()) {
                                baCdList.add((Integer)feature.getProperty("id"));
                            }
                        }
                        GerinneOSbReport gr = new GerinneOSbReport();
                        int[] gew = new int[baCdList.size()];
                        if (baCdList.isEmpty()) {
                            gew = null;
                        } else {
                            for (int i = 0; i < baCdList.size(); ++i) {
                                gew[i] = (Integer)baCdList.get(i);
                            }
                        }
                        return gr.createSbReport(gew);
                    }

                    protected void done() {
                        try {
                            DownloadManager.instance().add((Download)new FakeFileDownload((File)this.get(), "Statistik: Gerinne (offen)->Schaubezirke"));
                        }
                        catch (Exception e) {
                            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), "Bei der Erstellung der Auswertung ist ein Fehler aufgetreten.\nEine Fehlerbeschreibung kann dem Logging entnommen werden", "Fehler", 0);
                            LOG.error((Object)"Error while performing the offene Gerinne sb report.", (Throwable)e);
                        }
                    }
                };
                wdt.start();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while creating gerinne offen sb report", (Throwable)ex);
        }
    }
}

