/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.reports;

import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.download.FakeFileDownload;
import de.cismet.watergis.gui.dialog.KatasterFlaechenReportDialog;
import de.cismet.watergis.reports.KatasterflaechenReport;
import de.cismet.watergis.reports.types.Flaeche;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class KatasterFlaechenReportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(KatasterFlaechenReportAction.class);

    public KatasterFlaechenReportAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-analytics-piechart.png");
        String text = "Fl\u00e4chenthema";
        String tooltiptext = "Fl\u00e4chenauswertung";
        String mnemonic = "F";
        try {
            text = NbBundle.getMessage(KatasterFlaechenReportAction.class, (String)"KatasterFlaechenReportAction.text");
            tooltiptext = NbBundle.getMessage(KatasterFlaechenReportAction.class, (String)"KatasterFlaechenReportAction.toolTipText");
            mnemonic = NbBundle.getMessage(KatasterFlaechenReportAction.class, (String)"KatasterFlaechenReportAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            StaticSwingTools.showDialog((JDialog)KatasterFlaechenReportDialog.getInstance());
            if (!KatasterFlaechenReportDialog.getInstance().isCancelled()) {
                WaitingDialogThread<File> wdt = new WaitingDialogThread<File>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "erstelle Auswertung", null, 100, true){

                    protected File doInBackground() throws Exception {
                        Flaeche fl;
                        ArrayList<Flaeche> flList = new ArrayList<Flaeche>();
                        ArrayList<Integer> baCdList = new ArrayList<Integer>();
                        if (KatasterFlaechenReportDialog.getInstance().isSelectionFl()) {
                            FeatureServiceFeature[] featureServiceFeatureArray = KatasterFlaechenReportDialog.getInstance().getSelectedFl();
                            int n = featureServiceFeatureArray.length;
                            for (int i = 0; i < n; ++i) {
                                FeatureServiceFeature feature = featureServiceFeatureArray[i];
                                fl = new Flaeche();
                                fl.setGeom(feature.getGeometry());
                                fl.setAttr1(feature.getProperty(KatasterFlaechenReportDialog.getInstance().getAttr1()));
                                fl.setAttr2(feature.getProperty(KatasterFlaechenReportDialog.getInstance().getAttr2()));
                                flList.add(fl);
                            }
                        } else {
                            FeatureServiceFeature[] service = KatasterFlaechenReportDialog.getInstance().getFlaechenService();
                            service.initAndWait();
                            List features = service.getFeatureFactory().createFeatures(service.getQuery(), null, null, 0, 0, null);
                            for (FeatureServiceFeature feature : features) {
                                fl = new Flaeche();
                                fl.setGeom(feature.getGeometry());
                                fl.setAttr1(feature.getProperty(KatasterFlaechenReportDialog.getInstance().getAttr1()));
                                fl.setAttr2(feature.getProperty(KatasterFlaechenReportDialog.getInstance().getAttr2()));
                                flList.add(fl);
                            }
                        }
                        if (KatasterFlaechenReportDialog.getInstance().isSelectionGew()) {
                            for (FeatureServiceFeature feature : KatasterFlaechenReportDialog.getInstance().getSelectedGew()) {
                                baCdList.add((Integer)feature.getProperty("id"));
                            }
                        }
                        KatasterflaechenReport gr = new KatasterflaechenReport();
                        int[] gew = new int[baCdList.size()];
                        if (baCdList.isEmpty()) {
                            gew = null;
                        } else {
                            for (int i = 0; i < baCdList.size(); ++i) {
                                gew[i] = (Integer)baCdList.get(i);
                            }
                        }
                        return gr.createFlaechenReport(flList.toArray(new Flaeche[flList.size()]), gew);
                    }

                    protected void done() {
                        try {
                            DownloadManager.instance().add((Download)new FakeFileDownload((File)this.get(), "Statistik: Kataster->Fl\u00e4chen"));
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while performing the gewaesser report.", (Throwable)e);
                        }
                    }
                };
                wdt.start();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Error while creating gewaesser report", (Throwable)ex);
        }
    }
}

