/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.AllGemeinden;
import de.cismet.cids.custom.watergis.server.search.RouteEnvelopes;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.download.FakeFileDownload;
import de.cismet.watergis.gui.actions.reports.KatasterGewaesserReportAction;
import de.cismet.watergis.gui.dialog.KatasterGemeindeReportDialog;
import de.cismet.watergis.reports.KatasterGemeindeReport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class KatasterGemeindenReportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(KatasterGemeindenReportAction.class);

    public KatasterGemeindenReportAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-analytics-piechart.png");
        String text = "Gemeinden";
        String tooltiptext = "Gemeindenauswertung";
        String mnemonic = "G";
        try {
            text = NbBundle.getMessage(KatasterGemeindenReportAction.class, (String)"GemeindenReportAction.text");
            tooltiptext = NbBundle.getMessage(KatasterGemeindenReportAction.class, (String)"GemeindenReportAction.toolTipText");
            mnemonic = NbBundle.getMessage(KatasterGemeindenReportAction.class, (String)"GemeindenReportAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int result = JOptionPane.showOptionDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(KatasterGewaesserReportAction.class, (String)"KatasterGemeindenReportAction.actionPerformed.message"), NbBundle.getMessage(KatasterGewaesserReportAction.class, (String)"KatasterGemeindenReportAction.actionPerformed.title"), 0, -1, null, new Object[]{"Weiter zur Statistik", "Abbrechen"}, null);
        if (result == 0 && (result = JOptionPane.showOptionDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(KatasterGewaesserReportAction.class, (String)"KatasterGemeindenReportAction.actionPerformed.message2"), NbBundle.getMessage(KatasterGewaesserReportAction.class, (String)"KatasterGemeindenReportAction.actionPerformed.title2"), 0, -1, null, new Object[]{"Weiter zur Statistik", "Abbrechen"}, null)) == 0) {
            try {
                StaticSwingTools.showDialog((JDialog)KatasterGemeindeReportDialog.getInstance());
                if (!KatasterGemeindeReportDialog.getInstance().isCancelled()) {
                    WaitingDialogThread<File> wdt = new WaitingDialogThread<File>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "erstelle Auswertung                ", null, 100, true){

                        /*
                         * WARNING - void declaration
                         */
                        protected File doInBackground() throws Exception {
                            void var6_20;
                            AllGemeinden search;
                            ArrayList<Integer> baCdList = new ArrayList<Integer>();
                            ArrayList<Integer> gmdList = new ArrayList<Integer>();
                            if (KatasterGemeindeReportDialog.getInstance().isSelectionGew()) {
                                for (FeatureServiceFeature featureServiceFeature : KatasterGemeindeReportDialog.getInstance().getSelectedGew()) {
                                    baCdList.add((Integer)featureServiceFeature.getProperty("id"));
                                }
                            } else if (AppBroker.getInstance().isGu()) {
                                String praefixGroup = AppBroker.getInstance().getOwnWwGr() != null ? (String)AppBroker.getInstance().getOwnWwGr().getProperty("praefixgroup") : null;
                                search = praefixGroup != null ? new RouteEnvelopes(" dlm25wPk_ww_gr1.owner = '" + AppBroker.getInstance().getOwner() + "' or dlm25wPk_ww_gr1.praefixgroup = '" + praefixGroup + "'") : new RouteEnvelopes(" dlm25wPk_ww_gr1.owner = '" + AppBroker.getInstance().getOwner() + "'");
                                User user = SessionManager.getSession().getUser();
                                ArrayList arrayList = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
                                if (arrayList != null && !arrayList.isEmpty()) {
                                    for (ArrayList f : arrayList) {
                                        baCdList.add((Integer)f.get(2));
                                    }
                                }
                            }
                            if (KatasterGemeindeReportDialog.getInstance().isSelectionGmd()) {
                                for (AllGemeinden allGemeinden : KatasterGemeindeReportDialog.getInstance().getSelectedGmd()) {
                                    gmdList.add((Integer)allGemeinden.getProperty("gmd_nr"));
                                }
                            } else {
                                search = new AllGemeinden(baCdList);
                                User user = SessionManager.getSession().getUser();
                                ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
                                if (attributes != null && !attributes.isEmpty()) {
                                    for (ArrayList f : attributes) {
                                        gmdList.add((Integer)f.get(0));
                                    }
                                }
                            }
                            KatasterGemeindeReport gr = new KatasterGemeindeReport();
                            int[] gmd = new int[gmdList.size()];
                            int[] gew = new int[baCdList.size()];
                            boolean bl = false;
                            while (var6_20 < gmdList.size()) {
                                gmd[var6_20] = (Integer)gmdList.get((int)var6_20);
                                ++var6_20;
                            }
                            if (baCdList.isEmpty()) {
                                gew = null;
                            } else {
                                void var6_22;
                                boolean bl2 = false;
                                while (var6_22 < baCdList.size()) {
                                    gew[var6_22] = (Integer)baCdList.get((int)var6_22);
                                    ++var6_22;
                                }
                            }
                            return gr.createGemeindeReport(gmd, gew, this.wd);
                        }

                        protected void done() {
                            try {
                                File file = (File)this.get();
                                if (file != null) {
                                    DownloadManager.instance().add((Download)new FakeFileDownload(file, "Statistik: Kataster->Gemeinden"));
                                }
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Error while performing the gemeinden report.", (Throwable)e);
                            }
                        }
                    };
                    wdt.start();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while creating gemeinden report", (Throwable)ex);
            }
        }
    }
}

