/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.reports;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import de.cismet.cids.custom.watergis.server.search.RouteEnvelopes;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.tools.gui.downloadmanager.Download;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.download.FakeFileDownload;
import de.cismet.watergis.gui.dialog.KatasterGewaesserReportDialog;
import de.cismet.watergis.reports.KatasterGewaesserReport;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.MissingResourceException;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class KatasterGewaesserReportAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(KatasterGewaesserReportAction.class);

    public KatasterGewaesserReportAction() {
        URL icon = this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-analytics-piechart.png");
        String text = "Gew\u00e4sser";
        String tooltiptext = "Gew\u00e4sser";
        String mnemonic = "E";
        try {
            text = NbBundle.getMessage(KatasterGewaesserReportAction.class, (String)"GewaesserGewReportAction.text");
            tooltiptext = NbBundle.getMessage(KatasterGewaesserReportAction.class, (String)"GewaesserGewReportAction.toolTipText");
            mnemonic = NbBundle.getMessage(KatasterGewaesserReportAction.class, (String)"GewaesserGewReportAction.mnemonic");
        }
        catch (MissingResourceException e) {
            LOG.error((Object)"Couldn't find resources. Using fallback settings.", (Throwable)e);
        }
        if (icon != null) {
            this.putValue("SmallIcon", new ImageIcon(icon));
        }
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        this.putValue("Name", text);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int result = JOptionPane.showOptionDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(KatasterGewaesserReportAction.class, (String)"KatasterGewaesserReportAction.actionPerformed.message"), NbBundle.getMessage(KatasterGewaesserReportAction.class, (String)"KatasterGewaesserReportAction.actionPerformed.title"), 0, -1, null, new Object[]{"Weiter zur Statistik", "Abbrechen"}, null);
        if (result == 0) {
            try {
                StaticSwingTools.showDialog((JDialog)KatasterGewaesserReportDialog.getInstance());
                if (!KatasterGewaesserReportDialog.getInstance().isCancelled()) {
                    WaitingDialogThread<File> wdt = new WaitingDialogThread<File>(StaticSwingTools.getParentFrame((Component)AppBroker.getInstance().getWatergisApp()), true, "erstelle Auswertung", null, 100, true){

                        protected File doInBackground() throws Exception {
                            ArrayList<Integer> baCdList = new ArrayList<Integer>();
                            if (KatasterGewaesserReportDialog.getInstance().isSelectionGew()) {
                                for (FeatureServiceFeature feature : KatasterGewaesserReportDialog.getInstance().getSelectedGew()) {
                                    baCdList.add((Integer)feature.getProperty("id"));
                                }
                            } else if (AppBroker.getInstance().isGu()) {
                                String praefixGroup = AppBroker.getInstance().getOwnWwGr() != null ? (String)AppBroker.getInstance().getOwnWwGr().getProperty("praefixgroup") : null;
                                RouteEnvelopes search = praefixGroup != null ? new RouteEnvelopes(" dlm25wPk_ww_gr1.owner = '" + AppBroker.getInstance().getOwner() + "' or dlm25wPk_ww_gr1.praefixgroup = '" + praefixGroup + "'") : new RouteEnvelopes(" dlm25wPk_ww_gr1.owner = '" + AppBroker.getInstance().getOwner() + "'");
                                User user = SessionManager.getSession().getUser();
                                ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
                                if (attributes != null && !attributes.isEmpty()) {
                                    for (ArrayList f : attributes) {
                                        baCdList.add((Integer)f.get(2));
                                    }
                                }
                            }
                            KatasterGewaesserReport gr = new KatasterGewaesserReport();
                            int[] gew = new int[baCdList.size()];
                            if (baCdList.isEmpty()) {
                                gew = null;
                            } else {
                                for (int i = 0; i < baCdList.size(); ++i) {
                                    gew[i] = (Integer)baCdList.get(i);
                                }
                            }
                            return gr.createGewaesserReport(gew, this.wd);
                        }

                        protected void done() {
                            try {
                                DownloadManager.instance().add((Download)new FakeFileDownload((File)this.get(), "Statistik: Kataster->Gew\u00e4sser"));
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Error while performing the Kataster Gewaesser report.", (Throwable)e);
                            }
                        }
                    };
                    wdt.start();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while creating gemeinden report", (Throwable)ex);
            }
        }
    }
}

