/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.selection;

import de.cismet.cismap.DrawingManager;
import de.cismet.cismap.commons.features.DrawingSLDStyledFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.gui.layerwidget.ZoomToFeaturesWorker;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.openide.util.NbBundle;

public class ZoomAllDrawingsAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ZoomAllDrawingsAction.class);

    public ZoomAllDrawingsAction() {
        String tooltip = NbBundle.getMessage(ZoomAllDrawingsAction.class, (String)"ZoomAllDrawingsAction.toolTipText");
        this.putValue("ShortDescription", tooltip);
        String text = NbBundle.getMessage(ZoomAllDrawingsAction.class, (String)"ZoomAllDrawingsAction.text");
        this.putValue("Name", text);
        String mnemonic = NbBundle.getMessage(ZoomAllDrawingsAction.class, (String)"ZoomAllDrawingsAction.mnemonic");
        this.putValue("MnemonicKey", KeyStroke.getKeyStroke(mnemonic).getKeyCode());
        ImageIcon icon = new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-googleplusold.png"));
        this.putValue("SmallIcon", icon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<DrawingSLDStyledFeature> sel = DrawingManager.getInstance().getAllFeatures();
        ZoomToFeaturesWorker worker = new ZoomToFeaturesWorker(sel.toArray(new Feature[sel.size()]), 10);
        worker.execute();
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

