/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.actions.split;

import Sirius.server.middleware.types.MetaClass;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.LineAndStationCreator;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.FeatureCreator;
import de.cismet.cismap.commons.gui.attributetable.FeatureLockerFactory;
import de.cismet.cismap.commons.gui.attributetable.FeatureLockingInterface;
import de.cismet.cismap.commons.gui.attributetable.LockAlreadyExistsException;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.linearreferencing.FeatureRegistry;
import de.cismet.cismap.linearreferencing.LinearReferencingHelper;
import de.cismet.math.geometry.StaticGeometryFunctions;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.merge.CidsLayerFeatureMerger;
import de.cismet.watergis.gui.actions.split.FeatureSplitter;
import de.cismet.watergis.utils.GeometryUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CidsLayerFeatureSplitter
implements FeatureSplitter {
    private static final Logger LOG = Logger.getLogger(CidsLayerFeatureSplitter.class);
    private static final String[] POSSIBLE_LINE_PROP_NAMES = new String[]{"ba_st", "bak_st", "la_st", "lak_st", "sg_su_stat"};
    private static int stationId = -1;
    private static Set<Feature> lockedFeatures = new TreeSet<Feature>();
    private final List<FeatureServiceFeature> additionalFeaturesToSave = new ArrayList<FeatureServiceFeature>();
    private List<FeatureServiceFeature> originalFeature = new ArrayList<FeatureServiceFeature>();
    private List<FeatureServiceFeature> featuresToRemove = new ArrayList<FeatureServiceFeature>();
    private Map<FeatureLockingInterface, List<Object>> lockMap = new HashMap<FeatureLockingInterface, List<Object>>();
    private LinearReferencingHelper linearReferencingHelper = FeatureRegistry.getInstance().getLinearReferencingSolver();

    @Override
    public Feature[] split(Feature masterFeature, LineString splitLine) {
        if (masterFeature instanceof DefaultFeatureServiceFeature) {
            int i;
            DefaultFeatureServiceFeature dfsf = (DefaultFeatureServiceFeature)masterFeature;
            boolean isMulti = masterFeature.getGeometry().getGeometryType().toLowerCase().startsWith("multi");
            Geometry geom = dfsf.getGeometry();
            Geometry[] splittedGeom = GeometryUtils.splitGeom(geom, splitLine);
            if (splittedGeom.length > 0) {
                for (i = 0; i < splittedGeom.length; ++i) {
                    if ((splittedGeom[i] instanceof LineString || splittedGeom[i] instanceof MultiLineString) && splittedGeom[i].getLength() < 0.01) {
                        return null;
                    }
                    if (!(splittedGeom[i] instanceof Polygon) && !(splittedGeom[i] instanceof MultiPolygon) || !(splittedGeom[i].getArea() < 1.0E-4)) continue;
                    return null;
                }
            }
            if (isMulti) {
                for (i = 0; i < splittedGeom.length; ++i) {
                    splittedGeom[i] = StaticGeometryFunctions.toMultiGeometry((Geometry)splittedGeom[i]);
                    splittedGeom[i].setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                }
            } else if (splittedGeom[0] instanceof LineString) {
                Arrays.sort(splittedGeom, new Comparator<Geometry>(){

                    @Override
                    public int compare(Geometry o1, Geometry o2) {
                        return (int)Math.signum(o2.getLength() - o1.getLength());
                    }
                });
            }
            if (((DefaultFeatureServiceFeature)masterFeature).getLayerProperties() == null || ((DefaultFeatureServiceFeature)masterFeature).getLayerProperties().getAttributeTableRuleSet() == null) {
                LOG.error((Object)"Cids layer has no layer properties");
                return null;
            }
            ArrayList<FeatureServiceFeature> newFeatures = new ArrayList<FeatureServiceFeature>();
            if (splittedGeom.length > 1) {
                CidsLayer layer = (CidsLayer)((CidsLayerFeature)masterFeature).getLayerProperties().getFeatureService();
                if (layer.getMetaClass().getTableName().equalsIgnoreCase("dlm25w.fg_bak")) {
                    try {
                        this.splitCat2((CidsLayerFeature)masterFeature, splitLine);
                    }
                    catch (LockAlreadyExistsException ex) {
                        return null;
                    }
                }
                masterFeature.setGeometry(splittedGeom[0]);
                for (int i2 = 1; i2 < splittedGeom.length; ++i2) {
                    AttributeTableRuleSet ruleSet = ((DefaultFeatureServiceFeature)masterFeature).getLayerProperties().getAttributeTableRuleSet();
                    FeatureServiceFeature newFeature = ruleSet.cloneFeature((FeatureServiceFeature)dfsf);
                    newFeatures.add(newFeature);
                    try {
                        newFeature.setGeometry(splittedGeom[i2]);
                        String linePropertyName = null;
                        Object origLineBean = null;
                        for (String possibleName : POSSIBLE_LINE_PROP_NAMES) {
                            origLineBean = ((CidsLayerFeature)masterFeature).getBean().getProperty(possibleName);
                            if (!(origLineBean instanceof CidsBean)) continue;
                            linePropertyName = possibleName;
                            break;
                        }
                        if (linePropertyName == null) continue;
                        if (ruleSet.isCatThree()) {
                            newFeature.setProperty(linePropertyName, null);
                            FeatureCreator creator = ruleSet.getFeatureCreator();
                            LineAndStationCreator lineCreator = (LineAndStationCreator)creator;
                            MetaClass routeMc = lineCreator.getRouteClass();
                            String stationProperty = lineCreator.getStationProperty();
                            if (i2 == 1) {
                                ((CidsLayerFeature)masterFeature).removeStations();
                                ((CidsLayerFeature)masterFeature).setProperty(linePropertyName, null);
                                ((CidsLayerFeature)masterFeature).getBean().setProperty(linePropertyName, null);
                                if (creator instanceof LineAndStationCreator) {
                                    CidsLayerFeatureMerger.setCalculatedLine((FeatureServiceFeature)masterFeature, routeMc, this.linearReferencingHelper, splittedGeom[0], stationProperty);
                                }
                                ((CidsLayerFeature)masterFeature).initStations();
                            }
                            if (!(creator instanceof LineAndStationCreator)) continue;
                            CidsLayerFeatureMerger.setCalculatedLine(newFeature, routeMc, this.linearReferencingHelper, splittedGeom[i2], stationProperty);
                            ((CidsLayerFeature)newFeature).initStations();
                            continue;
                        }
                        CidsBean statLine = CidsLayerFeatureSplitter.cloneStationline((CidsBean)origLineBean);
                        statLine = this.adjustLineStation(statLine, splittedGeom[i2], true);
                        newFeature.setProperty(linePropertyName, (Object)statLine);
                        if (i2 != 1) continue;
                        this.adjustLineStation((CidsBean)origLineBean, splittedGeom[0], false);
                        ((DefaultFeatureServiceFeature)masterFeature).setProperty(linePropertyName, origLineBean);
                        continue;
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while cloning station line", (Throwable)e);
                    }
                }
            }
            return newFeatures.toArray(new Feature[newFeatures.size()]);
        }
        return null;
    }

    private void splitCat2(CidsLayerFeature fgBak, LineString splitLine) throws LockAlreadyExistsException {
        ArrayList<MetaClass> cat2Classes = new ArrayList<MetaClass>();
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_anll"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_bbef"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_d"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_due"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_gbk_delta"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_leis"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_prof"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_rl"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_sb"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_sbef"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_tech"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_ubef"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba_ughz"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_ae"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gbk"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gn1"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gn2"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gn3"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_gwk"));
        cat2Classes.add(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak_wk"));
        for (MetaClass cl : cat2Classes) {
            try {
                FeatureLockingInterface locker;
                CidsLayer layer = new CidsLayer(cl);
                layer.initAndWait();
                String query = cl.getTableName().toLowerCase().contains("fg_bak") ? "dlm25w.fg_bak.ba_cd = '" + fgBak.getProperty("ba_cd") + "'" : "dlm25w.fg_ba.ba_cd = '" + fgBak.getProperty("ba_cd") + "'";
                List features = layer.getFeatureFactory().createFeatures((Object)query, null, null, 0, 0, null);
                if (features != null && !features.isEmpty() && (locker = FeatureLockerFactory.getInstance().getLockerForFeatureService((AbstractFeatureService)layer)) != null) {
                    try {
                        List<Object> locks = this.lockMap.get(locker);
                        ArrayList<Feature> featuresToLock = new ArrayList<Feature>();
                        if (locks == null) {
                            locks = new ArrayList<Object>();
                            this.lockMap.put(locker, locks);
                        }
                        for (Feature f : features) {
                            if (lockedFeatures.contains(f)) continue;
                            featuresToLock.add(f);
                        }
                        locks.add(locker.lock(featuresToLock, false));
                        lockedFeatures.addAll(featuresToLock);
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), "Es k\u00f6nnen aufgesetzte Objekte aus " + layer.getName() + " nicht gesperrt werden", "Sperre", 0);
                        this.unlockObjects();
                        throw new LockAlreadyExistsException(e.getMessage(), "Object already locked");
                    }
                }
                for (Feature f : features) {
                    FeatureServiceFeature feature = (FeatureServiceFeature)f;
                    if (!feature.getGeometry().intersects((Geometry)splitLine)) continue;
                    AttributeTableRuleSet ruleSet = ((DefaultFeatureServiceFeature)feature).getLayerProperties().getAttributeTableRuleSet();
                    FeatureServiceFeature clonedFeature = ruleSet.cloneFeature(feature);
                    clonedFeature.setId(feature.getId());
                    clonedFeature.setProperty("id", (Object)feature.getId());
                    ((CidsLayerFeature)clonedFeature).getBean();
                    this.originalFeature.add(clonedFeature);
                    Feature[] splittedFeatures = this.split((Feature)feature, splitLine);
                    if (splittedFeatures == null || splittedFeatures.length <= 0) continue;
                    this.additionalFeaturesToSave.add(feature);
                    for (Feature splittedFeature : splittedFeatures) {
                        if (splittedFeature.getGeometry() == null || !(splittedFeature.getGeometry() instanceof LineString) || !(((LineString)splittedFeature.getGeometry()).getLength() > 0.01)) continue;
                        this.featuresToRemove.add((FeatureServiceFeature)splittedFeature);
                        this.additionalFeaturesToSave.add((FeatureServiceFeature)splittedFeature);
                    }
                }
            }
            catch (LockAlreadyExistsException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.error((Object)"Error while splitting features");
            }
        }
    }

    @Override
    public List<FeatureServiceFeature> getAdditionalFeaturesToSave() {
        return this.additionalFeaturesToSave;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() {
        try {
            for (FeatureServiceFeature feature : this.originalFeature) {
                try {
                    CidsBean bean = ((CidsLayerFeature)feature).getBean();
                    bean.getMetaObject().setStatus(2);
                    if ((CidsBean)bean.getProperty("ba_st") != null) {
                        bean.getMetaObject().setStatus(2);
                        bean.getMetaObject().getAttribute("ba_st").setChanged(true);
                        ((CidsBean)bean.getProperty("ba_st")).getMetaObject().setStatus(2);
                        ((CidsBean)bean.getProperty("ba_st")).getMetaObject().getAttribute("von").setChanged(true);
                        ((CidsBean)bean.getProperty("ba_st")).getMetaObject().getAttribute("bis").setChanged(true);
                        ((CidsBean)bean.getProperty("ba_st")).getMetaObject().getAttribute("geom").setChanged(true);
                        ((CidsBean)bean.getProperty("ba_st.geom")).getMetaObject().setStatus(2);
                        ((CidsBean)bean.getProperty("ba_st.geom")).getMetaObject().getAttribute("GEO_STRING").setChanged(true);
                        ((CidsBean)bean.getProperty("ba_st.von")).getMetaObject().setStatus(2);
                        ((CidsBean)bean.getProperty("ba_st.von")).getMetaObject().getAttribute("wert").setChanged(true);
                        ((CidsBean)bean.getProperty("ba_st.von")).getMetaObject().getAttribute("real_point").setChanged(true);
                        ((CidsBean)bean.getProperty("ba_st.von.real_point")).getMetaObject().setStatus(2);
                        ((CidsBean)bean.getProperty("ba_st.von.real_point")).getMetaObject().getAttribute("GEO_STRING").setChanged(true);
                        ((CidsBean)bean.getProperty("ba_st.bis")).getMetaObject().setStatus(2);
                        ((CidsBean)bean.getProperty("ba_st.bis")).getMetaObject().getAttribute("wert").setChanged(true);
                        ((CidsBean)bean.getProperty("ba_st.bis")).getMetaObject().getAttribute("real_point").setChanged(true);
                        ((CidsBean)bean.getProperty("ba_st.bis.real_point")).getMetaObject().setStatus(2);
                        ((CidsBean)bean.getProperty("ba_st.bis.real_point")).getMetaObject().getAttribute("GEO_STRING").setChanged(true);
                    }
                    if ((CidsBean)bean.getProperty("bak_st") != null) {
                        bean.getMetaObject().setStatus(2);
                        bean.getMetaObject().getAttribute("bak_st").setChanged(true);
                        ((CidsBean)bean.getProperty("bak_st")).getMetaObject().setStatus(2);
                        ((CidsBean)bean.getProperty("bak_st")).getMetaObject().getAttribute("von").setChanged(true);
                        ((CidsBean)bean.getProperty("bak_st")).getMetaObject().getAttribute("bis").setChanged(true);
                        ((CidsBean)bean.getProperty("bak_st")).getMetaObject().getAttribute("geom").setChanged(true);
                        ((CidsBean)bean.getProperty("bak_st.geom")).getMetaObject().setStatus(2);
                        ((CidsBean)bean.getProperty("bak_st.geom")).getMetaObject().getAttribute("GEO_STRING").setChanged(true);
                        ((CidsBean)bean.getProperty("bak_st.von")).getMetaObject().setStatus(2);
                        ((CidsBean)bean.getProperty("bak_st.von")).getMetaObject().getAttribute("wert").setChanged(true);
                        ((CidsBean)bean.getProperty("bak_st.von")).getMetaObject().getAttribute("real_point").setChanged(true);
                        ((CidsBean)bean.getProperty("bak_st.von.real_point")).getMetaObject().setStatus(2);
                        ((CidsBean)bean.getProperty("bak_st.von.real_point")).getMetaObject().getAttribute("GEO_STRING").setChanged(true);
                        ((CidsBean)bean.getProperty("bak_st.bis")).getMetaObject().setStatus(2);
                        ((CidsBean)bean.getProperty("bak_st.bis")).getMetaObject().getAttribute("wert").setChanged(true);
                        ((CidsBean)bean.getProperty("bak_st.bis")).getMetaObject().getAttribute("real_point").setChanged(true);
                        ((CidsBean)bean.getProperty("bak_st.bis.real_point")).getMetaObject().setStatus(2);
                        ((CidsBean)bean.getProperty("bak_st.bis.real_point")).getMetaObject().getAttribute("GEO_STRING").setChanged(true);
                    }
                    bean.persist();
                }
                catch (Exception e) {
                    ((CidsLayerFeature)feature).getBean().getMetaObject().setStatus(2);
                    LOG.error((Object)"Cannot undo split change", (Throwable)e);
                }
                ((CidsLayerFeature)feature).getBean().getMetaObject().setStatus(0);
            }
            for (FeatureServiceFeature feature : this.featuresToRemove) {
                try {
                    ((CidsLayerFeature)feature).delete();
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot undo split change", (Throwable)e);
                }
            }
        }
        finally {
            this.unlockObjects();
        }
    }

    private CidsBean adjustLineStation(CidsBean master, Geometry geometry, boolean cloneStations) throws Exception {
        double tillValue;
        Geometry routGeom;
        LengthIndexedLine lil;
        double fromValue;
        int newId;
        CidsBean fromStation = this.linearReferencingHelper.getStationBeanFromLineBean(master, true);
        CidsBean tillStation = this.linearReferencingHelper.getStationBeanFromLineBean(master, false);
        if (cloneStations && fromStation != null) {
            fromStation = CidsLayerFeatureSplitter.cloneStation(fromStation);
            newId = --stationId;
            fromStation.getMetaObject().setID(newId);
            fromStation.setProperty("id", (Object)newId);
        }
        if (cloneStations && tillStation != null) {
            tillStation = CidsLayerFeatureSplitter.cloneStation(tillStation);
            newId = --stationId;
            tillStation.getMetaObject().setID(newId);
            tillStation.setProperty("id", (Object)newId);
            master = this.linearReferencingHelper.createLineBeanFromStationBean(fromStation, tillStation);
        }
        if ((fromValue = (lil = new LengthIndexedLine(routGeom = this.linearReferencingHelper.getRouteGeometryFromStationBean(fromStation))).indexOf(geometry.getCoordinates()[0])) > (tillValue = lil.indexOf(geometry.getCoordinates()[geometry.getCoordinates().length - 1]))) {
            double tmp = fromValue;
            fromValue = tillValue;
            tillValue = tmp;
        }
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
        Point fromPoint = factory.createPoint(lil.extractPoint(fromValue));
        Point tillPoint = factory.createPoint(lil.extractPoint(tillValue));
        Geometry lineGeometry = lil.extractLine(fromValue, tillValue);
        fromPoint.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        tillPoint.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        lineGeometry.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
        this.linearReferencingHelper.setLinearValueToStationBean(Double.valueOf(fromValue), fromStation);
        this.linearReferencingHelper.setLinearValueToStationBean(Double.valueOf(tillValue), tillStation);
        this.linearReferencingHelper.setPointGeometryToStationBean((Geometry)fromPoint, fromStation);
        this.linearReferencingHelper.setPointGeometryToStationBean((Geometry)tillPoint, tillStation);
        this.linearReferencingHelper.setGeometryToLineBean(lineGeometry, master);
        return master;
    }

    @Override
    public void unlockObjects() {
        for (FeatureLockingInterface locker : this.lockMap.keySet()) {
            List<Object> lockList = this.lockMap.get(locker);
            for (Object lock : lockList) {
                try {
                    locker.unlock(lock);
                }
                catch (Exception e) {
                    LOG.error((Object)"Cannot unlock object", (Throwable)e);
                }
            }
        }
        lockedFeatures.clear();
    }

    public static CidsBean cloneStation(CidsBean bean) throws Exception {
        if (bean == null) {
            return null;
        }
        CidsBean clone = bean.getMetaObject().getMetaClass().getEmptyInstance().getBean();
        clone.setProperty("wert", bean.getProperty("wert"));
        Object geom = bean.getProperty("real_point");
        if (geom instanceof CidsBean) {
            clone.setProperty("real_point", (Object)CidsLayerFeatureSplitter.cloneCidsBean((CidsBean)geom));
        }
        clone.setProperty("route", bean.getProperty("route"));
        return clone;
    }

    public static CidsBean cloneStationline(CidsBean bean) throws Exception {
        Object geomBean;
        Object toBean;
        if (bean == null) {
            return null;
        }
        CidsBean clone = bean.getMetaObject().getMetaClass().getEmptyInstance().getBean();
        Object fromBean = bean.getProperty("von");
        if (fromBean instanceof CidsBean) {
            clone.setProperty("von", (Object)CidsLayerFeatureSplitter.cloneStation((CidsBean)fromBean));
        }
        if ((toBean = bean.getProperty("bis")) instanceof CidsBean) {
            clone.setProperty("bis", (Object)CidsLayerFeatureSplitter.cloneStation((CidsBean)toBean));
        }
        if ((geomBean = bean.getProperty("geom")) instanceof CidsBean) {
            clone.setProperty("geom", (Object)CidsLayerFeatureSplitter.cloneCidsBean((CidsBean)geomBean));
        }
        return clone;
    }

    public static CidsBean cloneCidsBean(CidsBean bean) throws Exception {
        return CidsLayerFeatureSplitter.cloneCidsBean(bean, true);
    }

    public static CidsBean cloneCidsBean(CidsBean bean, boolean cloneBeans) throws Exception {
        if (bean == null) {
            return null;
        }
        CidsBean clone = bean.getMetaObject().getMetaClass().getEmptyInstance().getBean();
        for (String propName : bean.getPropertyNames()) {
            if (propName.toLowerCase().equals("id")) continue;
            Object o = bean.getProperty(propName);
            if (o instanceof CidsBean) {
                if (cloneBeans) {
                    clone.setProperty(propName, (Object)CidsLayerFeatureSplitter.cloneCidsBean((CidsBean)o));
                    continue;
                }
                clone.setProperty(propName, (Object)((CidsBean)o));
                continue;
            }
            if (o instanceof Collection) {
                List list = (List)o;
                ArrayList<CidsBean> newList = new ArrayList<CidsBean>();
                for (CidsBean tmpBean : list) {
                    if (cloneBeans) {
                        newList.add(CidsLayerFeatureSplitter.cloneCidsBean(tmpBean));
                        continue;
                    }
                    newList.add(tmpBean);
                }
                clone.setProperty(propName, newList);
                continue;
            }
            if (o instanceof Geometry) {
                clone.setProperty(propName, ((Geometry)o).clone());
                continue;
            }
            if (o instanceof Long) {
                clone.setProperty(propName, (Object)new Long(o.toString()));
                continue;
            }
            if (o instanceof Double) {
                clone.setProperty(propName, (Object)new Double(o.toString()));
                continue;
            }
            if (o instanceof Integer) {
                clone.setProperty(propName, (Object)new Integer(o.toString()));
                continue;
            }
            if (o instanceof Boolean) {
                clone.setProperty(propName, (Object)new Boolean(o.toString()));
                continue;
            }
            if (o instanceof String) {
                clone.setProperty(propName, o);
                continue;
            }
            if (o != null) {
                LOG.error((Object)("unknown property type: " + o.getClass().getName()));
            }
            clone.setProperty(propName, o);
        }
        return clone;
    }
}

