/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.components;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.simplify.TopologyPreservingSimplifier;
import de.cismet.cismap.commons.features.DefaultFeatureCollection;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.PureNewFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.attributetable.SimpleAttributeTableModel;
import de.cismet.cismap.commons.gui.piccolo.CustomFixedWidthStroke;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.gui.piccolo.eventlistener.SelectionListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Date;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.openide.util.NbBundle;

public class AttributeTableDialog
extends JDialog {
    private static final org.apache.log4j.Logger LOG = org.apache.log4j.Logger.getLogger(AttributeTableDialog.class);
    private static final int MAX_COLUMN_SIZE = 200;
    private FeatureServiceFeature returnValue;
    private SimpleAttributeTableModel model;
    private final Color[] colors = new Color[]{new Color(217, 215, 204), new Color(242, 187, 19), new Color(217, 159, 126), new Color(242, 65, 48), new Color(121, 132, 39), new Color(184, 206, 233), new Color(216, 120, 57)};
    private int colorCounter = 0;
    private List<PFeature> allPFeature;
    private JTable attrTab;
    private JButton butCancel;
    private JButton butOk;
    private JScrollPane jScrollPane1;
    private JLabel lblTitle;

    public AttributeTableDialog(Frame parent, String title, boolean modal) {
        super(parent, title, modal);
        this.initComponents();
        this.attrTab.setSelectionMode(0);
        this.attrTab.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FeatureServiceFeature f;
                Geometry highlightingGeometry;
                if (!e.getValueIsAdjusting() && AttributeTableDialog.this.attrTab.getSelectedRowCount() == 1 && (highlightingGeometry = (f = AttributeTableDialog.this.model.getFeatureServiceFeature(AttributeTableDialog.this.attrTab.convertRowIndexToModel(AttributeTableDialog.this.attrTab.getSelectedRow()))).getGeometry()) != null) {
                    if (highlightingGeometry.getCoordinates().length > 500) {
                        highlightingGeometry = TopologyPreservingSimplifier.simplify((Geometry)highlightingGeometry, (double)30.0);
                    }
                    PureNewFeature highligtingFeature = new PureNewFeature(highlightingGeometry){

                        public Stroke getLineStyle() {
                            return new CustomFixedWidthStroke(3.0f);
                        }
                    };
                    highligtingFeature.setFillingPaint((Paint)Color.decode("#EEC506"));
                    CismapBroker.getInstance().getMappingComponent().highlightFeature((Feature)highligtingFeature, 1500, Color.RED);
                }
            }
        });
    }

    public void setData(AbstractFeatureService service, List<FeatureServiceFeature> featureList) {
        Map featureServiceAttributes = service.getFeatureServiceAttributes();
        List orderedFeatureServiceAttributes = service.getOrderedFeatureServiceAttributes();
        this.model = new SimpleAttributeTableModel(orderedFeatureServiceAttributes, featureServiceAttributes, featureList, service.getLayerProperties().getAttributeTableRuleSet());
        this.attrTab.setModel((TableModel)this.model);
        this.attrTab.setDefaultRenderer(String.class, new AttributeTableCellRenderer());
        this.attrTab.setDefaultRenderer(Boolean.class, new AttributeTableCellRenderer());
        this.attrTab.setDefaultRenderer(java.util.Date.class, new AttributeTableCellRenderer());
        this.attrTab.setDefaultRenderer(Number.class, new NumberCellRenderer());
        AttributeTableRuleSet tableRuleSet = null;
        if (service.getLayerProperties() != null) {
            tableRuleSet = service.getLayerProperties().getAttributeTableRuleSet();
        }
        if (tableRuleSet != null) {
            for (int i = 0; i < this.attrTab.getColumnCount(); ++i) {
                String columnName = this.model.getColumnAttributeName(i);
                TableCellRenderer renderer = tableRuleSet.getCellRenderer(columnName);
                if (renderer == null) continue;
                this.attrTab.getColumn(columnName).setCellRenderer(renderer);
            }
        }
        this.setTableSize();
    }

    private void setTableSize() {
        TableColumnModel columnModel = this.attrTab.getColumnModel();
        FontMetrics fmetrics = this.attrTab.getFontMetrics(this.attrTab.getFont());
        TableModel model = this.attrTab.getModel();
        int columnCount = model.getColumnCount();
        int totalSize = 0;
        this.attrTab.setAutoResizeMode(0);
        for (int i = 0; i < columnCount; ++i) {
            int size = (int)fmetrics.getStringBounds(model.getColumnName(i), this.attrTab.getGraphics()).getWidth();
            for (int row = 0; row < model.getRowCount() && row < 50; ++row) {
                int tmpSize = (int)fmetrics.getStringBounds(String.valueOf(model.getValueAt(row, i)), this.attrTab.getGraphics()).getWidth();
                if (tmpSize > size && tmpSize < 200) {
                    size = tmpSize;
                    continue;
                }
                if (tmpSize <= size || tmpSize < 200) continue;
                size = 200;
            }
            totalSize += size + 30;
            columnModel.getColumn(i).setPreferredWidth(size + 30);
        }
        this.attrTab.setMinimumSize(new Dimension(totalSize + 20, 50));
    }

    private void removeSelectionOnAllFeatures() {
        MappingComponent map = CismapBroker.getInstance().getMappingComponent();
        SelectionListener sl = (SelectionListener)map.getInputEventListener().get("SELECT");
        this.allPFeature = this.getPFeature();
        ArrayList<Feature> toBeUnselected = new ArrayList<Feature>();
        for (PFeature feature : this.allPFeature) {
            if (!feature.isSelected()) continue;
            feature.setSelected(false);
            feature.refreshDesign();
            sl.removeSelectedFeature(feature);
            toBeUnselected.add(feature.getFeature());
        }
        ((DefaultFeatureCollection)CismapBroker.getInstance().getMappingComponent().getFeatureCollection()).unselect(toBeUnselected);
    }

    private List<PFeature> getPFeature() {
        MappingComponent map = CismapBroker.getInstance().getMappingComponent();
        SelectionListener sl = (SelectionListener)map.getInputEventListener().get("SELECT");
        return sl.getAllSelectedPFeatures();
    }

    private Color getNextColor() {
        return this.colors[++this.colorCounter % this.colors.length];
    }

    public void setCustomText(String text) {
        this.lblTitle.setText(text);
    }

    private void initComponents() {
        this.lblTitle = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.attrTab = new JXTable();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                AttributeTableDialog.this.formWindowClosed(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.lblTitle.setFont(new Font("Ubuntu", 0, 18));
        this.lblTitle.setText(NbBundle.getMessage(AttributeTableDialog.class, (String)"AttributeTableDialog.lblTitle.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(15, 0, 10, 0);
        this.getContentPane().add((Component)this.lblTitle, gridBagConstraints);
        this.attrTab.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.attrTab);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.butOk.setText(NbBundle.getMessage(AttributeTableDialog.class, (String)"AttributeTableDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTableDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 10, 0);
        this.getContentPane().add((Component)this.butOk, gridBagConstraints);
        this.butCancel.setText(NbBundle.getMessage(AttributeTableDialog.class, (String)"AttributeTableDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttributeTableDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        this.getContentPane().add((Component)this.butCancel, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.returnValue = null;
        this.resetColors();
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        this.returnValue = this.model.getFeatureServiceFeature(this.attrTab.convertRowIndexToModel(this.attrTab.getSelectedRow()));
        this.resetColors();
        this.setVisible(false);
    }

    private void formWindowClosed(WindowEvent evt) {
        this.resetColors();
    }

    private void resetColors() {
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(AttributeTableDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(AttributeTableDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(AttributeTableDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(AttributeTableDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                AttributeTableDialog dialog = new AttributeTableDialog(new JFrame(), "test", true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public FeatureServiceFeature getReturnValue() {
        return this.returnValue;
    }

    private class NumberCellRenderer
    extends AttributeTableCellRenderer {
        private DecimalFormat format;

        public NumberCellRenderer() {
            this.format = new DecimalFormat();
            this.format.setGroupingUsed(false);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof Number) {
                value = this.format.format(value);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class AttributeTableCellRenderer
    extends DefaultTableCellRenderer {
        private AttributeTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Object formattedValue = value;
            if (value instanceof Date) {
                long dateInMillis = ((Date)value).getTime();
                formattedValue = DateFormat.getDateInstance().format(new java.util.Date(dateInMillis));
            }
            Component c = super.getTableCellRendererComponent(table, formattedValue, isSelected, hasFocus, row, column);
            FeatureServiceFeature feature = AttributeTableDialog.this.model.getFeatureServiceFeature(table.convertRowIndexToModel(row));
            return c;
        }
    }

    private class ColoredCellRenderer
    extends DefaultTableCellRenderer {
        private ColoredCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component oc = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            return oc;
        }
    }
}

