/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.components;

import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.tools.gui.HighlightingRadioButtonMenuItem;
import de.cismet.watergis.gui.actions.geoprocessing.AbstractGeoprocessingAction;
import de.cismet.watergis.utils.JPopupMenuButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import org.jdom.Element;
import org.openide.util.Lookup;

public class GeometryOpButton
extends JPopupMenuButton
implements Configurable {
    private static final String CONFIGURATION = "GeometryOpButton";
    private static final String MODE_ATTRIBUTE = "mode";
    private final JPopupMenu popup = new JPopupMenu();
    private final List<AbstractGeoprocessingAction> geoprocessingActions = new ArrayList<AbstractGeoprocessingAction>();
    private AbstractGeoprocessingAction currentGeoprocessingAction = null;

    public GeometryOpButton() {
        this.setModel(new JToggleButton.ToggleButtonModel());
        this.geoprocessingActions.addAll(Lookup.getDefault().lookupAll(AbstractGeoprocessingAction.class));
        Collections.sort(this.geoprocessingActions, new Comparator<AbstractGeoprocessingAction>(){

            @Override
            public int compare(AbstractGeoprocessingAction o1, AbstractGeoprocessingAction o2) {
                return new Integer(o1.getSortOrder()).compareTo(o2.getSortOrder());
            }
        });
        for (AbstractGeoprocessingAction geoProcessingAction : this.geoprocessingActions) {
            if (this.currentGeoprocessingAction == null) {
                this.setCurrentGeoprocessingAction(geoProcessingAction);
            }
            HighlightingRadioButtonMenuItem geoprocessingMenu = new HighlightingRadioButtonMenuItem(UIManager.getDefaults().getColor("ProgressBar.foreground"), Color.WHITE);
            geoprocessingMenu.setIcon(new ImageIcon(((Object)((Object)this)).getClass().getResource("/de/cismet/watergis/res/icons16/icon-calcequals.png")));
            geoprocessingMenu.setAction(geoProcessingAction);
            geoProcessingAction.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() instanceof HighlightingRadioButtonMenuItem) {
                        HighlightingRadioButtonMenuItem menu = (HighlightingRadioButtonMenuItem)e.getSource();
                        GeometryOpButton.this.setCurrentGeoprocessingAction((AbstractGeoprocessingAction)menu.getAction());
                    }
                }
            });
            this.popup.add((JMenuItem)geoprocessingMenu);
        }
        this.setPopupMenu(this.popup);
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GeometryOpButton.this.currentGeoprocessingAction != null) {
                    GeometryOpButton.this.currentGeoprocessingAction.actionPerformed(e);
                }
            }
        });
    }

    public void setMode(String mode) {
        for (AbstractGeoprocessingAction geoprocessingAction : this.geoprocessingActions) {
            if (!geoprocessingAction.getName().equals(mode)) continue;
            this.setCurrentGeoprocessingAction(geoprocessingAction);
            break;
        }
    }

    public void setCurrentGeoprocessingAction(AbstractGeoprocessingAction currentGeoprocessingAction) {
        this.currentGeoprocessingAction = currentGeoprocessingAction;
        for (Component component : this.popup.getComponents()) {
            if (!(component instanceof HighlightingRadioButtonMenuItem)) continue;
            HighlightingRadioButtonMenuItem menu = (HighlightingRadioButtonMenuItem)component;
            menu.setSelected(menu.getAction().equals(currentGeoprocessingAction));
        }
        this.setIcon(currentGeoprocessingAction.getSmallIcon());
        this.repaint();
    }

    public void setSelected(boolean b) {
        super.setSelected(false);
    }

    public void configure(Element parent) {
        Element conf;
        if (parent != null && (conf = parent.getChild(CONFIGURATION)) != null) {
            String modeAttr = conf.getAttributeValue(MODE_ATTRIBUTE);
            try {
                String mode = modeAttr;
                this.setMode(mode);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public void masterConfigure(Element parent) {
        this.configure(parent);
    }

    public Element getConfiguration() throws NoWriteError {
        Element conf = new Element(CONFIGURATION);
        if (this.currentGeoprocessingAction == null) {
            conf.setAttribute(MODE_ATTRIBUTE, null);
        } else {
            conf.setAttribute(MODE_ATTRIBUTE, this.currentGeoprocessingAction.getName());
        }
        return conf;
    }
}

