/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.components;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class ValidationJTextField
extends JTextField {
    private Pattern pattern = Pattern.compile(".*");

    public ValidationJTextField() {
        this.init();
    }

    public ValidationJTextField(String text) {
        super(text);
        this.init();
    }

    public ValidationJTextField(int columns) {
        super(columns);
        this.init();
    }

    public ValidationJTextField(String text, int columns) {
        super(text, columns);
        this.init();
    }

    public ValidationJTextField(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.init();
    }

    private void init() {
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                ValidationJTextField.this.validateText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ValidationJTextField.this.validateText();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ValidationJTextField.this.validateText();
            }
        });
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setPattern(String regEx) {
        this.pattern = Pattern.compile(regEx);
    }

    public boolean isContentValid() {
        String selectedItem = this.getText();
        Matcher m = this.pattern.matcher(selectedItem);
        return m.matches();
    }

    private void validateText() {
        if (this.isContentValid()) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(Color.red);
        }
    }
}

