/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.index.strtree.STRtree;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.math.geometry.StaticGeometryFunctions;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.utils.FeatureServiceHelper;
import de.cismet.watergis.utils.GeometryUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ClipDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(ClipDialog.class);
    private int selectedThemeFeatureCount = 0;
    private int selectedTargetThemeFeatureCount = 0;
    private ButtonGroup bgBuffer;
    private JButton butCancel;
    private JButton butOk;
    private JComboBox cbTargetTheme;
    private JComboBox cbTheme;
    private JCheckBox ckbMultiPart;
    private JCheckBox ckbSelected;
    private JCheckBox ckbSelectedTarget;
    private JDialog jDialog1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel labSelected;
    private JLabel labSelectedTarget;
    private JLabel labTableName;
    private JLabel labTargetTheme;
    private JLabel labTheme;
    private JTextField txtTable;

    public ClipDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.cbTheme.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = value instanceof String ? (String)value : (value != null ? ((AbstractFeatureService)value).getName() : " ");
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
        this.cbTargetTheme.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = value instanceof String ? (String)value : (value != null ? ((AbstractFeatureService)value).getName() : " ");
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
        this.txtTable.setText("Ausschnitt");
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

            public void featuresAdded(FeatureCollectionEvent fce) {
            }

            public void allFeaturesRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresChanged(FeatureCollectionEvent fce) {
            }

            public void featureSelectionChanged(FeatureCollectionEvent fce) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractFeatureService service = (AbstractFeatureService)ClipDialog.this.cbTheme.getSelectedItem();
                        ClipDialog.this.selectedThemeFeatureCount = ClipDialog.this.refreshSelectedFeatureCount(false, ClipDialog.this.ckbSelected, service, ClipDialog.this.selectedThemeFeatureCount, ClipDialog.this.labSelected);
                        AbstractFeatureService targetService = (AbstractFeatureService)ClipDialog.this.cbTargetTheme.getSelectedItem();
                        ClipDialog.this.selectedTargetThemeFeatureCount = ClipDialog.this.refreshSelectedFeatureCount(false, ClipDialog.this.ckbSelectedTarget, targetService, ClipDialog.this.selectedTargetThemeFeatureCount, ClipDialog.this.labSelectedTarget);
                    }
                });
            }

            public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
            }

            public void featureCollectionChanged() {
            }
        });
        ActiveLayerModel layerModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        layerModel.addTreeModelWithoutProgressListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                ClipDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                ClipDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                ClipDialog.this.setLayerModel();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                ClipDialog.this.setLayerModel();
            }
        });
        this.setLayerModel();
        this.enabledOrNot();
    }

    private void initComponents() {
        this.bgBuffer = new ButtonGroup();
        this.jDialog1 = new JDialog();
        this.labTheme = new JLabel();
        this.cbTheme = new JComboBox();
        this.labTableName = new JLabel();
        this.txtTable = new JTextField();
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.labTargetTheme = new JLabel();
        this.cbTargetTheme = new JComboBox();
        this.jPanel3 = new JPanel();
        this.ckbSelectedTarget = new JCheckBox();
        this.labSelectedTarget = new JLabel();
        this.jPanel4 = new JPanel();
        this.ckbSelected = new JCheckBox();
        this.labSelected = new JLabel();
        this.ckbMultiPart = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labTheme, (String)NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.labTheme.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.getContentPane().add((Component)this.labTheme, gridBagConstraints);
        this.cbTheme.setMinimumSize(new Dimension(200, 27));
        this.cbTheme.setPreferredSize(new Dimension(200, 27));
        this.cbTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClipDialog.this.cbThemeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.getContentPane().add((Component)this.cbTheme, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTableName, (String)NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.labTableName.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTableName, gridBagConstraints);
        this.txtTable.setMinimumSize(new Dimension(200, 27));
        this.txtTable.setPreferredSize(new Dimension(200, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtTable, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(80, 29));
        this.butOk.setPreferredSize(new Dimension(89, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClipDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClipDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTargetTheme, (String)NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.labTargetTheme.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTargetTheme, gridBagConstraints);
        this.cbTargetTheme.setMinimumSize(new Dimension(200, 27));
        this.cbTargetTheme.setPreferredSize(new Dimension(200, 27));
        this.cbTargetTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClipDialog.this.cbTargetThemeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.cbTargetTheme, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSelectedTarget, (String)NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.ckbSelectedTarget.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.ckbSelectedTarget, gridBagConstraints);
        this.labSelectedTarget.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel3.add((Component)this.labSelectedTarget, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSelected, (String)NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.ckbSelected.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.ckbSelected, gridBagConstraints);
        this.labSelected.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.labSelected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbMultiPart, (String)NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.ckbMultiPart.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.ckbMultiPart, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void setLayerModel() {
        this.cbTheme.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.setlayerModel.searchServices")}));
        this.cbTargetTheme.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.setlayerModel.searchPolygonServices")}));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                ClipDialog.this.cbTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(null).toArray(new AbstractFeatureService[0])));
                ClipDialog.this.cbTargetTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(new String[]{"Polygon", "MultiPolygon"}).toArray(new AbstractFeatureService[0])));
                if (ClipDialog.this.cbTheme.getModel().getSize() > 0) {
                    ClipDialog.this.cbTheme.setSelectedIndex(0);
                } else {
                    ClipDialog.this.cbTheme.setSelectedItem(null);
                }
                if (ClipDialog.this.cbTargetTheme.getModel().getSize() > 0) {
                    ClipDialog.this.cbTargetTheme.setSelectedIndex(0);
                } else {
                    ClipDialog.this.cbTargetTheme.setSelectedItem(null);
                }
            }
        });
        t.start();
    }

    private void butOkActionPerformed(ActionEvent evt) {
        final AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        final AbstractFeatureService targetService = (AbstractFeatureService)this.cbTargetTheme.getSelectedItem();
        final String tableName = this.txtTable.getText();
        WaitingDialogThread<H2FeatureService> wdt = new WaitingDialogThread<H2FeatureService>((Frame)AppBroker.getInstance().getWatergisApp(), true, "Ausschneiden                                            ", null, 100, true){

            protected H2FeatureService doInBackground() throws Exception {
                int progress = 10;
                this.wd.setText(NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.butOkActionPerformed.doInBackground.retrieving"));
                this.wd.setMax(100);
                this.wd.setProgress(5);
                if (Thread.interrupted()) {
                    return null;
                }
                String geometryTypeName = null;
                List<FeatureServiceFeature> featureList = FeatureServiceHelper.getFeatures(service, ClipDialog.this.ckbSelected.isSelected());
                this.wd.setProgress(10);
                if (Thread.interrupted()) {
                    return null;
                }
                List<FeatureServiceFeature> targetFeatureList = FeatureServiceHelper.getFeatures(targetService, ClipDialog.this.ckbSelectedTarget.isSelected());
                STRtree featureTree = FeatureServiceHelper.getFeatureTree(targetFeatureList);
                ArrayList<FeatureServiceFeature> resultedFeatures = new ArrayList<FeatureServiceFeature>();
                int count = 0;
                int featureCount = 0;
                this.wd.setText(NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.butOkActionPerformed.doInBackground.createFeatures"));
                boolean hasMultiPolygon = false;
                for (FeatureServiceFeature f : featureList) {
                    Geometry newGeom;
                    Geometry searchGeom;
                    List intersectingFeatures;
                    Geometry clipGeometry = null;
                    ++count;
                    if (geometryTypeName == null) {
                        geometryTypeName = f.getGeometry().getClass().getName();
                    }
                    if ((intersectingFeatures = featureTree.query((searchGeom = f.getGeometry()).getEnvelopeInternal())) != null && !intersectingFeatures.isEmpty()) {
                        clipGeometry = GeometryUtils.unionFeatureGeometries(intersectingFeatures);
                    }
                    if (clipGeometry != null && f.getGeometry() != null && (newGeom = f.getGeometry().intersection(clipGeometry)) != null && !newGeom.isEmpty()) {
                        if (ClipDialog.this.ckbMultiPart.isSelected()) {
                            boolean isMulti = newGeom instanceof MultiPolygon || newGeom instanceof MultiPoint || newGeom instanceof MultiLineString;
                            boolean bl = hasMultiPolygon = hasMultiPolygon || isMulti;
                            if (!newGeom.getClass().getName().equals(geometryTypeName) && (!isMulti || !newGeom.getGeometryN(0).getClass().getName().equals(geometryTypeName))) continue;
                            f.setGeometry(newGeom);
                            resultedFeatures.add(f);
                        } else {
                            for (int geomIndex = 0; geomIndex < newGeom.getNumGeometries(); ++geomIndex) {
                                Geometry newGeometryPart = newGeom.getGeometryN(geomIndex);
                                if (!newGeometryPart.getClass().getName().equals(geometryTypeName) && !(newGeometryPart = StaticGeometryFunctions.toMultiGeometry((Geometry)newGeom.getGeometryN(geomIndex))).getClass().getName().equals(geometryTypeName)) continue;
                                FeatureServiceFeature newFeature = (FeatureServiceFeature)f.clone();
                                newFeature.setGeometry(newGeometryPart);
                                newFeature.setProperty("id", (Object)(++featureCount));
                                resultedFeatures.add(newFeature);
                            }
                        }
                    }
                    if (Thread.interrupted()) {
                        return null;
                    }
                    if (progress >= 10 + count * 80 / featureList.size()) continue;
                    progress = 10 + count * 80 / featureList.size();
                    this.wd.setProgress(progress);
                }
                if (ClipDialog.this.ckbMultiPart.isSelected() && hasMultiPolygon) {
                    for (FeatureServiceFeature f : resultedFeatures) {
                        f.setGeometry(StaticGeometryFunctions.toMultiGeometry((Geometry)f.getGeometry()));
                    }
                }
                this.wd.setText(NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.butOkActionPerformed.doInBackground.creatingDatasource"));
                ArrayList<String> orderedAttributeNames = new ArrayList<String>();
                orderedAttributeNames.addAll(service.getOrderedFeatureServiceAttributes());
                return FeatureServiceHelper.createNewService(AppBroker.getInstance().getWatergisApp(), resultedFeatures, tableName, orderedAttributeNames);
            }

            protected void done() {
                try {
                    H2FeatureService service2 = (H2FeatureService)this.get();
                    if (service2 != null) {
                        FeatureServiceHelper.addServiceLayerToTheTree((AbstractFeatureService)service2);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while execute the Clip operation.", (Throwable)ex);
                }
            }
        };
        if (H2FeatureService.tableAlreadyExists((String)tableName)) {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.butOkActionPerformed.tableAlreadyExists", (Object)tableName), NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.butOkActionPerformed.tableAlreadyExists.title"), 0);
        } else {
            this.setVisible(false);
            wdt.start();
        }
    }

    private void cbThemeActionPerformed(ActionEvent evt) {
        AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        this.selectedThemeFeatureCount = this.refreshSelectedFeatureCount(false, this.ckbSelected, service, this.selectedThemeFeatureCount, this.labSelected);
        this.enabledOrNot();
    }

    private void cbTargetThemeActionPerformed(ActionEvent evt) {
        AbstractFeatureService service = (AbstractFeatureService)this.cbTargetTheme.getSelectedItem();
        this.selectedTargetThemeFeatureCount = this.refreshSelectedFeatureCount(false, this.ckbSelectedTarget, service, this.selectedTargetThemeFeatureCount, this.labSelectedTarget);
        this.enabledOrNot();
    }

    public int refreshSelectedFeatureCount(boolean forceGuiRefresh, JCheckBox box, AbstractFeatureService featureService, int lastSelectedFeatureCount, JLabel selectionCountlab) {
        int count = featureService == null ? 0 : FeatureServiceHelper.getSelectedFeatures(featureService).size();
        selectionCountlab.setText(NbBundle.getMessage(ClipDialog.class, (String)"ClipDialog.refreshSelectedFeatureCount.text", (Object)count));
        if (forceGuiRefresh || count != lastSelectedFeatureCount) {
            box.setSelected(count > 0);
        }
        return count;
    }

    private void enabledOrNot() {
        boolean isServiceSelected = this.cbTheme.getSelectedItem() instanceof AbstractFeatureService && this.cbTargetTheme.getSelectedItem() instanceof AbstractFeatureService;
        this.butOk.setEnabled(isServiceSelected);
    }
}

