/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.math.geometry.StaticGeometryFunctions;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.dialog.PointInLineDialog;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class DissolveDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(DissolveDialog.class);
    private int selectedThemeFeatureCount = 0;
    private JButton butCancel;
    private JButton butOk;
    private JComboBox cbTheme;
    private JCheckBox ckbMultiPart;
    private JCheckBox ckbSelected;
    private JList fieldList;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JLabel labDissolveAttr;
    private JLabel labSelected;
    private JLabel labTableName;
    private JLabel labTheme;
    private JTextField txtTable;

    public DissolveDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.txtTable.setText("Verschmelzen");
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

            public void featuresAdded(FeatureCollectionEvent fce) {
            }

            public void allFeaturesRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresChanged(FeatureCollectionEvent fce) {
            }

            public void featureSelectionChanged(FeatureCollectionEvent fce) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractFeatureService service = (AbstractFeatureService)DissolveDialog.this.cbTheme.getSelectedItem();
                        DissolveDialog.this.refreshSelectedFeatureCount(false, DissolveDialog.this.ckbSelected, service, DissolveDialog.this.selectedThemeFeatureCount, DissolveDialog.this.labSelected);
                    }
                });
            }

            public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
            }

            public void featureCollectionChanged() {
            }
        });
        ActiveLayerModel layerModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        layerModel.addTreeModelWithoutProgressListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                DissolveDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                DissolveDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                DissolveDialog.this.setLayerModel();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                DissolveDialog.this.setLayerModel();
            }
        });
        this.setLayerModel();
        this.refreshFieldModel();
    }

    private void initComponents() {
        this.labTableName = new JLabel();
        this.txtTable = new JTextField();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.labTheme = new JLabel();
        this.cbTheme = new JComboBox();
        this.jPanel4 = new JPanel();
        this.ckbSelected = new JCheckBox();
        this.labSelected = new JLabel();
        this.ckbMultiPart = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.fieldList = new JList();
        this.labDissolveAttr = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labTableName, (String)NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.labTableName.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.getContentPane().add((Component)this.labTableName, gridBagConstraints);
        this.txtTable.setMinimumSize(new Dimension(200, 27));
        this.txtTable.setPreferredSize(new Dimension(200, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.getContentPane().add((Component)this.txtTable, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(80, 29));
        this.butOk.setPreferredSize(new Dimension(80, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DissolveDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.getContentPane().add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DissolveDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.getContentPane().add((Component)this.butCancel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTheme, (String)NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.labTheme.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.getContentPane().add((Component)this.labTheme, gridBagConstraints);
        this.cbTheme.setMinimumSize(new Dimension(200, 27));
        this.cbTheme.setPreferredSize(new Dimension(200, 27));
        this.cbTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DissolveDialog.this.cbThemeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.getContentPane().add((Component)this.cbTheme, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSelected, (String)NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.ckbSelected.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.ckbSelected, gridBagConstraints);
        this.labSelected.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.labSelected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbMultiPart, (String)NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.ckbMultiPart.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.ckbMultiPart, gridBagConstraints);
        this.fieldList.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.fieldList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labDissolveAttr, (String)NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.labDissolveAttr.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.getContentPane().add((Component)this.labDissolveAttr, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        final AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        final List selectedFields = this.fieldList.getSelectedValuesList();
        final String[] propertyNames = selectedFields.toArray(new String[selectedFields.size()]);
        final String tableName = this.txtTable.getText();
        WaitingDialogThread<H2FeatureService> wdt = new WaitingDialogThread<H2FeatureService>((Frame)AppBroker.getInstance().getWatergisApp(), true, "Verschmelzen                                            ", null, 100, true){

            protected H2FeatureService doInBackground() throws Exception {
                int progress = 0;
                this.wd.setText(NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.butOkActionPerformed.doInBackground.retrieving"));
                this.wd.setMax(100);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"retrieve all features from the service");
                }
                List<FeatureServiceFeature> featureList = FeatureServiceHelper.getFeatures(service, DissolveDialog.this.ckbSelected.isSelected());
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"sort the features");
                }
                HashMap<List, ArrayList<FeatureServiceFeature>> featureMap = new HashMap<List, ArrayList<FeatureServiceFeature>>();
                int n = 0;
                int featureCount = featureList.size();
                this.wd.setText(NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.butOkActionPerformed.doInBackground.sorting"));
                for (FeatureServiceFeature featureServiceFeature : featureList) {
                    List propValues = DissolveDialog.this.getProperties(featureServiceFeature, propertyNames);
                    ArrayList<FeatureServiceFeature> dissolvedFeature = (ArrayList<FeatureServiceFeature>)featureMap.get(propValues);
                    if (dissolvedFeature == null) {
                        dissolvedFeature = new ArrayList<FeatureServiceFeature>();
                        dissolvedFeature.add(featureServiceFeature);
                        featureMap.put(propValues, dissolvedFeature);
                    } else {
                        dissolvedFeature.add(featureServiceFeature);
                    }
                    ++n;
                    if (Thread.interrupted()) {
                        return null;
                    }
                    if (progress >= n * 20 / featureCount) continue;
                    progress = n * 20 / featureCount;
                    this.wd.setProgress(progress);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"merge geometries");
                }
                this.wd.setText(NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.butOkActionPerformed.doInBackground.merging"));
                ArrayList<FeatureServiceFeature> dissolvedFeatures = new ArrayList<FeatureServiceFeature>();
                featureCount = featureMap.keySet().size();
                n = 0;
                for (Object key : featureMap.keySet()) {
                    List features = (List)featureMap.get(key);
                    FeatureServiceFeature f = (FeatureServiceFeature)features.get(0);
                    ArrayList<Geometry> geomList = new ArrayList<Geometry>();
                    if (Thread.interrupted()) {
                        return null;
                    }
                    for (FeatureServiceFeature feature : features) {
                        if (!feature.getGeometry().isValid()) {
                            geomList.add(feature.getGeometry().buffer(0.0));
                            continue;
                        }
                        geomList.add(feature.getGeometry());
                    }
                    GeometryFactory factory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), ((Geometry)geomList.get(0)).getSRID());
                    Geometry geom = factory.buildGeometry(geomList);
                    if (geom instanceof GeometryCollection) {
                        geom = ((GeometryCollection)geom).union();
                    }
                    if (DissolveDialog.this.ckbMultiPart.isSelected()) {
                        f.setGeometry(StaticGeometryFunctions.toMultiGeometry((Geometry)geom));
                        dissolvedFeatures.add(f);
                    } else {
                        for (int geomIndex = 0; geomIndex < geom.getNumGeometries(); ++geomIndex) {
                            FeatureServiceFeature newFeature = (FeatureServiceFeature)f.clone();
                            newFeature.setGeometry(geom.getGeometryN(geomIndex));
                            dissolvedFeatures.add(newFeature);
                        }
                    }
                    ++n;
                    if (Thread.interrupted()) {
                        return null;
                    }
                    if (progress >= 20 + n * 55 / featureCount) continue;
                    progress = 20 + n * 55 / featureCount;
                    this.wd.setProgress(progress);
                }
                this.wd.setText(NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.butOkActionPerformed.doInBackground.creatingDatasource"));
                ArrayList<String> arrayList = new ArrayList<String>();
                Map attributes = service.getFeatureServiceAttributes();
                for (String key : service.getOrderedFeatureServiceAttributes()) {
                    FeatureServiceAttribute attr = (FeatureServiceAttribute)attributes.get(key);
                    if (!attr.isGeometry() && !selectedFields.contains(key)) continue;
                    arrayList.add(key);
                }
                return FeatureServiceHelper.createNewService(AppBroker.getInstance().getWatergisApp(), dissolvedFeatures, tableName, arrayList);
            }

            protected void done() {
                try {
                    H2FeatureService service2 = (H2FeatureService)this.get();
                    if (service2 != null) {
                        FeatureServiceHelper.addServiceLayerToTheTree((AbstractFeatureService)service2);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while dissolving features.", (Throwable)ex);
                }
            }
        };
        if (H2FeatureService.tableAlreadyExists((String)tableName)) {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.butOkActionPerformed.tableAlreadyExists", (Object)tableName), NbBundle.getMessage(DissolveDialog.class, (String)"DissolveDialog.butOkActionPerformed.tableAlreadyExists.title"), 0);
        } else {
            this.setVisible(false);
            wdt.start();
        }
    }

    private void cbThemeActionPerformed(ActionEvent evt) {
        AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        this.refreshSelectedFeatureCount(false, this.ckbSelected, service, this.selectedThemeFeatureCount, this.labSelected);
        this.refreshFieldModel();
    }

    private List<Object> getProperties(FeatureServiceFeature feature, String[] propertyNames) {
        ArrayList<Object> propertyList = new ArrayList<Object>();
        for (String propName : propertyNames) {
            propertyList.add(feature.getProperty(propName));
        }
        return propertyList;
    }

    private void setLayerModel() {
        this.cbTheme.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(PointInLineDialog.class, (String)"DissolveDialog.setlayerModel.searchPointServices")}));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                DissolveDialog.this.cbTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(null).toArray(new AbstractFeatureService[0])));
                if (DissolveDialog.this.cbTheme.getModel().getSize() > 0) {
                    DissolveDialog.this.cbTheme.setSelectedIndex(0);
                } else {
                    DissolveDialog.this.cbTheme.setSelectedItem(null);
                }
            }
        });
        t.start();
    }

    public int refreshSelectedFeatureCount(boolean forceGuiRefresh, JCheckBox box, AbstractFeatureService featureService, int lastSelectedFeatureCount, JLabel selectionCountlab) {
        int count = featureService == null ? 0 : FeatureServiceHelper.getSelectedFeatures(featureService).size();
        selectionCountlab.setText(NbBundle.getMessage(DissolveDialog.class, (String)"Dissolve.refreshSelectedFeatureCount.text", (Object)count));
        if (forceGuiRefresh || count != lastSelectedFeatureCount) {
            box.setSelected(count > 0);
        }
        return count;
    }

    private void refreshFieldModel() {
        Object service = this.cbTheme.getSelectedItem();
        if (service != null && service instanceof AbstractFeatureService) {
            List<String> fields = FeatureServiceHelper.getAllFieldNames((AbstractFeatureService)service, null);
            DefaultListModel<String> model = new DefaultListModel<String>();
            for (String fieldName : fields) {
                model.add(model.size(), fieldName);
            }
            this.fieldList.setModel(model);
        } else {
            DefaultListModel model = new DefaultListModel();
            this.fieldList.setModel(model);
        }
    }
}

