/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.index.strtree.STRtree;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.featureservice.FeatureServiceAttribute;
import de.cismet.cismap.commons.featureservice.H2FeatureService;
import de.cismet.cismap.commons.featureservice.LayerProperties;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.components.location.SpatialSelectionMethodInterface;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class PointInLineDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(PointInLineDialog.class);
    private int selectedThemeFeatureCount = 0;
    private int selectedTargetThemeFeatureCount = 0;
    private ButtonGroup bgBuffer;
    private JButton butCancel;
    private JButton butOk;
    private JComboBox cbGeoMethod;
    private JComboBox cbTargetTheme;
    private JComboBox cbTheme;
    private JCheckBox ckbSelected;
    private JCheckBox ckbSelectedTarget;
    private JDialog jDialog1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JLabel labDistance;
    private JLabel labDistanceField;
    private JLabel labGeoMethod;
    private JLabel labSelected;
    private JLabel labSelectedTarget;
    private JLabel labTableName;
    private JLabel labTargetTheme;
    private JLabel labTheme;
    private JTextField txtBuffer;
    private JTextField txtDistanceField;
    private JTextField txtTable;

    public PointInLineDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.cbTheme.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = value instanceof String ? (String)value : (value != null ? ((AbstractFeatureService)value).getName() : " ");
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
        this.cbTargetTheme.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                String name = value instanceof String ? (String)value : (value != null ? ((AbstractFeatureService)value).getName() : " ");
                return super.getListCellRendererComponent((JList<?>)list, name, index, isSelected, cellHasFocus);
            }
        });
        Collection spatialSelectionMethod = Lookup.getDefault().lookupAll(SpatialSelectionMethodInterface.class);
        ArrayList<SpatialSelectionMethodInterface> ssmList = new ArrayList<SpatialSelectionMethodInterface>();
        for (SpatialSelectionMethodInterface method : spatialSelectionMethod) {
            if (!method.isUsedForGeoprocessing()) continue;
            ssmList.add(method);
        }
        Collections.sort(ssmList, new Comparator<SpatialSelectionMethodInterface>(){

            @Override
            public int compare(SpatialSelectionMethodInterface o1, SpatialSelectionMethodInterface o2) {
                return o1.getOrderId().compareTo(o2.getOrderId());
            }
        });
        this.cbGeoMethod.setModel(new DefaultComboBoxModel<SpatialSelectionMethodInterface>(ssmList.toArray(new SpatialSelectionMethodInterface[ssmList.size()])));
        this.txtTable.setText("PunktAufLinie");
        CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

            public void featuresAdded(FeatureCollectionEvent fce) {
            }

            public void allFeaturesRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresRemoved(FeatureCollectionEvent fce) {
            }

            public void featuresChanged(FeatureCollectionEvent fce) {
            }

            public void featureSelectionChanged(FeatureCollectionEvent fce) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractFeatureService service = (AbstractFeatureService)PointInLineDialog.this.cbTheme.getSelectedItem();
                        PointInLineDialog.this.selectedThemeFeatureCount = PointInLineDialog.this.refreshSelectedFeatureCount(false, PointInLineDialog.this.ckbSelected, service, PointInLineDialog.this.selectedThemeFeatureCount, PointInLineDialog.this.labSelected);
                        AbstractFeatureService targetService = (AbstractFeatureService)PointInLineDialog.this.cbTargetTheme.getSelectedItem();
                        PointInLineDialog.this.selectedTargetThemeFeatureCount = PointInLineDialog.this.refreshSelectedFeatureCount(false, PointInLineDialog.this.ckbSelectedTarget, targetService, PointInLineDialog.this.selectedTargetThemeFeatureCount, PointInLineDialog.this.labSelectedTarget);
                    }
                });
            }

            public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
            }

            public void featureCollectionChanged() {
            }
        });
        ActiveLayerModel layerModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        layerModel.addTreeModelWithoutProgressListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
                PointInLineDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                PointInLineDialog.this.setLayerModel();
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
                PointInLineDialog.this.setLayerModel();
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
                PointInLineDialog.this.setLayerModel();
            }
        });
        this.setLayerModel();
        this.cbGeoMethodItemStateChanged(null);
        this.enabledOrNot();
    }

    private void initComponents() {
        this.bgBuffer = new ButtonGroup();
        this.jDialog1 = new JDialog();
        this.labTheme = new JLabel();
        this.cbTheme = new JComboBox();
        this.labTableName = new JLabel();
        this.txtTable = new JTextField();
        this.txtBuffer = new JTextField();
        this.cbGeoMethod = new JComboBox();
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.labTargetTheme = new JLabel();
        this.cbTargetTheme = new JComboBox();
        this.labGeoMethod = new JLabel();
        this.labDistance = new JLabel();
        this.jPanel3 = new JPanel();
        this.ckbSelectedTarget = new JCheckBox();
        this.labSelectedTarget = new JLabel();
        this.jPanel4 = new JPanel();
        this.ckbSelected = new JCheckBox();
        this.labSelected = new JLabel();
        this.labDistanceField = new JLabel();
        this.txtDistanceField = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.labTheme, (String)NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.labTheme.text", (Object[])new Object[0]));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.getContentPane().add((Component)this.labTheme, gridBagConstraints);
        this.cbTheme.setMinimumSize(new Dimension(200, 27));
        this.cbTheme.setPreferredSize(new Dimension(200, 27));
        this.cbTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointInLineDialog.this.cbThemeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 5, 10);
        this.getContentPane().add((Component)this.cbTheme, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTableName, (String)NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.labTableName.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTableName, gridBagConstraints);
        this.txtTable.setMinimumSize(new Dimension(200, 27));
        this.txtTable.setPreferredSize(new Dimension(200, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtTable, gridBagConstraints);
        this.txtBuffer.setMinimumSize(new Dimension(200, 27));
        this.txtBuffer.setPreferredSize(new Dimension(200, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtBuffer, gridBagConstraints);
        this.cbGeoMethod.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbGeoMethod.setMinimumSize(new Dimension(200, 27));
        this.cbGeoMethod.setPreferredSize(new Dimension(200, 27));
        this.cbGeoMethod.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                PointInLineDialog.this.cbGeoMethodItemStateChanged(evt);
            }
        });
        this.cbGeoMethod.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                PointInLineDialog.this.cbGeoMethodPropertyChange(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.cbGeoMethod, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(80, 29));
        this.butOk.setPreferredSize(new Dimension(89, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointInLineDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointInLineDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labTargetTheme, (String)NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.labTargetTheme.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labTargetTheme, gridBagConstraints);
        this.cbTargetTheme.setMinimumSize(new Dimension(200, 27));
        this.cbTargetTheme.setPreferredSize(new Dimension(200, 27));
        this.cbTargetTheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PointInLineDialog.this.cbTargetThemeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.cbTargetTheme, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labGeoMethod, (String)NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.labGeoMethod.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labGeoMethod, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labDistance, (String)NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.labDistance.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labDistance, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSelectedTarget, (String)NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.ckbSelectedTarget.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel3.add((Component)this.ckbSelectedTarget, gridBagConstraints);
        this.labSelectedTarget.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel3.add((Component)this.labSelectedTarget, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSelected, (String)NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.ckbSelected.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.jPanel4.add((Component)this.ckbSelected, gridBagConstraints);
        this.labSelected.setPreferredSize(new Dimension(200, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.jPanel4.add((Component)this.labSelected, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.jPanel4, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.labDistanceField, (String)NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.labDistanceField.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.labDistanceField, gridBagConstraints);
        this.txtDistanceField.setMinimumSize(new Dimension(200, 27));
        this.txtDistanceField.setPreferredSize(new Dimension(200, 27));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.txtDistanceField, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void setLayerModel() {
        this.cbTheme.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.setlayerModel.searchPointServices")}));
        this.cbTargetTheme.setModel(new DefaultComboBoxModel<String>(new String[]{NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.setlayerModel.searchLineServices")}));
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                PointInLineDialog.this.cbTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(new String[]{"Point"}).toArray(new AbstractFeatureService[0])));
                PointInLineDialog.this.cbTargetTheme.setModel(new DefaultComboBoxModel<AbstractFeatureService>(FeatureServiceHelper.getServices(new String[]{"LineString", "MultiLineString"}).toArray(new AbstractFeatureService[0])));
                if (PointInLineDialog.this.cbTheme.getModel().getSize() > 0) {
                    PointInLineDialog.this.cbTheme.setSelectedIndex(0);
                } else {
                    PointInLineDialog.this.cbTheme.setSelectedItem(null);
                }
                if (PointInLineDialog.this.cbTargetTheme.getModel().getSize() > 0) {
                    PointInLineDialog.this.cbTargetTheme.setSelectedIndex(0);
                } else {
                    PointInLineDialog.this.cbTargetTheme.setSelectedItem(null);
                }
            }
        });
        t.start();
    }

    private void butOkActionPerformed(ActionEvent evt) {
        final AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        final AbstractFeatureService targetService = (AbstractFeatureService)this.cbTargetTheme.getSelectedItem();
        final String tableName = this.txtTable.getText();
        WaitingDialogThread<H2FeatureService> wdt = new WaitingDialogThread<H2FeatureService>((Frame)AppBroker.getInstance().getWatergisApp(), true, "PointInLine                                            ", null, 100, true){

            protected H2FeatureService doInBackground() throws Exception {
                int progress = 10;
                this.wd.setText(NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.butOkActionPerformed.doInBackground.retrieving"));
                this.wd.setMax(100);
                this.wd.setProgress(5);
                if (Thread.interrupted()) {
                    return null;
                }
                List<FeatureServiceFeature> featureList = FeatureServiceHelper.getFeatures(service, PointInLineDialog.this.ckbSelected.isSelected());
                this.wd.setProgress(10);
                if (Thread.interrupted()) {
                    return null;
                }
                List<FeatureServiceFeature> targetFeatureList = FeatureServiceHelper.getFeatures(targetService, PointInLineDialog.this.ckbSelectedTarget.isSelected());
                STRtree featureTree = FeatureServiceHelper.getFeatureTree(targetFeatureList);
                double buffer = 0.001;
                ArrayList<FeatureServiceFeature> resultedFeatures = new ArrayList<FeatureServiceFeature>();
                SpatialSelectionMethodInterface spatialOperation = (SpatialSelectionMethodInterface)PointInLineDialog.this.cbGeoMethod.getSelectedItem();
                LayerProperties serviceLayerProperties = featureList.get(0).getLayerProperties();
                LayerProperties targetServiceLayerProperties = targetFeatureList.get(0).getLayerProperties();
                HashMap<String, FeatureServiceAttribute> featureServiceAttributes = new HashMap<String, FeatureServiceAttribute>(serviceLayerProperties.getFeatureService().getFeatureServiceAttributes());
                HashMap<String, FeatureServiceAttribute> targetFeatureServiceAttributes = new HashMap<String, FeatureServiceAttribute>(targetServiceLayerProperties.getFeatureService().getFeatureServiceAttributes());
                ArrayList<String> secondaryFeatureProperties = new ArrayList<String>();
                Map<String, FeatureServiceAttribute> newFeatureServiceAttributes = FeatureServiceHelper.getSuitableFeatureServiceAttribute(featureServiceAttributes, targetFeatureServiceAttributes, targetService.getOrderedFeatureServiceAttributes(), secondaryFeatureProperties);
                LayerProperties newLayerProperties = serviceLayerProperties.clone();
                int count = 0;
                String distanceField = "";
                newLayerProperties.setFeatureService((AbstractFeatureService)serviceLayerProperties.getFeatureService().clone());
                newLayerProperties.getFeatureService().setFeatureServiceAttributes(newFeatureServiceAttributes);
                if (PointInLineDialog.this.txtBuffer.isEnabled() && !PointInLineDialog.this.txtBuffer.getText().equals("")) {
                    try {
                        buffer = Double.parseDouble(PointInLineDialog.this.txtBuffer.getText());
                    }
                    catch (NumberFormatException e) {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.butOkActionPerformed.doInBackground.noBuffer.message"), NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.butOkActionPerformed.doInBackground.noBuffer.title"), 0);
                        LOG.error((Object)"Invalid buffer entered. No buffer is used", (Throwable)e);
                    }
                }
                if (!PointInLineDialog.this.txtDistanceField.getText().equals("") && buffer != 0.001) {
                    FeatureServiceAttribute fsa = new FeatureServiceAttribute(PointInLineDialog.this.txtDistanceField.getText(), String.valueOf(8), false);
                    newFeatureServiceAttributes.put(PointInLineDialog.this.txtDistanceField.getText(), fsa);
                    distanceField = PointInLineDialog.this.txtDistanceField.getText();
                }
                this.wd.setText(NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.butOkActionPerformed.doInBackground.createFeatures"));
                for (FeatureServiceFeature f : featureList) {
                    Geometry searchGeom = f.getGeometry();
                    ++count;
                    if (buffer < 0.01) {
                        buffer = 0.01;
                    }
                    if (buffer != 0.0 && searchGeom != null) {
                        searchGeom = searchGeom.buffer(buffer);
                    }
                    if (searchGeom != null) {
                        List intersectingFeatures = featureTree.query(searchGeom.getEnvelopeInternal());
                        double maxDistanceToOrigin = Double.MAX_VALUE;
                        FeatureServiceFeature match = null;
                        for (FeatureServiceFeature targetFeature : intersectingFeatures) {
                            double distanceToOrigin;
                            if (!spatialOperation.featureGeometryFulfilsRequirements(f.getGeometry(), targetFeature.getGeometry(), buffer) || !((distanceToOrigin = f.getGeometry().distance(targetFeature.getGeometry())) < maxDistanceToOrigin)) continue;
                            match = targetFeature;
                            maxDistanceToOrigin = distanceToOrigin;
                        }
                        if (match != null) {
                            resultedFeatures.add(FeatureServiceHelper.mergeFeatures(f, match, newLayerProperties, secondaryFeatureProperties, distanceField));
                        }
                    }
                    if (Thread.interrupted()) {
                        return null;
                    }
                    if (progress >= 10 + count * 80 / featureList.size()) continue;
                    progress = 10 + count * 80 / featureList.size();
                    this.wd.setProgress(progress);
                }
                ArrayList<String> orderedAttributeNames = new ArrayList<String>();
                orderedAttributeNames.addAll(service.getOrderedFeatureServiceAttributes());
                orderedAttributeNames.addAll(secondaryFeatureProperties);
                if (!distanceField.equals("")) {
                    orderedAttributeNames.add(distanceField);
                }
                this.wd.setText(NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.butOkActionPerformed.doInBackground.creatingDatasource"));
                return FeatureServiceHelper.createNewService(AppBroker.getInstance().getWatergisApp(), resultedFeatures, tableName, orderedAttributeNames);
            }

            protected void done() {
                try {
                    H2FeatureService service2 = (H2FeatureService)this.get();
                    if (service2 != null) {
                        FeatureServiceHelper.addServiceLayerToTheTree((AbstractFeatureService)service2);
                    }
                }
                catch (Exception ex) {
                    LOG.error((Object)"Error while execute the point in line operation.", (Throwable)ex);
                }
            }
        };
        if (H2FeatureService.tableAlreadyExists((String)tableName)) {
            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.butOkActionPerformed.tableAlreadyExists", (Object)tableName), NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.butOkActionPerformed.tableAlreadyExists.title"), 0);
        } else {
            this.setVisible(false);
            wdt.start();
        }
    }

    private void cbThemeActionPerformed(ActionEvent evt) {
        AbstractFeatureService service = (AbstractFeatureService)this.cbTheme.getSelectedItem();
        this.selectedThemeFeatureCount = this.refreshSelectedFeatureCount(false, this.ckbSelected, service, this.selectedThemeFeatureCount, this.labSelected);
        this.enabledOrNot();
    }

    private void cbTargetThemeActionPerformed(ActionEvent evt) {
        AbstractFeatureService service = (AbstractFeatureService)this.cbTargetTheme.getSelectedItem();
        this.selectedTargetThemeFeatureCount = this.refreshSelectedFeatureCount(false, this.ckbSelectedTarget, service, this.selectedTargetThemeFeatureCount, this.labSelectedTarget);
        this.enabledOrNot();
    }

    private void cbGeoMethodPropertyChange(PropertyChangeEvent evt) {
    }

    private void cbGeoMethodItemStateChanged(ItemEvent evt) {
        Object method = this.cbGeoMethod.getSelectedItem();
        if (method instanceof SpatialSelectionMethodInterface) {
            boolean distanceRequired = ((SpatialSelectionMethodInterface)method).isDistanceRequired();
            this.txtBuffer.setEnabled(distanceRequired);
            this.txtDistanceField.setEnabled(distanceRequired);
        }
    }

    public int refreshSelectedFeatureCount(boolean forceGuiRefresh, JCheckBox box, AbstractFeatureService featureService, int lastSelectedFeatureCount, JLabel selectionCountlab) {
        int count = featureService == null ? 0 : FeatureServiceHelper.getSelectedFeatures(featureService).size();
        selectionCountlab.setText(NbBundle.getMessage(PointInLineDialog.class, (String)"PointInLineDialog.refreshSelectedFeatureCount.text", (Object)count));
        if (forceGuiRefresh || count != lastSelectedFeatureCount) {
            box.setSelected(count > 0);
        }
        return count;
    }

    private void enabledOrNot() {
        boolean isServiceSelected = this.cbTheme.getSelectedItem() instanceof AbstractFeatureService && this.cbTargetTheme.getSelectedItem() instanceof AbstractFeatureService;
        this.butOk.setEnabled(isServiceSelected);
    }
}

