/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.java2xml.Java2XML;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import de.cismet.jump.sld.editor.CidsRenderingStylePanel;
import de.cismet.watergis.broker.AppBroker;
import de.latlon.deejump.plugin.style.LayerStyle2SLDPlugIn;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;
import org.deegree.style.persistence.sld.SLDParser;
import org.deegree.style.se.unevaluated.Style;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class VisualizingDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(VisualizingDialog.class);
    private final CidsRenderingStylePanel stylePanel;
    private final Blackboard blackboard;
    private final Blackboard persistenceBlackboard;
    private final Layer layer;
    private boolean canceled = true;
    private JPanel jPanel1;
    private JButton jbCancel;
    private JButton jbOk;

    private VisualizingDialog() {
        super((Frame)AppBroker.getInstance().getWatergisApp(), true);
        this.initComponents();
        LayerManager layerManager = new LayerManager();
        FeatureSchema featureSchema = new FeatureSchema();
        FeatureDataset features = new FeatureDataset(featureSchema);
        layerManager.setFiringEvents(false);
        this.layer = AppBroker.getInstance().getDrawingStyleLayer() != null ? AppBroker.getInstance().getDrawingStyleLayer() : new Layer("default", Color.RED, (FeatureCollection)features, layerManager);
        this.blackboard = new Blackboard();
        this.persistenceBlackboard = new Blackboard();
        this.stylePanel = new CidsRenderingStylePanel(this.blackboard, this.layer, this.persistenceBlackboard);
        GridBagConstraints constraint = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0);
        this.jPanel1.add((Component)this.stylePanel, constraint);
    }

    public static VisualizingDialog getInstance() {
        return LazyInitializer.INSTANCE;
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jbOk = new JButton();
        this.jbCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jbOk, (String)NbBundle.getMessage(VisualizingDialog.class, (String)"VisualizingDialog.jbOk.text", (Object[])new Object[0]));
        this.jbOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualizingDialog.this.jbOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 5);
        this.getContentPane().add((Component)this.jbOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jbCancel, (String)NbBundle.getMessage(VisualizingDialog.class, (String)"VisualizingDialog.jbCancel.text", (Object[])new Object[0]));
        this.jbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VisualizingDialog.this.jbCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 10, 10);
        this.getContentPane().add((Component)this.jbCancel, gridBagConstraints);
        this.pack();
    }

    private void jbOkActionPerformed(ActionEvent evt) {
        this.canceled = false;
        this.stylePanel.updateStyles();
        this.setVisible(false);
    }

    private void jbCancelActionPerformed(ActionEvent evt) {
        this.canceled = true;
        this.setVisible(false);
    }

    public static String exportSLD(Layer layer, String geometryType) {
        String sld = null;
        try {
            Java2XML java2Xml = new Java2XML();
            StringWriter xmlWriter = new StringWriter();
            String name = "default";
            java2Xml.write((Object)layer, "layer", (Writer)xmlWriter);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("wmsLayerName", "default");
            params.put("featureTypeStyle", "default");
            params.put("styleName", "default");
            params.put("styleTitle", "default");
            params.put("Namespace", "http://cismet.de");
            params.put("NamespacePrefix", "");
            params.put("geoType", geometryType);
            params.put("geomProperty", "geom");
            if (layer.getMinScale() != null) {
                params.put("maxScale", "" + layer.getMinScale());
            }
            if (layer.getMaxScale() != null) {
                params.put("minScale", "" + layer.getMaxScale());
            }
            sld = LayerStyle2SLDPlugIn.transformContext((Reader)new StringReader(xmlWriter.toString()), params);
        }
        catch (Exception e) {
            LOG.info((Object)"could not save sld definition", (Throwable)e);
        }
        return sld;
    }

    public static Map<String, LinkedList<Style>> getStyles(Layer layer, String geometryType) {
        StringReader input = new StringReader(VisualizingDialog.exportSLD(layer, geometryType));
        Map styles = null;
        XMLInputFactory factory = XMLInputFactory.newInstance();
        try {
            styles = SLDParser.getStyles((XMLStreamReader)factory.createXMLStreamReader(input));
        }
        catch (Exception ex) {
            LOG.error((Object)"Fehler in der SLD", (Throwable)ex);
        }
        if (styles == null) {
            LOG.info((Object)"SLD Parser funtkioniert nicht");
        }
        return styles;
    }

    public Layer getStyleLayer() {
        return this.layer;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private static final class LazyInitializer {
        private static final transient VisualizingDialog INSTANCE = new VisualizingDialog();

        private LazyInitializer() {
        }
    }
}

