/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.dialog;

import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.layerwidget.ActiveLayerModel;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.tools.gui.RestrictedFileSystemView;
import de.cismet.tools.gui.downloadmanager.DownloadManager;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.dialog.BufferDialog;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class WkFgReportDialog
extends JDialog {
    private static final Logger LOG = Logger.getLogger(WkFgReportDialog.class);
    private boolean cancelled = false;
    private int selectedThemeFeatureCount = -1;
    private String lastPath = null;
    private JButton butCancel;
    private JButton butFile;
    private JButton butOk;
    private JCheckBox ckbSelection1;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JTextField txtFile;

    private WkFgReportDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        if (!modal) {
            CismapBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener(new FeatureCollectionListener(){

                public void featuresAdded(FeatureCollectionEvent fce) {
                }

                public void allFeaturesRemoved(FeatureCollectionEvent fce) {
                }

                public void featuresRemoved(FeatureCollectionEvent fce) {
                }

                public void featuresChanged(FeatureCollectionEvent fce) {
                }

                public void featureSelectionChanged(FeatureCollectionEvent fce) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            WkFgReportDialog.this.selectedThemeFeatureCount = WkFgReportDialog.this.refreshSelectedFeatureCount(false);
                        }
                    });
                }

                public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
                }

                public void featureCollectionChanged() {
                }
            });
        }
    }

    public static WkFgReportDialog getInstance() {
        return LazyInitializer.INSTANCE;
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setSize(420, 165);
            this.cancelled = true;
            this.selectedThemeFeatureCount = this.refreshSelectedFeatureCount(true);
        }
        super.setVisible(b);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.jPanel3 = new JPanel();
        this.txtFile = new JTextField();
        this.butFile = new JButton();
        this.filler1 = new Box.Filler(new Dimension(200, 0), new Dimension(200, 0), new Dimension(200, Short.MAX_VALUE));
        this.ckbSelection1 = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle(NbBundle.getMessage(WkFgReportDialog.class, (String)"WkFgReportDialog.title", (Object[])new Object[0]));
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(WkFgReportDialog.class, (String)"WkFgReportDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.setMinimumSize(new Dimension(170, 29));
        this.butOk.setPreferredSize(new Dimension(170, 29));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkFgReportDialog.this.butOkActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(WkFgReportDialog.class, (String)"WkFgReportDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.setMinimumSize(new Dimension(170, 29));
        this.butCancel.setPreferredSize(new Dimension(170, 29));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkFgReportDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 15, 10);
        this.jPanel1.add((Component)this.butCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 25;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.txtFile.setText(NbBundle.getMessage(WkFgReportDialog.class, (String)"WkFgReportDialog.txtFile.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.txtFile, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butFile, (String)NbBundle.getMessage(WkFgReportDialog.class, (String)"WkFgReportDialog.butFile.text", (Object[])new Object[0]));
        this.butFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WkFgReportDialog.this.butFileActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.jPanel3.add((Component)this.butFile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        this.getContentPane().add((Component)this.filler1, gridBagConstraints);
        this.ckbSelection1.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.ckbSelection1, (String)NbBundle.getMessage(WkFgReportDialog.class, (String)"WkFgReportDialog.ckbSelection1.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 10);
        this.getContentPane().add((Component)this.ckbSelection1, gridBagConstraints);
        this.pack();
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.setVisible(false);
    }

    private void butOkActionPerformed(ActionEvent evt) {
        if (!this.txtFile.getText().equals("")) {
            this.cancelled = false;
            this.setVisible(false);
        } else {
            this.butFileActionPerformed(null);
        }
    }

    private void butFileActionPerformed(ActionEvent evt) {
        JFileChooser fc;
        try {
            fc = new JFileChooser(this.lastPath == null ? DownloadManager.instance().getDestinationDirectory().toString() : this.lastPath);
        }
        catch (Exception bug) {
            fc = new JFileChooser(this.lastPath == null ? DownloadManager.instance().getDestinationDirectory().toString() : this.lastPath, (FileSystemView)new RestrictedFileSystemView());
        }
        fc.setFileSelectionMode(1);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory();
            }

            @Override
            public String getDescription() {
                return NbBundle.getMessage(WkFgReportDialog.class, (String)"GewaesserReportDialog.butFileActionPerformed().getDescription()");
            }
        });
        int ans = fc.showSaveDialog(this);
        if (ans == 0) {
            this.txtFile.setText(fc.getSelectedFile().getAbsolutePath());
            this.lastPath = fc.getSelectedFile().getAbsolutePath();
        }
    }

    public int refreshSelectedFeatureCount(boolean forceGuiRefresh) {
        TreeSet<FeatureServiceFeature> set = new TreeSet<FeatureServiceFeature>();
        for (AbstractFeatureService service : this.getAllActiveFgLaWkServices()) {
            set.addAll(FeatureServiceHelper.getSelectedFeatures(service));
        }
        int count = set.size();
        this.ckbSelection1.setText(NbBundle.getMessage(WkFgReportDialog.class, (String)"WkFgReportDialog.ckbSelection1.text") + " " + NbBundle.getMessage(BufferDialog.class, (String)"WkFgReportDialog.refreshSelectedFeatureCount.text", (Object)count));
        this.ckbSelection1.setEnabled(true);
        if (forceGuiRefresh || count != this.selectedThemeFeatureCount) {
            this.ckbSelection1.setSelected(count > 0);
        }
        if (count == 0) {
            this.ckbSelection1.setSelected(false);
            this.ckbSelection1.setEnabled(false);
        }
        return count;
    }

    public FeatureServiceFeature[] getSelectedFeatures() {
        TreeSet<FeatureServiceFeature> set = new TreeSet<FeatureServiceFeature>();
        for (AbstractFeatureService service : this.getAllActiveFgLaWkServices()) {
            set.addAll(FeatureServiceHelper.getSelectedFeatures(service));
        }
        return set.toArray(new FeatureServiceFeature[set.size()]);
    }

    private List<AbstractFeatureService> getAllActiveFgLaWkServices() {
        ArrayList<AbstractFeatureService> serviceList = new ArrayList<AbstractFeatureService>();
        ActiveLayerModel mappingModel = (ActiveLayerModel)AppBroker.getInstance().getMappingComponent().getMappingModel();
        TreeMap treeMap = mappingModel.getMapServices();
        ArrayList keyList = new ArrayList(treeMap.keySet());
        Iterator it = keyList.iterator();
        while (it.hasNext()) {
            CidsLayer featureService;
            Object service = treeMap.get(it.next());
            if (!(service instanceof CidsLayer) || !(featureService = (CidsLayer)service).getMetaClass().getTableName().equalsIgnoreCase("dlm25w.fg_bak_wk")) continue;
            try {
                if (!featureService.isInitialized()) {
                    ((AbstractFeatureService)service).initAndWait();
                }
                serviceList.add((AbstractFeatureService)featureService);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while initialising service", (Throwable)e);
            }
        }
        return serviceList;
    }

    public String getPath() {
        return this.txtFile.getText();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isSelection() {
        return this.ckbSelection1.isSelected();
    }

    private static final class LazyInitializer {
        private static final transient WkFgReportDialog INSTANCE = new WkFgReportDialog((Frame)AppBroker.getInstance().getWatergisApp(), true);

        private LazyInitializer() {
        }
    }
}

