/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.panels;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKBReader;
import de.cismet.cids.custom.watergis.server.search.GafPosition;
import de.cismet.cids.custom.watergis.server.search.PhotoGetBaStat;
import de.cismet.cids.custom.watergis.server.search.PhotoGetLaStat;
import de.cismet.cids.custom.watergis.server.search.PhotoGetPhotoNumber;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsFeatureFactory;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.features.ModifiableFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableFactory;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.util.SelectionChangedEvent;
import de.cismet.cismap.commons.util.SelectionChangedListener;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.gaf.CheckAction;
import de.cismet.watergis.gui.dialog.GafImportDialog;
import de.cismet.watergis.gui.dialog.PhotoOptionsDialog;
import de.cismet.watergis.gui.panels.GafProfEditor;
import de.cismet.watergis.profile.AbstractImportDialog;
import de.cismet.watergis.profile.ProfileLine;
import de.cismet.watergis.profile.ProfileReader;
import de.cismet.watergis.profile.ProfileReaderFactory;
import de.cismet.watergis.utils.CidsBeanUtils;
import de.cismet.watergis.utils.ContributorWrapper;
import de.cismet.watergis.utils.ConversionUtils;
import de.cismet.watergis.utils.CustomGafCatalogueReader;
import de.cismet.watergis.utils.CustomJrViewer;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JRSaveContributor;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class GafProf
extends JPanel {
    private static CidsLayer ppLayer = null;
    private static int idCounter = -1;
    private static final String FILE_PROTOCOL_PREFIX = "file://";
    private static final Logger LOG = Logger.getLogger(GafProf.class);
    private static final SimpleDateFormat timeFormatter = new SimpleDateFormat("HH:mm:ss");
    public static CidsLayerFeature selectedFeature = null;
    private List<CidsLayerFeature> newFeatures = new ArrayList<CidsLayerFeature>();
    private String oldMode;
    private boolean askForSave = true;
    private JButton butBack;
    private JButton butDelete;
    private JButton butNextProfile;
    private JButton butPrevProfile;
    private JButton butPrint;
    private JButton butPrintPreview;
    private JButton butRemoveSelection;
    private JButton butSave;
    private JButton butSaveAll;
    private JButton butZoomToProfile;
    private GafProfEditor editor;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JToggleButton tbLocate;
    private JToggleButton tbProcessing;

    public GafProf() {
        this.initComponents();
        this.tbLocate.setVisible(false);
        GafProfEditor.setPpLayer(ppLayer);
        this.tbProcessing.setVisible(false);
        SelectionManager.getInstance().addSelectionChangedListener(new SelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("qp");
                if (GafProf.this.tbLocate.isSelected() || !GafProf.this.isDisplayable()) {
                    return;
                }
                if (!GafProf.this.isShowing()) {
                    return;
                }
                if (features != null && !features.isEmpty()) {
                    Collections.sort(features, PhotoOptionsDialog.getInstance().getSorter());
                    if (selectedFeature == null || !features.get(0).equals(selectedFeature)) {
                        GafProf.this.setEditorFeature((CidsLayerFeature)features.get(0));
                        GafProf.this.butPrevProfile.setEnabled(false);
                        GafProf.this.butNextProfile.setEnabled(features.size() > 1);
                    }
                } else {
                    GafProf.this.setEditorFeature(null);
                }
            }
        });
        DropTargetAdapter dropListener = new DropTargetAdapter(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent e) {
                try {
                    Transferable tr = e.getTransferable();
                    DataFlavor[] flavors = tr.getTransferDataFlavors();
                    boolean isAccepted = false;
                    for (int i = 0; i < flavors.length; ++i) {
                        String tmp;
                        if (flavors[i].isFlavorJavaFileListType()) {
                            e.acceptDrop(e.getDropAction());
                            List files = (List)tr.getTransferData(flavors[i]);
                            if (files != null && files.size() > 0) {
                                GafProf.this.editor.showEditor(true, true);
                                GafProf.addGafServicesToTree();
                                new GafUploadWorker(files).start();
                            }
                            e.dropComplete(true);
                            return;
                        }
                        if (!flavors[i].isRepresentationClassInputStream()) continue;
                        if (!isAccepted) {
                            e.acceptDrop(e.getDropAction());
                            isAccepted = true;
                        }
                        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)tr.getTransferData(flavors[i])));
                        ArrayList<File> fileList = new ArrayList<File>();
                        while ((tmp = br.readLine()) != null) {
                            if (!tmp.trim().startsWith(GafProf.FILE_PROTOCOL_PREFIX)) continue;
                            File f = new File(tmp.trim().substring(GafProf.FILE_PROTOCOL_PREFIX.length()));
                            if (f.exists()) {
                                fileList.add(f);
                                continue;
                            }
                            f = new File(URLDecoder.decode(tmp.trim().substring(GafProf.FILE_PROTOCOL_PREFIX.length()), "UTF-8"));
                            if (f.exists()) {
                                fileList.add(f);
                                continue;
                            }
                            LOG.warn((Object)("File " + f.toString() + " does not exist."));
                        }
                        br.close();
                        if (fileList.size() <= 0) continue;
                        GafProf.this.editor.showEditor(true, true);
                        GafProf.addGafServicesToTree();
                        new GafUploadWorker(fileList).start();
                        e.dropComplete(true);
                        return;
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
                e.rejectDrop();
            }
        };
        new DropTarget(this.editor, dropListener);
    }

    static synchronized int getNewId() {
        return --idCounter;
    }

    private static String objectToString(Object string) {
        if (string == null) {
            return "";
        }
        return string.toString();
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.butPrintPreview = new JButton();
        this.butPrint = new JButton();
        this.butPrevProfile = new JButton();
        this.butNextProfile = new JButton();
        this.tbLocate = new JToggleButton();
        this.tbProcessing = new JToggleButton();
        this.butZoomToProfile = new JButton();
        this.butBack = new JButton();
        this.butDelete = new JButton();
        this.butSave = new JButton();
        this.butRemoveSelection = new JButton();
        this.butSaveAll = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.editor = new GafProfEditor();
        this.setLayout(new GridBagLayout());
        this.jToolBar1.setRollover(true);
        this.butPrintPreview.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-searchdocument.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butPrintPreview, (String)NbBundle.getMessage(GafProf.class, (String)"GafProf.butPrintPreview.text"));
        this.butPrintPreview.setToolTipText(NbBundle.getMessage(GafProf.class, (String)"GafProf.butPrintPreview.toolTipText"));
        this.butPrintPreview.setFocusable(false);
        this.butPrintPreview.setHorizontalTextPosition(0);
        this.butPrintPreview.setVerticalTextPosition(3);
        this.butPrintPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProf.this.butPrintPreviewActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butPrintPreview);
        this.butPrint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-print.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butPrint, (String)NbBundle.getMessage(GafProf.class, (String)"GafProf.butPrint.text"));
        this.butPrint.setToolTipText(NbBundle.getMessage(GafProf.class, (String)"GafProf.butPrint.toolTipText"));
        this.butPrint.setFocusable(false);
        this.butPrint.setHorizontalTextPosition(0);
        this.butPrint.setVerticalTextPosition(3);
        this.butPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProf.this.butPrintActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butPrint);
        this.butPrevProfile.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-arrow-left.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butPrevProfile, (String)NbBundle.getMessage(GafProf.class, (String)"GafProf.butPrevProfile.text"));
        this.butPrevProfile.setToolTipText(NbBundle.getMessage(GafProf.class, (String)"GafProf.butPrevProfile.toolTipText"));
        this.butPrevProfile.setFocusable(false);
        this.butPrevProfile.setHorizontalTextPosition(0);
        this.butPrevProfile.setVerticalTextPosition(3);
        this.butPrevProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProf.this.butPrevProfileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butPrevProfile);
        this.butNextProfile.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-arrow-right.png")));
        this.butNextProfile.setToolTipText(NbBundle.getMessage(GafProf.class, (String)"GafProf.butNextProfile.toolTipText"));
        this.butNextProfile.setFocusable(false);
        this.butNextProfile.setHorizontalTextPosition(0);
        this.butNextProfile.setVerticalTextPosition(3);
        this.butNextProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProf.this.butNextProfileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butNextProfile);
        this.tbLocate.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-flagtriangle.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.tbLocate, (String)NbBundle.getMessage(GafProf.class, (String)"GafProf.tbLocate.text"));
        this.tbLocate.setToolTipText(NbBundle.getMessage(GafProf.class, (String)"GafProf.tbLocate.toolTipText"));
        this.tbLocate.setFocusable(false);
        this.tbLocate.setHorizontalTextPosition(0);
        this.tbLocate.setVerticalTextPosition(3);
        this.tbLocate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProf.this.tbLocateActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.tbLocate);
        this.tbProcessing.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-edit.png")));
        this.tbProcessing.setToolTipText(NbBundle.getMessage(GafProf.class, (String)"GafProf.tbProcessing.toolTipText"));
        this.tbProcessing.setFocusable(false);
        this.tbProcessing.setHorizontalTextPosition(0);
        this.tbProcessing.setVerticalTextPosition(3);
        this.tbProcessing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProf.this.tbProcessingActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.tbProcessing);
        this.butZoomToProfile.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-selectionadd.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butZoomToProfile, (String)NbBundle.getMessage(GafProf.class, (String)"GafProf.butZoomToProfile.text"));
        this.butZoomToProfile.setToolTipText(NbBundle.getMessage(GafProf.class, (String)"GafProf.butZoomToProfile.toolTipText"));
        this.butZoomToProfile.setFocusable(false);
        this.butZoomToProfile.setHorizontalTextPosition(0);
        this.butZoomToProfile.setVerticalTextPosition(3);
        this.butZoomToProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProf.this.butZoomToProfileActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butZoomToProfile);
        this.butBack.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-fullscreen.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butBack, (String)NbBundle.getMessage(GafProf.class, (String)"GafProf.butBack.text"));
        this.butBack.setToolTipText(NbBundle.getMessage(GafProf.class, (String)"GafProf.butBack.toolTipText"));
        this.butBack.setFocusable(false);
        this.butBack.setHorizontalTextPosition(0);
        this.butBack.setVerticalTextPosition(3);
        this.butBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProf.this.butBackActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butBack);
        this.butDelete.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-circledelete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butDelete, (String)NbBundle.getMessage(GafProf.class, (String)"GafProf.butDelete.text"));
        this.butDelete.setToolTipText(NbBundle.getMessage(GafProf.class, (String)"GafProf.butDelete.toolTipText"));
        this.butDelete.setFocusable(false);
        this.butDelete.setHorizontalTextPosition(0);
        this.butDelete.setVerticalTextPosition(3);
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProf.this.butDeleteActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butDelete);
        this.butSave.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-editalt.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butSave, (String)NbBundle.getMessage(GafProf.class, (String)"GafProf.butSave.text"));
        this.butSave.setToolTipText(NbBundle.getMessage(GafProf.class, (String)"GafProf.butSave.toolTipText"));
        this.butSave.setFocusable(false);
        this.butSave.setHorizontalTextPosition(0);
        this.butSave.setVerticalTextPosition(3);
        this.butSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProf.this.butSaveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butSave);
        this.butRemoveSelection.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-selectionremove.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butRemoveSelection, (String)NbBundle.getMessage(GafProf.class, (String)"GafProf.butRemoveSelection.text"));
        this.butRemoveSelection.setToolTipText(NbBundle.getMessage(GafProf.class, (String)"GafProf.butRemoveSelection.toolTipText"));
        this.butRemoveSelection.setFocusable(false);
        this.butRemoveSelection.setHorizontalTextPosition(0);
        this.butRemoveSelection.setVerticalTextPosition(3);
        this.butRemoveSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProf.this.butRemoveSelectionActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butRemoveSelection);
        this.butSaveAll.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/saveAll.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butSaveAll, (String)NbBundle.getMessage(GafProf.class, (String)"GafProf.butSaveAll.text"));
        this.butSaveAll.setToolTipText(NbBundle.getMessage(GafProf.class, (String)"GafProf.butSaveAll.toolTipText"));
        this.butSaveAll.setFocusable(false);
        this.butSaveAll.setHorizontalTextPosition(0);
        this.butSaveAll.setVerticalTextPosition(3);
        this.butSaveAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GafProf.this.butSaveAllActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butSaveAll);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.editor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void butPrintPreviewActionPerformed(ActionEvent evt) {
        WaitingDialogThread<JasperPrint> wdt = new WaitingDialogThread<JasperPrint>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(GafProf.class, (String)"GafProf.butPrintPreviewActionPerformed.WaitingDialogThread"), null, 500){

            protected JasperPrint doInBackground() throws Exception {
                return GafProf.fillreport(GafProf.this.editor.getCidsLayerFeature());
            }

            protected void done() {
                try {
                    JasperPrint jasperPrint = (JasperPrint)this.get();
                    CustomJrViewer aViewer = new CustomJrViewer(jasperPrint);
                    ArrayList<ContributorWrapper> contributors = new ArrayList<ContributorWrapper>();
                    for (JRSaveContributor contributor : aViewer.getSaveContributors()) {
                        if (contributor.getDescription().toLowerCase().contains("pdf")) {
                            contributors.add(new ContributorWrapper(contributor, "PDF"));
                            continue;
                        }
                        if (!contributor.getDescription().toLowerCase().contains("docx")) continue;
                        contributors.add(new ContributorWrapper(contributor, "DOCX"));
                    }
                    Collections.sort(contributors, new Comparator<JRSaveContributor>(){

                        @Override
                        public int compare(JRSaveContributor o1, JRSaveContributor o2) {
                            if (o1 != null && o2 != null) {
                                return o1.getDescription().compareTo(o2.getDescription());
                            }
                            if (o1 == null && o2 == null) {
                                return 0;
                            }
                            if (o1 == null) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                    aViewer.setSaveContributors(contributors.toArray(new JRSaveContributor[contributors.size()]));
                    JFrame aFrame = new JFrame(NbBundle.getMessage(GafProf.class, (String)"GafProf.butPrintPreviewActionPerformed.aFrame.title"));
                    aFrame.getContentPane().add((Component)((Object)aViewer));
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    aFrame.setSize(screenSize.width / 2, screenSize.height / 2);
                    Insets insets = aFrame.getInsets();
                    aFrame.setSize(aFrame.getWidth() + insets.left + insets.right, aFrame.getHeight() + insets.top + insets.bottom + 20);
                    aFrame.setLocationRelativeTo(GafProf.this);
                    aFrame.setVisible(true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while creating report", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private void butPrintActionPerformed(ActionEvent evt) {
        WaitingDialogThread<JasperPrint> wdt = new WaitingDialogThread<JasperPrint>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(GafProf.class, (String)"GafProf.butPrintActionPerformed.WaitingDialogThread"), null, 500){

            protected JasperPrint doInBackground() throws Exception {
                return GafProf.fillreport(GafProf.this.editor.getCidsLayerFeature());
            }

            protected void done() {
                try {
                    JasperPrint jasperPrint = (JasperPrint)this.get();
                    jasperPrint.setOrientation(OrientationEnum.LANDSCAPE);
                    JasperPrintManager.printReport((JasperPrint)jasperPrint, (boolean)true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while creating report", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    @Deprecated
    public static InputStream loadFileFromWebDav(CidsLayerFeature feature, Component parent) throws Exception {
        return null;
    }

    public static void deleteProfile(CidsLayerFeature feature) throws Exception {
        String nr = String.valueOf(feature.getProperty("qp_nr"));
        feature.delete();
        ppLayer.initAndWait();
        List features = ppLayer.getFeatureFactory().createFeatures((Object)("qp_nr = " + nr), null, null, 0, 0, null);
        if (features != null) {
            for (DefaultFeatureServiceFeature f : features) {
                if (!(f instanceof CidsLayerFeature)) continue;
                ((CidsLayerFeature)f).delete();
            }
        }
    }

    public static String getBasicReportFileName(CidsLayerFeature feature) throws Exception {
        Double stat;
        String baCd;
        Object baStObject = feature.getProperty("ba_st");
        if (baStObject instanceof CidsBean) {
            baCd = (String)((CidsBean)baStObject).getProperty("route.ba_cd");
            stat = (Double)((CidsBean)baStObject).getProperty("wert");
        } else {
            baCd = (String)feature.getProperty("ba_cd");
            stat = (Double)baStObject;
        }
        DecimalFormat format = new DecimalFormat("0.00");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(',');
        format.setDecimalFormatSymbols(symbols);
        format.setGroupingUsed(false);
        return GafProf.removeIllegaleFileNameCharacters(baCd) + "__" + format.format(stat) + ".pdf";
    }

    public static Double getFeatureStation(CidsLayerFeature feature) {
        Object baStObject = feature.getProperty("ba_st");
        Double stat = baStObject instanceof CidsBean ? (Double)((CidsBean)baStObject).getProperty("wert") : (Double)baStObject;
        return stat;
    }

    public static String getBasicGafFileName(CidsLayerFeature feature) throws Exception {
        Object baStObject = feature.getProperty("ba_st");
        String baCd = baStObject instanceof CidsBean ? (String)((CidsBean)baStObject).getProperty("route.ba_cd") : (String)feature.getProperty("ba_cd");
        return GafProf.removeIllegaleFileNameCharacters(baCd) + ".gaf";
    }

    public static String getLawaReportFileName(CidsLayerFeature feature) throws Exception {
        String baCd = String.valueOf(feature.getProperty("la_cd"));
        Double stat = (Double)feature.getProperty("la_st");
        DecimalFormat format = new DecimalFormat("0.00");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator(',');
        format.setDecimalFormatSymbols(symbols);
        format.setGroupingUsed(false);
        return GafProf.removeIllegaleFileNameCharacters(baCd) + "__" + format.format(stat) + ".pdf";
    }

    public static String getLawaGafFileName(CidsLayerFeature feature) throws Exception {
        String baCd = String.valueOf(feature.getProperty("la_cd"));
        return GafProf.removeIllegaleFileNameCharacters(baCd) + ".gaf";
    }

    public static String removeIllegaleFileNameCharacters(String name) {
        name = name.replace("\\", "-");
        name = name.replace("/", "_");
        name = name.replace(":", "+");
        name = name.replace("*", "#");
        name = name.replace("?", "!");
        name = name.replace("\"", "'");
        name = name.replace("<", "$");
        name = name.replace(">", "%");
        name = name.replace("|", "~");
        return name;
    }

    public static JasperPrint fillreport(final CidsLayerFeature feature) throws Exception {
        JRDataSource ds = new JRDataSource(){
            private boolean first = true;

            public boolean next() throws JRException {
                if (this.first) {
                    this.first = false;
                    return true;
                }
                return false;
            }

            public Object getFieldValue(JRField jrf) throws JRException {
                return feature.getBean().getProperty(jrf.getName());
            }
        };
        HashMap<String, Object> map = new HashMap<String, Object>();
        CidsBean basisStat = (CidsBean)feature.getBean().getProperty("ba_st");
        CidsBean freigabe = (CidsBean)feature.getBean().getProperty("freigabe");
        User user = SessionManager.getSession().getUser();
        Boolean hasPermissionforBemerkung = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? Boolean.valueOf(true) : Boolean.valueOf(feature.getProperty("upl_name") != null && feature.getProperty("upl_name").equals(user.getName()));
        map.put("punkt", feature.getGeometry());
        map.put("upl_nutzer", feature.getProperty("upl_name"));
        map.put("upl_datum", GafProf.dateTime2String(feature.getProperty("upl_datum"), (String)feature.getProperty("upl_zeit")));
        map.put("qp_nr", GafProf.objectToString(feature.getProperty("qp_nr")));
        map.put("pos", ConversionUtils.numberToString(feature.getProperty("re")) + " " + ConversionUtils.numberToString(feature.getProperty("ho")));
        map.put("lawa", GafProf.objectToString(feature.getProperty("la_cd")));
        map.put("lawa_stat", feature.getProperty("la_st") == null ? "" : ConversionUtils.numberToString(feature.getProperty("la_st")));
        map.put("dhhn", "ja");
        map.put("status", GafProf.objectToString(feature.getProperty("l_st")));
        map.put("aufn_nutzer", feature.getProperty("aufn_name"));
        map.put("aufn_datum", GafProf.dateTime2String(feature.getProperty("aufn_datum"), (String)feature.getProperty("aufn_zeit")));
        map.put("titel", feature.getProperty("titel"));
        map.put("beschreibung", feature.getProperty("beschreib"));
        map.put("bemerkung", feature.getProperty("bemerkung"));
        if (basisStat != null) {
            map.put("basis", feature.getProperty("ba_cd"));
            map.put("basis_stat", ConversionUtils.numberToString(basisStat.getProperty("wert")));
        } else {
            map.put("basis", "");
            map.put("basis_stat", "");
        }
        if (freigabe != null) {
            map.put("freigabe", freigabe.toString());
        } else {
            map.put("freigabe", "");
        }
        map.put("isUploader", hasPermissionforBemerkung);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)GafProf.class.getResourceAsStream("/de/cismet/watergis/reports/gafProf.jasper"));
        return JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)ds);
    }

    private static String dateTime2String(Object date, String time) {
        if (date == null && time == null) {
            return "";
        }
        if (date == null) {
            return time;
        }
        if (time == null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
                return format.format(date);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"Not a date", (Throwable)e);
                return "";
            }
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
            return format.format(date) + " " + time;
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Not a date", (Throwable)e);
            return "";
        }
    }

    public static void addGafServicesToTree() {
        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("qp");
        if (services == null || services.isEmpty()) {
            CidsLayer layer = new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.qp"));
            AppBroker.getInstance().getMappingComponent().getMappingModel().addLayer((RetrievalServiceLayer)layer);
            AttributeTableFactory.getInstance().switchProcessingMode((AbstractFeatureService)layer);
        } else if (!SelectionManager.getInstance().getEditableServices().contains(services.get(0))) {
            AttributeTableFactory.getInstance().switchProcessingMode(services.get(0));
        }
    }

    public static void closeEditMode() {
        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("qp");
        if ((services != null || services.isEmpty()) && SelectionManager.getInstance().getEditableServices().contains(services.get(0))) {
            AttributeTableFactory.getInstance().switchProcessingMode(services.get(0));
        }
    }

    private static void addLayerToTree(String layerName) {
        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree(layerName);
        if (services == null || services.isEmpty()) {
            CidsLayer l = new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)("dlm25w." + layerName)));
            AppBroker.getInstance().getMappingComponent().getMappingModel().addLayer((RetrievalServiceLayer)l);
        }
    }

    public static void reloadGafProfileServices() {
        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("qp");
        for (AbstractFeatureService featureService : services) {
            featureService.retrieve(true);
        }
    }

    private void butPrevProfileActionPerformed(ActionEvent evt) {
        CidsLayerFeature feature = this.editor.getCidsLayerFeature();
        List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("qp");
        if (features != null && !features.isEmpty()) {
            Collections.sort(features, PhotoOptionsDialog.getInstance().getSorter());
            int index = features.indexOf(feature);
            if (--index >= 0) {
                this.setEditorFeature((CidsLayerFeature)features.get(index));
            }
            this.butNextProfile.setEnabled(index < features.size() - 1);
            this.butPrevProfile.setEnabled(index > 0);
        } else {
            this.butNextProfile.setEnabled(false);
            this.butPrevProfile.setEnabled(false);
        }
    }

    private void butNextProfileActionPerformed(ActionEvent evt) {
        CidsLayerFeature feature = this.editor.getCidsLayerFeature();
        List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("qp");
        if (features != null && !features.isEmpty()) {
            Collections.sort(features, PhotoOptionsDialog.getInstance().getSorter());
            int index = features.indexOf(feature);
            if (++index < features.size()) {
                this.setEditorFeature((CidsLayerFeature)features.get(index));
            }
            this.butNextProfile.setEnabled(index < features.size() - 1);
            this.butPrevProfile.setEnabled(index > 0);
        } else {
            this.butNextProfile.setEnabled(false);
            this.butPrevProfile.setEnabled(false);
        }
    }

    private void tbProcessingActionPerformed(ActionEvent evt) {
    }

    private void butBackActionPerformed(ActionEvent evt) {
        AppBroker.getInstance().getMappingComponent().back(true);
    }

    private void butSaveActionPerformed(ActionEvent evt) {
        try {
            CidsLayerFeature feature = this.editor.getCidsLayerFeature();
            AttributeTableRuleSet ruleSet = feature.getLayerProperties().getAttributeTableRuleSet();
            if (ruleSet != null) {
                ruleSet.beforeSave((FeatureServiceFeature)feature);
            }
            feature.saveChangesWithoutReload();
            GafProf.reloadGafProfileServices();
        }
        catch (Exception e) {
            LOG.error((Object)"Eror while saving feature", (Throwable)e);
        }
    }

    private void butRemoveSelectionActionPerformed(ActionEvent evt) {
        SelectionManager.getInstance().removeSelectedFeatures((Feature)this.editor.getCidsLayerFeature());
    }

    private void butZoomToProfileActionPerformed(ActionEvent evt) {
        CidsLayerFeature feature = this.editor.getCidsLayerFeature();
        MappingComponent mappingComponent = CismapBroker.getInstance().getMappingComponent();
        if (mappingComponent != null) {
            XBoundingBox bbox = new XBoundingBox(feature.getGeometry());
            bbox.increase(10);
            BoundingBox scaledBBox = mappingComponent.getScaledBoundingBox(1000.0, (BoundingBox)bbox);
            mappingComponent.gotoBoundingBoxWithHistory(scaledBBox);
        } else {
            LOG.error((Object)"MappingComponent is not set");
        }
    }

    private void butDeleteActionPerformed(final ActionEvent evt) {
        final CidsLayerFeature feature = this.editor.getCidsLayerFeature();
        if (!feature.hasWritePermissions()) {
            return;
        }
        int ans = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(GafProf.class, (String)"GafProf.butDeleteActionPerformed().text"), NbBundle.getMessage(GafProf.class, (String)"GafProf.butDeleteActionPerformed().title"), 0);
        if (ans != 0) {
            return;
        }
        WaitingDialogThread<Void> wdt = new WaitingDialogThread<Void>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(GafProf.class, (String)"GafProf.butDeleteActionPerformed.WaitingDialogThread"), null, 500){

            protected Void doInBackground() throws Exception {
                GafProf.deleteProfile(feature);
                return null;
            }

            protected void done() {
                try {
                    this.get();
                    GafProf.reloadGafProfileServices();
                    GafProf.this.askForSave = false;
                    GafProf.this.butRemoveSelectionActionPerformed(evt);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while deleting objects", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private void tbLocateActionPerformed(ActionEvent evt) {
        if (this.tbLocate.isSelected()) {
            this.makeFeatureEditable((FeatureServiceFeature)this.editor.getCidsLayerFeature());
        } else {
            CidsLayerFeature layerFeature = this.editor.getCidsLayerFeature();
            try {
                layerFeature.getBean().setProperty("geom.geo_field", (Object)layerFeature.getGeometry());
                CidsLayerFeature feature = this.editor.getCidsLayerFeature();
                AttributeTableRuleSet ruleSet = feature.getLayerProperties().getAttributeTableRuleSet();
                if (ruleSet != null) {
                    ruleSet.beforeSave((FeatureServiceFeature)feature);
                }
                feature.saveChangesWithoutReload();
                layerFeature.setEditable(false);
                GafProf.reloadGafProfileServices();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while setting the new geometry", (Throwable)e);
            }
        }
    }

    private void butSaveAllActionPerformed(ActionEvent evt) {
        WaitingDialogThread<Void> wdt = new WaitingDialogThread<Void>((Frame)AppBroker.getInstance().getWatergisApp(), true, NbBundle.getMessage(GafProf.class, (String)"GafProf.butSaveAllActionPerformed"), null, 100){

            protected Void doInBackground() throws Exception {
                CidsLayerFeature feature = GafProf.this.editor.getCidsLayerFeature();
                AttributeTableRuleSet ruleSet = feature.getLayerProperties().getAttributeTableRuleSet();
                List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("qp");
                if (features != null && !features.isEmpty()) {
                    for (FeatureServiceFeature selectedF : features) {
                        if (selectedF.getId() == feature.getId()) continue;
                        selectedF.setProperty("aufn_name", feature.getProperty("aufn_name"));
                        selectedF.setProperty("aufn_datum", feature.getProperty("aufn_datum"));
                        selectedF.setProperty("aufn_zeit", feature.getProperty("aufn_zeit"));
                        selectedF.setProperty("titel", feature.getProperty("titel"));
                        selectedF.setProperty("beschreib", feature.getProperty("beschreib"));
                        selectedF.setProperty("bemerkung", feature.getProperty("bemerkung"));
                        selectedF.setProperty("l_st", feature.getBean().getProperty("l_st"));
                        selectedF.setProperty("freigabe", feature.getBean().getProperty("freigabe"));
                        if (!(selectedF instanceof ModifiableFeature)) continue;
                        ((ModifiableFeature)selectedF).saveChangesWithoutReload();
                    }
                }
                if (ruleSet != null) {
                    ruleSet.beforeSave((FeatureServiceFeature)feature);
                }
                feature.saveChangesWithoutReload();
                return null;
            }

            protected void done() {
                try {
                    this.get();
                    GafProf.reloadGafProfileServices();
                }
                catch (Exception e) {
                    LOG.error((Object)"Error apply changes for all selected profiles", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private void setEditorFeature(CidsLayerFeature feature) {
        this.askForSave = true;
        if (this.tbLocate.isSelected()) {
            this.tbLocate.setSelected(false);
            this.tbLocateActionPerformed(null);
        }
        if (feature != null && !feature.isEditable()) {
            this.makeFeatureEditable((FeatureServiceFeature)feature);
        }
        this.editor.setCidsLayerFeature(feature);
        this.enableToolbar(feature != null);
        CidsLayerFeature formerSelectedFeature = selectedFeature;
        selectedFeature = feature;
        this.refreshFeatureVisualisation(formerSelectedFeature);
        this.refreshFeatureVisualisation(selectedFeature);
        if (feature != null) {
            this.butDelete.setEnabled(this.editor.hasWriteAccess());
        }
    }

    private void refreshFeatureVisualisation(CidsLayerFeature feature) {
        AbstractFeatureService service;
        if (feature != null && (service = feature.getLayerProperties().getFeatureService()) != null) {
            List pfeatureList = service.getPNode().getChildrenReference();
            for (PFeature pf : pfeatureList) {
                PFeature mapFeature;
                Feature f = pf.getFeature();
                if (!(f instanceof FeatureServiceFeature)) continue;
                if (((FeatureServiceFeature)f).getId() == feature.getId()) {
                    pf.visualize();
                    pf.refreshDesign();
                }
                if ((mapFeature = (PFeature)pf.getViewer().getPFeatureHM().get(feature)) == null) continue;
                mapFeature.visualize();
                mapFeature.refreshDesign();
            }
        }
    }

    private void enableToolbar(boolean enabled) {
        boolean writable = enabled && this.editor.hasWriteAccess();
        this.butBack.setEnabled(enabled);
        this.butNextProfile.setEnabled(enabled);
        this.butPrevProfile.setEnabled(enabled);
        this.butPrint.setEnabled(enabled);
        this.butPrintPreview.setEnabled(enabled);
        this.butRemoveSelection.setEnabled(enabled);
        this.butZoomToProfile.setEnabled(enabled);
        this.tbLocate.setEnabled(writable);
        this.tbProcessing.setEnabled(writable);
        this.butSave.setEnabled(writable);
        this.butDelete.setEnabled(writable);
    }

    private void makeFeatureEditable(FeatureServiceFeature feature) {
        if (feature != null && !feature.isEditable()) {
            try {
                feature.setEditable(true);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while locking feature.", (Throwable)ex);
            }
        }
    }

    public void dispose() {
        selectedFeature = null;
        this.editor.dispose();
        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("qp");
        if (services != null && !services.isEmpty() && SelectionManager.getInstance().getEditableServices().contains(services.get(0))) {
            AttributeTableFactory.getInstance().switchProcessingMode(services.get(0));
        }
    }

    public static void tryStationCreation(CidsLayerFeature feature, CidsBean newGafBean) throws Exception {
        Station stat = GafProf.getNextFgBaStat(feature.getGeometry(), 1.0);
        if (stat != null) {
            MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
            CidsBean stationBean = CidsBeanUtils.createNewCidsBeanFromTableName("dlm25w.fg_ba_punkt");
            CidsBean stationGeom = CidsBeanUtils.createNewCidsBeanFromTableName("geom");
            MetaObject route = SessionManager.getProxy().getMetaObject(stat.getId(), routeMc.getID(), "DLM25W");
            stationGeom.setProperty("geo_field", (Object)stat.getPoint());
            stationBean.setProperty("wert", (Object)stat.getStat());
            stationBean.setProperty("route", (Object)route.getBean());
            stationBean.setProperty("real_point", (Object)stationGeom);
            newGafBean.setProperty("ba_st", (Object)stationBean);
            feature.setProperty("ba_cd", (Object)stat.getBaCd());
            Station laStat = GafProf.getNextFgLaStat(stat.getPoint());
            if (laStat != null) {
                feature.setProperty("la_cd", (Object)laStat.getLaCd());
                feature.setProperty("la_st", (Object)laStat.getStat());
            }
        }
    }

    private static Station getNextFgBaStat(Geometry geom, double maxDist) {
        try {
            User user = SessionManager.getSession().getUser();
            ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new PhotoGetBaStat(geom, maxDist));
            if (attributes != null && !attributes.isEmpty()) {
                GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
                WKBReader wkbReader = new WKBReader(geomFactory);
                Station stat = new Station();
                stat.setId((Integer)((ArrayList)attributes.get(0)).get(0));
                stat.setBaCd((String)((ArrayList)attributes.get(0)).get(1));
                stat.setStat((Double)((ArrayList)attributes.get(0)).get(2));
                stat.setPoint(wkbReader.read((byte[])((ArrayList)attributes.get(0)).get(3)));
                return stat;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Errro while retrieving next fg ba station.", (Throwable)ex);
        }
        return null;
    }

    private static Station getNextFgLaStat(Geometry geom) {
        try {
            User user = SessionManager.getSession().getUser();
            ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new PhotoGetLaStat(geom));
            if (attributes != null && !attributes.isEmpty()) {
                GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
                WKBReader wkbReader = new WKBReader(geomFactory);
                Station stat = new Station();
                stat.setLaCd((BigDecimal)((ArrayList)attributes.get(0)).get(1));
                stat.setStat((Double)((ArrayList)attributes.get(0)).get(2));
                return stat;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Errro while retrieving next fg ba station.", (Throwable)ex);
        }
        return null;
    }

    static {
        MetaClass mc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.qp_gaf_pp");
        if (mc != null) {
            ppLayer = new CidsLayer(mc);
        }
    }

    private static class Station {
        private int id;
        private String baCd;
        private BigDecimal laCd;
        private double stat;
        private Geometry point;

        private Station() {
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getBaCd() {
            return this.baCd;
        }

        public void setBaCd(String baCd) {
            this.baCd = baCd;
        }

        public double getStat() {
            return this.stat;
        }

        public void setStat(double stat) {
            this.stat = stat;
        }

        public Geometry getPoint() {
            return this.point;
        }

        public void setPoint(Geometry point) {
            this.point = point;
        }

        public BigDecimal getLaCd() {
            return this.laCd;
        }

        public void setLaCd(BigDecimal laCd) {
            this.laCd = laCd;
        }
    }

    final class GafUploadWorker
    extends WaitingDialogThread<List<CidsLayerFeature>> {
        private final Collection<File> profs;

        public GafUploadWorker(Collection<File> profs) {
            super(StaticSwingTools.getParentFrame((Component)GafProf.this), true, "Importiere Profil", null, 50);
            this.profs = profs;
        }

        protected List<CidsLayerFeature> doInBackground() throws Exception {
            ArrayList<CidsLayerFeature> newBeans = new ArrayList<CidsLayerFeature>();
            boolean dhhn92Check = false;
            boolean dhhn92 = false;
            Iterator<File> it = this.profs.iterator();
            ArrayList<File> possibleCatalogueFiles = new ArrayList<File>();
            List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("qp");
            CidsLayer layer = null;
            Date currentTime = new Date();
            layer = services != null && !services.isEmpty() ? (CidsLayer)services.get(0) : new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.qp"));
            while (it.hasNext()) {
                File f = it.next();
                if (f.getName().toLowerCase().endsWith(".gaf") || f.getName().toLowerCase().endsWith(".csv") || f.getName().toLowerCase().endsWith(".txt")) continue;
                possibleCatalogueFiles.add(f);
                it.remove();
            }
            for (File gafFile : this.profs) {
                String userName = SessionManager.getSession().getUser().getName();
                ProfileReader reader = ProfileReaderFactory.getReader(gafFile);
                boolean hasBkcat = false;
                boolean hasRkcat = false;
                AbstractImportDialog dialog = reader.getImportDialog(StaticSwingTools.getParentFrame((Component)GafProf.this));
                if (dialog != null) {
                    dialog.setAlwaysOnTop(true);
                    StaticSwingTools.showDialog((JDialog)dialog);
                    if (dialog.isCancelled()) continue;
                }
                for (File catalogue : possibleCatalogueFiles) {
                    try {
                        CustomGafCatalogueReader.FILE_TYPE catType = reader.addCustomCatalogue(catalogue);
                        if (catType.equals((Object)CustomGafCatalogueReader.FILE_TYPE.BK)) {
                            if (hasBkcat) {
                                JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(GafUploadWorker.class, (String)"GafProf.ImageUploadWorker.doInBackground().multiBkCat.message"), NbBundle.getMessage(GafUploadWorker.class, (String)"GafProf.ImageUploadWorker.doInBackground().multiBkCat.title"), 0);
                                return null;
                            }
                            hasBkcat = true;
                            continue;
                        }
                        if (!catType.equals((Object)CustomGafCatalogueReader.FILE_TYPE.RK)) continue;
                        if (hasRkcat) {
                            JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(GafUploadWorker.class, (String)"GafProf.ImageUploadWorker.doInBackground().multiRkCat.message"), NbBundle.getMessage(GafUploadWorker.class, (String)"GafProf.ImageUploadWorker.doInBackground().multiRkCat.title"), 0);
                            return null;
                        }
                        hasRkcat = true;
                    }
                    catch (IllegalArgumentException e) {
                        JOptionPane.showMessageDialog(AppBroker.getInstance().getWatergisApp(), NbBundle.getMessage(GafUploadWorker.class, (String)"GafProf.ImageUploadWorker.doInBackground().unknownCat.message", (Object)e.getMessage()), NbBundle.getMessage(GafUploadWorker.class, (String)"GafProf.ImageUploadWorker.doInBackground().unknownCat.title"), 0);
                        return null;
                    }
                }
                String[] errors = reader.checkFile();
                if (errors != null && errors.length > 0) {
                    CheckAction.handleErrors(errors, gafFile);
                    return null;
                }
                if (!dhhn92Check) {
                    StaticSwingTools.showDialog((JDialog)GafImportDialog.getInstance());
                    GafImportDialog.getInstance().setAlwaysOnTop(true);
                    dhhn92Check = true;
                    boolean bl = dhhn92 = !GafImportDialog.getInstance().isCancelled();
                }
                if (!dhhn92) continue;
                for (Double profile : reader.getProfiles()) {
                    CidsBean freigabeBean;
                    HashMap<String, Integer> props = new HashMap<String, Integer>();
                    CidsBean newGafBean = CidsBeanUtils.createNewCidsBeanFromTableName("dlm25w.qp");
                    int id = GafProf.getNewId();
                    for (String propName : newGafBean.getPropertyNames()) {
                        props.put(propName, null);
                    }
                    props.put("id", id);
                    layer.initAndWait();
                    CidsLayerFeature feature = new CidsLayerFeature(props, layer.getMetaClass(), ((CidsFeatureFactory)layer.getFeatureFactory()).getLayerInfo(), layer.getLayerProperties(), null);
                    newGafBean.setProperty("id", (Object)id);
                    newGafBean.setProperty("upl_datum", (Object)new java.sql.Date(currentTime.getTime()));
                    newGafBean.setProperty("upl_zeit", (Object)timeFormatter.format(currentTime.getTime()));
                    newGafBean.setProperty("upl_name", (Object)userName);
                    newGafBean.setProperty("qp_nr", (Object)this.getNextProfileNumber());
                    newGafBean.setProperty("ww_gr", (Object)AppBroker.getInstance().getOwnWwGr());
                    Geometry intersectionPoint = this.getIntersectionPoint((Geometry)reader.getNpLine(profile));
                    if (intersectionPoint == null) {
                        intersectionPoint = reader.getProfilePoint(profile);
                    }
                    if (intersectionPoint != null) {
                        CidsBean geom = CidsBeanUtils.createNewCidsBeanFromTableName("geom");
                        geom.setProperty("geo_field", (Object)intersectionPoint);
                        newGafBean.setProperty("geom", (Object)geom);
                        feature.setGeometry(intersectionPoint);
                        CidsBean statusBean = this.getCatalogueElement("dlm25w.k_l_st", "l_st", "V-Bau");
                        if (statusBean != null) {
                            newGafBean.setProperty("l_st", (Object)statusBean);
                        }
                        GafProf.tryStationCreation(feature, newGafBean);
                    }
                    if ((freigabeBean = this.getCatalogueElement("dlm25w.k_freigabe", "name", "alle Nutzer")) != null) {
                        newGafBean.setProperty("freigabe", (Object)freigabeBean);
                    }
                    feature.setMetaObject(newGafBean.getMetaObject());
                    AttributeTableRuleSet ruleSet = feature.getLayerProperties().getAttributeTableRuleSet();
                    if (ruleSet != null) {
                        ruleSet.beforeSave((FeatureServiceFeature)feature);
                    }
                    for (ProfileLine line : reader.getProfileContent(profile)) {
                        CidsBean ppBean = CidsBeanUtils.createNewCidsBeanFromTableName("dlm25w.qp_gaf_pp");
                        CidsBean geom = CidsBeanUtils.createNewCidsBeanFromTableName("geom");
                        GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
                        Double rw = (Double)reader.getProfileContent(ProfileReader.GAF_FIELDS.RW, line);
                        Double hw = (Double)reader.getProfileContent(ProfileReader.GAF_FIELDS.HW, line);
                        geom.setProperty("geo_field", (Object)gf.createPoint(new Coordinate(rw.doubleValue(), hw.doubleValue())));
                        ppBean.setProperty("geom", (Object)geom);
                        ppBean.setProperty("id_gaf", reader.getProfileContent(ProfileReader.GAF_FIELDS.ID, line));
                        ppBean.setProperty("y", reader.getProfileContent(ProfileReader.GAF_FIELDS.Y, line));
                        ppBean.setProperty("z", reader.getProfileContent(ProfileReader.GAF_FIELDS.Z, line));
                        ppBean.setProperty("kz", reader.getProfileContent(ProfileReader.GAF_FIELDS.KZ, line));
                        ppBean.setProperty("hyk", reader.getProfileContent(ProfileReader.GAF_FIELDS.HYK, line));
                        ppBean.setProperty("hw", (Object)hw);
                        ppBean.setProperty("rw", (Object)rw);
                        ppBean.setProperty("fis_g_date", (Object)new Timestamp(System.currentTimeMillis()));
                        ppBean.setProperty("fis_g_user", (Object)SessionManager.getSession().getUser().getName());
                        ppBean.setProperty("qp_nr", newGafBean.getProperty("qp_nr"));
                        ppBean.setProperty("p_nr", (Object)this.getNextProfileNumber());
                        Object obj = reader.getProfileContent(ProfileReader.GAF_FIELDS.RK, line);
                        if (obj instanceof CustomGafCatalogueReader.RkObject) {
                            CustomGafCatalogueReader.RkObject rkObj = (CustomGafCatalogueReader.RkObject)obj;
                            ppBean.setProperty("rk", null);
                            ppBean.setProperty("rk_name", (Object)rkObj.getName());
                            ppBean.setProperty("rk_k", (Object)rkObj.getK());
                            ppBean.setProperty("rk_kst", (Object)rkObj.getKst());
                        } else {
                            ppBean.setProperty("rk", obj);
                        }
                        obj = reader.getProfileContent(ProfileReader.GAF_FIELDS.BK, line);
                        if (obj instanceof CustomGafCatalogueReader.BkObject) {
                            CustomGafCatalogueReader.BkObject bkObj = (CustomGafCatalogueReader.BkObject)obj;
                            ppBean.setProperty("bk", null);
                            ppBean.setProperty("bk_name", (Object)bkObj.getName());
                            ppBean.setProperty("bk_ax", (Object)bkObj.getAx());
                            ppBean.setProperty("bk_ay", (Object)bkObj.getAy());
                            ppBean.setProperty("bk_dp", (Object)bkObj.getDp());
                        } else {
                            ppBean.setProperty("bk", obj);
                        }
                        ppBean.persist();
                    }
                    CidsLayerFeature newFeature = (CidsLayerFeature)feature.saveChanges();
                    newBeans.add(newFeature);
                }
            }
            this.addFeatures(newBeans);
            return newBeans;
        }

        protected void done() {
            try {
                List newFeatures = (List)this.get();
                if (newFeatures != null && !newFeatures.isEmpty()) {
                    List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("qp");
                    SelectionManager.getInstance().removeSelectedFeatures(features);
                    SelectionManager.getInstance().addSelectedFeatures(newFeatures);
                    GafProf.this.newFeatures.addAll(newFeatures);
                    GafProf.reloadGafProfileServices();
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
            finally {
                if (GafProf.this.editor.getCidsLayerFeature() == null) {
                    GafProf.this.editor.showEditor(false, false);
                } else {
                    GafProf.this.editor.showEditor(true, false);
                }
            }
        }

        private void addFeatures(List<? extends FeatureServiceFeature> features) {
            AttributeTable tablePf;
            List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("qp");
            if (services != null && !services.isEmpty() && (tablePf = AppBroker.getInstance().getWatergisApp().getAttributeTableByFeatureService(services.get(0))) != null) {
                for (FeatureServiceFeature featureServiceFeature : features) {
                    tablePf.addFeature(featureServiceFeature);
                }
            }
        }

        private CidsBean getCatalogueElement(String className, String attributeName, String value) {
            MetaClass mc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)className);
            String query = "select " + mc.getID() + ", " + mc.getPrimaryKey() + " from " + mc.getTableName();
            query = query + " WHERE " + attributeName + " = '" + value + "'";
            try {
                MetaObject[] mo = SessionManager.getConnection().getMetaObjectByQuery(SessionManager.getSession().getUser(), query);
                if (mo != null && mo.length > 0) {
                    return mo[0].getBean();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private Integer getNextProfileNumber() {
            try {
                User user = SessionManager.getSession().getUser();
                ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new PhotoGetPhotoNumber());
                if (attributes != null && !attributes.isEmpty()) {
                    return ((Long)((ArrayList)attributes.get(0)).get(0)).intValue();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Errro while retrieving next profile number.", (Throwable)ex);
            }
            return null;
        }

        private Geometry getIntersectionPoint(Geometry geom) {
            try {
                User user = SessionManager.getSession().getUser();
                ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new GafPosition(geom, 1));
                if (attributes != null && !attributes.isEmpty()) {
                    GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
                    WKBReader wkbReader = new WKBReader(geomFactory);
                    return wkbReader.read((byte[])((ArrayList)attributes.get(0)).get(0));
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Errro while retrieving gaf profile position.", (Throwable)ex);
            }
            return null;
        }
    }
}

