/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.panels;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKBReader;
import de.cismet.cids.custom.watergis.server.search.PhotoGetBaStat;
import de.cismet.cids.custom.watergis.server.search.PhotoGetLaStat;
import de.cismet.cids.custom.watergis.server.search.PhotoGetPhotoNumber;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsFeatureFactory;
import de.cismet.cismap.cidslayer.CidsLayer;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.BoundingBox;
import de.cismet.cismap.commons.CrsTransformer;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.XBoundingBox;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureServiceFeature;
import de.cismet.cismap.commons.featureservice.AbstractFeatureService;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.attributetable.AttributeTable;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableFactory;
import de.cismet.cismap.commons.gui.attributetable.AttributeTableRuleSet;
import de.cismet.cismap.commons.gui.piccolo.PFeature;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.util.SelectionChangedEvent;
import de.cismet.cismap.commons.util.SelectionChangedListener;
import de.cismet.cismap.commons.util.SelectionManager;
import de.cismet.commons.security.WebDavClient;
import de.cismet.commons.security.WebDavHelper;
import de.cismet.netutil.ProxyHandler;
import de.cismet.tools.CismetThreadPool;
import de.cismet.tools.PasswordEncrypter;
import de.cismet.tools.gui.StaticSwingTools;
import de.cismet.tools.gui.WaitingDialogThread;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.dialog.PhotoOptionsDialog;
import de.cismet.watergis.gui.panels.PhotoEditor;
import de.cismet.watergis.utils.CidsBeanUtils;
import de.cismet.watergis.utils.ContributorWrapper;
import de.cismet.watergis.utils.ConversionUtils;
import de.cismet.watergis.utils.CustomJrViewer;
import de.cismet.watergis.utils.ExifReader;
import de.cismet.watergis.utils.FeatureServiceHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutionException;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingWorker;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JRSaveContributor;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class Photo
extends JPanel {
    private static int idCounter = -1;
    public static final String WEB_DAV_USER;
    public static final String WEB_DAV_PASSWORD;
    public static final String WEB_DAV_DIRECTORY;
    private static final String FILE_PROTOCOL_PREFIX = "file://";
    private static final Logger LOG;
    private static final WebDavClient webDavClient;
    public static CidsLayerFeature selectedFeature;
    private static final SimpleDateFormat timeFormatter;
    private List<CidsLayerFeature> newFeatures = new ArrayList<CidsLayerFeature>();
    private String oldMode;
    private boolean askForSave = true;
    private JButton butBack;
    private JButton butDelete;
    private JButton butNextPhoto;
    private JButton butPrevPhoto;
    private JButton butPrint;
    private JButton butPrintPreview;
    private JButton butRemoveSelection;
    private JButton butSave;
    private JButton butZoomToPhoto;
    private PhotoEditor editor;
    private JScrollPane jScrollPane1;
    private JToolBar jToolBar1;
    private JToggleButton tbAngle;
    private JToggleButton tbLocate;
    private JToggleButton tbProcessing;

    public Photo() {
        this.initComponents();
        this.tbProcessing.setVisible(false);
        SelectionManager.getInstance().addSelectionChangedListener(new SelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("foto");
                if (Photo.this.tbLocate.isSelected() || !Photo.this.isDisplayable()) {
                    return;
                }
                if (features != null && !features.isEmpty()) {
                    Collections.sort(features, PhotoOptionsDialog.getInstance().getSorter());
                    if (selectedFeature == null || !features.get(0).equals(selectedFeature)) {
                        Photo.this.setEditorFeature((CidsLayerFeature)features.get(0));
                        Photo.this.butPrevPhoto.setEnabled(false);
                        Photo.this.butNextPhoto.setEnabled(features.size() > 1);
                    }
                } else {
                    Photo.this.setEditorFeature(null);
                }
            }
        });
        DropTargetAdapter dropListener = new DropTargetAdapter(){

            @Override
            public void dragEnter(DropTargetDragEvent dtde) {
            }

            @Override
            public void dragExit(DropTargetEvent dte) {
            }

            @Override
            public void drop(DropTargetDropEvent e) {
                try {
                    Transferable tr = e.getTransferable();
                    DataFlavor[] flavors = tr.getTransferDataFlavors();
                    boolean isAccepted = false;
                    for (int i = 0; i < flavors.length; ++i) {
                        String tmp;
                        if (flavors[i].isFlavorJavaFileListType()) {
                            e.acceptDrop(e.getDropAction());
                            List files = (List)tr.getTransferData(flavors[i]);
                            if (files != null && files.size() > 0) {
                                Photo.this.editor.showEditor(true, true);
                                Photo.addPhotoServicesToTree();
                                CismetThreadPool.execute((Runnable)new ImageUploadWorker(files));
                            }
                            e.dropComplete(true);
                            return;
                        }
                        if (!flavors[i].isRepresentationClassInputStream()) continue;
                        if (!isAccepted) {
                            e.acceptDrop(e.getDropAction());
                            isAccepted = true;
                        }
                        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)tr.getTransferData(flavors[i])));
                        ArrayList<File> fileList = new ArrayList<File>();
                        while ((tmp = br.readLine()) != null) {
                            if (!tmp.trim().startsWith(Photo.FILE_PROTOCOL_PREFIX)) continue;
                            File f = new File(tmp.trim().substring(Photo.FILE_PROTOCOL_PREFIX.length()));
                            if (f.exists()) {
                                fileList.add(f);
                                continue;
                            }
                            f = new File(URLDecoder.decode(tmp.trim().substring(Photo.FILE_PROTOCOL_PREFIX.length()), "UTF-8"));
                            if (f.exists()) {
                                fileList.add(f);
                                continue;
                            }
                            LOG.warn((Object)("File " + f.toString() + " does not exist."));
                        }
                        br.close();
                        if (fileList.size() <= 0) continue;
                        Photo.this.editor.showEditor(true, true);
                        Photo.addPhotoServicesToTree();
                        CismetThreadPool.execute((Runnable)new ImageUploadWorker(fileList));
                        e.dropComplete(true);
                        return;
                    }
                }
                catch (Exception ex) {
                    LOG.warn((Object)ex, (Throwable)ex);
                }
                e.rejectDrop();
            }
        };
        new DropTarget(this.editor, dropListener);
    }

    static synchronized int getNewId() {
        return --idCounter;
    }

    private static String objectToString(Object string) {
        if (string == null) {
            return "";
        }
        return string.toString();
    }

    private void initComponents() {
        this.jToolBar1 = new JToolBar();
        this.butPrintPreview = new JButton();
        this.butPrint = new JButton();
        this.butPrevPhoto = new JButton();
        this.butNextPhoto = new JButton();
        this.tbLocate = new JToggleButton();
        this.tbAngle = new JToggleButton();
        this.tbProcessing = new JToggleButton();
        this.butZoomToPhoto = new JButton();
        this.butBack = new JButton();
        this.butDelete = new JButton();
        this.butSave = new JButton();
        this.butRemoveSelection = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.editor = new PhotoEditor(webDavClient, WEB_DAV_DIRECTORY);
        this.setLayout(new GridBagLayout());
        this.jToolBar1.setRollover(true);
        this.butPrintPreview.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-searchdocument.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butPrintPreview, (String)NbBundle.getMessage(Photo.class, (String)"Photo.butPrintPreview.text"));
        this.butPrintPreview.setToolTipText(NbBundle.getMessage(Photo.class, (String)"Photo.butPrintPreview.toolTipText"));
        this.butPrintPreview.setFocusable(false);
        this.butPrintPreview.setHorizontalTextPosition(0);
        this.butPrintPreview.setVerticalTextPosition(3);
        this.butPrintPreview.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Photo.this.butPrintPreviewActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butPrintPreview);
        this.butPrint.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-print.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butPrint, (String)NbBundle.getMessage(Photo.class, (String)"Photo.butPrint.text"));
        this.butPrint.setToolTipText(NbBundle.getMessage(Photo.class, (String)"Photo.butPrint.toolTipText"));
        this.butPrint.setFocusable(false);
        this.butPrint.setHorizontalTextPosition(0);
        this.butPrint.setVerticalTextPosition(3);
        this.butPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Photo.this.butPrintActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butPrint);
        this.butPrevPhoto.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-arrow-left.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butPrevPhoto, (String)NbBundle.getMessage(Photo.class, (String)"Photo.butPrevPhoto.text"));
        this.butPrevPhoto.setToolTipText(NbBundle.getMessage(Photo.class, (String)"Photo.butPrevPhoto.toolTipText"));
        this.butPrevPhoto.setFocusable(false);
        this.butPrevPhoto.setHorizontalTextPosition(0);
        this.butPrevPhoto.setVerticalTextPosition(3);
        this.butPrevPhoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Photo.this.butPrevPhotoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butPrevPhoto);
        this.butNextPhoto.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-arrow-right.png")));
        this.butNextPhoto.setToolTipText(NbBundle.getMessage(Photo.class, (String)"Photo.butNextPhoto.toolTipText"));
        this.butNextPhoto.setFocusable(false);
        this.butNextPhoto.setHorizontalTextPosition(0);
        this.butNextPhoto.setVerticalTextPosition(3);
        this.butNextPhoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Photo.this.butNextPhotoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butNextPhoto);
        this.tbLocate.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-flagtriangle.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.tbLocate, (String)NbBundle.getMessage(Photo.class, (String)"Photo.tbLocate.text"));
        this.tbLocate.setToolTipText(NbBundle.getMessage(Photo.class, (String)"Photo.tbLocate.toolTipText"));
        this.tbLocate.setFocusable(false);
        this.tbLocate.setHorizontalTextPosition(0);
        this.tbLocate.setVerticalTextPosition(3);
        this.tbLocate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Photo.this.tbLocateActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.tbLocate);
        this.tbAngle.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-angle.png")));
        this.tbAngle.setToolTipText(NbBundle.getMessage(Photo.class, (String)"Photo.tbAngle.toolTipText"));
        this.tbAngle.setFocusable(false);
        this.tbAngle.setHorizontalTextPosition(0);
        this.tbAngle.setVerticalTextPosition(3);
        this.tbAngle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Photo.this.tbAngleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.tbAngle);
        this.tbProcessing.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/cismap/commons/gui/attributetable/res/icon-edit.png")));
        this.tbProcessing.setToolTipText(NbBundle.getMessage(Photo.class, (String)"Photo.tbProcessing.toolTipText"));
        this.tbProcessing.setFocusable(false);
        this.tbProcessing.setHorizontalTextPosition(0);
        this.tbProcessing.setVerticalTextPosition(3);
        this.tbProcessing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Photo.this.tbProcessingActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.tbProcessing);
        this.butZoomToPhoto.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-selectionadd.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butZoomToPhoto, (String)NbBundle.getMessage(Photo.class, (String)"Photo.butZoomToPhoto.text"));
        this.butZoomToPhoto.setToolTipText(NbBundle.getMessage(Photo.class, (String)"Photo.butZoomToPhoto.toolTipText"));
        this.butZoomToPhoto.setFocusable(false);
        this.butZoomToPhoto.setHorizontalTextPosition(0);
        this.butZoomToPhoto.setVerticalTextPosition(3);
        this.butZoomToPhoto.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Photo.this.butZoomToPhotoActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butZoomToPhoto);
        this.butBack.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-fullscreen.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butBack, (String)NbBundle.getMessage(Photo.class, (String)"Photo.butBack.text"));
        this.butBack.setToolTipText(NbBundle.getMessage(Photo.class, (String)"Photo.butBack.toolTipText"));
        this.butBack.setFocusable(false);
        this.butBack.setHorizontalTextPosition(0);
        this.butBack.setVerticalTextPosition(3);
        this.butBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Photo.this.butBackActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butBack);
        this.butDelete.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-circledelete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butDelete, (String)NbBundle.getMessage(Photo.class, (String)"Photo.butDelete.text"));
        this.butDelete.setToolTipText(NbBundle.getMessage(Photo.class, (String)"Photo.butDelete.toolTipText"));
        this.butDelete.setFocusable(false);
        this.butDelete.setHorizontalTextPosition(0);
        this.butDelete.setVerticalTextPosition(3);
        this.butDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Photo.this.butDeleteActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butDelete);
        this.butSave.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-editalt.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butSave, (String)NbBundle.getMessage(Photo.class, (String)"Photo.butSave.text"));
        this.butSave.setToolTipText(NbBundle.getMessage(Photo.class, (String)"Photo.butSave.toolTipText"));
        this.butSave.setFocusable(false);
        this.butSave.setHorizontalTextPosition(0);
        this.butSave.setVerticalTextPosition(3);
        this.butSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Photo.this.butSaveActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butSave);
        this.butRemoveSelection.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/watergis/res/icons16/icon-selectionremove.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.butRemoveSelection, (String)NbBundle.getMessage(Photo.class, (String)"Photo.butRemoveSelection.text"));
        this.butRemoveSelection.setToolTipText(NbBundle.getMessage(Photo.class, (String)"Photo.butRemoveSelection.toolTipText"));
        this.butRemoveSelection.setFocusable(false);
        this.butRemoveSelection.setHorizontalTextPosition(0);
        this.butRemoveSelection.setVerticalTextPosition(3);
        this.butRemoveSelection.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Photo.this.butRemoveSelectionActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.butRemoveSelection);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jToolBar1, gridBagConstraints);
        this.editor.setMinimumSize(new Dimension(800, 500));
        this.jScrollPane1.setViewportView(this.editor);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
    }

    private void butPrintPreviewActionPerformed(ActionEvent evt) {
        WaitingDialogThread<JasperPrint> wdt = new WaitingDialogThread<JasperPrint>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(Photo.class, (String)"Photo.butPrintPreviewActionPerformed.WaitingDialogThread"), null, 500){

            protected JasperPrint doInBackground() throws Exception {
                return Photo.fillreport(Photo.this.editor.getCidsLayerFeature());
            }

            protected void done() {
                try {
                    JasperPrint jasperPrint = (JasperPrint)this.get();
                    CustomJrViewer aViewer = new CustomJrViewer(jasperPrint);
                    ArrayList<ContributorWrapper> contributors = new ArrayList<ContributorWrapper>();
                    for (JRSaveContributor contributor : aViewer.getSaveContributors()) {
                        if (contributor.getDescription().toLowerCase().contains("pdf")) {
                            contributors.add(new ContributorWrapper(contributor, "PDF"));
                            continue;
                        }
                        if (!contributor.getDescription().toLowerCase().contains("docx")) continue;
                        contributors.add(new ContributorWrapper(contributor, "DOCX"));
                    }
                    Collections.sort(contributors, new Comparator<JRSaveContributor>(){

                        @Override
                        public int compare(JRSaveContributor o1, JRSaveContributor o2) {
                            if (o1 != null && o2 != null) {
                                return o1.getDescription().compareTo(o2.getDescription());
                            }
                            if (o1 == null && o2 == null) {
                                return 0;
                            }
                            if (o1 == null) {
                                return 1;
                            }
                            return -1;
                        }
                    });
                    aViewer.setSaveContributors(contributors.toArray(new JRSaveContributor[contributors.size()]));
                    JFrame aFrame = new JFrame(NbBundle.getMessage(Photo.class, (String)"Photo.butPrintPreviewActionPerformed.aFrame.title"));
                    aFrame.getContentPane().add((Component)((Object)aViewer));
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    aFrame.setSize(screenSize.width / 2, screenSize.height / 2);
                    Insets insets = aFrame.getInsets();
                    aFrame.setSize(aFrame.getWidth() + insets.left + insets.right, aFrame.getHeight() + insets.top + insets.bottom + 20);
                    aFrame.setLocationRelativeTo(Photo.this);
                    aFrame.setVisible(true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while creating report", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private void butPrintActionPerformed(ActionEvent evt) {
        WaitingDialogThread<JasperPrint> wdt = new WaitingDialogThread<JasperPrint>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(Photo.class, (String)"Photo.butPrintActionPerformed.WaitingDialogThread"), null, 500){

            protected JasperPrint doInBackground() throws Exception {
                return Photo.fillreport(Photo.this.editor.getCidsLayerFeature());
            }

            protected void done() {
                try {
                    JasperPrint jasperPrint = (JasperPrint)this.get();
                    jasperPrint.setOrientation(OrientationEnum.LANDSCAPE);
                    JasperPrintManager.printReport((JasperPrint)jasperPrint, (boolean)true);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while creating report", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    public static InputStream loadFileFromWebDav(CidsLayerFeature feature, Component parent) throws Exception {
        String path = (String)feature.getBean().getProperty("dateipfad");
        String file = WebDavHelper.encodeURL((String)((String)feature.getProperty("foto")));
        return webDavClient.getInputStream(WEB_DAV_DIRECTORY + path + file);
    }

    public static void deletePhoto(CidsLayerFeature feature) throws Exception {
        String path = (String)feature.getProperty("dateipfad");
        String file = (String)feature.getProperty("foto");
        WebDavHelper.deleteFileFromWebDAV((String)file, (WebDavClient)webDavClient, (String)(WEB_DAV_DIRECTORY + path));
        AttributeTable table = AppBroker.getInstance().getWatergisApp().getAttributeTableByFeature((FeatureServiceFeature)feature);
        feature.removeStations();
        if (table != null) {
            table.removeFeature((FeatureServiceFeature)feature);
        } else {
            feature.delete();
        }
    }

    private void reloadPrPfTable() {
        AttributeTable tablePf;
        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("foto_pr_pf");
        if (services != null && !services.isEmpty() && (tablePf = AppBroker.getInstance().getWatergisApp().getAttributeTableByFeatureService(services.get(0))) != null) {
            tablePf.reload();
        }
    }

    private void addNewFeaturesToTable(List<CidsLayerFeature> features) {
        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("foto");
        if (services != null && !services.isEmpty()) {
            AttributeTable tablePf = AppBroker.getInstance().getWatergisApp().getAttributeTableByFeatureService(services.get(0));
            ArrayList<CidsLayerFeature> newFeatures = new ArrayList<CidsLayerFeature>();
            newFeatures.addAll(features);
            if (tablePf != null) {
                tablePf.addFeatures(newFeatures);
            }
        }
    }

    public static JasperPrint fillreport(final CidsLayerFeature feature) throws Exception {
        JRDataSource ds = new JRDataSource(){
            private boolean first = true;

            public boolean next() throws JRException {
                if (this.first) {
                    this.first = false;
                    return true;
                }
                return false;
            }

            public Object getFieldValue(JRField jrf) throws JRException {
                return feature.getBean().getProperty(jrf.getName());
            }
        };
        HashMap<String, Object> map = new HashMap<String, Object>();
        CidsBean basisStat = (CidsBean)feature.getBean().getProperty("ba_st");
        CidsBean freigabe = (CidsBean)feature.getBean().getProperty("freigabe");
        User user = SessionManager.getSession().getUser();
        Boolean hasPermissionforBemerkung = user == null || user.getUserGroup().getName().equalsIgnoreCase("administratoren") ? Boolean.valueOf(true) : Boolean.valueOf(feature.getProperty("upl_name") != null && feature.getProperty("upl_name").equals(user.getName()));
        map.put("punkt", feature.getGeometry());
        map.put("foto", feature.getProperty("foto"));
        map.put("upl_nutzer", feature.getProperty("upl_name"));
        map.put("upl_datum", Photo.dateTime2String(feature.getProperty("upl_datum"), (String)feature.getProperty("upl_zeit")));
        map.put("bild_id", String.valueOf(feature.getProperty("foto_nr")));
        map.put("bild_id_gu", feature.getProperty("foto_nr_gu") == null ? "" : String.valueOf(feature.getProperty("foto_nr_gu")));
        map.put("pos", ConversionUtils.numberToString(feature.getProperty("re")) + " " + ConversionUtils.numberToString(feature.getProperty("ho")));
        map.put("winkel", ConversionUtils.numberToString(feature.getProperty("winkel")));
        map.put("lawa", feature.getProperty("la_cd") == null ? "" : feature.getProperty("la_cd").toString());
        if (basisStat != null) {
            map.put("basis", feature.getProperty("ba_cd"));
            map.put("basis_stat", ConversionUtils.numberToString(basisStat.getProperty("wert")));
        } else {
            map.put("basis", "");
            map.put("basis_stat", "");
        }
        map.put("lawa_stat", ConversionUtils.numberToString(feature.getProperty("la_st")));
        map.put("re_li", Photo.objectToString(feature.getProperty("l_rl")));
        map.put("status", Photo.objectToString(feature.getProperty("l_st")));
        map.put("aufn_nutzer", feature.getProperty("aufn_name"));
        map.put("aufn_datum", Photo.dateTime2String(feature.getProperty("aufn_datum"), (String)feature.getProperty("aufn_zeit")));
        if (freigabe != null) {
            map.put("freigabe", freigabe.toString());
        } else {
            map.put("freigabe", "");
        }
        map.put("titel", feature.getProperty("titel"));
        map.put("beschreibung", feature.getProperty("beschreib"));
        map.put("bemerkung", feature.getProperty("bemerkung"));
        map.put("foto", feature.getProperty("foto"));
        map.put("isUploader", hasPermissionforBemerkung);
        JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)Photo.class.getResourceAsStream("/de/cismet/watergis/reports/foto.jasper"));
        return JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)ds);
    }

    private static String dateTime2String(Object date, String time) {
        if (date == null && time == null) {
            return "";
        }
        if (date == null) {
            return time;
        }
        if (time == null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
                return format.format(date);
            }
            catch (IllegalArgumentException e) {
                LOG.error((Object)"Not a date", (Throwable)e);
                return "";
            }
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
            return format.format(date) + " " + time;
        }
        catch (IllegalArgumentException e) {
            LOG.error((Object)"Not a date", (Throwable)e);
            return "";
        }
    }

    public static void reloadPhotoServices() {
        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("foto");
        for (AbstractFeatureService featureService : services) {
            featureService.retrieve(true);
        }
        List<AbstractFeatureService> servicesPrPf = FeatureServiceHelper.getCidsLayerServicesFromTree("foto_pr_pf");
        for (AbstractFeatureService featureService : servicesPrPf) {
            featureService.retrieve(true);
        }
    }

    public static void addPhotoServicesToTree() {
        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("foto");
        if (services == null || services.isEmpty()) {
            CidsLayer layer = new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.foto"));
            AppBroker.getInstance().getMappingComponent().getMappingModel().addLayer((RetrievalServiceLayer)layer);
            AttributeTableFactory.getInstance().switchProcessingMode((AbstractFeatureService)layer);
        } else if (!SelectionManager.getInstance().getEditableServices().contains(services.get(0))) {
            AttributeTableFactory.getInstance().switchProcessingMode(services.get(0));
        }
        Photo.addLayerToTree("foto_pr_pf");
    }

    public static void closeEditMode() {
        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("foto");
        if ((services != null || services.isEmpty()) && SelectionManager.getInstance().getEditableServices().contains(services.get(0))) {
            AttributeTableFactory.getInstance().switchProcessingMode(services.get(0));
        }
    }

    private static void addLayerToTree(String layerName) {
        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree(layerName);
        if (services == null || services.isEmpty()) {
            CidsLayer l = new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)("dlm25w." + layerName)));
            AppBroker.getInstance().getMappingComponent().getMappingModel().addLayer((RetrievalServiceLayer)l);
        }
    }

    private void butPrevPhotoActionPerformed(ActionEvent evt) {
        CidsLayerFeature feature = this.editor.getCidsLayerFeature();
        List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("foto");
        if (features != null && !features.isEmpty()) {
            Collections.sort(features, PhotoOptionsDialog.getInstance().getSorter());
            int index = features.indexOf(feature);
            if (--index >= 0) {
                this.setEditorFeature((CidsLayerFeature)features.get(index));
            }
            this.butNextPhoto.setEnabled(index != features.size() - 1);
            this.butPrevPhoto.setEnabled(index != 0);
        } else {
            this.butNextPhoto.setEnabled(false);
            this.butPrevPhoto.setEnabled(false);
        }
    }

    private void butNextPhotoActionPerformed(ActionEvent evt) {
        CidsLayerFeature feature = this.editor.getCidsLayerFeature();
        List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("foto");
        if (features != null && !features.isEmpty()) {
            Collections.sort(features, PhotoOptionsDialog.getInstance().getSorter());
            int index = features.indexOf(feature);
            if (++index < features.size()) {
                this.setEditorFeature((CidsLayerFeature)features.get(index));
            }
            this.butNextPhoto.setEnabled(index < features.size() - 1);
            this.butPrevPhoto.setEnabled(index != 0);
        } else {
            this.butNextPhoto.setEnabled(false);
            this.butPrevPhoto.setEnabled(false);
        }
    }

    private void tbProcessingActionPerformed(ActionEvent evt) {
    }

    private void butBackActionPerformed(ActionEvent evt) {
        AppBroker.getInstance().getMappingComponent().back(true);
    }

    private void butSaveActionPerformed(ActionEvent evt) {
        try {
            CidsLayerFeature feature = this.editor.getCidsLayerFeature();
            AttributeTableRuleSet ruleSet = feature.getLayerProperties().getAttributeTableRuleSet();
            if (ruleSet != null) {
                ruleSet.beforeSave((FeatureServiceFeature)feature);
            }
            feature.saveChangesWithoutReload();
            this.editor.setCidsLayerFeature(feature);
            Photo.reloadPhotoServices();
        }
        catch (Exception e) {
            LOG.error((Object)"Eror while saving feature", (Throwable)e);
        }
    }

    private void butRemoveSelectionActionPerformed(ActionEvent evt) {
        SelectionManager.getInstance().removeSelectedFeatures((Feature)this.editor.getCidsLayerFeature());
    }

    private void butZoomToPhotoActionPerformed(ActionEvent evt) {
        CidsLayerFeature feature = this.editor.getCidsLayerFeature();
        MappingComponent mappingComponent = CismapBroker.getInstance().getMappingComponent();
        if (mappingComponent != null) {
            XBoundingBox bbox = new XBoundingBox(feature.getGeometry());
            bbox.increase(10);
            BoundingBox scaledBBox = mappingComponent.getScaledBoundingBox(500.0, (BoundingBox)bbox);
            mappingComponent.gotoBoundingBoxWithHistory(scaledBBox);
        } else {
            LOG.error((Object)"MappingComponent is not set");
        }
    }

    private void butDeleteActionPerformed(final ActionEvent evt) {
        final CidsLayerFeature feature = this.editor.getCidsLayerFeature();
        int ans = JOptionPane.showConfirmDialog(this, NbBundle.getMessage(Photo.class, (String)"Photo.butDeleteActionPerformed().text"), NbBundle.getMessage(Photo.class, (String)"Photo.butDeleteActionPerformed().title"), 0);
        if (ans != 0) {
            return;
        }
        WaitingDialogThread<Void> wdt = new WaitingDialogThread<Void>(StaticSwingTools.getParentFrame((Component)this), true, NbBundle.getMessage(Photo.class, (String)"Photo.butDeleteActionPerformed.WaitingDialogThread"), null, 500){

            protected Void doInBackground() throws Exception {
                Photo.deletePhoto(feature);
                return null;
            }

            protected void done() {
                try {
                    this.get();
                    Photo.reloadPhotoServices();
                    Photo.this.askForSave = false;
                    Photo.this.butRemoveSelectionActionPerformed(evt);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while deleting objects", (Throwable)e);
                }
            }
        };
        wdt.start();
    }

    private void tbLocateActionPerformed(ActionEvent evt) {
        if (this.tbLocate.isSelected()) {
            if (this.tbAngle.isSelected()) {
                this.tbAngle.setSelected(false);
                this.tbAngleActionPerformed(null);
            }
            this.makeFeatureEditable((FeatureServiceFeature)this.editor.getCidsLayerFeature());
        } else {
            CidsLayerFeature layerFeature = this.editor.getCidsLayerFeature();
            try {
                AttributeTableRuleSet ruleSet;
                Station stat;
                layerFeature.getBean().setProperty("geom.geo_field", (Object)layerFeature.getGeometry());
                if (PhotoOptionsDialog.getInstance().isAutomatic() && (stat = Photo.getNextFgBaStat(layerFeature.getGeometry(), PhotoOptionsDialog.getInstance().getDistance())) != null) {
                    MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
                    CidsBean stationBean = CidsBeanUtils.createNewCidsBeanFromTableName("dlm25w.fg_ba_punkt");
                    CidsBean geom = CidsBeanUtils.createNewCidsBeanFromTableName("geom");
                    MetaObject route = SessionManager.getProxy().getMetaObject(stat.getId(), routeMc.getID(), "DLM25W");
                    geom.setProperty("geo_field", (Object)stat.getPoint());
                    stationBean.setProperty("wert", (Object)stat.getStat());
                    stationBean.setProperty("route", (Object)route.getBean());
                    stationBean.setProperty("real_point", (Object)geom);
                    if (layerFeature.getStationEditor("ba_st").getCidsBean() != null) {
                        layerFeature.getStationEditor("ba_st").getCidsBean().setProperty("route", (Object)route.getBean());
                        layerFeature.getStationEditor("ba_st").getCidsBean().setProperty("wert", (Object)stat.getStat());
                    } else {
                        layerFeature.getStationEditor("ba_st").setCidsBean(stationBean);
                        this.editor.setStatBean(stationBean);
                    }
                    layerFeature.getBean().setProperty("ba_st", (Object)stationBean);
                    Station laStat = Photo.getNextFgLaStat(stat.getPoint());
                    if (laStat != null) {
                        layerFeature.setProperty("la_cd", (Object)laStat.getLaCd());
                        layerFeature.setProperty("la_st", (Object)laStat.getStat());
                    }
                }
                if ((ruleSet = layerFeature.getLayerProperties().getAttributeTableRuleSet()) != null) {
                    ruleSet.beforeSave((FeatureServiceFeature)layerFeature);
                }
                layerFeature.saveChangesWithoutReload();
                this.editor.setCidsLayerFeature(layerFeature);
                layerFeature.setEditable(false);
                EventQueue.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        Photo.reloadPhotoServices();
                    }
                });
            }
            catch (Exception e) {
                LOG.error((Object)"Error while setting the new geometry", (Throwable)e);
            }
        }
    }

    private void tbAngleActionPerformed(ActionEvent evt) {
        if (this.tbAngle.isSelected()) {
            if (this.tbLocate.isSelected()) {
                this.tbLocate.setSelected(false);
                this.tbLocateActionPerformed(null);
            }
            this.oldMode = AppBroker.getInstance().getMappingComponent().getInteractionMode();
            AppBroker.getInstance().getMappingComponent().setInteractionMode("FOTO_ANGLE_LISTENER");
        } else if (this.oldMode != null) {
            AppBroker.getInstance().getMappingComponent().setInteractionMode(this.oldMode);
        }
    }

    private void setEditorFeature(CidsLayerFeature feature) {
        this.askForSave = true;
        if (this.tbLocate.isSelected()) {
            this.tbLocate.setSelected(false);
            this.tbLocateActionPerformed(null);
        }
        if (this.tbAngle.isSelected()) {
            this.tbAngle.setSelected(false);
            this.tbAngleActionPerformed(null);
        }
        if (feature != null && !feature.isEditable()) {
            this.makeFeatureEditable((FeatureServiceFeature)feature);
        }
        this.editor.setCidsLayerFeature(feature);
        this.enableToolbar(feature != null);
        CidsLayerFeature formerSelectedFeature = selectedFeature;
        selectedFeature = feature;
        Photo.refreshFeatureDesignOnMap(formerSelectedFeature);
        Photo.refreshFeatureDesignOnMap(selectedFeature);
    }

    private void enableToolbar(boolean enabled) {
        boolean writable = enabled && this.editor.hasWriteAccess();
        this.butBack.setEnabled(enabled);
        this.butNextPhoto.setEnabled(enabled);
        this.butPrevPhoto.setEnabled(enabled);
        this.butPrint.setEnabled(enabled);
        this.butPrintPreview.setEnabled(enabled);
        this.butRemoveSelection.setEnabled(enabled);
        this.butZoomToPhoto.setEnabled(enabled);
        this.tbAngle.setEnabled(writable);
        this.tbLocate.setEnabled(writable);
        this.tbProcessing.setEnabled(writable);
        this.butSave.setEnabled(writable);
        this.butDelete.setEnabled(writable);
    }

    private void makeFeatureEditable(FeatureServiceFeature feature) {
        if (feature != null && !feature.isEditable()) {
            try {
                feature.setEditable(true);
            }
            catch (Exception ex) {
                LOG.error((Object)"Error while locking feature.", (Throwable)ex);
            }
        }
    }

    private static Station getNextFgBaStat(Geometry geom, double maxDist) {
        try {
            User user = SessionManager.getSession().getUser();
            ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new PhotoGetBaStat(geom, maxDist));
            if (attributes != null && !attributes.isEmpty()) {
                GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
                WKBReader wkbReader = new WKBReader(geomFactory);
                Station stat = new Station();
                stat.setId((Integer)((ArrayList)attributes.get(0)).get(0));
                stat.setBaCd((String)((ArrayList)attributes.get(0)).get(1));
                stat.setStat((Double)((ArrayList)attributes.get(0)).get(2));
                stat.setPoint(wkbReader.read((byte[])((ArrayList)attributes.get(0)).get(3)));
                return stat;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Errro while retrieving next fg ba station.", (Throwable)ex);
        }
        return null;
    }

    private static Station getNextFgLaStat(Geometry geom) {
        try {
            User user = SessionManager.getSession().getUser();
            ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new PhotoGetLaStat(geom));
            if (attributes != null && !attributes.isEmpty()) {
                GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
                WKBReader wkbReader = new WKBReader(geomFactory);
                Station stat = new Station();
                stat.setLaCd((BigDecimal)((ArrayList)attributes.get(0)).get(1));
                stat.setStat((Double)((ArrayList)attributes.get(0)).get(2));
                return stat;
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Errro while retrieving next fg ba station.", (Throwable)ex);
        }
        return null;
    }

    public void dispose() {
        this.setEditorFeature(null);
        this.editor.dispose();
        List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("foto");
        if (services != null && !services.isEmpty() && SelectionManager.getInstance().getEditableServices().contains(services.get(0))) {
            AttributeTableFactory.getInstance().switchProcessingMode(services.get(0));
        }
    }

    public static void refreshFeatureDesignOnMap(CidsLayerFeature feature) {
        if (feature != null) {
            AbstractFeatureService service = feature.getLayerProperties().getFeatureService();
            PFeature mapFeature = (PFeature)CismapBroker.getInstance().getMappingComponent().getPFeatureHM().get(feature);
            if (mapFeature != null) {
                mapFeature.visualize();
                mapFeature.refreshDesign();
            }
            if (service != null) {
                List pfeatureList = service.getPNode().getChildrenReference();
                for (PFeature pf : pfeatureList) {
                    Feature f = pf.getFeature();
                    if (!(f instanceof FeatureServiceFeature) || ((FeatureServiceFeature)f).getId() != feature.getId()) continue;
                    ((FeatureServiceFeature)f).setGeometry(feature.getGeometry());
                    pf.visualize();
                    pf.refreshDesign();
                }
            }
        }
    }

    public static void tryStationCreation(CidsLayerFeature feature, CidsBean bean) throws Exception {
        Station stat = Photo.getNextFgBaStat(feature.getGeometry(), PhotoOptionsDialog.getInstance().getDistance());
        if (stat != null) {
            MetaClass routeMc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba");
            CidsBean stationBean = CidsBeanUtils.createNewCidsBeanFromTableName("dlm25w.fg_ba_punkt");
            CidsBean geom = CidsBeanUtils.createNewCidsBeanFromTableName("geom");
            MetaObject route = SessionManager.getProxy().getMetaObject(stat.getId(), routeMc.getID(), "DLM25W");
            CidsBean newFotoBean = bean;
            if (newFotoBean == null) {
                newFotoBean = feature.getBean();
            }
            geom.setProperty("geo_field", (Object)stat.getPoint());
            stationBean.setProperty("wert", (Object)stat.getStat());
            stationBean.setProperty("route", (Object)route.getBean());
            stationBean.setProperty("real_point", (Object)geom);
            newFotoBean.setProperty("ba_st", (Object)stationBean);
            feature.setProperty("ba_cd", (Object)stat.getBaCd());
            feature.setProperty("ba_st", (Object)stat.getStat());
            feature.removeStations();
            feature.initStations();
            Station laStat = Photo.getNextFgLaStat(stat.getPoint());
            if (laStat != null) {
                feature.setProperty("la_cd", (Object)laStat.getLaCd());
                feature.setProperty("la_st", (Object)laStat.getStat());
            }
        }
    }

    static {
        LOG = Logger.getLogger(Photo.class);
        selectedFeature = null;
        timeFormatter = new SimpleDateFormat("HH:mm:ss");
        ResourceBundle bundle = ResourceBundle.getBundle("WebDav");
        String pass = bundle.getString("password");
        if (pass != null) {
            pass = new String(PasswordEncrypter.decrypt((char[])pass.toCharArray(), (boolean)true));
        }
        WEB_DAV_PASSWORD = pass;
        WEB_DAV_USER = bundle.getString("username");
        WEB_DAV_DIRECTORY = bundle.getString("url");
        webDavClient = new WebDavClient(ProxyHandler.getInstance().getProxy(), WEB_DAV_USER, WEB_DAV_PASSWORD, true);
    }

    private static class Station {
        private int id;
        private String baCd;
        private BigDecimal laCd;
        private double stat;
        private Geometry point;

        private Station() {
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getBaCd() {
            return this.baCd;
        }

        public void setBaCd(String baCd) {
            this.baCd = baCd;
        }

        public double getStat() {
            return this.stat;
        }

        public void setStat(double stat) {
            this.stat = stat;
        }

        public Geometry getPoint() {
            return this.point;
        }

        public void setPoint(Geometry point) {
            this.point = point;
        }

        public BigDecimal getLaCd() {
            return this.laCd;
        }

        public void setLaCd(BigDecimal laCd) {
            this.laCd = laCd;
        }
    }

    final class ImageUploadWorker
    extends SwingWorker<List<CidsLayerFeature>, Void> {
        private final Collection<File> fotos;

        public ImageUploadWorker(Collection<File> fotos) {
            this.fotos = fotos;
        }

        @Override
        protected List<CidsLayerFeature> doInBackground() throws Exception {
            ArrayList<CidsLayerFeature> newBeans = new ArrayList<CidsLayerFeature>();
            List<AbstractFeatureService> services = FeatureServiceHelper.getCidsLayerServicesFromTree("foto");
            CidsLayer layer = null;
            layer = services != null && !services.isEmpty() ? (CidsLayer)services.get(0) : new CidsLayer(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.foto"));
            for (File imageFile : this.fotos) {
                AttributeTableRuleSet ruleSet;
                CidsBean freigabeBean;
                SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd-HHmmss");
                String fileName = format.format(new Date());
                String filePrefix = "foto/";
                if (AppBroker.getInstance().getOwnWwGr() != null) {
                    Integer wwGr = (Integer)AppBroker.getInstance().getOwnWwGr().getProperty("ww_gr");
                    filePrefix = filePrefix + wwGr + "/";
                    fileName = fileName + "-" + wwGr;
                }
                String userName = SessionManager.getSession().getUser().getName();
                filePrefix = filePrefix + userName + "/";
                fileName = fileName + "-" + userName + "-" + imageFile.getName();
                WebDavHelper.createFolder((String)(WEB_DAV_DIRECTORY + filePrefix), (WebDavClient)webDavClient);
                WebDavHelper.uploadFileToWebDAV((String)fileName, (File)imageFile, (String)(WEB_DAV_DIRECTORY + filePrefix), (WebDavClient)webDavClient, (Component)Photo.this);
                HashMap<String, Integer> props = new HashMap<String, Integer>();
                CidsBean newFotoBean = CidsBeanUtils.createNewCidsBeanFromTableName("dlm25w.foto");
                int id = Photo.getNewId();
                for (String propName : newFotoBean.getPropertyNames()) {
                    props.put(propName, null);
                }
                props.put("id", id);
                layer.initAndWait();
                CidsLayerFeature feature = new CidsLayerFeature(props, layer.getMetaClass(), ((CidsFeatureFactory)layer.getFeatureFactory()).getLayerInfo(), layer.getLayerProperties(), null);
                Date currentTime = new Date();
                newFotoBean.setProperty("id", (Object)id);
                newFotoBean.setProperty("foto", (Object)fileName);
                newFotoBean.setProperty("dateipfad", (Object)filePrefix);
                newFotoBean.setProperty("upl_datum", (Object)new java.sql.Date(currentTime.getTime()));
                newFotoBean.setProperty("upl_zeit", (Object)timeFormatter.format(currentTime));
                newFotoBean.setProperty("upl_name", (Object)userName);
                newFotoBean.setProperty("dateipfad", (Object)filePrefix);
                newFotoBean.setProperty("foto_nr", (Object)this.getNextPhotoNumber());
                newFotoBean.setProperty("ww_gr", (Object)AppBroker.getInstance().getOwnWwGr());
                ExifReader reader = new ExifReader(imageFile);
                try {
                    Point point = reader.getGpsCoords();
                    if (point != null) {
                        point = (Point)CrsTransformer.transformToDefaultCrs((Geometry)point);
                        point.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                        CidsBean geom = CidsBeanUtils.createNewCidsBeanFromTableName("geom");
                        geom.setProperty("geo_field", (Object)point);
                        newFotoBean.setProperty("geom", (Object)geom);
                        feature.setGeometry((Geometry)point);
                        CidsBean statusBean = this.getCatalogueElement("dlm25w.k_l_st", "l_st", "V-GPS3");
                        if (statusBean != null) {
                            newFotoBean.setProperty("l_st", (Object)statusBean);
                        }
                    }
                    newFotoBean.setProperty("winkel", (Object)reader.getGpsDirection());
                    if (reader.getTime() != null) {
                        newFotoBean.setProperty("aufn_datum", (Object)new java.sql.Date(reader.getTime().getTime()));
                        newFotoBean.setProperty("aufn_zeit", (Object)new Timestamp(reader.getTime().getTime()));
                    }
                }
                catch (Throwable ex) {
                    LOG.error((Object)"Error while reading exif data.", ex);
                }
                if (feature.getGeometry() == null) {
                    MappingComponent mc = CismapBroker.getInstance().getMappingComponent();
                    BoundingBox bbox = mc.getCurrentBoundingBoxFromCamera();
                    Geometry geom = bbox.getGeometry(CrsTransformer.extractSridFromCrs((String)CismapBroker.getInstance().getSrs().getCode()));
                    Point center = geom.getCentroid();
                    CidsBean cidsGeom = CidsBeanUtils.createNewCidsBeanFromTableName("geom");
                    cidsGeom.setProperty("geo_field", (Object)center);
                    newFotoBean.setProperty("geom", (Object)cidsGeom);
                    feature.setGeometry((Geometry)center);
                    CidsBean statusBean = this.getCatalogueElement("dlm25w.k_l_st", "l_st", "DOP");
                    if (statusBean != null) {
                        newFotoBean.setProperty("l_st", (Object)statusBean);
                    }
                }
                if ((freigabeBean = this.getCatalogueElement("dlm25w.k_freigabe", "name", "alle Nutzer")) != null) {
                    newFotoBean.setProperty("freigabe", (Object)freigabeBean);
                }
                feature.setMetaObject(newFotoBean.getMetaObject());
                if (PhotoOptionsDialog.getInstance().isAutomatic()) {
                    Photo.tryStationCreation(feature, null);
                }
                if ((ruleSet = feature.getLayerProperties().getAttributeTableRuleSet()) != null) {
                    ruleSet.beforeSave((FeatureServiceFeature)feature);
                }
                CidsLayerFeature newFeature = (CidsLayerFeature)feature.saveChanges();
                feature.removeStations();
                newBeans.add(newFeature);
            }
            return newBeans;
        }

        @Override
        protected void done() {
            try {
                List newFeatures = (List)this.get();
                if (!newFeatures.isEmpty()) {
                    List<FeatureServiceFeature> features = FeatureServiceHelper.getSelectedCidsLayerFeatures("foto");
                    SelectionManager.getInstance().removeSelectedFeatures(features);
                    SelectionManager.getInstance().addSelectedFeatures(newFeatures);
                    Photo.reloadPhotoServices();
                    Photo.this.reloadPrPfTable();
                    Photo.this.addNewFeaturesToTable(newFeatures);
                }
            }
            catch (InterruptedException ex) {
                LOG.warn((Object)ex, (Throwable)ex);
            }
            catch (ExecutionException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            finally {
                Photo.this.editor.showEditor(true, false);
            }
        }

        private CidsBean getCatalogueElement(String className, String attributeName, String value) {
            MetaClass mc = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)className);
            String query = "select " + mc.getID() + ", " + mc.getPrimaryKey() + " from " + mc.getTableName();
            query = query + " WHERE " + attributeName + " = '" + value + "'";
            try {
                MetaObject[] mo = SessionManager.getConnection().getMetaObjectByQuery(SessionManager.getSession().getUser(), query);
                if (mo != null && mo.length > 0) {
                    return mo[0].getBean();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        private Integer getNextPhotoNumber() {
            try {
                User user = SessionManager.getSession().getUser();
                ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new PhotoGetPhotoNumber());
                if (attributes != null && !attributes.isEmpty()) {
                    return ((Long)((ArrayList)attributes.get(0)).get(0)).intValue();
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Errro while retrieving next photo number.", (Throwable)ex);
            }
            return null;
        }
    }
}

