/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.panels;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.io.WKBReader;
import de.cismet.cids.custom.watergis.server.search.RouteEnvelopes;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.commons.concurrency.CismetConcurrency;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.panels.ZoomPanel;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingWorker;
import org.apache.log4j.Logger;

public class RouteZoomPanel
extends ZoomPanel {
    private static final Logger LOG = Logger.getLogger(RouteZoomPanel.class);

    public RouteZoomPanel() {
        super(ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_ba"), "fg_ba", null);
    }

    @Override
    public void init() {
        this.routeModelInitialised = false;
        this.cbObjects.setModel(new DefaultComboBoxModel<Object>(new Object[]{"Lade ..."}));
        SwingWorker<ZoomPanel.GeometryElement[], Void> sw = new SwingWorker<ZoomPanel.GeometryElement[], Void>(){

            @Override
            protected ZoomPanel.GeometryElement[] doInBackground() throws Exception {
                if (RouteZoomPanel.this.objectMc != null) {
                    RouteEnvelopes search;
                    if (AppBroker.getInstance().getOwner().equalsIgnoreCase("administratoren") || AppBroker.getInstance().getOwner().equalsIgnoreCase("admin_edit") || AppBroker.getInstance().getOwner().equalsIgnoreCase("gaeste") || AppBroker.getInstance().getOwner().equalsIgnoreCase("lung") || AppBroker.getInstance().getOwner().equalsIgnoreCase("lv_wbv") || AppBroker.getInstance().getOwner().equalsIgnoreCase("lu") || AppBroker.getInstance().getOwner().equalsIgnoreCase("uwb_hro") || AppBroker.getInstance().getOwner().equalsIgnoreCase("uwb_lro") || AppBroker.getInstance().getOwner().equalsIgnoreCase("uwb_lup") || AppBroker.getInstance().getOwner().equalsIgnoreCase("uwb_mse") || AppBroker.getInstance().getOwner().equalsIgnoreCase("uwb_nwm") || AppBroker.getInstance().getOwner().equalsIgnoreCase("uwb_sn") || AppBroker.getInstance().getOwner().equalsIgnoreCase("uwb_vg") || AppBroker.getInstance().getOwner().equalsIgnoreCase("uwb_vr") || AppBroker.getInstance().getOwner().equalsIgnoreCase("anonymous")) {
                        search = new RouteEnvelopes(null);
                    } else {
                        String praefixGroup = AppBroker.getInstance().getOwnWwGr() != null ? (String)AppBroker.getInstance().getOwnWwGr().getProperty("praefixgroup") : null;
                        search = praefixGroup != null ? new RouteEnvelopes(" dlm25wPk_ww_gr1.owner = '" + AppBroker.getInstance().getOwner() + "' or dlm25wPk_ww_gr1.praefixgroup = '" + praefixGroup + "'") : new RouteEnvelopes(" dlm25wPk_ww_gr1.owner = '" + AppBroker.getInstance().getOwner() + "'");
                    }
                    ArrayList<ZoomPanel.GeometryElement> beans = new ArrayList<ZoomPanel.GeometryElement>();
                    User user = SessionManager.getSession().getUser();
                    ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)search);
                    if (attributes != null && !attributes.isEmpty()) {
                        GeometryFactory geomFactory = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), CismapBroker.getInstance().getDefaultCrsAlias());
                        WKBReader wkbReader = new WKBReader(geomFactory);
                        for (ArrayList f : attributes) {
                            if (!(f.get(0) instanceof byte[])) continue;
                            Geometry g = wkbReader.read((byte[])f.get(0));
                            g.setSRID(CismapBroker.getInstance().getDefaultCrsAlias());
                            beans.add(new ZoomPanel.GeometryElement((Integer)f.get(2), (String)f.get(1), g, false));
                        }
                    }
                    return beans.toArray(new ZoomPanel.GeometryElement[beans.size()]);
                }
                return new ZoomPanel.GeometryElement[0];
            }

            @Override
            protected void done() {
                try {
                    ZoomPanel.GeometryElement[] tmp = (ZoomPanel.GeometryElement[])this.get();
                    RouteZoomPanel.this.cbObjects.setModel(new DefaultComboBoxModel<ZoomPanel.GeometryElement>(tmp));
                    RouteZoomPanel.this.routeModelInitialised = true;
                }
                catch (InterruptedException | ExecutionException e) {
                    LOG.error((Object)"Error while initializing the model of the route combobox", (Throwable)e);
                }
            }
        };
        CismetConcurrency.getInstance((String)"watergis").getDefaultExecutor().execute(sw);
    }
}

