/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.panels;

import Sirius.navigator.DefaultNavigatorExceptionHandler;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import de.cismet.cismap.commons.Crs;
import de.cismet.cismap.commons.RetrievalServiceLayer;
import de.cismet.cismap.commons.ServiceLayer;
import de.cismet.cismap.commons.features.Feature;
import de.cismet.cismap.commons.features.FeatureCollectionEvent;
import de.cismet.cismap.commons.features.FeatureCollectionListener;
import de.cismet.cismap.commons.gui.MappingComponent;
import de.cismet.cismap.commons.gui.statusbar.ServicesBusyPanel;
import de.cismet.cismap.commons.gui.statusbar.ServicesErrorPanel;
import de.cismet.cismap.commons.gui.statusbar.ServicesRetrievedPanel;
import de.cismet.cismap.commons.interaction.ActiveLayerListener;
import de.cismet.cismap.commons.interaction.CismapBroker;
import de.cismet.cismap.commons.interaction.StatusListener;
import de.cismet.cismap.commons.interaction.events.ActiveLayerEvent;
import de.cismet.cismap.commons.interaction.events.StatusEvent;
import de.cismet.cismap.commons.rasterservice.MapService;
import de.cismet.cismap.commons.retrieval.RepaintEvent;
import de.cismet.cismap.commons.retrieval.RepaintListener;
import de.cismet.tools.gui.exceptionnotification.DefaultExceptionHandlerListener;
import de.cismet.tools.gui.exceptionnotification.ExceptionNotificationStatusPanel;
import de.cismet.watergis.broker.AppBroker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class StatusBar
extends JPanel
implements StatusListener,
FeatureCollectionListener,
ActiveLayerListener,
RepaintListener {
    private static final Logger LOG = Logger.getLogger(StatusBar.class);
    private static final int K_DIVISOR = 1000;
    private static final int K_SQUARE_DIVISOR = 1000000;
    private JPanel servicesBusyPanel = new ServicesBusyPanel();
    private JPanel servicesRetrievedPanel = new ServicesRetrievedPanel();
    private JPanel servicesErrorPanel = new ServicesErrorPanel();
    private Timer timer;
    private ExceptionNotificationStatusPanel exceptionNotificationStatusPanel;
    private Box.Filler filler1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lblCoordinates;
    private JLabel lblMeasuring;
    private JLabel lblNotification;
    private JPanel pnlCoordinates;
    private JPanel pnlMeasuring;
    private JPanel pnlNotification;
    private JPanel pnlServicesStatus;
    private ServicesRetrievedPanel servicesRetrievedPanel1;

    public StatusBar() {
        this.initComponents();
        this.lblCoordinates.setText("");
        try {
            AppBroker.getInstance().getMappingComponent().getFeatureCollection().addFeatureCollectionListener((FeatureCollectionListener)this);
            AppBroker.getInstance().getMappingComponent().addRepaintListener((RepaintListener)this);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        DefaultNavigatorExceptionHandler.getInstance().addListener((DefaultExceptionHandlerListener)this.exceptionNotificationStatusPanel);
    }

    private void initComponents() {
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.pnlServicesStatus = new JPanel();
        this.servicesRetrievedPanel1 = new ServicesRetrievedPanel();
        this.jPanel2 = new JPanel();
        this.pnlNotification = new JPanel();
        this.lblNotification = new JLabel();
        this.pnlMeasuring = new JPanel();
        this.lblMeasuring = new JLabel();
        this.pnlCoordinates = new JPanel();
        this.lblCoordinates = new JLabel();
        this.exceptionNotificationStatusPanel = new ExceptionNotificationStatusPanel();
        this.jPanel1 = new JPanel();
        this.setMaximumSize(new Dimension(32769, 20));
        this.setMinimumSize(new Dimension(200, 20));
        this.setPreferredSize(new Dimension(500, 20));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                StatusBar.this.formMouseClicked(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.filler1, gridBagConstraints);
        this.pnlServicesStatus.setLayout(new BorderLayout());
        this.pnlServicesStatus.add((Component)this.servicesRetrievedPanel1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 2);
        this.add((Component)this.pnlServicesStatus, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jPanel2, gridBagConstraints);
        this.pnlNotification.setLayout(new BorderLayout());
        this.pnlNotification.add((Component)this.lblNotification, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 10);
        this.add((Component)this.pnlNotification, gridBagConstraints);
        this.pnlMeasuring.setLayout(new BorderLayout());
        this.pnlMeasuring.add((Component)this.lblMeasuring, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 10);
        this.add((Component)this.pnlMeasuring, gridBagConstraints);
        this.pnlCoordinates.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.lblCoordinates, (String)NbBundle.getMessage(StatusBar.class, (String)"StatusBar.lblCoordinates.text"));
        this.pnlCoordinates.add((Component)this.lblCoordinates, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.add((Component)this.pnlCoordinates, gridBagConstraints);
        this.add((Component)this.exceptionNotificationStatusPanel, new GridBagConstraints());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void formMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() > 1) {
            if (!CismapBroker.getInstance().getMappingComponent().isInternalLayerWidgetVisible()) {
                CismapBroker.getInstance().getMappingComponent().showInternalLayerWidget(true, 300);
            } else {
                CismapBroker.getInstance().getMappingComponent().showInternalLayerWidget(false, 150);
            }
        }
    }

    public synchronized void showNotification(String text) {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.lblNotification.setText(text);
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                StatusBar.this.lblNotification.setText("");
            }
        }, 5000L);
    }

    public void statusValueChanged(final StatusEvent e) {
        if (!EventQueue.isDispatchThread()) {
            LOG.warn((Object)("status bar event invocation not in edt. This can lead to an error. Event = " + e.getName()), (Throwable)new Exception());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    StatusBar.this.statusValueChanged(e);
                }
            });
            return;
        }
        if (!e.getName().equals("mode")) {
            if (e.getName().equals("retrieval.started")) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RETRIEVAL_STARTED (" + e.getValue() + ", " + System.currentTimeMillis() + ")"));
                }
            } else if (!e.getName().equals("retrieval.completed")) {
                if (e.getName().equals("retrieval.aborted")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("RETRIEVAL_ABORTED (" + e.getValue() + ", " + System.currentTimeMillis() + ")"));
                    }
                } else if (e.getName().equals("retrieval.error")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("RETRIEVAL_ERROR (" + e.getValue() + ", " + System.currentTimeMillis() + ")"));
                    }
                } else if (e.getName().equals("retrieval.removed")) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("RETRIEVAL_REMOVED (" + e.getValue() + ", " + System.currentTimeMillis() + ")"));
                    }
                } else if (e.getName().equals("retrieval.reset") && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RETRIEVAL_RESET (" + e.getValue() + ", " + System.currentTimeMillis() + ")"));
                }
            }
        }
        this.refreshControls(e);
    }

    private void refreshControls(final StatusEvent e) {
        Runnable modifyControls = new Runnable(){

            @Override
            public void run() {
                TreeMap services = CismapBroker.getInstance().getMappingComponent().getMappingModel().getRasterServices();
                int stat = 0;
                for (Integer key : services.keySet()) {
                    MapService service = (MapService)services.get(key);
                    if (!service.isVisible() || service.getPNode() == null || (double)service.getPNode().getTransparency() == 0.0 || service instanceof RetrievalServiceLayer && !((RetrievalServiceLayer)service).isEnabled()) continue;
                    int progress = service.getProgress();
                    if (service.isRefreshNeeded()) {
                        if (stat != 0) continue;
                        stat = 1;
                        continue;
                    }
                    if (progress == -1 || progress > 0 && progress < 100) {
                        if (stat != 0) continue;
                        stat = 1;
                        continue;
                    }
                    if (!(service instanceof RetrievalServiceLayer) || !((RetrievalServiceLayer)service).hasErrors()) continue;
                    stat = 2;
                }
                StatusBar.this.pnlServicesStatus.removeAll();
                if (stat == 0) {
                    StatusBar.this.pnlServicesStatus.add((Component)StatusBar.this.servicesRetrievedPanel, "Center");
                } else if (stat == 1) {
                    StatusBar.this.pnlServicesStatus.add((Component)StatusBar.this.servicesBusyPanel, "Center");
                } else if (stat == 2) {
                    StatusBar.this.pnlServicesStatus.add((Component)StatusBar.this.servicesErrorPanel, "Center");
                }
                StatusBar.this.pnlServicesStatus.revalidate();
                StatusBar.this.pnlServicesStatus.repaint();
                if (e != null) {
                    if (e.getName().equals("coordinate_string")) {
                        Coordinate c = (Coordinate)e.getValue();
                        StatusBar.this.lblCoordinates.setText(MappingComponent.getCoordinateString((double)c.x, (double)c.y));
                    } else if (!(e.getName().equals("measurement") || e.getName().equals("mode") || e.getName().equals("object_infos") || e.getName().equals("scale"))) {
                        if (e.getName().equals("crs")) {
                            StatusBar.this.lblCoordinates.setToolTipText(((Crs)e.getValue()).getShortname());
                        } else if (e.getName().equals("retrieval.started") || e.getName().equals("map.extent.fixed") || e.getName().equals("map.scale.fixed")) {
                            // empty if block
                        }
                    }
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            modifyControls.run();
        } else {
            EventQueue.invokeLater(modifyControls);
        }
    }

    private double roundTo2Decimals(double d) {
        return (double)((int)(d * 100.0)) / 100.0;
    }

    private void showMeasuring(Feature f) {
        double length;
        Geometry geom = f.getGeometry();
        double area = geom != null ? geom.getArea() : 0.0;
        double d = length = geom != null ? geom.getLength() : 0.0;
        if (geom != null && geom.getArea() == 0.0) {
            int segments = geom.getNumGeometries() * (geom.getNumPoints() - 1);
            double lastSegmentLength = 0.0;
            if (geom.getNumPoints() > 1) {
                Coordinate start = geom.getCoordinates()[geom.getNumPoints() - 2];
                Coordinate end = geom.getCoordinates()[geom.getNumPoints() - 1];
                GeometryFactory fg = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING));
                LineString lastSegment = fg.createLineString(new Coordinate[]{start, end});
                lastSegmentLength = lastSegment.getLength();
            }
            if (length < 10000.0) {
                this.lblMeasuring.setText(NbBundle.getMessage(StatusBar.class, (String)"StatusBar.lblMeasuring.text.length.m", (Object)segments, (Object)this.roundTo2Decimals(lastSegmentLength), (Object)this.roundTo2Decimals(length)));
            } else {
                this.lblMeasuring.setText(NbBundle.getMessage(StatusBar.class, (String)"StatusBar.lblMeasuring.text.length.km", (Object)segments, (Object)this.roundTo2Decimals(lastSegmentLength /= 1000.0), (Object)this.roundTo2Decimals(length /= 1000.0)));
            }
        } else if (length < 10000.0) {
            this.lblMeasuring.setText(NbBundle.getMessage(StatusBar.class, (String)"StatusBar.lblMeasuring.text.m", (Object)this.roundTo2Decimals(length), (Object)this.roundTo2Decimals(area)));
        } else {
            this.lblMeasuring.setText(NbBundle.getMessage(StatusBar.class, (String)"StatusBar.lblMeasuring.text.km", (Object)this.roundTo2Decimals(length /= 1000.0), (Object)this.roundTo2Decimals(area /= 1000000.0)));
        }
    }

    public void featuresAdded(FeatureCollectionEvent fce) {
        Collection features = fce.getEventFeatures();
        if (AppBroker.getInstance().getMappingComponent().getInteractionMode().equals("MEASURE_MODE") && features != null && features.size() == 1) {
            Feature f = features.toArray(new Feature[1])[0];
            this.showMeasuring(f);
        }
    }

    public void allFeaturesRemoved(FeatureCollectionEvent fce) {
    }

    public void featuresRemoved(FeatureCollectionEvent fce) {
        this.lblMeasuring.setText("");
    }

    public void featuresChanged(FeatureCollectionEvent fce) {
        Collection features = fce.getEventFeatures();
        if (AppBroker.getInstance().getMappingComponent().getInteractionMode().equals("MEASURE_MODE") && features != null && features.size() == 1) {
            Feature f = features.toArray(new Feature[1])[0];
            this.showMeasuring(f);
        }
    }

    public void featureSelectionChanged(FeatureCollectionEvent fce) {
    }

    public void featureReconsiderationRequested(FeatureCollectionEvent fce) {
    }

    public void featureCollectionChanged() {
    }

    public void layerAdded(ActiveLayerEvent e) {
    }

    public void layerRemoved(ActiveLayerEvent e) {
        if (!EventQueue.isDispatchThread()) {
            LOG.warn((Object)"status bar event invocation not in edt. This can lead to an error.", (Throwable)new Exception());
        }
        if (e.getLayer() instanceof ServiceLayer) {
            this.statusValueChanged(new StatusEvent("retrieval.removed", (Object)((ServiceLayer)e.getLayer())));
        }
    }

    public void layerPositionChanged(ActiveLayerEvent e) {
    }

    public void layerVisibilityChanged(ActiveLayerEvent e) {
    }

    public void layerAvailabilityChanged(ActiveLayerEvent e) {
        ServiceLayer layer;
        if (e.getLayer() instanceof ServiceLayer && !(layer = (ServiceLayer)e.getLayer()).isEnabled()) {
            this.statusValueChanged(new StatusEvent("retrieval.removed", (Object)layer));
        }
    }

    public void layerInformationStatusChanged(ActiveLayerEvent e) {
    }

    public void layerSelectionChanged(ActiveLayerEvent e) {
    }

    public void repaintStart(RepaintEvent e) {
    }

    public void repaintComplete(RepaintEvent e) {
        if (!EventQueue.isDispatchThread()) {
            LOG.warn((Object)"status bar event invocation not in edt. This can lead to an error.", (Throwable)new Exception());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Entered repaint complete: " + e.getRetrievalEvent().getRetrievalService() + " (" + System.currentTimeMillis() + ")"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RETRIEVAL_COMPLETED (" + e.getRetrievalEvent().getRetrievalService() + ", " + System.currentTimeMillis() + ")"));
        }
        this.refreshControls(null);
    }

    public void repaintError(RepaintEvent e) {
        if (!EventQueue.isDispatchThread()) {
            LOG.warn((Object)"status bar event invocation not in edt. This can lead to an error.", (Throwable)new Exception());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Entered RETRIEVAL_ERROR: " + e.getRetrievalEvent().getRetrievalService() + " (" + System.currentTimeMillis() + ")"));
        }
        this.refreshControls(null);
    }
}

