/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.panels;

import de.cismet.lookupoptions.AbstractOptionsPanel;
import de.cismet.lookupoptions.OptionsPanelController;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.panels.WatergisOptionsCategory;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;
import org.jdom.Element;
import org.openide.util.NbBundle;

public class WatergisOptionsPanel
extends AbstractOptionsPanel
implements OptionsPanelController {
    private static final Logger LOG = Logger.getLogger(WatergisOptionsPanel.class);
    private static final String OPTION_NAME = NbBundle.getMessage(WatergisOptionsPanel.class, (String)"WatergisOptionsPanel.OPTION_NAME");
    private int maxShownRecentlyOpenedLocalConfigFiles = 5;
    private Box.Filler filler2;
    private JLabel lblLocalConfigFiles;
    private JSpinner spnShownLocalConfigFiles;

    public WatergisOptionsPanel() {
        super(OPTION_NAME, WatergisOptionsCategory.class);
        this.initComponents();
    }

    private void initComponents() {
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.lblLocalConfigFiles = new JLabel();
        this.spnShownLocalConfigFiles = new JSpinner();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.filler2, gridBagConstraints);
        this.lblLocalConfigFiles.setText(NbBundle.getMessage(WatergisOptionsPanel.class, (String)"WatergisOptionsPanel.lblLocalConfigFiles.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 5, 3, 10);
        this.add(this.lblLocalConfigFiles, gridBagConstraints);
        this.spnShownLocalConfigFiles.setModel(new SpinnerNumberModel(5, 1, 50, 1));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        this.add(this.spnShownLocalConfigFiles, gridBagConstraints);
    }

    public void update() {
        this.maxShownRecentlyOpenedLocalConfigFiles = AppBroker.getInstance().getRecentlyOpenedFilesList().getMaxAmount();
        this.spnShownLocalConfigFiles.setValue(this.maxShownRecentlyOpenedLocalConfigFiles);
    }

    public void applyChanges() {
        this.maxShownRecentlyOpenedLocalConfigFiles = (Integer)this.spnShownLocalConfigFiles.getValue();
        AppBroker.getInstance().getRecentlyOpenedFilesList().setMaxAmount(this.maxShownRecentlyOpenedLocalConfigFiles);
    }

    public boolean isChanged() {
        boolean result = false;
        result = this.maxShownRecentlyOpenedLocalConfigFiles != (Integer)this.spnShownLocalConfigFiles.getValue();
        return result;
    }

    public String getTooltip() {
        return NbBundle.getMessage(WatergisOptionsPanel.class, (String)"WatergisOptionsPanel.tooltip");
    }

    public Element getConfiguration() throws NoWriteError {
        return null;
    }

    public void configure(Element parent) {
    }

    public void masterConfigure(Element parent) {
    }
}

