/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.recently_opened_files;

import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.watergis.broker.AppBroker;
import de.cismet.watergis.gui.actions.AdoptLocalConfigFileAction;
import de.cismet.watergis.gui.actions.AdoptServerConfigFileAction;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.jdom.Element;

public class FileMenu
extends JMenu
implements Configurable {
    private static final Logger LOG = Logger.getLogger(FileMenu.class);
    final List<JMenuItem> serverProfileItems = new ArrayList<JMenuItem>();
    final List<Component> before = new ArrayList<Component>();
    final List<Component> after = new ArrayList<Component>();

    public FileMenu() {
        this.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                FileMenu.this.rebuild();
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
    }

    public void saveComponentsAfterInitialisation() {
        Component[] comps = this.getMenuComponents();
        List<Component> active = this.before;
        for (Component comp : comps) {
            if (active != null) {
                active.add(comp);
            }
            if (active == this.before && comp.getName() != null && comp.getName().trim().equals("sepCentralFilesStart")) {
                active = null;
                continue;
            }
            if (active != null || comp.getName() == null || !comp.getName().trim().equals("sepLocalFilesEnd")) continue;
            active = this.after;
            this.after.add(comp);
        }
    }

    private void rebuild() {
        this.removeAll();
        for (Component component : this.before) {
            this.add(component);
        }
        for (JMenuItem serverProfile : this.serverProfileItems) {
            this.add(serverProfile);
        }
        Collection<File> fileHistory = AppBroker.getInstance().getRecentlyOpenedFilesList().getFileList();
        if (!fileHistory.isEmpty()) {
            this.add(new JPopupMenu.Separator());
        }
        this.rebuildLocalFiles(fileHistory);
        for (Component component : this.after) {
            this.add(component);
        }
    }

    private void rebuildLocalFiles(Collection<File> fileHistory) {
        for (File file : fileHistory) {
            JMenuItem menuItem = new JMenuItem(file.getName());
            menuItem.setAction(new AdoptLocalConfigFileAction(file));
            String fileNameWithOutExt = FilenameUtils.removeExtension((String)file.getName());
            menuItem.setText(fileNameWithOutExt);
            this.add(menuItem);
        }
    }

    public void configure(Element parent) {
    }

    public void masterConfigure(Element parent) {
        this.serverProfileItems.clear();
        Element serverprofiles = parent.getChild("serverProfiles");
        for (Element next : serverprofiles.getChildren("profile")) {
            String id = next.getAttributeValue("id");
            String sorter = next.getAttributeValue("sorter");
            String name = next.getAttributeValue("name");
            String path = next.getAttributeValue("path");
            String icon = next.getAttributeValue("icon");
            String descr = next.getAttributeValue("descr");
            String descrWidth = next.getAttributeValue("descrwidth");
            String complexDescriptionText = next.getTextTrim();
            String complexDescriptionSwitch = next.getAttributeValue("complexdescr");
            JMenuItem serverProfileMenuItem = new JMenuItem();
            serverProfileMenuItem.setAction(new AdoptServerConfigFileAction(path, name));
            serverProfileMenuItem.setText(name);
            serverProfileMenuItem.setName("ServerProfile:" + sorter + ":" + name);
            try {
                serverProfileMenuItem.setIcon(new ImageIcon(this.getClass().getResource(icon)));
            }
            catch (Exception iconE) {
                LOG.warn((Object)"Could not create Icon for ServerProfile.", (Throwable)iconE);
            }
            this.serverProfileItems.add(serverProfileMenuItem);
            Collections.sort(this.serverProfileItems, new Comparator<JMenuItem>(){

                @Override
                public int compare(JMenuItem o1, JMenuItem o2) {
                    if (o1.getName() != null && o2.getName() != null) {
                        return o1.getName().compareTo(o2.getName());
                    }
                    return 0;
                }
            });
        }
    }

    public Element getConfiguration() throws NoWriteError {
        return null;
    }
}

