/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.gui.recently_opened_files;

import de.cismet.tools.configuration.Configurable;
import de.cismet.tools.configuration.NoWriteError;
import de.cismet.watergis.gui.WatergisApp;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.openide.util.Exceptions;

public class RecentlyOpenedFilesList
implements Configurable {
    private static final Logger LOG = Logger.getLogger(RecentlyOpenedFilesList.class);
    private static final String XML_ENCODING;
    private int maxAmount = 5;
    private LinkedList<File> fileList = new LinkedList();
    private String recentlyOpenedFilesFilePath = WatergisApp.getDIRECTORYPATH_WATERGIS() + System.getProperty("file.separator") + "recentlyOpenedFiles.files";

    public void addFile(File file) {
        if (this.fileList.contains(file)) {
            this.fileList.remove(file);
        }
        this.fileList.push(file);
        while (this.fileList.size() > this.maxAmount) {
            this.fileList.removeLast();
        }
    }

    public Collection<File> getFileList() {
        if (this.fileList.size() < this.maxAmount) {
            return this.fileList;
        }
        return this.fileList.subList(0, this.maxAmount);
    }

    public void configure(Element parent) {
        this.loadFilenames();
    }

    private void loadFilenames() {
        Element rootObject = null;
        try {
            SAXBuilder builder = new SAXBuilder(false);
            Document doc = builder.build(new File(this.recentlyOpenedFilesFilePath));
            rootObject = doc.getRootElement();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error while reading the list with the recently opened files", (Throwable)e);
        }
        if (rootObject != null) {
            try {
                Element maxAmountElement = rootObject.getChild("maxAmount");
                this.maxAmount = Integer.parseInt(maxAmountElement.getText());
                Element files = rootObject.getChild("files");
                List filepaths = files.getChildren("file");
                this.fileList.clear();
                for (int i = 0; i < filepaths.size(); ++i) {
                    File file = new File(((Element)filepaths.get(i)).getText());
                    this.fileList.addLast(file);
                }
            }
            catch (Exception skip) {
                LOG.warn((Object)"Error while reading the list with the recently opened files", (Throwable)skip);
            }
        }
    }

    public void masterConfigure(Element parent) {
    }

    public Element getConfiguration() throws NoWriteError {
        this.saveFilenames();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFilenames() {
        OutputStreamWriter writer = null;
        try {
            Element root = new Element("watergisRecentlyOpenedLocalConfigFiles");
            Element maxAmountElement = new Element("maxAmount");
            maxAmountElement.addContent(Integer.toString(this.maxAmount));
            root.addContent((Content)maxAmountElement);
            Element files = new Element("files");
            for (int i = 0; i < this.fileList.size() && i < this.maxAmount; ++i) {
                Element file = new Element("file");
                file.addContent(this.fileList.get(i).getAbsolutePath());
                files.addContent((Content)file);
            }
            root.addContent((Content)files);
            Document doc = new Document(root);
            Format format = Format.getPrettyFormat();
            format.setEncoding(XML_ENCODING);
            XMLOutputter serializer = new XMLOutputter(format);
            File file = new File(this.recentlyOpenedFilesFilePath);
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file), XML_ENCODING);
            serializer.output(doc, (Writer)writer);
            writer.flush();
        }
        catch (UnsupportedEncodingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (FileNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public int getMaxAmount() {
        return this.maxAmount;
    }

    public void setMaxAmount(int maxAmount) {
        this.maxAmount = maxAmount;
    }

    static {
        String charset = Charset.defaultCharset().toString();
        XML_ENCODING = "MacRoman".equals(charset) ? "UTF-8" : "ISO-8859-1";
    }
}

