/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.profile;

import Sirius.server.middleware.types.MetaClass;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.cidslayer.DefaultCidsLayerBindableReferenceCombo;
import de.cismet.watergis.profile.AbstractImportDialog;
import de.cismet.watergis.profile.ProfileReader;
import de.cismet.watergis.profile.WPROFReader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class CsvWprofImportDialog
extends AbstractImportDialog {
    private static final String[][] ALL_ALLOWED_TYPE_COMBINATIONS = new String[2][];
    private MetaClass LAWA_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_la");
    private DefaultComboBoxModel<String>[] models;
    private boolean cancelled = false;
    private boolean routeRequired = false;
    private final WPROFReader parentReader;
    private String[] columnProposal = null;
    private boolean initInProgress = false;
    private List<JPanel> previewPanels = new ArrayList<JPanel>();
    private JButton butCancel;
    private JButton butOk;
    private JButton butOk1;
    private JComboBox cbRoute;
    private JCheckBox chkHeader;
    private JCheckBox chkSeparator;
    private JDialog diaRoute;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JPanel panColumns;
    private JPanel panControl;
    private JPanel panData;

    public CsvWprofImportDialog(Frame parent, boolean modal, String[] columnProposal, WPROFReader parentReader) {
        super(parent, modal);
        this.setTitle("Importiere Profildaten");
        this.initComponents();
        this.parentReader = parentReader;
        this.init(columnProposal, true);
    }

    private void init(String[] columnProposal, boolean init) {
        int i;
        this.models = new DefaultComboBoxModel[columnProposal.length];
        this.columnProposal = columnProposal;
        String[][] exampleData = this.parentReader.readExampleData();
        if (init) {
            for (i = 0; i < columnProposal.length; ++i) {
                if (columnProposal[i] == null) continue;
                this.initInProgress = true;
                this.chkHeader.setSelected(true);
                this.initInProgress = false;
                break;
            }
        }
        for (i = 0; i < columnProposal.length; ++i) {
            JComboBox<String> cbColumn = new JComboBox<String>();
            boolean isDouble = this.hasOnlyDouble(exampleData, i);
            this.models[i] = this.createModel(isDouble);
            if (columnProposal[i] != null) {
                this.models[i].setSelectedItem(columnProposal[i]);
            }
            cbColumn.setModel(this.models[i]);
            cbColumn.addItemListener(new ColumnItemListener(i));
            cbColumn.setPreferredSize(new Dimension(120, 34));
            cbColumn.setMinimumSize(new Dimension(120, 34));
            cbColumn.setMaximumSize(new Dimension(120, 34));
            this.panColumns.add(cbColumn);
        }
        for (int row = 0; row < 15 && row < exampleData.length; ++row) {
            JLabel labData;
            JPanel panRow = new JPanel();
            for (int i2 = 0; i2 < columnProposal.length && i2 < exampleData[row].length; ++i2) {
                labData = new JLabel(exampleData[row][i2].substring(0, Math.min(exampleData[row][i2].length(), 12)));
                labData.setToolTipText(exampleData[row][i2]);
                labData.setPreferredSize(new Dimension(120, 22));
                labData.setMinimumSize(new Dimension(120, 22));
                labData.setMaximumSize(new Dimension(120, 22));
                panRow.add(labData);
            }
            int emptyCols = 0;
            while (exampleData[row].length + emptyCols < columnProposal.length) {
                labData = new JLabel("<html>&nbsp;<html>");
                labData.setPreferredSize(new Dimension(120, 22));
                labData.setMinimumSize(new Dimension(120, 22));
                labData.setMaximumSize(new Dimension(120, 22));
                panRow.add(labData);
                ++emptyCols;
            }
            panRow.setOpaque(false);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = row + 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            this.previewPanels.add(panRow);
            this.panData.add((Component)panRow, gridBagConstraints);
        }
        this.adjustComboboxes(0);
        final int width = columnProposal.length * 130;
        this.setSize(width < 720 ? 720 : width, 351);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CsvWprofImportDialog.this.setSize(width < 720 ? 720 : width, 350);
                CsvWprofImportDialog.this.getContentPane().repaint();
                CsvWprofImportDialog.this.getContentPane().doLayout();
            }
        });
        if (this.models.length < 3) {
            this.cancelled = true;
            this.setVisible(false);
        }
    }

    private boolean hasOnlyDouble(String[][] exampleData, int index) {
        int i;
        int n = i = this.chkHeader.isSelected() ? 1 : 0;
        while (i < exampleData.length) {
            String[] row = exampleData[i];
            try {
                if (row.length <= index) {
                    return false;
                }
                Double.parseDouble(row[index].replace(",", ".").replace("*", ""));
            }
            catch (NumberFormatException e) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private DefaultComboBoxModel<String> createModel(boolean isDouble) {
        TreeSet<String> allowedTypes = new TreeSet<String>();
        allowedTypes.add("");
        if (isDouble) {
            allowedTypes.add(ProfileReader.GAF_FIELDS.Z.name());
            allowedTypes.add(ProfileReader.GAF_FIELDS.Y.name());
            allowedTypes.add(ProfileReader.GAF_FIELDS.STATION.name());
        }
        allowedTypes.add(ProfileReader.GAF_FIELDS.HYK.name());
        allowedTypes.add(ProfileReader.GAF_FIELDS.ID.name());
        allowedTypes.add(ProfileReader.GAF_FIELDS.RK.name());
        allowedTypes.add(ProfileReader.GAF_FIELDS.BK.name());
        allowedTypes.add(ProfileReader.GAF_FIELDS.KZ.name());
        allowedTypes.add(ProfileReader.GAF_FIELDS.HW.name());
        allowedTypes.add(ProfileReader.GAF_FIELDS.RW.name());
        ArrayList list = new ArrayList(allowedTypes.descendingSet());
        Collections.reverse(list);
        return new DefaultComboBoxModel<String>(list.toArray(new String[allowedTypes.size()]));
    }

    private void adjustComboboxes(int index) {
        TreeSet<String> usedValues = new TreeSet<String>();
        boolean allBoxesFilled = true;
        String selectedValue = (String)this.models[index].getSelectedItem();
        usedValues.add(selectedValue);
        for (int i = 0; i < this.models.length; ++i) {
            if (i == index) continue;
            String value = (String)this.models[i].getSelectedItem();
            if (!value.equals("") && usedValues.contains(value)) {
                this.models[i].setSelectedItem("");
                continue;
            }
            if (value.equals("") || usedValues.contains(value)) continue;
            usedValues.add(value);
        }
        this.butOk.setEnabled(this.hasAllowedCombination(usedValues));
    }

    private boolean hasAllowedCombination(TreeSet<String> usedValues) {
        for (String[] combination : ALL_ALLOWED_TYPE_COMBINATIONS) {
            if (usedValues.size() < combination.length) continue;
            boolean combFullfilled = true;
            for (String val : combination) {
                if (usedValues.contains(val)) continue;
                combFullfilled = false;
                break;
            }
            if (!combFullfilled) continue;
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.diaRoute = new JDialog();
        this.butOk1 = new JButton();
        this.jLabel2 = new JLabel();
        this.cbRoute = new DefaultCidsLayerBindableReferenceCombo(this.LAWA_MC, true);
        this.panColumns = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.panData = new JPanel();
        this.panControl = new JPanel();
        this.butOk = new JButton();
        this.butCancel = new JButton();
        this.chkHeader = new JCheckBox();
        this.chkSeparator = new JCheckBox();
        this.diaRoute.setDefaultCloseOperation(2);
        this.diaRoute.setTitle(NbBundle.getMessage(CsvWprofImportDialog.class, (String)"CsvWprofImportDialog.diaRoute.title", (Object[])new Object[0]));
        this.diaRoute.setAlwaysOnTop(true);
        this.diaRoute.setModal(true);
        this.diaRoute.getContentPane().setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk1, (String)NbBundle.getMessage(CsvWprofImportDialog.class, (String)"CsvWprofImportDialog.butOk1.text", (Object[])new Object[0]));
        this.butOk1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvWprofImportDialog.this.butOk1ActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 5);
        this.diaRoute.getContentPane().add((Component)this.butOk1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(CsvWprofImportDialog.class, (String)"CsvWprofImportDialog.jLabel2.text", (Object[])new Object[0]));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.diaRoute.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.cbRoute.setMinimumSize(new Dimension(200, 27));
        this.cbRoute.setPreferredSize(new Dimension(200, 27));
        this.cbRoute.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvWprofImportDialog.this.cbRouteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(15, 10, 10, 10);
        this.diaRoute.getContentPane().add((Component)this.cbRoute, gridBagConstraints);
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.panColumns.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.getContentPane().add((Component)this.panColumns, gridBagConstraints);
        this.panData.setLayout(new GridBagLayout());
        this.jScrollPane1.setViewportView(this.panData);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 5);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.panControl.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.butOk, (String)NbBundle.getMessage(CsvWprofImportDialog.class, (String)"CsvWprofImportDialog.butOk.text", (Object[])new Object[0]));
        this.butOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvWprofImportDialog.this.butOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 10, 5);
        this.panControl.add((Component)this.butOk, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.butCancel, (String)NbBundle.getMessage(CsvWprofImportDialog.class, (String)"CsvWprofImportDialog.butCancel.text", (Object[])new Object[0]));
        this.butCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CsvWprofImportDialog.this.butCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 10, 10);
        this.panControl.add((Component)this.butCancel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.chkHeader, (String)NbBundle.getMessage(CsvWprofImportDialog.class, (String)"CsvWprofImportDialog.chkHeader.text", (Object[])new Object[0]));
        this.chkHeader.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CsvWprofImportDialog.this.chkHeaderItemStateChanged(evt);
            }
        });
        this.chkHeader.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CsvWprofImportDialog.this.chkHeaderStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 12, 10);
        this.panControl.add((Component)this.chkHeader, gridBagConstraints);
        this.chkSeparator.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.chkSeparator, (String)NbBundle.getMessage(CsvWprofImportDialog.class, (String)"CsvWprofImportDialog.chkSeparator.text", (Object[])new Object[0]));
        this.chkSeparator.setToolTipText(NbBundle.getMessage(CsvWprofImportDialog.class, (String)"CsvWprofImportDialog.chkSeparator.toolTipText", (Object[])new Object[0]));
        this.chkSeparator.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                CsvWprofImportDialog.this.chkSeparatorItemStateChanged(evt);
            }
        });
        this.chkSeparator.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                CsvWprofImportDialog.this.chkSeparatorStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 10, 12, 10);
        this.panControl.add((Component)this.chkSeparator, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.getContentPane().add((Component)this.panControl, gridBagConstraints);
        this.pack();
    }

    private void butOkActionPerformed(ActionEvent evt) {
        this.cancelled = false;
        this.routeRequired = false;
        HashMap<ProfileReader.GAF_FIELDS, Integer> fieldMap = new HashMap<ProfileReader.GAF_FIELDS, Integer>();
        for (int i = 0; i < this.models.length; ++i) {
            String selectedValue = (String)this.models[i].getSelectedItem();
            if (selectedValue.equals("")) continue;
            fieldMap.put(ProfileReader.GAF_FIELDS.valueOf(selectedValue), i);
        }
        this.parentReader.setHeader(fieldMap, this.chkHeader.isSelected());
        if (!fieldMap.containsKey((Object)ProfileReader.GAF_FIELDS.RW) || !fieldMap.containsKey((Object)ProfileReader.GAF_FIELDS.HW)) {
            this.routeRequired = true;
        }
        this.setVisible(false);
    }

    private void butCancelActionPerformed(ActionEvent evt) {
        this.cancelled = true;
        this.routeRequired = false;
        this.setVisible(false);
    }

    private void butOk1ActionPerformed(ActionEvent evt) {
        if (this.cbRoute.getSelectedItem() != null) {
            this.parentReader.setRoute((CidsLayerFeature)this.cbRoute.getSelectedItem());
            this.diaRoute.setVisible(false);
        }
    }

    private void cbRouteActionPerformed(ActionEvent evt) {
    }

    private void chkHeaderStateChanged(ChangeEvent evt) {
    }

    private void chkHeaderItemStateChanged(ItemEvent evt) {
        if (!this.initInProgress) {
            this.panColumns.removeAll();
            for (JPanel p : this.previewPanels) {
                this.panData.remove(p);
            }
            this.previewPanels.clear();
            this.init(this.columnProposal, false);
        }
    }

    private void chkSeparatorItemStateChanged(ItemEvent evt) {
        this.parentReader.setDuplicateSepAllowed(this.chkSeparator.isSelected());
        if (!this.initInProgress) {
            this.panColumns.removeAll();
            for (JPanel p : this.previewPanels) {
                this.panData.remove(p);
                this.getContentPane().remove(p);
            }
            this.previewPanels.clear();
            this.init(this.columnProposal, false);
        }
    }

    private void chkSeparatorStateChanged(ChangeEvent evt) {
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isRouteRequired() {
        return this.routeRequired;
    }

    static {
        CsvWprofImportDialog.ALL_ALLOWED_TYPE_COMBINATIONS[0] = new String[]{ProfileReader.GAF_FIELDS.STATION.name(), ProfileReader.GAF_FIELDS.Y.name(), ProfileReader.GAF_FIELDS.Z.name()};
        CsvWprofImportDialog.ALL_ALLOWED_TYPE_COMBINATIONS[1] = new String[]{ProfileReader.GAF_FIELDS.Z.name(), ProfileReader.GAF_FIELDS.HW.name(), ProfileReader.GAF_FIELDS.RW.name()};
    }

    private class ColumnItemListener
    implements ItemListener {
        private final int index;

        public ColumnItemListener(int index) {
            this.index = index;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            CsvWprofImportDialog.this.adjustComboboxes(this.index);
        }
    }
}

