/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.profile;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.newuser.User;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import de.cismet.cids.custom.watergis.server.search.GafCatalogueValues;
import de.cismet.cids.custom.watergis.server.search.GafPosition;
import de.cismet.cids.server.search.CidsServerSearch;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.watergis.profile.AbstractImportDialog;
import de.cismet.watergis.profile.AbstractProfileReader;
import de.cismet.watergis.profile.ProfileLine;
import de.cismet.watergis.profile.ProfileReader;
import de.cismet.watergis.profile.QpCheckResult;
import de.cismet.watergis.utils.CustomGafCatalogueReader;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class GafReader
extends AbstractProfileReader {
    private static final Logger LOG = Logger.getLogger(GafReader.class);
    private static String[] allKz;
    private static String[] allHYK;
    private static int[] allRK;
    private static int[] allBK;
    private static String[][] allKzHykPerms;
    private static final Map<String, String> kzAbbrevs;
    private static final Color UK_COLOR;
    private static final Color OK_COLOR;
    private CidsLayerFeature lageBezug = null;
    private CidsLayerFeature hoeheBezug = null;
    private CidsLayerFeature status = null;
    private CidsLayerFeature freigabe = null;
    private String[] header;
    private final int[] gafIndex = new int[10];

    public GafReader(File gafFile) {
        this.initFromFile(gafFile);
    }

    public GafReader(List<DefaultFeatureServiceFeature> gafFeatures) {
        this.initFromFeatures(1.0, gafFeatures);
    }

    public GafReader(Map<Double, List<DefaultFeatureServiceFeature>> gafFeaturesMap) {
        for (Double profileId : gafFeaturesMap.keySet()) {
            this.initFromFeatures(profileId, gafFeaturesMap.get(profileId));
        }
    }

    @Override
    public CidsLayerFeature getLageBezug() {
        return this.lageBezug;
    }

    @Override
    public void setLageBezug(CidsLayerFeature lageBezug) {
        this.lageBezug = lageBezug;
    }

    @Override
    public CidsLayerFeature getHoeheBezug() {
        return this.hoeheBezug;
    }

    @Override
    public void setHoeheBezug(CidsLayerFeature hoeheBezug) {
        this.hoeheBezug = hoeheBezug;
    }

    @Override
    public CidsLayerFeature getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(CidsLayerFeature status) {
        this.status = status;
    }

    @Override
    public CidsLayerFeature getFreigabe() {
        return this.freigabe;
    }

    @Override
    public void setFreigabe(CidsLayerFeature freigabe) {
        this.freigabe = freigabe;
    }

    private static synchronized void initialiseCatalogueValues() {
        if (allKz == null) {
            try {
                User user = SessionManager.getSession().getUser();
                ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new GafCatalogueValues());
                if (attributes != null && !attributes.isEmpty()) {
                    int i;
                    ArrayList kz = (ArrayList)attributes.get(0);
                    ArrayList rk = (ArrayList)attributes.get(1);
                    ArrayList bk = (ArrayList)attributes.get(2);
                    ArrayList<String> hyk = new ArrayList<String>();
                    ArrayList<String[]> kzHykPerms = new ArrayList<String[]>();
                    allKz = new String[kz.size()];
                    allRK = new int[rk.size()];
                    allBK = new int[bk.size()];
                    for (i = 0; i < kz.size(); ++i) {
                        GafReader.allKz[i] = (String)((ArrayList)kz.get(i)).get(0);
                        if (!(((ArrayList)kz.get(i)).get(1) instanceof String)) continue;
                        hyk.add((String)((ArrayList)kz.get(i)).get(1));
                        kzHykPerms.add(new String[]{allKz[i], (String)((ArrayList)kz.get(i)).get(1)});
                    }
                    for (i = 0; i < rk.size(); ++i) {
                        GafReader.allRK[i] = (Integer)((ArrayList)rk.get(i)).get(0);
                    }
                    for (i = 0; i < bk.size(); ++i) {
                        GafReader.allBK[i] = (Integer)((ArrayList)bk.get(i)).get(0);
                    }
                    allHYK = hyk.toArray(new String[hyk.size()]);
                    allKzHykPerms = (String[][])kzHykPerms.toArray((T[])new String[0][0]);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while reading GAF catalogue values.", (Throwable)e);
                allKz = new String[0];
                allHYK = new String[0];
                allRK = new int[0];
                allBK = new int[0];
                allKzHykPerms = new String[0][0];
            }
        }
    }

    @Override
    public AbstractImportDialog getImportDialog(Frame parent) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initFromFile(File gafFile) {
        BufferedReader reader = null;
        this.fieldMap = new HashMap();
        try {
            String line;
            String headerLine;
            String trimmedLine;
            reader = new BufferedReader(new FileReader(gafFile));
            ArrayList<String> headers = new ArrayList<String>();
            boolean hasValue = true;
            while (!(hasValue = (trimmedLine = (headerLine = reader.readLine()).trim()).length() != 0) || headerLine == null) {
            }
            StringTokenizer st = new StringTokenizer(headerLine, " \t");
            int index = 0;
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                headers.add(token.toUpperCase());
                try {
                    ProfileReader.GAF_FIELDS field = ProfileReader.GAF_FIELDS.valueOf(token.toUpperCase());
                    this.fieldMap.put(field, index);
                }
                catch (IllegalArgumentException field) {
                    // empty catch block
                }
                ++index;
            }
            this.header = headers.toArray(new String[headers.size()]);
            while ((line = reader.readLine()) != null) {
                String trimmedLine2 = line.trim();
                if (trimmedLine2.length() == 0) continue;
                if (line.length() <= 1) {
                    break;
                }
                line = line.replace(',', '.');
                st = new StringTokenizer(line, " \t");
                ArrayList<String> contFields = new ArrayList<String>();
                int tokenIndex = 0;
                int tokenCount = st.countTokens();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (tokenIndex != ProfileReader.GAF_FIELDS.ID.ordinal() && tokenIndex != ProfileReader.GAF_FIELDS.HYK.ordinal()) {
                        token = token.toUpperCase();
                    }
                    if ((tokenIndex == ProfileReader.GAF_FIELDS.RK.ordinal() || tokenIndex == ProfileReader.GAF_FIELDS.BK.ordinal()) && token.equals("0")) {
                        token = "-1";
                    }
                    if (!(tokenIndex != ProfileReader.GAF_FIELDS.RK.ordinal() && tokenIndex != ProfileReader.GAF_FIELDS.BK.ordinal() || !token.contains(".") && token.length() <= 6)) {
                        contFields.add("-1");
                        ++tokenIndex;
                    }
                    if (!(tokenIndex != ProfileReader.GAF_FIELDS.RK.ordinal() && tokenIndex != ProfileReader.GAF_FIELDS.BK.ordinal() || !token.contains(".") && token.length() <= 6)) {
                        contFields.add("-1");
                        ++tokenIndex;
                    }
                    contFields.add(token);
                    ++tokenIndex;
                }
                if (contFields.size() < 10) {
                    contFields.add("X");
                }
                String[] contentFields = contFields.toArray(new String[contFields.size()]);
                ProfileLine profLine = new ProfileLine(this.fieldMap, contentFields);
                this.content.add(profLine);
                Double station = Double.parseDouble(contentFields[(Integer)this.fieldMap.get((Object)ProfileReader.GAF_FIELDS.STATION)]);
                ArrayList<ProfileLine> profile = (ArrayList<ProfileLine>)this.profiles.get(station);
                if (profile == null) {
                    profile = new ArrayList<ProfileLine>();
                    this.profiles.put(station, profile);
                }
                profile.add(profLine);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reading GAF file", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOG.error((Object)"Cannot close reader", (Throwable)ex);
                }
            }
        }
    }

    private void initFromFeatures(Double profileId, List<DefaultFeatureServiceFeature> features) {
        try {
            this.initCatalogues();
            this.customRkCatalogue = CustomGafCatalogueReader.createRkCatalogue(features, this.rkList);
            this.customBkCatalogue = CustomGafCatalogueReader.createBkCatalogue(features, this.bkList);
            for (int i = 0; i < 10; ++i) {
                this.fieldMap.put(ProfileReader.GAF_FIELDS.values()[i], i);
            }
            for (DefaultFeatureServiceFeature feature : features) {
                String name;
                String[] contentFields = new String[10];
                contentFields[ProfileReader.GAF_FIELDS.Y.ordinal()] = this.objectToString(feature.getProperty("y"), "-1");
                contentFields[ProfileReader.GAF_FIELDS.Z.ordinal()] = this.objectToString(feature.getProperty("z"), "-1");
                contentFields[ProfileReader.GAF_FIELDS.ID.ordinal()] = this.objectToString(feature.getProperty("id_gaf"), "-1");
                contentFields[ProfileReader.GAF_FIELDS.KZ.ordinal()] = this.objectToString(feature.getProperty("kz"), "x");
                contentFields[ProfileReader.GAF_FIELDS.HW.ordinal()] = this.objectToString(feature.getProperty("hw"), "-1");
                contentFields[ProfileReader.GAF_FIELDS.RW.ordinal()] = this.objectToString(feature.getProperty("rw"), "-1");
                contentFields[ProfileReader.GAF_FIELDS.HYK.ordinal()] = this.objectToString(feature.getProperty("hyk"), "x");
                contentFields[ProfileReader.GAF_FIELDS.STATION.ordinal()] = this.stationObjectToString(profileId, "1.0");
                if (feature.getProperty("rk_name") == null) {
                    contentFields[ProfileReader.GAF_FIELDS.RK.ordinal()] = this.objectToString(feature.getProperty("rk"), "x");
                } else {
                    String rk;
                    name = (String)feature.getProperty("rk_name");
                    Double k = (Double)feature.getProperty("rk_k");
                    Double kst = (Double)feature.getProperty("rk_kst");
                    contentFields[ProfileReader.GAF_FIELDS.RK.ordinal()] = rk = this.customRkCatalogue.getRkId(name, k, kst);
                }
                if (feature.getProperty("bk_name") == null) {
                    contentFields[ProfileReader.GAF_FIELDS.BK.ordinal()] = this.objectToString(feature.getProperty("bk"), "x");
                } else {
                    String bk;
                    name = (String)feature.getProperty("bk_name");
                    Double ax = (Double)feature.getProperty("bk_ax");
                    Double ay = (Double)feature.getProperty("bk_ay");
                    Double dp = (Double)feature.getProperty("bk_dp");
                    contentFields[ProfileReader.GAF_FIELDS.BK.ordinal()] = bk = this.customBkCatalogue.getBkId(name, ax, ay, dp);
                }
                ProfileLine profLine = new ProfileLine(this.fieldMap, contentFields);
                this.content.add(profLine);
                Double station = Double.parseDouble(contentFields[(Integer)this.fieldMap.get((Object)ProfileReader.GAF_FIELDS.STATION)]);
                ArrayList<ProfileLine> profile = (ArrayList<ProfileLine>)this.profiles.get(station);
                if (profile == null) {
                    profile = new ArrayList<ProfileLine>();
                    this.profiles.put(station, profile);
                }
                profile.add(profLine);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reading GAF data from features", (Throwable)e);
        }
    }

    public String createGafFile() {
        StringBuilder gafContent = new StringBuilder();
        for (ProfileReader.GAF_FIELDS col : ProfileReader.GAF_FIELDS.values()) {
            if (col.ordinal() == ProfileReader.GAF_FIELDS.values().length - 1) {
                gafContent.append(col.name());
                continue;
            }
            gafContent.append(this.toFixedSizeString(col.name(), 8, ' '));
        }
        gafContent.append("\r\n");
        ArrayList keyList = new ArrayList(this.profiles.keySet());
        Collections.sort(keyList);
        for (Double profileId : keyList) {
            List lines = (List)this.profiles.get(profileId);
            for (ProfileLine line : lines) {
                for (ProfileReader.GAF_FIELDS col : ProfileReader.GAF_FIELDS.values()) {
                    gafContent.append(line.getField(col));
                    if (col.ordinal() == ProfileReader.GAF_FIELDS.values().length - 1) continue;
                    gafContent.append("\t");
                }
                gafContent.append("\r\n");
            }
        }
        gafContent.append('\u001a').append("\r\n");
        return gafContent.toString();
    }

    public String createCustomRkCatalogueFile() {
        if (this.customRkCatalogue != null) {
            return this.customRkCatalogue.createCatalogueFile();
        }
        return null;
    }

    public String createCustomBkCatalogueFile() {
        if (this.customBkCatalogue != null) {
            return this.customBkCatalogue.createCatalogueFile();
        }
        return null;
    }

    private String toFixedSizeString(String s, int size, char filler) {
        StringBuilder fixedSizeString = new StringBuilder(s);
        for (int i = s.length(); i < size; ++i) {
            fixedSizeString.append(filler);
        }
        return fixedSizeString.toString();
    }

    private ProfileLine getLineOfFirstKz(Double profile, String kz) {
        ArrayList profContent = (ArrayList)this.profiles.get(profile);
        for (ProfileLine line : profContent) {
            if (!line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase(kz)) continue;
            return line;
        }
        return null;
    }

    private int getLineNumberOfFirstKz(Double profile, String kz) {
        int lineNumber = 1;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            if (this.getStationNumber(line) != profile.doubleValue() || !line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase(kz)) continue;
            return lineNumber;
        }
        return -1;
    }

    public static void main(String[] args) {
        GafReader r = new GafReader(new File("/home/therter/tmp/qp_gaf_testdatei.gaf"));
        Double prof = (Double)r.getProfiles().toArray()[0];
        Image i = r.createImage(prof, 800, 300);
        JFrame frame = new JFrame("test");
        JPanel panel = new JPanel();
        JLabel label = new JLabel();
        label.setIcon(new ImageIcon(i));
        panel.add(label);
        frame.add(panel);
        frame.setSize(850, 350);
        frame.setDefaultCloseOperation(2);
        frame.setVisible(true);
    }

    private String stationObjectToString(Object obj, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Double) {
            DecimalFormat format = new DecimalFormat("0.000");
            DecimalFormatSymbols symbols = new DecimalFormatSymbols();
            symbols.setDecimalSeparator('.');
            format.setDecimalFormatSymbols(symbols);
            format.setGroupingUsed(false);
            return format.format(obj);
        }
        return String.valueOf(obj);
    }

    private Integer toInteger(String obj) {
        try {
            return Integer.parseInt(obj);
        }
        catch (NumberFormatException e) {
            LOG.error((Object)"Not a number", (Throwable)e);
            return null;
        }
    }

    @Override
    public String[] checkFile() {
        ArrayList<GafErrorContainer> errorList = new ArrayList<GafErrorContainer>();
        GafReader.initialiseCatalogueValues();
        errorList.addAll(this.checkGafSyntax());
        if (!errorList.isEmpty()) {
            return this.errorListToStrings(errorList);
        }
        this.replacePaPe();
        this.replaceXanXen("OK");
        this.replaceXanXen("UK");
        errorList.addAll(Arrays.asList(this.checkNP()));
        errorList.addAll(Arrays.asList(this.checkMGError()));
        errorList.addAll(Arrays.asList(this.checkOGError()));
        errorList.addAll(Arrays.asList(this.checkNPPAPE()));
        errorList.addAll(Arrays.asList(this.checkNPLogik()));
        errorList.addAll(Arrays.asList(this.checkSOAOE()));
        errorList.addAll(Arrays.asList(this.checkUKANEN()));
        errorList.addAll(Arrays.asList(this.checkUKLogik()));
        errorList.addAll(Arrays.asList(this.checkOKANEN()));
        errorList.addAll(Arrays.asList(this.checkOKLogik()));
        errorList.addAll(Arrays.asList(this.checkEI()));
        errorList.addAll(Arrays.asList(this.checkMA()));
        errorList.addAll(Arrays.asList(this.checkAR()));
        errorList.addAll(Arrays.asList(this.checkHA()));
        errorList.addAll(Arrays.asList(this.checkY()));
        errorList.addAll(Arrays.asList(this.checkZ()));
        errorList.addAll(Arrays.asList(this.checkHW()));
        errorList.addAll(Arrays.asList(this.checkRW()));
        errorList.addAll(Arrays.asList(this.checkKZ()));
        errorList.addAll(Arrays.asList(this.checkHyk()));
        errorList.addAll(Arrays.asList(this.checkKzHyk()));
        errorList.addAll(Arrays.asList(this.checkRk()));
        errorList.addAll(Arrays.asList(this.checkBk()));
        Collections.sort(errorList);
        return this.errorListToStrings(errorList);
    }

    private void changeKZ(Double profileId, double y, String oldKZ, String newKZ) {
        List<ProfileLine> profileContent = this.getProfileContent(profileId);
        for (ProfileLine line : profileContent) {
            double yVal = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Y));
            if (yVal != y || !line.getField(ProfileReader.GAF_FIELDS.KZ).equals(oldKZ)) continue;
            line.setField(ProfileReader.GAF_FIELDS.KZ, newKZ);
            break;
        }
    }

    private void replacePaPe() {
        for (Double profileId : this.profiles.keySet()) {
            List<ProfileLine> profileContent = this.getProfileContent(profileId);
            double yMin = Double.MAX_VALUE;
            double yMax = Double.MIN_VALUE;
            String minKZ = null;
            String maxKZ = null;
            boolean paFound = false;
            boolean peFound = false;
            boolean sameMin = false;
            boolean sameMax = false;
            for (ProfileLine line : profileContent) {
                double y = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Y));
                if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("PE")) {
                    peFound = true;
                }
                if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("PA")) {
                    paFound = true;
                }
                if (y == yMin) {
                    sameMin = true;
                }
                if (y == yMax) {
                    sameMax = true;
                }
                if (y < yMin) {
                    yMin = y;
                    minKZ = line.getField(ProfileReader.GAF_FIELDS.KZ);
                    sameMin = false;
                }
                if (!(y > yMax)) continue;
                yMax = y;
                maxKZ = line.getField(ProfileReader.GAF_FIELDS.KZ);
                sameMax = false;
            }
            if (!paFound && !sameMin && yMin == 0.0 && minKZ != null && minKZ.equalsIgnoreCase("PP")) {
                this.changeKZ(profileId, yMin, minKZ, "PA");
            }
            if (peFound || sameMax || maxKZ == null || !maxKZ.equalsIgnoreCase("PP")) continue;
            this.changeKZ(profileId, yMax, maxKZ, "PE");
        }
    }

    private void replaceXanXen(String x) {
        for (Double profileId : this.profiles.keySet()) {
            List<ProfileLine> profileContent = this.getProfileContent(profileId);
            double yMin = Double.MAX_VALUE;
            double yMax = Double.MIN_VALUE;
            String minKZ = null;
            String maxKZ = null;
            boolean paFound = false;
            boolean peFound = false;
            boolean sameMin = false;
            boolean sameMax = false;
            boolean okppFound = false;
            for (ProfileLine line : profileContent) {
                double y = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Y));
                if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase(x + "PP")) {
                    okppFound = true;
                }
                if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase(x + "EN")) {
                    peFound = true;
                }
                if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase(x + "AN")) {
                    paFound = true;
                }
                if (!line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase(x + "PP")) continue;
                if (y == yMin) {
                    sameMin = true;
                }
                if (y == yMax) {
                    sameMax = true;
                }
                if (y < yMin) {
                    yMin = y;
                    minKZ = line.getField(ProfileReader.GAF_FIELDS.KZ);
                    sameMin = false;
                }
                if (!(y > yMax)) continue;
                yMax = y;
                maxKZ = line.getField(ProfileReader.GAF_FIELDS.KZ);
                sameMax = false;
            }
            if (okppFound && !paFound && !sameMin && minKZ != null && minKZ.equalsIgnoreCase(x + "PP")) {
                this.changeKZ(profileId, yMin, minKZ, x + "AN");
            }
            if (!okppFound || peFound || sameMax || maxKZ == null || !maxKZ.equalsIgnoreCase(x + "PP")) continue;
            this.changeKZ(profileId, yMax, maxKZ, x + "EN");
        }
    }

    private String[] errorListToStrings(List<GafErrorContainer> errorList) {
        String[] errorStrings = new String[errorList.size()];
        for (int i = 0; i < errorList.size(); ++i) {
            GafErrorContainer c = errorList.get(i);
            errorStrings[i] = c.getStation() + " " + c.getLine() + " " + c.getCode();
        }
        return errorStrings;
    }

    private List<GafErrorContainer> checkGafSyntax() {
        ArrayList<GafErrorContainer> errorList = new ArrayList<GafErrorContainer>();
        int indexZero = 0;
        for (int ind : this.gafIndex) {
            if (ind != 0) continue;
            ++indexZero;
        }
        if (indexZero > 1) {
            errorList.add(new GafErrorContainer(0.0, 0, "Ung\u00fcltige GAF-Datei"));
            return errorList;
        }
        int lineNumber = 1;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            if (line.hasCorrectLength()) continue;
            errorList.add(new GafErrorContainer(0.0, lineNumber, "Ung\u00fcltige GAF-Datei"));
        }
        return errorList;
    }

    @Override
    public QpCheckResult checkFileForHints() {
        return new QpCheckResult();
    }

    private GafErrorContainer[] checkOGError() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        ProfileLine fileRow = null;
        int lineNumber = -1;
        for (Double profileId : this.profiles.keySet()) {
            LineString line = this.getLineBetween(profileId, "LU", "Ru");
            fileRow = this.getLineOfFirstKz(profileId, "Ru");
            lineNumber = this.getLineNumberOfFirstKz(profileId, "Ru");
            if (line == null) {
                line = this.getLineBetween(profileId, "LBOK", "RBOK");
                fileRow = this.getLineOfFirstKz(profileId, "RBOK");
                lineNumber = this.getLineNumberOfFirstKz(profileId, "RBOK");
            }
            if (line == null) {
                line = this.getLineBetween(profileId, "PA", "PE");
                fileRow = this.getLineOfFirstKz(profileId, "PE");
                lineNumber = this.getLineNumberOfFirstKz(profileId, "PE");
            }
            if (line == null || this.getIntersectionPointCount((Geometry)line) != 0) continue;
            errors.add(new GafErrorContainer(this.getStationNumber(fileRow), lineNumber, "OG"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkMGError() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        ProfileLine fileRow = null;
        int lineNumber = -1;
        for (Double profileId : this.profiles.keySet()) {
            LineString line = this.getLineBetween(profileId, "LU", "Ru");
            fileRow = this.getLineOfFirstKz(profileId, "Ru");
            lineNumber = this.getLineNumberOfFirstKz(profileId, "Ru");
            if (line == null) {
                line = this.getLineBetween(profileId, "LBOK", "RBOK");
                fileRow = this.getLineOfFirstKz(profileId, "RBOK");
                lineNumber = this.getLineNumberOfFirstKz(profileId, "RBOK");
            }
            if (line == null) {
                line = this.getLineBetween(profileId, "PA", "PE");
                fileRow = this.getLineOfFirstKz(profileId, "PE");
                lineNumber = this.getLineNumberOfFirstKz(profileId, "PE");
            }
            if (line == null || this.getIntersectionPointCount((Geometry)line) <= 1) continue;
            errors.add(new GafErrorContainer(this.getStationNumber(fileRow), lineNumber, "MG"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private int getIntersectionPointCount(Geometry geom) {
        try {
            User user = SessionManager.getSession().getUser();
            ArrayList attributes = (ArrayList)SessionManager.getProxy().customServerSearch(user, (CidsServerSearch)new GafPosition(geom, 3));
            if (attributes != null && !attributes.isEmpty()) {
                return attributes.size();
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Errro while retrieving gaf profile position.", (Throwable)ex);
        }
        return 0;
    }

    private GafErrorContainer[] checkNP() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        boolean found = false;
        double station = -1.0;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            if (station != -1.0 && station != this.getStationNumber(line)) {
                if (!found) {
                    errors.add(new GafErrorContainer(station, lineNumber, "NP"));
                }
                found = false;
            }
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("PA") || line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("PE")) {
                found = true;
            }
            station = this.getStationNumber(line);
        }
        if (!found) {
            errors.add(new GafErrorContainer(station, lineNumber, "NP"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkNPPAPE() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        boolean pa = false;
        boolean pe = false;
        double station = -1.0;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            if (station != -1.0 && station != this.getStationNumber(line)) {
                if (!pa || !pe) {
                    errors.add(new GafErrorContainer(station, lineNumber, "NP-PA-PE"));
                }
                pe = false;
                pa = false;
            }
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("PA")) {
                pa = true;
            }
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("PE")) {
                pe = true;
            }
            station = this.getStationNumber(line);
        }
        if (!pa || !pe) {
            errors.add(new GafErrorContainer(station, lineNumber, "NP-PA-PE"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkNPLogik() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        String[] npOrder = new String[]{"LDUK", "LDOK", "LBOK", "LBUK", "LU", "FS", "RU", "RBUK", "RBOK", "RDOK", "RDUK"};
        int index = 0;
        double station = -1.0;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            String kz = line.getField(ProfileReader.GAF_FIELDS.KZ).toUpperCase();
            int i = this.indexOf(npOrder, kz);
            if (station != -1.0 && station != this.getStationNumber(line)) {
                index = 0;
            }
            if (i != -1) {
                if (i < index) {
                    errors.add(new GafErrorContainer(station, lineNumber, "NP-LOGIK"));
                } else {
                    index = i;
                }
            }
            station = this.getStationNumber(line);
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkSOAOE() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        boolean soa = false;
        boolean soe = false;
        boolean so = false;
        double station = -1.0;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("SOA")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (!(!so || so && soa && soe)) {
                        errors.add(new GafErrorContainer(station, lineNumber, "S-OA-OE"));
                    }
                    soe = false;
                }
                station = this.getStationNumber(line);
                soa = true;
                so = true;
            }
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("SOE")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (!(!so || so && soa && soe)) {
                        errors.add(new GafErrorContainer(station, lineNumber, "S-OA-OE"));
                    }
                    soa = false;
                }
                station = this.getStationNumber(line);
                soe = true;
                so = true;
            }
            if (!line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("SOP")) continue;
            if (station != -1.0 && station != this.getStationNumber(line)) {
                if (!(!so || so && soa && soe)) {
                    errors.add(new GafErrorContainer(station, lineNumber, "S-OA-OE"));
                }
                soa = false;
                soe = false;
            }
            station = this.getStationNumber(line);
            so = true;
        }
        if (!(station == -1.0 || !so || so && soa && soe)) {
            errors.add(new GafErrorContainer(station, lineNumber, "S-OA-OE"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkUKANEN() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        boolean ba = false;
        boolean be = false;
        double station = -1.0;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("UKAN")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (ba && !be) {
                        errors.add(new GafErrorContainer(station, lineNumber, "UK-AN-EN"));
                    }
                    ba = false;
                }
                station = this.getStationNumber(line);
                if (ba) {
                    errors.add(new GafErrorContainer(station, lineNumber, "UK-AN-EN"));
                }
                ba = true;
                be = false;
            }
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("UKEN")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (ba && !be) {
                        errors.add(new GafErrorContainer(station, lineNumber, "UK-AN-EN"));
                    }
                    ba = false;
                }
                if (!ba) {
                    errors.add(new GafErrorContainer(station, lineNumber, "UK-AN-EN"));
                }
                ba = false;
                be = true;
            }
            if (!line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("UKPP") && !line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("UKBA") && !line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("UKWP") && !line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("UKBW") && !line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("UKBP") && !line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("UKBE")) continue;
            if (station != -1.0 && station != this.getStationNumber(line)) {
                if (ba && !be) {
                    errors.add(new GafErrorContainer(station, lineNumber, "UK-AN-EN"));
                }
                ba = false;
                be = false;
            }
            if (ba) continue;
            errors.add(new GafErrorContainer(station, lineNumber, "UK-AN-EN"));
        }
        if (station != -1.0 && ba && !be) {
            errors.add(new GafErrorContainer(station, lineNumber, "UK-AN-EN"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkUKLogik() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        boolean ua = false;
        boolean ue = false;
        boolean b = false;
        double station = -1.0;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("UKBA")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    ua = false;
                    b = false;
                }
                station = this.getStationNumber(line);
                if (ua) {
                    errors.add(new GafErrorContainer(station, lineNumber, "UK-LOGIK"));
                }
                ua = true;
                ue = false;
            }
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("UKBW") || line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("UKBE")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    ua = false;
                    b = false;
                }
                station = this.getStationNumber(line);
                if (!ua) {
                    errors.add(new GafErrorContainer(station, lineNumber, "UK-LOGIK"));
                }
                ua = false;
                ue = true;
            }
            if (!line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("UKBP")) continue;
            if (station != -1.0 && station != this.getStationNumber(line)) {
                ua = false;
                ue = false;
                b = false;
            }
            station = this.getStationNumber(line);
            if (ua && !ue) continue;
            errors.add(new GafErrorContainer(station, lineNumber, "UK-LOGIK"));
        }
        if (station != -1.0 && ua && !ue) {
            errors.add(new GafErrorContainer(station, lineNumber, "UK-LOGIK"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkOKANEN() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        boolean ba = false;
        boolean be = false;
        double station = -1.0;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("OKAN")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (ba && !be) {
                        errors.add(new GafErrorContainer(station, lineNumber, "OK-AN-EN"));
                    }
                    ba = false;
                }
                if (ba) {
                    errors.add(new GafErrorContainer(station, lineNumber, "OK-AN-EN"));
                }
                station = this.getStationNumber(line);
                ba = true;
                be = false;
            }
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("OKEN")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (ba && !be) {
                        errors.add(new GafErrorContainer(station, lineNumber, "OK-AN-EN"));
                    }
                    ba = false;
                }
                if (!ba) {
                    errors.add(new GafErrorContainer(station, lineNumber, "OK-AN-EN"));
                }
                ba = false;
                be = true;
            }
            if (!line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("OKPP") && !line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("OKBA") && !line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("OKWP") && !line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("OKBW") && !line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("OKBP") && !line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("OKBE")) continue;
            if (station != -1.0 && station != this.getStationNumber(line)) {
                if (ba && !be) {
                    errors.add(new GafErrorContainer(station, lineNumber, "OK-AN-EN"));
                }
                ba = false;
                be = false;
            }
            if (ba) continue;
            errors.add(new GafErrorContainer(station, lineNumber, "OK-AN-EN"));
        }
        if (station != -1.0 && ba && !be) {
            errors.add(new GafErrorContainer(station, lineNumber, "OK-AN-EN"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkOKLogik() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        boolean oa = false;
        boolean oe = false;
        boolean b = false;
        double station = -1.0;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("OKBA")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    oa = false;
                    b = false;
                }
                station = this.getStationNumber(line);
                if (oa) {
                    errors.add(new GafErrorContainer(station, lineNumber, "OK-LOGIK"));
                }
                oa = true;
                oe = false;
            }
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("OKBW") || line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("OKBE")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    oa = false;
                    b = false;
                }
                station = this.getStationNumber(line);
                if (!oa) {
                    errors.add(new GafErrorContainer(station, lineNumber, "OK-LOGIK"));
                }
                oa = false;
                oe = true;
            }
            if (!line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("OKBP")) continue;
            if (station != -1.0 && station != this.getStationNumber(line)) {
                oa = false;
                oe = false;
                b = false;
            }
            station = this.getStationNumber(line);
            if (oa && !oe) continue;
            errors.add(new GafErrorContainer(station, lineNumber, "OK-LOGIK"));
        }
        if (station != -1.0 && oa && !oe) {
            errors.add(new GafErrorContainer(station, lineNumber, "OK-LOGIK"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkEI() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        boolean eiuk = false;
        boolean eifs = false;
        Double eiukZ = null;
        Double eifsZ = null;
        double station = -1.0;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("EIUK")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (eiuk != eifs || eiukZ != null && eifsZ != null && eiukZ <= eifsZ) {
                        errors.add(new GafErrorContainer(station, lineNumber, "EI"));
                    }
                    eifs = false;
                    eifsZ = null;
                }
                eiuk = true;
                station = this.getStationNumber(line);
                try {
                    eiukZ = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Z));
                }
                catch (NumberFormatException e) {
                    eiukZ = 0.0;
                }
            }
            if (!line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("EIFS")) continue;
            if (station != -1.0 && station != this.getStationNumber(line)) {
                if (eiuk != eifs || eiukZ != null && eifsZ != null && eiukZ <= eifsZ) {
                    errors.add(new GafErrorContainer(station, lineNumber, "EI"));
                }
                eiuk = false;
                eiukZ = null;
            }
            eifs = true;
            station = this.getStationNumber(line);
            try {
                eifsZ = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Z));
            }
            catch (NumberFormatException e) {
                eifsZ = 0.0;
            }
        }
        if (station != -1.0 && (eiuk != eifs || eiukZ != null && eifsZ != null && eiukZ <= eifsZ)) {
            errors.add(new GafErrorContainer(station, lineNumber, "EI"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkMA() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        boolean mauk = false;
        boolean mafs = false;
        Double maukZ = null;
        Double mafsZ = null;
        double station = -1.0;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("MAUK")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (mauk != mafs || maukZ != null && mafsZ != null && maukZ <= mafsZ) {
                        errors.add(new GafErrorContainer(station, lineNumber, "MA"));
                    }
                    mafs = false;
                    mafsZ = null;
                }
                mauk = true;
                station = this.getStationNumber(line);
                try {
                    maukZ = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Z));
                }
                catch (NumberFormatException e) {
                    maukZ = 0.0;
                }
            }
            if (!line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("MAFS")) continue;
            if (station != -1.0 && station != this.getStationNumber(line)) {
                if (mauk != mafs || maukZ != null && mafsZ != null && maukZ <= mafsZ) {
                    errors.add(new GafErrorContainer(station, lineNumber, "MA"));
                }
                mauk = false;
                maukZ = null;
            }
            mafs = true;
            station = this.getStationNumber(line);
            try {
                mafsZ = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Z));
            }
            catch (NumberFormatException e) {
                mafsZ = 0.0;
            }
        }
        if (station != -1.0 && (mauk != mafs || maukZ != null && mafsZ != null && maukZ <= mafsZ)) {
            errors.add(new GafErrorContainer(station, lineNumber, "MA"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkAR() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        boolean aruk = false;
        boolean arfs = false;
        boolean arlr = false;
        boolean arrr = false;
        Double arukZ = null;
        Double arfsZ = null;
        Double arlrY = null;
        Double arrrY = null;
        double station = -1.0;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("ARUK")) {
                aruk = true;
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (aruk != arfs || arfs != arlr || arlr != arrr || arukZ != null && arfsZ != null && arlrY != null && arrrY != null && (arukZ <= arfsZ || arlrY >= arrrY)) {
                        errors.add(new GafErrorContainer(station, lineNumber, "AR"));
                    }
                    aruk = false;
                    arfs = false;
                    arlr = false;
                    arrr = false;
                    arfsZ = null;
                    arlrY = null;
                    arrrY = null;
                }
                station = this.getStationNumber(line);
                try {
                    arukZ = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Z));
                }
                catch (NumberFormatException e) {
                    arukZ = 0.0;
                }
            }
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("ARFS")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (aruk != arfs || arfs != arlr || arlr != arrr || arukZ != null && arfsZ != null && arlrY != null && arrrY != null && (arukZ <= arfsZ || arlrY >= arrrY)) {
                        errors.add(new GafErrorContainer(station, lineNumber, "AR"));
                    }
                    aruk = false;
                    arlr = false;
                    arrr = false;
                    arukZ = null;
                    arlrY = null;
                    arrrY = null;
                }
                arfs = true;
                station = this.getStationNumber(line);
                try {
                    arfsZ = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Z));
                }
                catch (NumberFormatException e) {
                    arfsZ = 0.0;
                }
            }
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("ARLR")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (aruk != arfs || arfs != arlr || arlr != arrr || arukZ != null && arfsZ != null && arlrY != null && arrrY != null && (arukZ <= arfsZ || arlrY >= arrrY)) {
                        errors.add(new GafErrorContainer(station, lineNumber, "AR"));
                    }
                    aruk = false;
                    arfs = false;
                    arrr = false;
                    arukZ = null;
                    arfsZ = null;
                    arrrY = null;
                }
                station = this.getStationNumber(line);
                arlr = true;
                try {
                    arlrY = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Y));
                }
                catch (NumberFormatException e) {
                    arlrY = 0.0;
                }
            }
            if (!line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("ARRR")) continue;
            if (station != -1.0 && station != this.getStationNumber(line)) {
                if (aruk != arfs || arfs != arlr || arlr != arrr || arukZ != null && arfsZ != null && arlrY != null && arrrY != null && (arukZ <= arfsZ || arlrY >= arrrY)) {
                    errors.add(new GafErrorContainer(station, 0, "AR"));
                }
                aruk = false;
                arfs = false;
                arlr = false;
                arukZ = null;
                arfsZ = null;
                arlrY = null;
            }
            arrr = true;
            station = this.getStationNumber(line);
            try {
                arrrY = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Y));
            }
            catch (NumberFormatException e) {
                arrrY = 0.0;
            }
        }
        if (station != -1.0 && (aruk != arfs || arfs != arlr || arlr != arrr || arukZ != null && arfsZ != null && arlrY != null && arrrY != null && (arukZ <= arfsZ || arlrY >= arrrY))) {
            errors.add(new GafErrorContainer(station, lineNumber, "AR"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkHA() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        boolean hauk = false;
        boolean hafs = false;
        boolean halr = false;
        boolean harr = false;
        Double haukZ = null;
        Double hafsZ = null;
        Double halrY = null;
        Double harrY = null;
        double station = -1.0;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("HAUK")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (hauk != hafs || hafs != halr || halr != harr || haukZ != null && hafsZ != null && halrY != null && harrY != null && (haukZ <= hafsZ || halrY >= harrY)) {
                        errors.add(new GafErrorContainer(station, lineNumber, "HA"));
                    }
                    hafs = false;
                    halr = false;
                    harr = false;
                    hafsZ = null;
                    halrY = null;
                    harrY = null;
                }
                hauk = true;
                station = this.getStationNumber(line);
                try {
                    haukZ = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Z));
                }
                catch (NumberFormatException e) {
                    haukZ = 0.0;
                }
            }
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("HAFS")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (hauk != hafs || hafs != halr || halr != harr || haukZ != null && hafsZ != null && halrY != null && harrY != null && (haukZ <= hafsZ || halrY >= harrY)) {
                        errors.add(new GafErrorContainer(station, lineNumber, "HA"));
                    }
                    hauk = false;
                    halr = false;
                    harr = false;
                    halrY = null;
                    harrY = null;
                }
                station = this.getStationNumber(line);
                hafs = true;
                try {
                    hafsZ = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Z));
                }
                catch (NumberFormatException e) {
                    hafsZ = 0.0;
                }
            }
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("HALR")) {
                if (station != -1.0 && station != this.getStationNumber(line)) {
                    if (hauk != hafs || hafs != halr || halr != harr || haukZ != null && hafsZ != null && halrY != null && harrY != null && (haukZ <= hafsZ || halrY >= harrY)) {
                        errors.add(new GafErrorContainer(station, lineNumber, "HA"));
                    }
                    hauk = false;
                    hafs = false;
                    harr = false;
                    hafsZ = null;
                    harrY = null;
                }
                station = this.getStationNumber(line);
                halr = true;
                try {
                    halrY = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Y));
                }
                catch (NumberFormatException e) {
                    halrY = 0.0;
                }
            }
            if (!line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("HARR")) continue;
            if (station != -1.0 && station != this.getStationNumber(line)) {
                if (hauk != hafs || hafs != halr || halr != harr || haukZ != null && hafsZ != null && halrY != null && harrY != null && (haukZ <= hafsZ || halrY >= harrY)) {
                    errors.add(new GafErrorContainer(station, lineNumber, "HA"));
                }
                hauk = false;
                hafs = false;
                halr = false;
                hafsZ = null;
                halrY = null;
            }
            station = this.getStationNumber(line);
            harr = true;
            try {
                harrY = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Y));
            }
            catch (NumberFormatException e) {
                harrY = 0.0;
            }
        }
        if (station != -1.0 && (hauk != hafs || hafs != halr || halr != harr || haukZ != null && hafsZ != null && halrY != null && harrY != null && (haukZ <= hafsZ || halrY >= harrY))) {
            errors.add(new GafErrorContainer(station, lineNumber, "HA"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkY() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        double y = Double.MIN_VALUE;
        for (ProfileLine line : this.content) {
            double newY;
            ++lineNumber;
            if (line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("PE") || line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("SOE") || line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("UKEN") || line.getField(ProfileReader.GAF_FIELDS.KZ).equalsIgnoreCase("OKEN")) {
                y = Double.MIN_VALUE;
                continue;
            }
            try {
                newY = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Y));
                if (y < -999.99 || newY > 999.99) {
                    errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "Y"));
                }
            }
            catch (NumberFormatException e) {
                newY = 0.0;
            }
            if (y != Double.MIN_VALUE && newY < y) {
                errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "Y"));
                continue;
            }
            y = newY;
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkZ() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            try {
                double z = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.Z));
                if (!(z < -19.99) && !(z > 199.99)) continue;
                errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "Z"));
            }
            catch (NumberFormatException e) {
                errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "Z"));
            }
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkHW() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            try {
                double hw = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.HW));
                if (!(hw < 5600000.0) && !(hw > 6399999.99)) continue;
                errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "HW"));
            }
            catch (NumberFormatException e) {
                errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "HW"));
            }
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkRW() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        for (ProfileLine line : this.content) {
            ++lineNumber;
            try {
                double rw = Double.parseDouble(line.getField(ProfileReader.GAF_FIELDS.RW));
                if (!(rw < 3.3E7) && !(rw > 3.399999999E7)) continue;
                errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "RW"));
            }
            catch (NumberFormatException e) {
                errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "RW"));
            }
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkKZ() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        for (ProfileLine line : this.content) {
            String kz = line.getField(ProfileReader.GAF_FIELDS.KZ);
            ++lineNumber;
            if (this.indexOf(allKz, kz) != -1) continue;
            errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "KZ"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkHyk() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        for (ProfileLine line : this.content) {
            String hyk = line.getField(ProfileReader.GAF_FIELDS.HYK);
            ++lineNumber;
            if (hyk.equalsIgnoreCase("x") || this.indexOf(allHYK, hyk) != -1) continue;
            errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "HYK"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkKzHyk() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        for (ProfileLine line : this.content) {
            boolean found = false;
            String hyk = line.getField(ProfileReader.GAF_FIELDS.HYK);
            String kz = line.getField(ProfileReader.GAF_FIELDS.KZ);
            ++lineNumber;
            if (!hyk.equalsIgnoreCase("x")) {
                for (String[] tmp : allKzHykPerms) {
                    if (!tmp[0].equalsIgnoreCase(kz) || !tmp[1].equalsIgnoreCase(hyk)) continue;
                    found = true;
                }
            } else {
                found = true;
            }
            if (found) continue;
            errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "KZ-HYK"));
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkRk() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        ArrayList<Integer> allRkWithCustom = new ArrayList<Integer>();
        if (this.customRkCatalogue != null) {
            Object object = this.customRkCatalogue.getAllRk().iterator();
            while (object.hasNext()) {
                int rkKey = (Integer)object.next();
                allRkWithCustom.add(rkKey);
            }
        } else {
            for (int rkKey : allRK) {
                allRkWithCustom.add(rkKey);
            }
        }
        for (ProfileLine line : this.content) {
            boolean found = false;
            ++lineNumber;
            try {
                int rk = Integer.parseInt(line.getField(ProfileReader.GAF_FIELDS.RK));
                if (rk == -1) {
                    found = true;
                }
                Iterator iterator = allRkWithCustom.iterator();
                while (iterator.hasNext()) {
                    int krk = (Integer)iterator.next();
                    if (krk != rk) continue;
                    found = true;
                }
                if (found) continue;
                errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "RK"));
            }
            catch (NumberFormatException e) {
                errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "RK"));
            }
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private GafErrorContainer[] checkBk() {
        ArrayList<GafErrorContainer> errors = new ArrayList<GafErrorContainer>();
        int lineNumber = 1;
        ArrayList<Integer> allBkWithCustom = new ArrayList<Integer>();
        if (this.customBkCatalogue != null) {
            Object object = this.customBkCatalogue.getAllBk().iterator();
            while (object.hasNext()) {
                int rbKey = (Integer)object.next();
                allBkWithCustom.add(rbKey);
            }
        } else {
            for (int rbKey : allBK) {
                allBkWithCustom.add(rbKey);
            }
        }
        for (ProfileLine line : this.content) {
            ++lineNumber;
            boolean found = false;
            try {
                int bk = Integer.parseInt(line.getField(ProfileReader.GAF_FIELDS.BK));
                if (bk == -1) {
                    found = true;
                }
                Iterator iterator = allBkWithCustom.iterator();
                while (iterator.hasNext()) {
                    int kbk = (Integer)iterator.next();
                    if (kbk != bk) continue;
                    found = true;
                }
                if (found) continue;
                errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "BK"));
            }
            catch (NumberFormatException e) {
                errors.add(new GafErrorContainer(this.getStationNumber(line), lineNumber, "BK"));
            }
        }
        return errors.toArray(new GafErrorContainer[errors.size()]);
    }

    private int indexOf(String[] sArray, String value) {
        for (int i = 0; i < sArray.length; ++i) {
            if (!sArray[i].equals(value)) continue;
            return i;
        }
        return -1;
    }

    static {
        kzAbbrevs = new HashMap<String, String>();
        UK_COLOR = new Color(180, 0, 0);
        OK_COLOR = new Color(255, 80, 80);
        kzAbbrevs.put("LDOK", "0");
        kzAbbrevs.put("LDUK", "1");
        kzAbbrevs.put("LBOK", "2");
        kzAbbrevs.put("LBUK", "3");
        kzAbbrevs.put("LU", "4");
        kzAbbrevs.put("RU", "5");
        kzAbbrevs.put("RBUK", "6");
        kzAbbrevs.put("RBOK", "7");
        kzAbbrevs.put("RDUK", "8");
        kzAbbrevs.put("RDOK", "9");
    }

    private class GafErrorContainer
    implements Comparable<GafErrorContainer> {
        Double station;
        Integer line;
        String code;

        public GafErrorContainer(Double station, Integer line, String code) {
            this.station = station;
            this.line = line;
            this.code = code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public void setLine(Integer line) {
            this.line = line;
        }

        public void setStation(Double station) {
            this.station = station;
        }

        public String getCode() {
            return this.code;
        }

        public Integer getLine() {
            return this.line;
        }

        public Double getStation() {
            return this.station;
        }

        @Override
        public int compareTo(GafErrorContainer o) {
            if (this.getLine() == null && o.getLine() == null) {
                return 0;
            }
            if (this.getLine() == null) {
                return -1;
            }
            if (o.getLine() == null) {
                return 1;
            }
            return this.getLine().compareTo(o.getLine());
        }
    }
}

