/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.watergis.profile;

import Sirius.navigator.connection.SessionManager;
import Sirius.server.middleware.types.MetaClass;
import Sirius.server.middleware.types.MetaObject;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.linearref.LengthIndexedLine;
import com.vividsolutions.jts.linearref.LinearLocation;
import com.vividsolutions.jts.linearref.LocationIndexedLine;
import de.cismet.cids.dynamics.CidsBean;
import de.cismet.cids.navigator.utils.ClassCacheMultiple;
import de.cismet.cismap.cidslayer.CidsLayerFeature;
import de.cismet.cismap.commons.features.DefaultFeatureServiceFeature;
import de.cismet.connectioncontext.AbstractConnectionContext;
import de.cismet.connectioncontext.ConnectionContext;
import de.cismet.watergis.profile.AbstractImportDialog;
import de.cismet.watergis.profile.AbstractProfileReader;
import de.cismet.watergis.profile.CsvWprofImportDialog;
import de.cismet.watergis.profile.ProfileLine;
import de.cismet.watergis.profile.ProfileReader;
import de.cismet.watergis.profile.QpCheckResult;
import java.awt.Frame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class WPROFReader
extends AbstractProfileReader {
    private static final Logger LOG = Logger.getLogger(WPROFReader.class);
    private static final ConnectionContext CC = ConnectionContext.create((AbstractConnectionContext.Category)AbstractConnectionContext.Category.OTHER, (String)"WPROFReader");
    private static final MetaClass ROUTE_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"dlm25w.fg_bak", (ConnectionContext)CC);
    private static final MetaClass GEOM_MC = ClassCacheMultiple.getMetaClass((String)"DLM25W", (String)"geom", (ConnectionContext)CC);
    private File csvFile;
    private String[] columnProposal = this.getColumnProposal();
    private boolean headerField = false;
    private CidsLayerFeature lageBezug = null;
    private CidsLayerFeature hoeheBezug = null;
    private CidsLayerFeature status = null;
    private CidsLayerFeature freigabe = null;
    private CidsLayerFeature lawaRoute = null;
    private double artificialStationId = -1.0;
    private MetaObject[] routes = null;
    private boolean duplicateSepAllowed = true;

    public WPROFReader(File file) {
        this.initFromFile(file);
    }

    public WPROFReader(List<DefaultFeatureServiceFeature> gafFeatures) {
        this.initFromFeatures(1.0, gafFeatures);
    }

    public boolean isDuplicateSepAllowed() {
        return this.duplicateSepAllowed;
    }

    public void setDuplicateSepAllowed(boolean duplicateSepAllowed) {
        this.duplicateSepAllowed = duplicateSepAllowed;
    }

    private void initFromFeatures(Double profileId, List<DefaultFeatureServiceFeature> features) {
        try {
            this.fieldMap = new HashMap();
            for (int i = 0; i < 10; ++i) {
                this.fieldMap.put(ProfileReader.GAF_FIELDS.values()[i], i);
            }
            for (DefaultFeatureServiceFeature feature : features) {
                String[] contentFields = new String[10];
                contentFields[ProfileReader.GAF_FIELDS.Y.ordinal()] = this.objectToString(feature.getProperty("y"), null);
                contentFields[ProfileReader.GAF_FIELDS.Z.ordinal()] = this.objectToString(feature.getProperty("z"), null);
                contentFields[ProfileReader.GAF_FIELDS.ID.ordinal()] = this.objectToString(feature.getProperty("gaf_id"), null);
                contentFields[ProfileReader.GAF_FIELDS.KZ.ordinal()] = this.objectToString(feature.getProperty("kz"), null);
                contentFields[ProfileReader.GAF_FIELDS.HW.ordinal()] = this.objectToString(feature.getProperty("hw"), null);
                contentFields[ProfileReader.GAF_FIELDS.RW.ordinal()] = this.objectToString(feature.getProperty("rw"), null);
                contentFields[ProfileReader.GAF_FIELDS.HYK.ordinal()] = this.objectToString(feature.getProperty("hyk"), null);
                contentFields[ProfileReader.GAF_FIELDS.STATION.ordinal()] = this.objectToString(profileId, String.valueOf(profileId));
                contentFields[ProfileReader.GAF_FIELDS.RK.ordinal()] = this.objectToString(feature.getProperty("rk"), null);
                contentFields[ProfileReader.GAF_FIELDS.BK.ordinal()] = this.objectToString(feature.getProperty("bk"), null);
                ProfileLine profLine = new ProfileLine(this.fieldMap, contentFields);
                this.content.add(profLine);
                Double station = profLine.getFieldAsDouble(ProfileReader.GAF_FIELDS.STATION);
                ArrayList<ProfileLine> profile = (ArrayList<ProfileLine>)this.profiles.get(station);
                if (profile == null) {
                    profile = new ArrayList<ProfileLine>();
                    this.profiles.put(station, profile);
                }
                profile.add(profLine);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reading GAF data from features", (Throwable)e);
        }
    }

    @Override
    public CidsLayerFeature getLageBezug() {
        return this.lageBezug;
    }

    @Override
    public void setLageBezug(CidsLayerFeature lageBezug) {
        this.lageBezug = lageBezug;
    }

    public void setRoute(CidsLayerFeature lawaRoute) {
        this.lawaRoute = lawaRoute;
    }

    @Override
    public CidsLayerFeature getHoeheBezug() {
        return this.hoeheBezug;
    }

    @Override
    public void setHoeheBezug(CidsLayerFeature hoeheBezug) {
        this.hoeheBezug = hoeheBezug;
    }

    @Override
    public CidsLayerFeature getStatus() {
        return this.status;
    }

    @Override
    public void setStatus(CidsLayerFeature status) {
        this.status = status;
    }

    @Override
    public CidsLayerFeature getFreigabe() {
        return this.freigabe;
    }

    @Override
    public void setFreigabe(CidsLayerFeature freigabe) {
        this.freigabe = freigabe;
    }

    @Override
    public void initFromFile(File csvFile) {
        this.csvFile = csvFile;
        this.analyseFile();
    }

    @Override
    public String[] checkFile() {
        return null;
    }

    @Override
    public QpCheckResult checkFileForHints() {
        int qPNumber = 0;
        if (this.content == null || this.content.isEmpty()) {
            this.readFile();
        }
        this.profiles.clear();
        QpCheckResult result = this.checkData();
        if (result.getErrors() != null && !result.getErrors().isEmpty()) {
            return result;
        }
        this.profiles.clear();
        if (this.fieldMap.containsKey((Object)ProfileReader.GAF_FIELDS.STATION) && this.fieldMap.containsKey((Object)ProfileReader.GAF_FIELDS.HW) && this.fieldMap.containsKey((Object)ProfileReader.GAF_FIELDS.RW)) {
            ArrayList parts = new ArrayList();
            Object lastY = null;
            Coordinate lastPoint = null;
            Double lastStat = null;
            ArrayList<ProfileLine> currentProfile = new ArrayList<ProfileLine>();
            for (ProfileLine line : this.content) {
                Coordinate currentPoint = new Coordinate(line.getFieldAsDouble(ProfileReader.GAF_FIELDS.RW).doubleValue(), line.getFieldAsDouble(ProfileReader.GAF_FIELDS.HW).doubleValue());
                Double currentY = lastPoint == null ? 0.0 : lastPoint.distance(currentPoint);
                Double currentStat = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.STATION);
                if (currentY == 0.0) {
                    lastPoint = currentPoint;
                }
                line.setField(ProfileReader.GAF_FIELDS.Y, currentY);
                if (lastStat != null && !lastStat.equals(currentStat)) {
                    this.profiles.put(lastStat, currentProfile);
                    ++qPNumber;
                    currentProfile = new ArrayList();
                    line.setField(ProfileReader.GAF_FIELDS.Y, 0.0);
                    lastPoint = currentPoint;
                }
                currentProfile.add(line);
                lastStat = currentStat;
            }
            this.profiles.put(lastStat, currentProfile);
            ++qPNumber;
        } else if (!this.fieldMap.containsKey((Object)ProfileReader.GAF_FIELDS.STATION) && this.fieldMap.containsKey((Object)ProfileReader.GAF_FIELDS.HW) && this.fieldMap.containsKey((Object)ProfileReader.GAF_FIELDS.RW)) {
            ArrayList<ProfileLine> currentProfile = new ArrayList<ProfileLine>();
            ArrayList parts = new ArrayList();
            Double lastY = null;
            Coordinate lastPoint = null;
            for (ProfileLine line : this.content) {
                Coordinate currentPoint = new Coordinate(line.getFieldAsDouble(ProfileReader.GAF_FIELDS.RW).doubleValue(), line.getFieldAsDouble(ProfileReader.GAF_FIELDS.HW).doubleValue());
                Double currentY = lastPoint == null ? 0.0 : lastPoint.distance(currentPoint);
                line.setField(ProfileReader.GAF_FIELDS.Y, currentY);
                if (lastY != null && lastY > currentY) {
                    this.calculateStation(currentProfile);
                    this.profiles.put(this.artificialStationId -= 1.0, currentProfile);
                    ++qPNumber;
                    currentProfile = new ArrayList();
                    line.setField(ProfileReader.GAF_FIELDS.Y, 0.0);
                    lastY = 0.0;
                    lastPoint = currentPoint;
                } else if (lastY == null) {
                    lastY = currentY;
                    lastPoint = currentPoint;
                } else {
                    lastY = currentY;
                }
                currentProfile.add(line);
            }
            ++qPNumber;
            this.profiles.put(this.artificialStationId -= 1.0, currentProfile);
            this.routes = null;
        } else if (this.fieldMap.containsKey((Object)ProfileReader.GAF_FIELDS.STATION)) {
            ArrayList<ProfileLine> parts = new ArrayList<ProfileLine>();
            this.setCalc(true);
            Double lastY = null;
            Double lastStat = null;
            ArrayList<ProfileLine> currentProfile = new ArrayList<ProfileLine>();
            for (ProfileLine line : this.content) {
                Double currentY = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.Y);
                Double currentStat = line.getFieldAsDouble(ProfileReader.GAF_FIELDS.STATION);
                if (lastStat == null || lastStat.equals(currentStat)) {
                    parts.add(line);
                } else {
                    this.processParts(parts, lastY, lastStat);
                    ++qPNumber;
                    this.profiles.put(lastStat, currentProfile);
                    currentProfile = new ArrayList();
                    parts.clear();
                    parts.add(line);
                }
                lastY = currentY;
                lastStat = currentStat;
                currentProfile.add(line);
            }
            this.processParts(parts, lastY, lastStat);
            this.profiles.put(lastStat, currentProfile);
            ++qPNumber;
        }
        return this.checkData();
    }

    private QpCheckResult checkData() {
        QpCheckResult result = new QpCheckResult();
        int profCount = 0;
        int incorrect = 0;
        String currentStat = null;
        boolean errorInCurrentQp = false;
        int lineNumber = this.hasHeaderField() ? 2 : 1;
        boolean addProfile = this.profiles.isEmpty();
        ArrayList<ProfileLine> currentProfile = new ArrayList<ProfileLine>();
        for (ProfileLine line : this.content) {
            if (this.fieldMap.containsKey((Object)ProfileReader.GAF_FIELDS.HW) && this.fieldMap.containsKey((Object)ProfileReader.GAF_FIELDS.RW) && this.fieldMap.containsKey((Object)ProfileReader.GAF_FIELDS.STATION)) {
                line.setBezug(this.lageBezug);
                if (currentStat == null || !currentStat.equals(line.getField(ProfileReader.GAF_FIELDS.STATION))) {
                    ++profCount;
                    if (addProfile && !currentProfile.isEmpty()) {
                        this.profiles.put(((ProfileLine)currentProfile.get(0)).getFieldAsDouble(ProfileReader.GAF_FIELDS.STATION), currentProfile);
                    }
                    currentProfile = new ArrayList();
                    currentProfile.add(line);
                } else {
                    currentProfile.add(line);
                }
                if (currentStat != null && currentStat.equals(line.getField(ProfileReader.GAF_FIELDS.STATION)) && errorInCurrentQp) continue;
                if (errorInCurrentQp) {
                    errorInCurrentQp = false;
                }
                try {
                    currentStat = line.getField(ProfileReader.GAF_FIELDS.STATION);
                    String rw = line.getField(ProfileReader.GAF_FIELDS.RW).replace(',', '.');
                    String hw = line.getField(ProfileReader.GAF_FIELDS.HW).replace(',', '.');
                    Double rwD = Double.parseDouble(rw);
                    Double hwD = Double.parseDouble(hw);
                    if (rwD < 3.3E7 || rwD > 3.3999999E7 || hwD < 5600000.0 || hwD > 6399999.0) {
                        QpCheckResult.ErrorResult error = new QpCheckResult.ErrorResult();
                        error.setErrorText("Der Datensatz mit der ID " + line.getField(ProfileReader.GAF_FIELDS.ID) + " hat eine ung\u00fcltige Position");
                        error.setLine(lineNumber);
                        result.addErrors(error);
                        ++incorrect;
                        errorInCurrentQp = true;
                    }
                }
                catch (Throwable e) {
                    QpCheckResult.ErrorResult error = new QpCheckResult.ErrorResult();
                    error.setErrorText("Der Datensatz mit der ID " + line.getField(ProfileReader.GAF_FIELDS.ID) + " hat eine ung\u00fcltige Position");
                    error.setLine(lineNumber);
                    result.addErrors(error);
                    ++incorrect;
                    errorInCurrentQp = true;
                }
            }
            ++lineNumber;
        }
        if (addProfile) {
            this.profiles.put(((ProfileLine)currentProfile.get(0)).getFieldAsDouble(ProfileReader.GAF_FIELDS.STATION), currentProfile);
        }
        result.setIncorrect(incorrect);
        result.setCorrect(profCount - incorrect);
        return result;
    }

    private void processParts(List<ProfileLine> parts, Double maxY, Double stat) {
        Geometry routeLine = this.lawaRoute.getGeometry();
        LengthIndexedLine lil = new LengthIndexedLine(routeLine);
        Coordinate point = lil.extractPoint(stat.doubleValue());
        LocationIndexedLine lineLIL = new LocationIndexedLine(routeLine);
        LinearLocation loc = lineLIL.indexOf(point);
        for (ProfileLine part : parts) {
            Coordinate partPoint = lineLIL.extractPoint(loc, part.getFieldAsDouble(ProfileReader.GAF_FIELDS.Y) - maxY / 2.0);
            part.setField(ProfileReader.GAF_FIELDS.RW, partPoint.x);
            part.setField(ProfileReader.GAF_FIELDS.HW, partPoint.y);
        }
    }

    private void calculateStation(List<ProfileLine> parts) {
        try {
            Coordinate[] c = new Coordinate[parts.size()];
            for (int i = 0; i < parts.size(); ++i) {
                c[i] = new Coordinate(parts.get(i).getFieldAsDouble(ProfileReader.GAF_FIELDS.RW).doubleValue(), parts.get(i).getFieldAsDouble(ProfileReader.GAF_FIELDS.HW).doubleValue());
            }
            GeometryFactory gf = new GeometryFactory(new PrecisionModel(PrecisionModel.FLOATING), 0);
            LineString line = gf.createLineString(c);
            MetaObject[] metaObjects = this.routes;
            int index = this.intersects(metaObjects, (Geometry)line);
            if (metaObjects == null || index == -1) {
                String query = "select " + GEOM_MC.getID() + ", geom." + GEOM_MC.getPrimaryKey() + " from " + ROUTE_MC.getTableName();
                query = query + " fg join " + GEOM_MC.getTableName() + " geom on (fg.geom = geom.id) where st_intersects(geom.geo_field, st_setSrid('" + line.toText() + "'::geometry, 5650))  order by abs(0.5 - ST_LineLocatePoint('" + line.toText() + "', st_geometryN(st_intersection(st_setSrid('" + line.toText() + "'::geometry, 5650), geom.geo_field)), 1)";
                this.routes = metaObjects = SessionManager.getProxy().getMetaObjectByQuery(query, 0, CC);
                index = 0;
            }
            if (metaObjects != null && metaObjects.length > 0) {
                MetaObject routeGeom = metaObjects[index];
                Geometry g = (Geometry)routeGeom.getBean().getProperty("geo_field");
                LocationIndexedLine lineLIL = new LocationIndexedLine(g);
                LinearLocation loc = lineLIL.indexOf(line.intersection(g).getCoordinate());
                double pos = loc.getSegmentFraction() * g.getLength();
                for (ProfileLine part : parts) {
                    part.setField(ProfileReader.GAF_FIELDS.STATION, pos);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Cannot retrieve route", (Throwable)e);
        }
    }

    private int intersects(MetaObject[] metaObjects, Geometry line) {
        if (metaObjects != null && metaObjects.length > 0) {
            for (int i = 0; i < metaObjects.length; ++i) {
                Geometry route;
                CidsBean geometry = metaObjects[i].getBean();
                if (geometry.getProperty("geo_field") == null || !(route = (Geometry)geometry.getProperty("geo_field")).intersects(line)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public AbstractImportDialog getImportDialog(Frame parent) {
        return new CsvWprofImportDialog(parent, true, this.getColumnProposal(), this);
    }

    public void setHeader(Map<ProfileReader.GAF_FIELDS, Integer> fieldMap, boolean headerField) {
        this.fieldMap = fieldMap;
        this.headerField = headerField;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getColumnProposal() {
        if (this.csvFile != null && this.csvFile.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(this.csvFile));
                String headerLine = reader.readLine();
                if (headerLine != null) {
                    StringTokenizer st = new StringTokenizer(headerLine, " \t");
                    String[] columns = new String[st.countTokens()];
                    int i = 0;
                    while (st.hasMoreTokens()) {
                        String tmp = st.nextToken();
                        columns[i++] = this.determineHeaderField(tmp);
                    }
                    String[] stringArray = columns;
                    return stringArray;
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Error while reading the header line", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return null;
    }

    private void readFile() {
        if (this.csvFile != null && this.csvFile.exists()) {
            BufferedReader reader = null;
            this.content = new ArrayList();
            try {
                String line;
                reader = new BufferedReader(new FileReader(this.csvFile));
                if (this.headerField) {
                    reader.readLine();
                }
                while ((line = reader.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    if (!this.duplicateSepAllowed) {
                        this.content.add(new ProfileLine(this.fieldMap, line.split("\\s")));
                        continue;
                    }
                    this.content.add(new ProfileLine(this.fieldMap, line.split("\\s+")));
                }
                if (this.fieldMap.size() == 3) {
                    // empty if block
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Error while reading the header line", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            for (ProfileLine line : this.content) {
                line.setBezug(this.lageBezug);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] readExampleData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        if (this.csvFile != null && this.csvFile.exists()) {
            BufferedReader reader = null;
            this.content = new ArrayList();
            try {
                String line;
                reader = new BufferedReader(new FileReader(this.csvFile));
                boolean rows = false;
                while ((line = reader.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    if (!this.duplicateSepAllowed) {
                        data.add(line.split("\\s"));
                        continue;
                    }
                    data.add(line.split("\\s+"));
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Error while reading the header line", (Throwable)e);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return (String[][])data.toArray((T[])new String[data.size()][]);
    }

    private void analyseFile() {
        this.columnProposal = this.getColumnProposal();
        int fieldrecognisedCount = 0;
        for (int i = 0; i < this.columnProposal.length; ++i) {
            if (this.columnProposal[i] == null) continue;
            ++fieldrecognisedCount;
        }
        this.headerField = (double)fieldrecognisedCount / (double)this.columnProposal.length > 0.5;
    }

    private String determineHeaderField(String name) {
        if (name.equalsIgnoreCase(ProfileReader.GAF_FIELDS.BK.name())) {
            return ProfileReader.GAF_FIELDS.BK.name();
        }
        if (name.equalsIgnoreCase(ProfileReader.GAF_FIELDS.HW.name())) {
            return ProfileReader.GAF_FIELDS.HW.name();
        }
        if (name.equalsIgnoreCase(ProfileReader.GAF_FIELDS.HYK.name())) {
            return ProfileReader.GAF_FIELDS.HYK.name();
        }
        if (name.equalsIgnoreCase(ProfileReader.GAF_FIELDS.ID.name())) {
            return ProfileReader.GAF_FIELDS.ID.name();
        }
        if (name.equalsIgnoreCase(ProfileReader.GAF_FIELDS.KZ.name())) {
            return ProfileReader.GAF_FIELDS.KZ.name();
        }
        if (name.equalsIgnoreCase(ProfileReader.GAF_FIELDS.RK.name())) {
            return ProfileReader.GAF_FIELDS.RK.name();
        }
        if (name.equalsIgnoreCase(ProfileReader.GAF_FIELDS.RW.name())) {
            return ProfileReader.GAF_FIELDS.RW.name();
        }
        if (name.equalsIgnoreCase(ProfileReader.GAF_FIELDS.STATION.name()) || name.toLowerCase().startsWith("st")) {
            return ProfileReader.GAF_FIELDS.STATION.name();
        }
        if (name.equalsIgnoreCase(ProfileReader.GAF_FIELDS.Y.name())) {
            return ProfileReader.GAF_FIELDS.Y.name();
        }
        if (name.equalsIgnoreCase(ProfileReader.GAF_FIELDS.Z.name())) {
            return ProfileReader.GAF_FIELDS.Z.name();
        }
        return null;
    }

    public boolean hasHeaderField() {
        return this.headerField;
    }
}

